/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.HostPropertiesModifier;
import com.sap.engine.services.httpserver.server.hosts.impl.ConfigurationReader;
import com.sap.engine.services.httpserver.server.hosts.impl.ConfigurationWriter;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesImpl;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;

public class HostPropertiesModifierImpl
implements HostPropertiesModifier {
    private HttpProperties httpProperties = null;
    private HostPropertiesImpl hostProperties = null;
    private ConfigurationWriter configurationWriter = null;
    private ConfigurationReader configurationReader = null;

    public HostPropertiesModifierImpl(HttpProperties httpProperties, HostPropertiesImpl hostProperties, ConfigurationWriter configurationWriter, ConfigurationReader configurationReader) {
        this.httpProperties = httpProperties;
        this.hostProperties = hostProperties;
        this.configurationWriter = configurationWriter;
        this.configurationReader = configurationReader;
    }

    public void setKeepAliveEnabled(boolean keepAliveEnabled) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("KeepAliveEnabled", String.valueOf(keepAliveEnabled));
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void setList(boolean list) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("DirList", String.valueOf(list));
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void setLogEnabled(boolean enableLog) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("EnableLoging", String.valueOf(enableLog));
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void setUseCache(boolean useCache) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("UseCache", String.valueOf(useCache));
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void setStartPage(String startPage) throws ConfigurationException {
        if (startPage != null && startPage.trim().equals("")) {
            startPage = null;
        }
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("StartPage", startPage);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void setRootDir(String vDir) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyProperty("Root", vDir);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void addHttpAlias(String alias, String value) throws ConfigurationException, IllegalHostArgumentsException {
        if (!(alias = alias.replace('/', '/').replace('\\', '/')).equals("/") && alias.startsWith("/")) {
            alias = alias.substring(1);
        }
        this.checkAlias(alias);
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyHttpAlias(alias, value, true);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void removeHttpAlias(String alias) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyHttpAlias(alias, null, false);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void changeHttpAlias(String alias, String value) throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.changeHttpAlias(alias, value);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public void enableApplicationAlias(String alias) throws ConfigurationException {
        alias = alias.replace('/', '/').replace('\\', '/');
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyApplicationAliases(alias, true, false);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
        this.hostProperties.getApplications().put((Object)alias, (Object)"true");
    }

    public void disableApplicationAlias(String alias) throws ConfigurationException {
        alias = alias.replace('/', '/').replace('\\', '/');
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyApplicationAliases(alias, false, false);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
        this.hostProperties.getApplications().put((Object)alias, (Object)"false");
    }

    public void removeApplicationAlias(String alias) throws ConfigurationException {
        alias = alias.replace('/', '/').replace('\\', '/');
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.modifyApplicationAliases(alias, false, true);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Log.logWarning("Error in waiting for READ configuration!", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
        this.hostProperties.getApplications().remove((Object)alias);
    }

    public void checkAlias(String alias) throws IllegalHostArgumentsException {
        alias = alias.replace('/', '/').replace('\\', '/');
        int zoneInd = -1;
        try {
            this.configurationReader.readConfiguration(false);
        }
        catch (ConfigurationException e) {
            Log.logWarning("The cached properties were not updated!", e, null);
        }
        if (this.httpProperties.getZoneSeparator() != null) {
            zoneInd = alias.indexOf(this.httpProperties.getZoneSeparator());
        }
        String aliasWithoutZone = null;
        if (zoneInd > -1) {
            aliasWithoutZone = alias.substring(0, zoneInd);
        }
        if (this.hostProperties.isApplicationAlias(alias) || this.hostProperties.getAliasValue(alias) != null || aliasWithoutZone != null && this.hostProperties.getAliasValue(aliasWithoutZone) != null) {
            throw new IllegalHostArgumentsException(IllegalHostArgumentsException.CANNOT_ADD_HTTP_ALIAS_ON_HOST_BECAUSE_APPLICATION_ALIAS_ALREADY_EXSITS, new Object[]{alias, this.hostProperties.getHostName()});
        }
    }
}

