/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.HostProperties;
import java.io.File;
import java.io.IOException;

public class HostPropertiesImpl
implements HostProperties {
    private String host = "default";
    private byte[] hostBytes = this.host.getBytes();
    private String rootDirectory = "../../docs";
    private String rootDirectoryCanonical = "../../docs";
    protected String startPage = "";
    protected boolean keepAliveEnabled = true;
    protected boolean list = false;
    protected boolean useCache = true;
    protected boolean enableLog = true;
    protected ConcurrentReadHashMap aliases = new ConcurrentReadHashMap();
    protected ConcurrentReadHashMap applications = new ConcurrentReadHashMap();
    private HttpHosts globalHostsInfo = null;

    public HostPropertiesImpl(String name, Log log, HttpHosts globalHostsInfo) {
        this.host = name;
        this.hostBytes = name.getBytes();
        this.globalHostsInfo = globalHostsInfo;
        try {
            this.initRootDir(this.rootDirectory);
        }
        catch (IOException io) {
            log.logError("Cannot set the root directory of http virtual host [" + name + "] to [" + this.rootDirectory + "]. Http error responses [404 Not Found] may be returned.", io, null);
        }
    }

    public String getHostName() {
        return this.host;
    }

    public byte[] getHostNameBytes() {
        return this.hostBytes;
    }

    public boolean isKeepAliveEnabled() {
        return this.keepAliveEnabled;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isLogEnabled() {
        return this.enableLog;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public String getRootDir() {
        return this.rootDirectoryCanonical;
    }

    public String getRootDirNoCanonical() {
        return this.rootDirectory;
    }

    public boolean rootExists() {
        return new File(this.rootDirectoryCanonical).exists();
    }

    public String[] getAliasNames() {
        int i;
        Object[] httpAliases = this.aliases.getAllKeys();
        Object[] appAliases = this.applications.getAllKeys();
        if (httpAliases == null && appAliases == null) {
            return null;
        }
        int length = 0;
        length = httpAliases == null ? appAliases.length : (appAliases == null ? httpAliases.length : httpAliases.length + appAliases.length);
        String[] result = new String[length];
        int off = 0;
        if (httpAliases != null) {
            i = 0;
            while (i < httpAliases.length) {
                result[off++] = (String)httpAliases[i];
                ++i;
            }
        }
        if (appAliases != null) {
            i = 0;
            while (i < appAliases.length) {
                result[off++] = (String)appAliases[i];
                ++i;
            }
        }
        return result;
    }

    public String getAliasValue(String key) {
        String res = (String)this.aliases.get((Object)key);
        if (res != null) {
            return res;
        }
        if (this.isApplicationAliasEnabled(key)) {
            res = this.globalHostsInfo.getApplicationAliasValue(key);
            if (res == null) {
                return "";
            }
            return res;
        }
        return null;
    }

    public boolean isApplicationAlias(String key) {
        return this.applications.containsKey((Object)key);
    }

    public boolean isApplicationAliasEnabled(String key) {
        return "true".equals(this.applications.get((Object)key));
    }

    public ConcurrentReadHashMap getHttpAliases() {
        return this.aliases;
    }

    public ConcurrentReadHashMap getApplications() {
        return this.applications;
    }

    public void dump() {
        System.out.println("host = " + this.host);
        System.out.println("aliases = " + this.aliases);
        System.out.println("applications = " + this.applications);
        System.out.println("enableLog = " + this.enableLog);
        System.out.println("keepAliveEnabled = " + this.keepAliveEnabled);
        System.out.println("list = " + this.list);
        System.out.println("startPage = " + this.startPage);
        System.out.println("useCache = " + this.useCache);
        System.out.println("vDir = " + this.rootDirectory);
    }

    protected void initRootDir(String vDir) throws IOException {
        File root = null;
        root = vDir == null || vDir.trim().equals("") ? new File(".") : new File(vDir);
        this.rootDirectoryCanonical = root.getCanonicalPath().replace('/', '/').replace('\\', '/');
    }
}

