/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.httpserver.server.HttpLock;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesImpl;

public class ConfigurationWriter {
    private static final String default_key = "default";
    private String currentID = null;
    private String hostName = null;
    private HostPropertiesImpl hostProperties = null;
    private ConfigurationHandlerFactory factory = null;

    public ConfigurationWriter(HostPropertiesImpl hostProperties, int serverId, ConfigurationHandlerFactory factory) {
        this.hostProperties = hostProperties;
        this.hostName = hostProperties.getHostName();
        this.currentID = Integer.toString(serverId);
        this.factory = factory;
    }

    public void writeToConfiguration() throws ConfigurationException {
        Object v1;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing virtual hosts settings.", e, null);
        }
        try {
            Configuration hostConfiguration = null;
            try {
                hostConfiguration = handler.openConfiguration("HttpHosts", 1);
            }
            catch (NameNotFoundException e) {
                hostConfiguration = handler.createSubConfiguration("HttpHosts");
                hostConfiguration.setCacheMode(18);
            }
            try {
                hostConfiguration = hostConfiguration.getSubConfiguration(this.hostName);
            }
            catch (InconsistentReadException e) {
                throw e;
            }
            catch (NameNotFoundException ex) {
                hostConfiguration = hostConfiguration.createSubConfiguration(this.hostName);
                hostConfiguration.setCacheMode(18);
            }
            this.writeAllSingleProperties(hostConfiguration);
            this.writeRootDir(hostConfiguration);
            this.writeStartPage(hostConfiguration);
            this.writeHttpAliases(hostConfiguration);
            this.writeApplicationAliases(hostConfiguration);
            handler.commit();
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var7_9 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var9_13 = v0;
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var9_12 = v1;
        try {
            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
        }
    }

    public synchronized void modifyProperty(String key, String value) throws ConfigurationException {
        Object v1;
        if (value == null) {
            value = "";
        }
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing virtual hosts settings.", e, null);
        }
        try {
            Configuration hostConfig = null;
            try {
                hostConfig = handler.openConfiguration("HttpHosts/" + this.hostName, 1);
            }
            catch (NameNotFoundException ex) {
                try {
                    hostConfig = handler.openConfiguration("HttpHosts", 1);
                }
                catch (NameNotFoundException e) {
                    hostConfig = handler.createSubConfiguration("HttpHosts");
                    hostConfig.setCacheMode(18);
                }
                hostConfig = hostConfig.createSubConfiguration(this.hostName);
                hostConfig.setCacheMode(18);
            }
            if (key.equals("DirList")) {
                hostConfig.modifyConfigEntry("DirList", (Object)value, true);
            } else if (key.equals("EnableLoging")) {
                hostConfig.modifyConfigEntry("EnableLoging", (Object)value, true);
            } else if (key.equals("KeepAliveEnabled")) {
                hostConfig.modifyConfigEntry("KeepAliveEnabled", (Object)value, true);
            } else if (key.equals("UseCache")) {
                hostConfig.modifyConfigEntry("UseCache", (Object)value, true);
            } else if (key.equals("Root")) {
                Configuration rootDirConfig = null;
                try {
                    rootDirConfig = hostConfig.getSubConfiguration("Root");
                }
                catch (InconsistentReadException e) {
                    throw e;
                }
                catch (NameNotFoundException e) {
                    rootDirConfig = hostConfig.createSubConfiguration("Root");
                    rootDirConfig.setCacheMode(18);
                }
                rootDirConfig.modifyConfigEntry(this.currentID, (Object)value, true);
            } else if (key.equals("StartPage")) {
                Configuration startPageConfig = null;
                try {
                    startPageConfig = hostConfig.getSubConfiguration("StartPage");
                }
                catch (InconsistentReadException e) {
                    throw e;
                }
                catch (NameNotFoundException e) {
                    startPageConfig = hostConfig.createSubConfiguration("StartPage");
                    startPageConfig.setCacheMode(18);
                }
                startPageConfig.modifyConfigEntry(this.currentID, (Object)value, true);
            }
            handler.commit();
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var10_16 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var12_20 = v0;
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var12_19 = v1;
        try {
            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void modifyHttpAlias(String alias, String value, boolean add) throws ConfigurationException {
        block64: {
            HttpLock httpLock;
            ConfigurationHandler handler;
            block62: {
                Configuration hostConfig;
                handler = this.factory.getConfigurationHandler();
                httpLock = HttpServerFrame.getHttpLock();
                try {
                    httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot get cluster lock for storing virtual hosts settings.", e, null);
                }
                try {
                    Configuration hostConfig2 = null;
                    try {
                        hostConfig2 = handler.openConfiguration("HttpHosts/" + this.hostName, 1);
                    }
                    catch (NameNotFoundException ex) {
                        try {
                            hostConfig2 = handler.openConfiguration("HttpHosts", 1);
                        }
                        catch (NameNotFoundException e) {
                            hostConfig2 = handler.createSubConfiguration("HttpHosts");
                            hostConfig2.setCacheMode(18);
                        }
                        hostConfig2 = hostConfig2.createSubConfiguration(this.hostName);
                        hostConfig2.setCacheMode(18);
                    }
                    Configuration aliasesConfig = null;
                    try {
                        aliasesConfig = hostConfig2.getSubConfiguration("Aliases/" + this.currentID);
                    }
                    catch (InconsistentReadException e) {
                        throw e;
                    }
                    catch (NameNotFoundException e) {
                        try {
                            aliasesConfig = hostConfig2.getSubConfiguration("Aliases");
                        }
                        catch (InconsistentReadException ire) {
                            throw ire;
                        }
                        catch (NameNotFoundException ee) {
                            aliasesConfig = hostConfig2.createSubConfiguration("Aliases");
                            aliasesConfig.setCacheMode(18);
                        }
                        aliasesConfig = aliasesConfig.createSubConfiguration(this.currentID);
                        aliasesConfig.setCacheMode(18);
                    }
                    if (add) {
                        aliasesConfig.modifyConfigEntry(alias, (Object)value, true);
                    } else {
                        try {
                            aliasesConfig.deleteConfigEntry(alias);
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                    }
                    try {
                        aliasesConfig = hostConfig2.getSubConfiguration("Aliases/default");
                    }
                    catch (InconsistentReadException e) {
                        throw e;
                    }
                    catch (NameNotFoundException e) {
                        aliasesConfig = hostConfig2.getSubConfiguration("Aliases");
                        aliasesConfig = aliasesConfig.createSubConfiguration(default_key);
                        aliasesConfig.setCacheMode(18);
                    }
                    if (add) {
                        aliasesConfig.modifyConfigEntry(alias, (Object)value, true);
                    } else {
                        try {
                            aliasesConfig.deleteConfigEntry(alias);
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                    }
                    handler.commit();
                    Object var13_28 = null;
                }
                catch (Throwable throwable) {
                    Object var13_29 = null;
                    try {
                        handler.closeAllConfigurations();
                        Object var15_32 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_33 = null;
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                        }
                        catch (Exception e) {
                            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
                        }
                        throw throwable2;
                    }
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                    }
                    catch (Exception e) {
                        Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
                    }
                    throw throwable;
                }
                try {
                    handler.closeAllConfigurations();
                    Object var15_30 = null;
                }
                catch (Throwable throwable) {
                    Object var15_31 = null;
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                    }
                    catch (Exception e) {
                        Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
                    }
                    throw throwable;
                }
                try {
                    httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
                }
                if (add) break block64;
                Configuration configApps = null;
                httpLock = HttpServerFrame.getHttpLock();
                try {
                    httpLock.enterLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e) {
                    Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e, null);
                }
                try {
                    configApps = handler.openConfiguration("HttpAliases", 1);
                }
                catch (NameNotFoundException ne) {
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e) {
                        Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e, null);
                    }
                    Object var18_41 = null;
                    try {
                        handler.closeAllConfigurations();
                        Object var20_45 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_46 = null;
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                        }
                        catch (Exception e2) {
                            Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                        }
                        throw throwable;
                    }
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                    }
                    return;
                }
                if (!configApps.existsSubConfiguration(this.hostName) || !(hostConfig = configApps.getSubConfiguration(this.hostName)).existsSubConfiguration(alias)) break block62;
                hostConfig.getSubConfiguration(alias).deleteAllConfigEntries();
                hostConfig.deleteConfiguration(alias);
                handler.commit();
            }
            Object var18_42 = null;
            try {
                handler.closeAllConfigurations();
                Object var20_47 = null;
            }
            catch (Throwable throwable) {
                Object var20_48 = null;
                try {
                    httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e2) {
                    Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                }
                throw throwable;
            }
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
            }
            catch (Exception e2) {
                Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
            }
            break block64;
            {
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (InconsistentReadException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.logWarning("Cannot delete database configuration HttpAliases/" + this.hostName + "/" + alias + " or its contents.", e, null);
                    Object var18_43 = null;
                    try {
                        handler.closeAllConfigurations();
                        Object var20_49 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_50 = null;
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                        }
                        catch (Exception e2) {
                            Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                        }
                        throw throwable;
                    }
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                    }
                    break block64;
                }
            }
            catch (Throwable throwable) {
                Object var18_44 = null;
                try {
                    handler.closeAllConfigurations();
                    Object var20_51 = null;
                }
                catch (Throwable throwable3) {
                    Object var20_52 = null;
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                    }
                    throw throwable3;
                }
                try {
                    httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e2) {
                    Log.logWarning("Cannot get cluster lock for removing uploaded files in virtual hosts.", e2, null);
                }
                throw throwable;
            }
        }
    }

    public synchronized void changeHttpAlias(String alias, String value) throws ConfigurationException {
        Object v1;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot get cluster lock for storing virtual hosts settings.", e, null);
        }
        try {
            Configuration hostConfig = null;
            try {
                hostConfig = handler.openConfiguration("HttpHosts/" + this.hostName, 1);
            }
            catch (NameNotFoundException ex) {
                try {
                    hostConfig = handler.openConfiguration("HttpHosts", 1);
                }
                catch (NameNotFoundException e) {
                    hostConfig = handler.createSubConfiguration("HttpHosts");
                    hostConfig.setCacheMode(18);
                }
                hostConfig = hostConfig.createSubConfiguration(this.hostName);
                hostConfig.setCacheMode(18);
            }
            Configuration aliasesConfig = null;
            try {
                aliasesConfig = hostConfig.getSubConfiguration("Aliases/" + this.currentID);
            }
            catch (InconsistentReadException e) {
                throw e;
            }
            catch (NameNotFoundException e) {
                try {
                    aliasesConfig = hostConfig.getSubConfiguration("Aliases");
                }
                catch (InconsistentReadException ire) {
                    throw ire;
                }
                catch (NameNotFoundException ee) {
                    aliasesConfig = hostConfig.createSubConfiguration("Aliases");
                    aliasesConfig.setCacheMode(18);
                }
                aliasesConfig = aliasesConfig.createSubConfiguration(this.currentID);
                aliasesConfig.setCacheMode(18);
            }
            aliasesConfig.modifyConfigEntry(alias, (Object)value, true);
            try {
                aliasesConfig = hostConfig.getSubConfiguration("Aliases/default");
            }
            catch (InconsistentReadException e) {
                throw e;
            }
            catch (NameNotFoundException e) {
                aliasesConfig = hostConfig.getSubConfiguration("Aliases");
                aliasesConfig = aliasesConfig.createSubConfiguration(default_key);
                aliasesConfig.setCacheMode(18);
            }
            aliasesConfig.modifyConfigEntry(alias, (Object)value, true);
            handler.commit();
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var12_17 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var14_21 = v0;
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var14_20 = v1;
        try {
            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
        }
    }

    public synchronized void modifyApplicationAliases(String alias, boolean enable, boolean remove) throws ConfigurationException {
        Object v1;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        HttpLock httpLock = HttpServerFrame.getHttpLock();
        try {
            httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
        }
        try {
            Configuration hostConfig = null;
            try {
                hostConfig = handler.openConfiguration("HttpHosts/" + this.hostName, 1);
            }
            catch (NameNotFoundException ex) {
                try {
                    hostConfig = handler.openConfiguration("HttpHosts", 1);
                }
                catch (NameNotFoundException e) {
                    hostConfig = handler.createSubConfiguration("HttpHosts");
                    hostConfig.setCacheMode(18);
                }
                hostConfig = hostConfig.createSubConfiguration(this.hostName);
                hostConfig.setCacheMode(18);
            }
            Configuration webAliasConfig = null;
            try {
                webAliasConfig = hostConfig.getSubConfiguration("WebApplications");
            }
            catch (InconsistentReadException e) {
                throw e;
            }
            catch (NameNotFoundException e) {
                webAliasConfig = hostConfig.createSubConfiguration("WebApplications");
                webAliasConfig.setCacheMode(18);
            }
            this.appAliasToConfiguration(alias, enable, remove, webAliasConfig);
            handler.commit();
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var11_14 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var13_18 = v0;
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
            }
            catch (Exception e) {
                Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var13_17 = v1;
        try {
            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
        }
        catch (Exception e) {
            Log.logWarning("Cannot close cluster lock for storing virtual hosts settings.", e, null);
        }
    }

    private void writeAllSingleProperties(Configuration hostConfiguration) throws ConfigurationException {
        hostConfiguration.modifyConfigEntry("KeepAliveEnabled", (Object)String.valueOf(this.hostProperties.isKeepAliveEnabled()), true);
        hostConfiguration.modifyConfigEntry("DirList", (Object)String.valueOf(this.hostProperties.isList()), true);
        hostConfiguration.modifyConfigEntry("UseCache", (Object)String.valueOf(this.hostProperties.isUseCache()), true);
        hostConfiguration.modifyConfigEntry("EnableLoging", (Object)String.valueOf(this.hostProperties.isLogEnabled()), true);
    }

    private void writeRootDir(Configuration hostConfiguration) throws ConfigurationException {
        Configuration rootDirConfig = null;
        try {
            rootDirConfig = hostConfiguration.createSubConfiguration("Root");
            rootDirConfig.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            rootDirConfig = hostConfiguration.getSubConfiguration("Root");
        }
        rootDirConfig.modifyConfigEntry(this.currentID, (Object)this.hostProperties.getRootDirNoCanonical(), true);
        rootDirConfig.modifyConfigEntry(default_key, (Object)this.hostProperties.getRootDirNoCanonical(), true);
    }

    private void writeStartPage(Configuration hostConfiguration) throws ConfigurationException {
        Configuration startPageConfig = null;
        try {
            startPageConfig = hostConfiguration.createSubConfiguration("StartPage");
            startPageConfig.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            startPageConfig = hostConfiguration.getSubConfiguration("StartPage");
        }
        startPageConfig.modifyConfigEntry(this.currentID, (Object)this.hostProperties.getStartPage(), true);
        startPageConfig.modifyConfigEntry(default_key, (Object)this.hostProperties.getStartPage(), true);
    }

    private void writeHttpAliases(Configuration hostConfiguration) throws ConfigurationException {
        Configuration httpAliasesConfig = null;
        try {
            hostConfiguration = hostConfiguration.createSubConfiguration("Aliases");
            hostConfiguration.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            hostConfiguration = hostConfiguration.getSubConfiguration("Aliases");
        }
        try {
            httpAliasesConfig = hostConfiguration.createSubConfiguration(this.currentID);
            httpAliasesConfig.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            httpAliasesConfig = hostConfiguration.getSubConfiguration(this.currentID);
        }
        this.fillConfiguration(httpAliasesConfig, this.hostProperties.getHttpAliases());
        try {
            httpAliasesConfig = hostConfiguration.createSubConfiguration(default_key);
            httpAliasesConfig.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            httpAliasesConfig = hostConfiguration.getSubConfiguration(default_key);
        }
        this.fillConfiguration(httpAliasesConfig, this.hostProperties.getHttpAliases());
    }

    private void writeApplicationAliases(Configuration hostConfiguration) throws ConfigurationException {
        Configuration appAliasesConfig = null;
        try {
            appAliasesConfig = hostConfiguration.createSubConfiguration("WebApplications");
            appAliasesConfig.setCacheMode(18);
        }
        catch (NameAlreadyExistsException e) {
            appAliasesConfig = hostConfiguration.getSubConfiguration("WebApplications");
        }
        this.fillConfiguration(appAliasesConfig, this.hostProperties.getApplications());
    }

    private void appAliasToConfiguration(String aliasName, boolean isEnabled, boolean willRemove, Configuration configuration) throws ConfigurationException {
        if (willRemove) {
            if (configuration.existsConfigEntry(aliasName)) {
                configuration.deleteConfigEntry(aliasName);
            }
        } else if (isEnabled) {
            configuration.modifyConfigEntry(aliasName, (Object)"true", true);
        } else {
            configuration.modifyConfigEntry(aliasName, (Object)"false", true);
        }
    }

    private void fillConfiguration(Configuration configuration, ConcurrentReadHashMap entries) throws ConfigurationException {
        configuration.deleteAllConfigEntries();
        Object[] entriesNames = entries.getAllKeys();
        int i = 0;
        while (entriesNames != null && i < entriesNames.length) {
            configuration.addConfigEntry((String)entriesNames[i], entries.get(entriesNames[i]));
            ++i;
        }
    }
}

