/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts.impl;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesImpl;
import java.io.File;
import java.io.IOException;

public class ConfigurationReader {
    private static final String default_key = "default";
    private String hostName = null;
    private HostPropertiesImpl hostProperties = null;
    private String currentID = null;
    private ConfigurationHandlerFactory factory = null;
    private Log log = null;

    public ConfigurationReader(HostPropertiesImpl hostProperties, int serverId, ConfigurationHandlerFactory factory, Log log) {
        this.hostProperties = hostProperties;
        this.hostName = hostProperties.getHostName();
        this.log = log;
        this.factory = factory;
        this.currentID = Integer.toString(serverId);
    }

    public synchronized void readConfiguration(boolean inListener) throws ConfigurationException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration hostConfig = null;
        try {
            hostConfig = handler.openConfiguration("HttpHosts/" + this.hostName, 0);
        }
        catch (NameNotFoundException e) {
            return;
        }
        try {
            this.setProperties(hostConfig);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            handler.closeAllConfigurations();
            throw throwable;
        }
        handler.closeAllConfigurations();
    }

    private void setProperties(Configuration configuration) throws InconsistentReadException {
        this.setSimpleProperty(configuration);
        try {
            this.setStartPage(configuration);
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Cannot initialize property StartPage of the virtual host " + this.hostName + ".", e, null);
        }
        try {
            this.setRootDir(configuration);
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Cannot initialize property Root of the virtual host " + this.hostName + ".", e, null);
        }
        try {
            this.setHttpAliases(configuration);
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Cannot initialize http aliases of the virtual host " + this.hostName + ".", e, null);
        }
        try {
            this.setApplicationAliases(configuration);
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Cannot initialize application aliases of the virtual host " + this.hostName + ".", e, null);
        }
    }

    private void setSimpleProperty(Configuration configuration) throws InconsistentReadException {
        try {
            this.hostProperties.list = new Boolean((String)configuration.getConfigEntry("DirList"));
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Unable to initialize DirList for the virtual host " + this.hostName + ". The default value will be used. Error is: " + e.toString(), null);
        }
        try {
            this.hostProperties.useCache = Boolean.valueOf((String)configuration.getConfigEntry("UseCache"));
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Unable to initialize UseCache for the virtual host " + this.hostName + ". The default value will be used. Error is: " + e.toString(), null);
        }
        try {
            this.hostProperties.enableLog = Boolean.valueOf((String)configuration.getConfigEntry("EnableLoging"));
            this.log.enableLog(this.hostProperties.enableLog);
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Unable to initialize EnableLoging for the virtual host " + this.hostName + ". The default value will be used. Error is: " + e.toString(), null);
        }
        try {
            this.hostProperties.keepAliveEnabled = Boolean.valueOf((String)configuration.getConfigEntry("KeepAliveEnabled"));
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            Log.logWarning("Unable to initialize KeepAliveEnabled for the virtual host " + this.hostName + ". The default value will be used. Error is: " + e.toString(), null);
        }
    }

    private void setStartPage(Configuration configuration) throws ConfigurationException, InconsistentReadException {
        Configuration subConfig = null;
        try {
            subConfig = configuration.getSubConfiguration("StartPage");
        }
        catch (NameNotFoundException e) {
            Log.logWarning("Sub configuration with name StartPage not found! Http virtual host " + this.hostName + " will have no start page.", null);
            return;
        }
        String property = null;
        try {
            property = (String)subConfig.getConfigEntry(this.currentID);
        }
        catch (NameNotFoundException nnfe) {
            try {
                property = (String)subConfig.getConfigEntry(default_key);
            }
            catch (NameNotFoundException e) {
                return;
            }
        }
        if (property != null && property.trim().equals("")) {
            property = null;
        }
        this.hostProperties.startPage = property;
    }

    private void setRootDir(Configuration configuration) throws ConfigurationException {
        Configuration subConfig = null;
        try {
            subConfig = configuration.getSubConfiguration("Root");
        }
        catch (NameNotFoundException e) {
            Log.logWarning("Sub configuration with name Root not found! Http virtual host " + this.hostName + " will have no root ditrectory.", null);
            try {
                this.hostProperties.initRootDir(null);
            }
            catch (Exception t) {
                Log.logWarning("Cannot initialize Root property. Error is: " + t.toString(), null);
            }
            return;
        }
        String property = null;
        try {
            property = (String)subConfig.getConfigEntry(this.currentID);
        }
        catch (NameNotFoundException nnfe) {
            try {
                property = (String)subConfig.getConfigEntry(default_key);
            }
            catch (NameNotFoundException e) {
                Log.logWarning("Value of the host property Root not found into the configuration! Http virtual host " + this.hostName + " will have no root ditrectory.", null);
            }
        }
        try {
            this.hostProperties.initRootDir(property);
        }
        catch (Exception t) {
            Log.logWarning("Cannot initialize Root property. Error is: " + t.toString(), null);
        }
    }

    private void setHttpAliases(Configuration configuration) throws ConfigurationException {
        Configuration subConfig = null;
        try {
            subConfig = configuration.getSubConfiguration("Aliases");
        }
        catch (NameNotFoundException e) {
            Log.logWarning("Sub configuration with name Aliases not found! Http aliases on virtual host " + this.hostName + " will not be initialized.", null);
            return;
        }
        ConcurrentReadHashMap aliases = null;
        try {
            Configuration currentIdConfig = subConfig.getSubConfiguration(this.currentID);
            aliases = this.configurationEntriesToAliases(currentIdConfig);
        }
        catch (NameNotFoundException nnfe) {
            Log.logWarning("Sub configuration with name " + this.currentID + " not found! " + "Http aliases on virtual host " + this.hostName + " could not be initialized.", null);
        }
        ConcurrentReadHashMap defaultAliases = null;
        try {
            Configuration defaultKeyConfig = subConfig.getSubConfiguration(default_key);
            defaultAliases = this.configurationEntriesToAliases(defaultKeyConfig);
            aliases = this.merge(aliases, defaultAliases);
        }
        catch (NameNotFoundException nnfe) {
            // empty catch block
        }
        this.setAliases(aliases);
        this.hostProperties.aliases = aliases;
    }

    private void setApplicationAliases(Configuration configuration) throws ConfigurationException {
        Configuration subConfig = null;
        try {
            subConfig = configuration.getSubConfiguration("WebApplications");
        }
        catch (NameNotFoundException e) {
            return;
        }
        this.hostProperties.applications = this.configurationEntriesToApplAliases(subConfig);
    }

    private void setAliases(ConcurrentReadHashMap aliases) {
        Object[] objectArray = aliases.getAllKeys();
        int i = 0;
        while (i < objectArray.length) {
            String alKey = (String)objectArray[i];
            String alValue = (String)aliases.get((Object)alKey);
            if (aliases.get((Object)alKey).equals("")) {
                alValue = alValue + File.separator;
            }
            if ((alValue = this.getAbsolutePath(alValue.replace('/', '/').replace('\\', '/'))).endsWith("/")) {
                aliases.put((Object)alKey, (Object)alValue.substring(0, alValue.length() - 1));
            } else {
                aliases.put((Object)alKey, (Object)alValue);
            }
            ++i;
        }
        try {
            aliases = (ConcurrentReadHashMap)aliases.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.logWarning("Cannot clone aliases table!", e, null);
        }
    }

    private String getAbsolutePath(String filePath) {
        File file = new File(filePath + File.separator);
        String result = null;
        try {
            result = file.getCanonicalPath().replace('/', '/').replace('\\', '/');
        }
        catch (IOException io) {
            Log.logWarning("Can't get the canonical path of the file " + filePath + ".", io, null);
            result = file.getAbsolutePath().replace('/', '/').replace('\\', '/');
        }
        if (result.charAt(result.length() - 1) == '/') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private ConcurrentReadHashMap configurationEntriesToApplAliases(Configuration config) throws ConfigurationException {
        String[] aliases = null;
        ConcurrentReadHashMap hReturn = new ConcurrentReadHashMap();
        if (config == null) {
            return hReturn;
        }
        aliases = config.getAllConfigEntryNames();
        if (aliases == null || aliases.length == 0) {
            return hReturn;
        }
        int i = 0;
        while (i < aliases.length) {
            String alias = (String)config.getConfigEntry(aliases[i]);
            if (alias.equals("true")) {
                hReturn.put((Object)aliases[i].trim(), (Object)"true");
            } else {
                hReturn.put((Object)aliases[i].trim(), (Object)"false");
            }
            ++i;
        }
        return hReturn;
    }

    private ConcurrentReadHashMap configurationEntriesToAliases(Configuration config) throws ConfigurationException {
        ConcurrentReadHashMap hReturn = new ConcurrentReadHashMap();
        String[] aliases = null;
        if (config == null) {
            return hReturn;
        }
        aliases = config.getAllConfigEntryNames();
        if (aliases == null || aliases.length == 0) {
            return hReturn;
        }
        int i = 0;
        while (i < aliases.length) {
            String alias = (String)config.getConfigEntry(aliases[i]);
            hReturn.put((Object)aliases[i].trim(), (Object)alias.trim());
            ++i;
        }
        return hReturn;
    }

    private ConcurrentReadHashMap merge(ConcurrentReadHashMap one, ConcurrentReadHashMap two) {
        if (two == null) {
            return one;
        }
        if (one == null) {
            return two;
        }
        Object[] keysTwo = two.getAllKeys();
        int i = 0;
        while (keysTwo != null && i < keysTwo.length) {
            if (!one.containsKey(keysTwo[i])) {
                one.put(keysTwo[i], two.get(keysTwo[i]));
            }
            ++i;
        }
        return one;
    }
}

