/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.hosts;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.httpserver.server.Date;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.cache.ByteArrCacheManager;
import com.sap.engine.services.httpserver.server.hosts.impl.ConfigurationReader;
import com.sap.engine.services.httpserver.server.hosts.impl.ConfigurationWriter;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesImpl;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesModifierImpl;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;

public class Host {
    private byte[] version = null;
    private String hostName = null;
    private HostPropertiesModifierImpl hostPropertiesModifier = null;
    private HostPropertiesImpl hostProperties = null;
    private ConfigurationReader configurationReader = null;
    private ConfigurationWriter configurationWriter = null;
    private ByteArrCacheManager cache;
    private ConcurrentHashMapIntObject mapHashToMB = new ConcurrentHashMapIntObject();
    private Log log = null;
    private Date date = null;
    private HttpProperties httpProperties = null;
    private ConcurrentHashMapObjectObject translationTable = new ConcurrentHashMapObjectObject();

    public Host(String hostName, byte[] ver, Log log, HttpProperties httpProperties, HttpHosts httpHosts, Date date, ConfigurationHandlerFactory factory, ApplicationServiceContext sc) {
        this.hostName = hostName;
        this.version = ver;
        this.log = log;
        this.date = date;
        this.httpProperties = httpProperties;
        this.hostProperties = new HostPropertiesImpl(hostName, log, httpHosts);
        int serverId = sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        this.configurationReader = new ConfigurationReader(this.hostProperties, serverId, factory, log);
        this.configurationWriter = new ConfigurationWriter(this.hostProperties, serverId, factory);
        this.hostPropertiesModifier = new HostPropertiesModifierImpl(httpProperties, this.hostProperties, this.configurationWriter, this.configurationReader);
        this.translationTable = new ConcurrentHashMapObjectObject();
    }

    public String getHostName() {
        return this.hostName;
    }

    public HostPropertiesImpl getHostProperties() {
        return this.hostProperties;
    }

    public HostPropertiesModifierImpl getHostPropertiesModyfier() {
        return this.hostPropertiesModifier;
    }

    public ConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean rootExists() {
        return this.hostProperties.rootExists();
    }

    public byte[] getVersion() {
        return this.version;
    }

    private void setCache(ByteArrCacheManager cache) {
        this.cache = cache;
    }

    public ByteArrCacheManager getCache() {
        return this.cache;
    }

    public void startCache() {
        if (this.hostProperties.isUseCache()) {
            if (this.httpProperties.getCacheSize() > -1) {
                this.setCache(new ByteArrCacheManager(0, this.httpProperties.getCacheSize()));
            } else {
                Log.logWarning("The cache size must be a positive integer.", null);
                this.setCache(new ByteArrCacheManager());
            }
        } else {
            this.setCache(new ByteArrCacheManager(0, 0));
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    public byte[] getTagAlias(int hashCode) {
        return (byte[])this.mapHashToMB.get(hashCode);
    }

    public void addTagAlias(int hashCode, byte[] alias) {
        this.mapHashToMB.put(hashCode, (Object)alias);
    }

    public void store() throws ConfigurationException {
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.configurationWriter.writeToConfiguration();
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
    }

    public ConcurrentHashMapObjectObject getTranslationTable() {
        return this.translationTable;
    }
}

