/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.cache;

import com.sap.engine.services.httpserver.server.cache.ByteArrCacheManager;
import com.sap.engine.services.timeout.TimeoutListener;

public class CacheTimeoutListener
implements TimeoutListener {
    private static ByteArrCacheManager[] cacheManagers = new ByteArrCacheManager[0];

    public static synchronized void registerCacheManager(ByteArrCacheManager newCache) {
        ByteArrCacheManager[] temp = new ByteArrCacheManager[cacheManagers.length + 1];
        System.arraycopy(cacheManagers, 0, temp, 0, cacheManagers.length);
        temp[CacheTimeoutListener.cacheManagers.length] = newCache;
        cacheManagers = temp;
    }

    public static synchronized void unregisterCacheManager(ByteArrCacheManager newCache) {
        if (!CacheTimeoutListener.contains(newCache)) {
            return;
        }
        ByteArrCacheManager[] temp = new ByteArrCacheManager[cacheManagers.length - 1];
        int tempP = 0;
        int i = 0;
        while (i < cacheManagers.length) {
            if (cacheManagers[i] != newCache) {
                temp[tempP++] = cacheManagers[i];
            }
            ++i;
        }
        cacheManagers = temp;
    }

    public static void clear() {
        cacheManagers = new ByteArrCacheManager[0];
    }

    public synchronized void timeout() {
        int i = 0;
        while (i < cacheManagers.length) {
            cacheManagers[i].update();
            ++i;
        }
    }

    public boolean check() {
        int i = 0;
        while (i < cacheManagers.length) {
            if (cacheManagers[i].check()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contains(ByteArrCacheManager newCache) {
        int i = 0;
        while (i < cacheManagers.length) {
            if (cacheManagers[i] == newCache) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

