/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.cache;

import com.sap.engine.services.httpserver.server.cache.CacheQueue;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItem;

public class CacheQueueLRU
implements CacheQueue {
    protected static final int MIN_SIZE_DEFAULT = 10;
    protected static final int MAX_SIZE_DEFAULT = 100;
    protected int maxSize;
    protected int minSize;
    protected int size;
    protected CacheQueueItem first;
    protected CacheQueueItem last;

    public CacheQueueLRU() {
        this(10, 100);
    }

    public CacheQueueLRU(int maxSize) {
        this(10, maxSize);
    }

    public CacheQueueLRU(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    public void update(CacheQueueItem node) {
        if (node != this.first) {
            if (this.last == node) {
                this.first = this.last;
                this.last = this.last.prev;
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
                node.next = this.first;
                node.prev = this.last;
                this.first.prev = node;
                this.last.next = node;
                this.first = node;
            }
        }
    }

    public CacheQueueItem add(CacheQueueItem node) {
        CacheQueueItem removed = null;
        if (this.first == null) {
            this.size = 1;
            node.prev = node;
            node.next = node;
            this.first = node;
            this.last = node;
            return null;
        }
        if (this.size < this.maxSize) {
            ++this.size;
            node.next = this.first;
            node.prev = this.last;
            this.last.next = node;
            this.first.prev = node;
            this.first = node;
        } else {
            node.next = this.first;
            node.prev = this.last.prev;
            this.last.prev.next = node;
            this.first.prev = node;
            this.first = node;
            removed = this.last;
            this.last = this.last.prev;
        }
        return removed;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public CacheQueueItem remove(CacheQueueItem node) {
        CacheQueueItem snode = node;
        --this.size;
        if (this.size > 0) {
            if (this.first == node) {
                this.last.next = this.first = node.next;
                node.prev.next = node.next;
                node.next.prev = node.prev;
            } else if (this.last == node) {
                this.first.prev = this.last = node.prev;
                node.prev.next = node.next;
                node.next.prev = node.prev;
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            node.next = null;
            node.prev = null;
        } else {
            this.first = null;
            this.last = null;
        }
        return snode;
    }

    public CacheQueueItem removeLast() {
        return this.remove(this.last);
    }

    public void print() {
        System.out.print("QUEUE ");
        System.out.print("(size:" + this.size + ")");
        if (this.first != null) {
            CacheQueueItem temp = this.first.next;
            while (temp != this.last) {
                temp = temp.next;
            }
        } else {
            System.out.println("Queue empty.");
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }
}

