/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.cache;

import com.sap.engine.services.httpserver.lib.util.MessageBytes;

public class CacheQueueItemKey {
    MessageBytes muri;
    MessageBytes mhost;
    byte[] uri;
    byte[] host;
    byte encoding;
    byte httpVersion;
    boolean connection;

    public CacheQueueItemKey(MessageBytes uri, byte[] host, byte encoding, byte httpVersion, boolean connection) {
        this.muri = uri;
        this.host = host;
        this.uri = uri == null ? null : uri.getBytes();
        this.mhost = host == null ? null : new MessageBytes(host);
        this.encoding = encoding;
        this.httpVersion = httpVersion;
        this.connection = connection;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.uri.length) {
            hash += (hash << 13) + (this.uri[i] & 0xFF);
            ++i;
        }
        if (this.host != null) {
            int i2 = 0;
            while (i2 < this.host.length) {
                hash += (hash << 13) + (this.host[i2] & 0xFF);
                ++i2;
            }
        }
        hash += (hash << 13) + (this.encoding & 0xFF);
        hash += (hash << 13) + (this.httpVersion & 0xFF);
        hash += (hash << 1) + (this.connection ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheQueueItemKey) {
            return this.equals((CacheQueueItemKey)obj);
        }
        return false;
    }

    public boolean equals(CacheQueueItemKey key) {
        if (key.host == null) {
            if (this.host == null) {
                return this.encoding == key.encoding && this.muri.equals(key.uri) && this.httpVersion == key.httpVersion && this.connection == key.connection;
            }
            return false;
        }
        if (key.host == null) {
            return false;
        }
        return this.encoding == key.encoding && this.muri.equals(key.uri) && this.mhost.equals(key.host) && this.httpVersion == key.httpVersion && this.connection == key.connection;
    }
}

