/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server.cache;

import com.sap.engine.lib.util.ConcurrentReadHashMap;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.cache.CacheQueue;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItem;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItemKey;
import com.sap.engine.services.httpserver.server.cache.CacheQueueLRU;
import com.sap.engine.services.httpserver.server.cache.CacheTimeoutListener;
import java.io.File;
import java.util.Enumeration;

public final class ByteArrCacheManager {
    private ConcurrentReadHashMap chash = new ConcurrentReadHashMap();
    private CacheQueue asByteArr;

    public ByteArrCacheManager() {
        this(new CacheQueueLRU());
    }

    public ByteArrCacheManager(int min, int max) {
        this(new CacheQueueLRU(min, max));
    }

    public ByteArrCacheManager(CacheQueue asByteArr) {
        this.asByteArr = asByteArr;
        CacheTimeoutListener.registerCacheManager(this);
    }

    public CacheQueueItem lookupCache(CacheQueueItemKey key) {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            CacheQueueItem cItem = (CacheQueueItem)this.chash.get((Object)key);
            if (cItem != null) {
                this.asByteArr.update(cItem);
            }
            CacheQueueItem cacheQueueItem = cItem;
            return cacheQueueItem;
        }
    }

    public void addCache(File f, byte[] entity, long size, long sizeBodyOnly, long date, int datepos, int expiresPos, MessageBytes uri, byte[] host, byte encode, boolean connection) {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            CacheQueueItemKey key = new CacheQueueItemKey(uri, host, encode, expiresPos == -1 ? (byte)1 : 0, connection);
            if (this.chash.containsKey((Object)key)) {
                return;
            }
            CacheQueueItem qi = new CacheQueueItem();
            qi.reuse(f, entity, size, sizeBodyOnly, date, datepos, expiresPos, key);
            qi.cacheType = (short)2;
            CacheQueue cacheQueue = this.asByteArr;
            synchronized (cacheQueue) {
                this.chash.put((Object)key, (Object)qi);
                CacheQueueItem c = this.asByteArr.add(qi);
                if (c != null) {
                    this.chash.remove((Object)c.key);
                }
            }
        }
    }

    public void removeCache(CacheQueueItemKey key) {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            CacheQueueItem cItem = (CacheQueueItem)this.chash.remove((Object)key);
            if (cItem != null) {
                CacheQueue cacheQueue = this.asByteArr;
                synchronized (cacheQueue) {
                    this.asByteArr.remove(cItem);
                }
            }
        }
    }

    public void printCaches() {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            System.out.println("******* byte[] cache ****************");
            this.asByteArr.print();
        }
    }

    public void forceShrink() {
        CacheQueue cacheQueue = this.asByteArr;
        synchronized (cacheQueue) {
            while (this.asByteArr.getSize() > this.asByteArr.getMinSize()) {
                this.asByteArr.removeLast();
            }
        }
    }

    public void printCacheHash() {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            System.out.println("******* Cache Hashtable ****************");
            Enumeration e = this.chash.keys();
            while (e.hasMoreElements()) {
                System.out.println(e.nextElement());
            }
        }
    }

    public void clear() {
        ByteArrCacheManager byteArrCacheManager = this;
        synchronized (byteArrCacheManager) {
            this.asByteArr.clear();
            this.chash.clear();
        }
    }

    public void update() {
        CacheQueueItem qi = null;
        Object[] entries = this.chash.getAllValues();
        int i = 0;
        while (entries != null && i < entries.length) {
            qi = (CacheQueueItem)entries[i];
            if (qi.changed()) {
                this.removeCache(qi.key);
            }
            ++i;
        }
    }

    public boolean check() {
        return this.chash != null && this.chash.size() != 0;
    }
}

