/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ProtocolParser;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.HttpFile;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.RequestImpl;
import com.sap.engine.services.httpserver.server.ResponseImpl;
import java.io.File;
import java.io.IOException;

public class StaticDataProcessor {
    private Client client = null;
    private ResponseImpl response = null;
    private RequestImpl request = null;
    private HttpFile httpFile = new HttpFile();

    public void init(Client client, RequestImpl request, ResponseImpl response) {
        this.client = client;
        this.request = request;
        this.response = response;
        this.httpFile.init(client);
    }

    public HttpFile getFileForRequest() {
        if (ByteArrayUtils.indexOf(Constants.allowed1, this.request.getRequestLine().getMethod()) < 0) {
            return null;
        }
        try {
            this.httpFile.initFile();
        }
        catch (IOException e) {
            this.client.getLog();
            Log.logWarning("Cannot open the requested file <" + this.httpFile.getFileNameCannonical() + ">.", e, this.request.getClientIP());
            return null;
        }
        if (!this.httpFile.requestMathesFileName()) {
            return null;
        }
        if (!this.isRequestedFileAllowed()) {
            return null;
        }
        return this.httpFile;
    }

    public void initForwarding() {
        if (!this.httpFile.isDirectory()) {
            return;
        }
        this.forwardToDirOrIndexPages();
    }

    private boolean isRequestedFileAllowed() {
        this.httpFile.setRootDirectory(this.client.getRequestAnalizer().getHostProperties().getRootDir().getBytes());
        if (!this.httpFile.isInRootDirectory()) {
            this.httpFile.setRootDirectory(this.client.getRequestAnalizer().getRequestPathMappings().getAliasValue().getBytes());
            if (!this.httpFile.isInRootDirectory()) {
                return false;
            }
        }
        return !this.httpFile.isInWebForbiddenDirs() && !this.httpFile.hasForbiddenExtension();
    }

    private void forwardToDirOrIndexPages() {
        MessageBytes requestUrl = this.request.getRequestLine().getUrlDecoded();
        if (requestUrl.charAt(requestUrl.length() - 1) == '/') {
            this.forwardToIndexPages();
        } else {
            if (this.request.getRequestLine().isEncoded()) {
                try {
                    MessageBytes location = this.request.getRequestLine().getUrlNotDecoded();
                    location.appendAfter(ParseUtils.separatorBytes);
                    this.response.setChangeLocation(ProtocolParser.makeAbsolute(location.toStringUTF8(), new MessageBytes(), this.client.getRequest()).getBytes());
                    return;
                }
                catch (ParseException e) {
                    this.client.getLog().logError("Cannot decode the request url. Redirection to a welcome file will fail.", (Throwable)((Object)e), this.client.getIP());
                }
            }
            requestUrl.appendAfter(ParseUtils.separatorBytes);
            this.response.setChangeLocation(ProtocolParser.makeAbsolute(requestUrl.toString(), new MessageBytes(), this.client.getRequest()).getBytes());
        }
    }

    private void forwardToIndexPages() {
        File indexFile = null;
        int len = this.client.getHttpProperties().getInfernames().length;
        int j = 0;
        while (j < len) {
            indexFile = new File(this.httpFile.getIOFileNameCannonical(), this.client.getHttpProperties().getInfernames()[j]);
            if (indexFile.exists()) {
                MessageBytes location = this.request.getRequestLine().getUrlDecoded();
                location.appendAfter(this.client.getHttpProperties().getInfernames()[j].getBytes());
                this.response.setChangeLocation(ProtocolParser.makeAbsolute(location.toString(), new MessageBytes(), this.client.getRequest()).getBytes());
                return;
            }
            ++j;
        }
    }
}

