/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.interfaces.client.SslAttributes;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.properties.ProxyServersProperties;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;

public class SslAttributesImpl
implements SslAttributes {
    private static CertificateFactory certFactory = null;
    private X509Certificate[] certificates = null;
    private X509Certificate[] certificates_icm = null;
    private String cipherSuite = null;
    private int keySize = -1;
    private Client client = null;

    public SslAttributesImpl() {
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            this.client.getLog();
            Log.logWarning("Can't get instance of the CertificateFactory. " + ce, null);
        }
    }

    public void init(SslAttributesImpl oldAttributes, Client newClient) {
        this.certificates = oldAttributes.certificates;
        this.certificates_icm = oldAttributes.certificates_icm;
        this.cipherSuite = oldAttributes.cipherSuite;
        this.client = newClient;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int readCertificates(byte[] request, int offset, int length, boolean isSSL, boolean isVerified) {
        if (isSSL && isVerified) {
            int cipherSuiteSize = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
            length -= 2 + cipherSuiteSize;
            if (cipherSuiteSize != 0) {
                byte[] cipherSuiteBytes = new byte[cipherSuiteSize];
                System.arraycopy(request, offset + length, cipherSuiteBytes, 0, cipherSuiteSize);
                this.cipherSuite = new String(cipherSuiteBytes);
            }
            int certCount = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
            length -= 2;
            if (certCount > 0) {
                this.certificates = new X509Certificate[certCount];
                CertificateFactory certFactory = null;
                try {
                    certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException ce) {
                    Log.logWarning("Error getting the default Certificate Factory (X.509). " + ce, null);
                }
                if (certFactory != null) {
                    int c = certCount - 1;
                    while (c >= 0) {
                        int certificateLength = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
                        byte[] certificateBytes = new byte[certificateLength];
                        System.arraycopy(request, offset + (length -= 2 + certificateLength), certificateBytes, 0, certificateLength);
                        ByteArrayInputStream bais = new ByteArrayInputStream(certificateBytes);
                        try {
                            this.certificates[c] = (X509Certificate)certFactory.generateCertificate(bais);
                        }
                        catch (CertificateException ce) {
                            Log.logWarning("Error retrieving the certificates of the client." + ce, null);
                        }
                        --c;
                    }
                }
            }
        }
        if (isVerified && this.certificates == null) {
            this.certificates = new X509Certificate[0];
        }
        return length;
    }

    public int readICMCertificates(byte[] request, int offset, int length) {
        byte connectionInfo = request[offset + length - 1];
        boolean isSSL = (connectionInfo & 1) != 0;
        boolean isVerified = (connectionInfo & 2) != 0;
        --length;
        if (isSSL && isVerified) {
            int cipherSuiteSize = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
            length -= 2 + cipherSuiteSize;
            if (cipherSuiteSize != 0) {
                byte[] cipherSuiteBytes = new byte[cipherSuiteSize];
                System.arraycopy(request, offset + length, cipherSuiteBytes, 0, cipherSuiteSize);
            }
            int certCount = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
            length -= 2;
            if (certCount > 0) {
                this.certificates_icm = new X509Certificate[certCount];
                CertificateFactory certFactory = null;
                try {
                    certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException ce) {
                    Log.logWarning("Can't get instance of the CertificateFactory. " + ce, null);
                }
                if (certFactory != null) {
                    int c = certCount - 1;
                    while (c >= 0) {
                        int certificateLength = ByteArrayUtils.bytesToInt(request[offset + length - 2], request[offset + length - 1]);
                        byte[] certificateBytes = new byte[certificateLength];
                        System.arraycopy(request, offset + (length -= 2 + certificateLength), certificateBytes, 0, certificateLength);
                        ByteArrayInputStream bais = new ByteArrayInputStream(certificateBytes);
                        try {
                            this.certificates_icm[c] = (X509Certificate)certFactory.generateCertificate(bais);
                        }
                        catch (CertificateException ce) {
                            Log.logWarning("Can't generate a certificate. " + ce, null);
                        }
                        --c;
                    }
                }
            }
        }
        if (isVerified && this.certificates_icm == null) {
            this.certificates_icm = new X509Certificate[0];
        }
        return length;
    }

    public void initCertificates() {
        byte[] cert;
        if (certFactory == null) {
            return;
        }
        if (this.client.getRequestAnalizer().isICM()) {
            if (this.client.getHttpProperties().getProxyServersProperties().acceptClientCertWithoutSSL() || this.certificates == null || this.certificates.length == 0) {
                return;
            }
            if (!this.client.getRequest().getRequestLine().isSecure()) {
                this.certificates = null;
            } else if (!this.checkProxyCert()) {
                this.certificates = null;
            }
            return;
        }
        ProxyServersProperties proxyServersProperties = this.client.getHttpProperties().getProxyServersProperties();
        if (proxyServersProperties.getClientCertificateHeaderName() == null) {
            return;
        }
        boolean fromProxy = false;
        if (this.client.getRequest().getRequestLine().isSecure() && (fromProxy = this.checkProxyCert())) {
            this.certificates = null;
            this.cipherSuite = null;
            this.keySize = -1;
        }
        if ((cert = this.client.getRequest().getHeaders().getHeader(proxyServersProperties.getClientCertificateHeaderName())) == null) {
            return;
        }
        if (fromProxy || proxyServersProperties.acceptClientCertWithoutSSL()) {
            int i;
            ArrayObject chainCerts = null;
            if (proxyServersProperties.getClientCertificateChainHeaderPrefix() != null) {
                i = 0;
                while (i < this.client.getRequest().getHeaders().size()) {
                    String value = this.client.getRequest().getHeaders().getHeader(proxyServersProperties.getClientCertificateChainHeaderPrefix() + (i + 1));
                    if (value == null) break;
                    if (chainCerts == null) {
                        chainCerts = new ArrayObject(this.client.getRequest().getHeaders().size());
                    }
                    chainCerts.add((Object)value.trim().getBytes());
                    ++i;
                }
            }
            if (chainCerts == null) {
                this.certificates = new X509Certificate[1];
                this.initNextCertificate(cert, 0);
            } else {
                this.certificates = new X509Certificate[1 + chainCerts.size()];
                this.initNextCertificate(cert, 0);
                i = 0;
                while (i < this.certificates.length - 1) {
                    this.initNextCertificate((byte[])chainCerts.elementAt(i), i + 1);
                    ++i;
                }
            }
            this.initSipherSuiteAndKeySize(proxyServersProperties);
        }
    }

    private void initNextCertificate(byte[] cert, int certificatesOffset) {
        try {
            cert = Base64.decode((byte[])cert);
        }
        catch (Exception t) {
            this.client.getLog();
            Log.logWarning("Error decoding proxy server certificate.", t, null);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(cert);
        try {
            this.certificates[certificatesOffset] = (X509Certificate)certFactory.generateCertificate(bais);
        }
        catch (CertificateException ce) {
            this.client.getLog();
            Log.logWarning("Can't generate a certificate. " + ce, null);
        }
    }

    private void initSipherSuiteAndKeySize(ProxyServersProperties proxyServersProperties) {
        byte[] cipherSuiteBytes = null;
        if (proxyServersProperties.getClientCipherSuiteHeaderName() != null) {
            cipherSuiteBytes = this.client.getRequest().getHeaders().getHeader(proxyServersProperties.getClientCipherSuiteHeaderName());
        }
        this.cipherSuite = cipherSuiteBytes != null ? new String(cipherSuiteBytes) : null;
        byte[] keySizeBytes = null;
        if (proxyServersProperties.getClientKeySizeHeaderName() != null) {
            keySizeBytes = this.client.getRequest().getHeaders().getHeader(proxyServersProperties.getClientKeySizeHeaderName());
        }
        if (keySizeBytes != null) {
            try {
                this.keySize = new Integer(new String(keySizeBytes).trim());
            }
            catch (NumberFormatException e) {
                this.client.getLog();
                Log.logWarning("Incorrect header value " + new String(proxyServersProperties.getClientKeySizeHeaderName()) + ". Found " + new String(keySizeBytes) + " but required integer.", e, this.client.getIP());
            }
        }
    }

    private boolean checkProxyCert() {
        if (this.client.getRequestAnalizer().isICM()) {
            if (this.certificates_icm == null || this.certificates_icm.length == 0) {
                return false;
            }
            if (this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames() == null || this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames().length == 0) {
                return false;
            }
            String certName = this.certificates_icm[0].getSubjectDN().getName();
            int i = 0;
            while (i < this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames().length) {
                if (this.equalsDN(this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames()[i].trim(), certName.trim())) {
                    return true;
                }
                ++i;
            }
        } else {
            if (this.certificates == null || this.certificates.length == 0) {
                return false;
            }
            if (this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames() == null || this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames().length == 0) {
                return false;
            }
            String certName = this.certificates[0].getSubjectDN().getName();
            int i = 0;
            while (i < this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames().length) {
                if (this.equalsDN(this.client.getHttpProperties().getProxyServersProperties().getProxyCertificatesNames()[i].trim(), certName.trim())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean equalsDN(String one, String two) {
        Properties syntax = new Properties();
        syntax.setProperty("jndi.syntax.direction", "left_to_right");
        syntax.setProperty("jndi.syntax.escape", "\\");
        syntax.setProperty("jndi.syntax.trimblanks", "true");
        syntax.setProperty("jndi.syntax.separator", ",");
        try {
            CompoundName dnOne = new CompoundName(one, syntax);
            CompoundName dnTwo = new CompoundName(two, syntax);
            return dnOne.equals(dnTwo);
        }
        catch (InvalidNameException e) {
            this.client.getLog();
            Log.logWarning("Can't compare certificates DN names.", e, this.client.getIP());
            return false;
        }
    }
}

