/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.interfaces.client.Response;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ProtocolParser;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.Responses;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.lib.protocol.Methods;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.CharArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.GzipCompression;
import com.sap.engine.services.httpserver.server.HttpFile;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.LongDataInfo;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItem;
import com.sap.engine.services.httpserver.server.io.ByteArrayOutputStream;
import com.sap.engine.services.httpserver.server.io.HttpInputStream;
import com.sap.engine.services.httpserver.server.io.HttpOutputStream;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ResponseImpl
implements Response,
Constants {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$httpserver$server$ResponseImpl == null ? (class$com$sap$engine$services$httpserver$server$ResponseImpl = ResponseImpl.class$("com.sap.engine.services.httpserver.server.ResponseImpl")) : class$com$sap$engine$services$httpserver$server$ResponseImpl));
    private Object synchLDT = new Object();
    private Client client = null;
    private Log log = null;
    private GzipCompression gzipCompression = null;
    private int status_code = 200;
    private byte[] reason_phrase = ResponseCodes._ok;
    private MimeHeaders headers = null;
    private HttpOutputStream httpOutputStream = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private boolean connectionKeepAlive = false;
    private byte connectionFlag = (byte)2;
    private boolean sendfile = true;
    private boolean isHEAD = false;
    private boolean done = false;
    private byte[] buffer = null;
    private boolean isEncoded = false;
    private boolean connectionClosed = false;
    private byte[] changeLocation = null;
    private boolean name_replaced = false;
    private boolean sendAlert = false;
    private int responseLength = -1;
    private boolean schemeChanged = false;
    private boolean locked = false;
    private boolean cachedReply = false;
    private boolean notSendAnyMore = false;
    private int ldtCounter = 0;
    private boolean ldtUsed = false;
    private boolean ldtNotified = false;
    private boolean ldtAlive = false;
    static /* synthetic */ Class class$com$sap$engine$services$httpserver$server$ResponseImpl;

    public ResponseImpl(Client client, Log log) {
        this.client = client;
        this.log = log;
        this.headers = new MimeHeaders();
        this.httpOutputStream = new HttpOutputStream(client);
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.gzipCompression = new GzipCompression(client.getWorkingDir(), client.getHttpProperties().getHttpCompressedProperties());
    }

    public void recycle() {
        this.headers.clear();
        this.status_code = 200;
        this.reason_phrase = ResponseCodes._ok;
        this.isHEAD = false;
        this.connectionFlag = (byte)2;
        this.done = false;
        this.buffer = null;
        this.isEncoded = false;
        this.connectionClosed = false;
        this.sendfile = true;
        this.changeLocation = null;
        this.name_replaced = false;
        this.sendAlert = false;
        this.responseLength = -1;
        this.schemeChanged = false;
        this.locked = false;
        this.connectionKeepAlive = false;
        this.cachedReply = false;
        this.httpOutputStream.reset();
        this.byteArrayOutputStream.reset();
        this.headers.clear();
        this.gzipCompression.init();
        this.notSendAnyMore = false;
        this.ldtCounter = 0;
        this.ldtUsed = false;
        this.ldtNotified = false;
        this.ldtAlive = false;
    }

    public void init(ResponseImpl oldResponse) {
        this.status_code = oldResponse.status_code;
        this.reason_phrase = oldResponse.reason_phrase;
        this.headers = (MimeHeaders)oldResponse.headers.clone();
        oldResponse.httpOutputStream = new HttpOutputStream(oldResponse.client);
        oldResponse.byteArrayOutputStream = new ByteArrayOutputStream();
        this.connectionFlag = oldResponse.connectionFlag;
        this.sendfile = oldResponse.sendfile;
        this.isHEAD = oldResponse.isHEAD;
        this.done = oldResponse.done;
        this.buffer = oldResponse.buffer;
        this.isEncoded = oldResponse.isEncoded;
        this.connectionClosed = oldResponse.connectionClosed;
        this.changeLocation = oldResponse.changeLocation;
        this.name_replaced = oldResponse.name_replaced;
        this.sendAlert = oldResponse.sendfile;
        this.responseLength = oldResponse.responseLength;
        this.schemeChanged = oldResponse.schemeChanged;
        this.connectionKeepAlive = oldResponse.connectionKeepAlive;
        this.cachedReply = oldResponse.cachedReply;
        this.notSendAnyMore = oldResponse.notSendAnyMore;
        this.ldtCounter = oldResponse.ldtCounter;
        this.ldtUsed = oldResponse.ldtUsed;
        this.ldtNotified = oldResponse.ldtNotified;
        this.ldtAlive = oldResponse.ldtAlive;
        oldResponse.locked = true;
    }

    public boolean nextRequestPart(byte[] input, int offset, int len) {
        return this.client.getRequestAnalizer().nextRequestPart(input, offset, len);
    }

    public void connectionClosed() {
        this.client.getRequestAnalizer().connectionClosed();
    }

    private void setStatusCode(int status_code) {
        this.status_code = status_code;
    }

    private void setStatusMessage(byte[] reason_phrase) {
        this.reason_phrase = reason_phrase;
    }

    public byte getConnectionFlag() {
        return this.connectionFlag;
    }

    public void putHeader(byte[] name, byte[] value) {
        this.headers.putHeader(name, value);
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public boolean isPersistentConnection() {
        return this.connectionKeepAlive;
    }

    public void setPersistentConnection(boolean keepAlive) {
        this.connectionKeepAlive = keepAlive;
        if (keepAlive) {
            this.connectionFlag = (byte)2;
        } else {
            this.connectionFlag = 1;
            if (this.client.getRequest().getRequestLine().getHttpMajorVersion() >= 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() >= 1) {
                this.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.close_);
            }
        }
    }

    public void setEncoded(boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    public boolean isEncoded() {
        return this.isEncoded;
    }

    public void done() {
        this.done = true;
    }

    public boolean sendAlert() {
        return this.sendAlert;
    }

    public void sendAlert(boolean sendAlert) {
        this.sendAlert = sendAlert;
    }

    public void setChangeLocation(byte[] changeLocation) {
        this.changeLocation = changeLocation;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setResponseCode(int statusCode) {
        if (this.locked) {
            return;
        }
        this.setStatusCode(statusCode);
    }

    public void sendResponse(byte[] responseByte, int offset, int length) throws IOException {
        if (this.locked) {
            return;
        }
        this.ldtCounter += length;
        if (this.client.getHttpProperties().getServletsLongDataTransferLimit() < 0 || this.ldtCounter < this.client.getHttpProperties().getServletsLongDataTransferLimit()) {
            this.client.send(responseByte, offset, length);
        } else {
            this.ldtUsed = true;
            Processor.longDataHash.put((long)this.client.getDispatcherId() << 32 | (long)this.client.getClientId() & 0xFFFFFFFFL, (Object)this);
            this.ldtCounter = 0;
            int lengthToSend = length;
            if (lengthToSend > this.client.getHttpProperties().getServletsLongDataTransferLimit()) {
                lengthToSend = this.client.getHttpProperties().getServletsLongDataTransferLimit();
            }
            Object object = this.synchLDT;
            synchronized (object) {
                this.ldtNotified = false;
                this.client.sendPart(responseByte, offset, lengthToSend);
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (!this.ldtNotified && delta < (long)this.client.getHttpProperties().getServletsLongDataTransferTimeout()) {
                    try {
                        this.synchLDT.wait(this.client.getHttpProperties().getServletsLongDataTransferTimeout());
                    }
                    catch (InterruptedException e) {
                        Log.logWarning("Thread interrupted while waiting on long data transfer monitor.", e, this.client.getIP());
                    }
                    if (location.beDebug()) {
                        location.debugT("sendResponse(byte[], int, int)", "Long data transfer status for client " + this.client.getClientId() + ": ldtAlive: " + this.ldtAlive + ", ldtNotify: " + this.ldtNotified);
                    }
                    if (this.ldtAlive) {
                        this.ldtAlive = false;
                        startTime = System.currentTimeMillis();
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
                if (lengthToSend != length) {
                    this.sendResponseLDT(responseByte, offset + lengthToSend, length - lengthToSend);
                }
                if (!this.ldtNotified && this.client.getHttpProperties().getServletsLongDataTransferTimeout() > 0) {
                    throw new HttpIOException("http_0068", new Object[]{"" + this.client.getHttpProperties().getServletsLongDataTransferTimeout()});
                }
            }
        }
    }

    private void sendResponseLDT(byte[] responseByte, int offset, int length) throws IOException {
        this.ldtCounter += length;
        if (this.client.getHttpProperties().getServletsLongDataTransferLimit() < 0 || this.ldtCounter < this.client.getHttpProperties().getServletsLongDataTransferLimit()) {
            int lengthForPool = this.getPoolBufferSize(length, 4096);
            byte[] nextMsg = Processor.poolContext.get(lengthForPool);
            if (nextMsg == null) {
                nextMsg = new byte[lengthForPool];
            }
            System.arraycopy(responseByte, offset, nextMsg, 0, length);
            this.client.send(nextMsg, 0, length);
        } else {
            this.ldtUsed = true;
            Processor.longDataHash.put((long)this.client.getDispatcherId() << 32 | (long)this.client.getClientId() & 0xFFFFFFFFL, (Object)this);
            this.ldtCounter = 0;
            int lengthToSend = length;
            if (lengthToSend > this.client.getHttpProperties().getServletsLongDataTransferLimit()) {
                lengthToSend = this.client.getHttpProperties().getServletsLongDataTransferLimit();
            }
            Object object = this.synchLDT;
            synchronized (object) {
                this.ldtNotified = false;
                int lengthForPool = this.getPoolBufferSize(lengthToSend, 4096);
                byte[] nextMsg = Processor.poolContext.get(lengthForPool);
                if (nextMsg == null) {
                    nextMsg = new byte[lengthForPool];
                }
                System.arraycopy(responseByte, offset, nextMsg, 0, lengthToSend);
                this.client.sendPart(nextMsg, 0, lengthToSend);
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (!this.ldtNotified && delta < (long)this.client.getHttpProperties().getServletsLongDataTransferTimeout()) {
                    try {
                        this.synchLDT.wait(this.client.getHttpProperties().getServletsLongDataTransferTimeout());
                    }
                    catch (InterruptedException e) {
                        Log.logWarning("Thread interrupted while waiting on long data transfer monitor.", e, this.client.getIP());
                    }
                    if (location.beDebug()) {
                        location.debugT("sendResponse(byte[], int, int)", "Long data transfer status for client " + this.client.getClientId() + ": ldtAlive: " + this.ldtAlive + ", ldtNotify: " + this.ldtNotified);
                    }
                    if (this.ldtAlive) {
                        this.ldtAlive = false;
                        startTime = System.currentTimeMillis();
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
                if (lengthToSend != length) {
                    this.sendResponseLDT(responseByte, offset + lengthToSend, length - lengthToSend);
                }
                if (!this.ldtNotified && this.client.getHttpProperties().getServletsLongDataTransferTimeout() > 0) {
                    throw new HttpIOException("http_0068", new Object[]{"" + this.client.getHttpProperties().getServletsLongDataTransferTimeout()});
                }
            }
        }
    }

    private int getPoolBufferSize(int size, int oldBuffer) {
        if (size - oldBuffer < 4096) {
            return oldBuffer + 4096;
        }
        return this.getPoolBufferSize(size, oldBuffer + 4096);
    }

    public boolean isLdtUsed() {
        return this.ldtUsed;
    }

    public void sendNext() {
        Object object = this.synchLDT;
        synchronized (object) {
            this.ldtNotified = true;
            this.synchLDT.notifyAll();
        }
    }

    public void setClientAlive() {
        Object object = this.synchLDT;
        synchronized (object) {
            this.ldtAlive = true;
            this.synchLDT.notifyAll();
        }
    }

    public void sendResponse(int responseCode) {
        if (this.locked) {
            return;
        }
        String aliasName = "";
        if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
            aliasName = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString();
        }
        this.setStatusCode(responseCode);
        this.setStatusMessage(ResponseCodes.reasonBytes(responseCode, aliasName));
        this.sendResponse();
    }

    public void sendFlag(byte connection) {
        if (this.locked) {
            return;
        }
        this.sendResponse(new byte[0], connection);
    }

    public void sendError(int statusCode, byte[] message, byte[] details) {
        if (this.locked) {
            return;
        }
        this.sendResponse(this.constructError(statusCode, message, details));
    }

    public void sendApplicationStopped(byte[] body) {
        if (this.locked) {
            return;
        }
        this.connectionFlag = 1;
        String aliasName = "";
        if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
            aliasName = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString();
        }
        this.status_code = 503;
        this.reason_phrase = ResponseCodes.reasonBytes(503, aliasName);
        this.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.close_);
        this.headers.putHeader(HeaderNames.entity_header_pragma_, HeaderValues.no_cache_);
        this.headers.putHeader(HeaderNames.entity_header_cache_control_, HeaderValues.no_cache_);
        this.headers.putIntHeader(HeaderNames.entity_header_expires_, 0);
        this.sendResponse(body);
    }

    public void setSchemeHttps() {
        this.schemeChanged = true;
    }

    public boolean isSchemeChanged() {
        return this.schemeChanged;
    }

    private byte[] getContentType(String file) {
        char[] filename = file.toCharArray();
        int i = CharArrayUtils.lastIndexOf(filename, '.');
        if (i == -1) {
            return HeaderValues.content_unknown_;
        }
        int j = filename.length - 1;
        while (j >= i) {
            filename[j] = (char)Ascii.toLower(filename[j]);
            --j;
        }
        String contentType = null;
        char[] ext = new char[filename.length - i];
        System.arraycopy(filename, i, ext, 0, ext.length);
        this.client.getHttpProvider();
        if (HttpProviderImpl.getWebContainer() != null) {
            this.client.getHttpProvider();
            contentType = HttpProviderImpl.getWebContainer().checkMIME(ext, this.client.getRequestAnalizer().getRequestPathMappings().getAliasName());
        }
        if (contentType == null) {
            contentType = this.client.getHttpProperties().getMimeMappings().getMimeType(new String(ext));
        }
        if (contentType == null) {
            return HeaderValues.content_unknown_;
        }
        return contentType.getBytes();
    }

    private boolean checkIfModified(File f) {
        long date1 = this.client.getRequestAnalizer().getDateHeader(HeaderNames.request_header_if_modified_since_);
        if (date1 != -1L) {
            return f.lastModified() - date1 > 1000L;
        }
        return true;
    }

    private byte[] insertStatusLine(byte close, boolean keepHeaders) {
        int c_l_header;
        if (this.client.getRequest().getRequestLine().isSimpleRequest()) {
            return new byte[0];
        }
        this.client.getRequest().getBody();
        this.checkEOBody();
        this.httpOutputStream.reset();
        if (keepHeaders) {
            this.httpOutputStream.keepAll();
        }
        this.headers.putDateHeader(HeaderNames.entity_header_date_);
        this.httpOutputStream.write(Constants.HTTP_11);
        if (ResponseCodes.status_code_byte[this.status_code] == null) {
            ResponseCodes.status_code_byte[this.status_code] = (" " + this.status_code).getBytes();
        }
        this.httpOutputStream.write(ResponseCodes.status_code_byte[this.status_code]);
        this.httpOutputStream.write(32);
        this.httpOutputStream.write(this.reason_phrase);
        this.httpOutputStream.write(13);
        this.httpOutputStream.write(10);
        if (this.sendAlert && this.client.getRequestAnalizer().getAlertMessage() != null && ByteArrayUtils.equalsIgnoreCase(this.headers.getHeader(HeaderNames.entity_header_content_type_), HeaderValues.text_html_) && (c_l_header = this.headers.getIntHeader(HeaderNames.entity_header_content_length_)) != -1) {
            this.headers.putIntHeader(HeaderNames.entity_header_content_length_, c_l_header += this.client.getRequestAnalizer().getAlertMessage().length);
        }
        if (this.connectionFlag != 1 && (this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0) && !this.headers.containsHeader("Connection")) {
            this.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.keep_alive_);
        }
        try {
            this.headers.write(this.httpOutputStream);
        }
        catch (IOException io) {
            Log.logWarning("Error in writing http response headers to the client output stream.", io, null);
        }
        this.httpOutputStream.write(13);
        this.httpOutputStream.write(10);
        if (this.sendAlert && this.client.getRequestAnalizer().getAlertMessage() != null) {
            this.httpOutputStream.write(this.client.getRequestAnalizer().getAlertMessage());
        }
        this.httpOutputStream.flush(close);
        return this.httpOutputStream.toByteArray();
    }

    private void sendResponse(File f) {
        int readed;
        byte[] head = null;
        RandomAccessFile r = null;
        boolean longdata = false;
        String fName = f.getName();
        String str_Content_Type = new String(this.getContentType(fName));
        if (this.isEncoded) {
            this.isEncoded = this.client.getHttpProperties().getHttpCompressedProperties().isGzip(fName, str_Content_Type);
        }
        if (this.isEncoded && this.client.getHttpProperties().getHttpCompressedProperties().getMaximumCompressedURLLength() > -1 && this.client.getHttpProperties().getHttpCompressedProperties().getMaximumCompressedURLLength() < this.getCompressedURLLength(this.client.getRequestAnalizer().getHostPropertiesInternal().getHostName(), this.client.getRequest().getRequestLine().getUrlDecoded().toString(), f.getName())) {
            this.isEncoded = false;
        }
        long r_len = -1L;
        try {
            r = new RandomAccessFile(f, "r");
            r_len = r.length();
        }
        catch (IOException ioe) {
            Log.logWarning("Error opening file.", ioe, this.client.getIP());
            String errorPage = this.checkError(ioe);
            if (errorPage != null) {
                this.handleError(errorPage, ioe);
            } else {
                this.sendResponse(this.constructError(500, "Can't read from the requested file.".getBytes(), ioe.toString().getBytes()));
            }
            return;
        }
        boolean isEncodedForCache = this.isEncoded;
        if (this.isEncoded) {
            if (this.client.getHttpProperties().getHttpCompressedProperties().getMinGZipLength() > 0 && r_len > (long)this.client.getHttpProperties().getHttpCompressedProperties().getMinGZipLength()) {
                try {
                    r.close();
                    r = this.gzipCompression.compressFile(this.client.getRequestAnalizer().getHostPropertiesInternal().getHostName(), this.client.getRequest().getRequestLine().getUrlDecoded().toString(), f, this.headers, (HashMapObjectObject)this.client.getRequestAnalizer().getTranslationTable());
                    r_len = r.length();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.logWarning("Cannot compress file <" + this.client.getRequest().getRequestLine().getUrlDecoded().toString() + ">.", e, this.client.getIP());
                }
            } else {
                this.isEncoded = false;
            }
        }
        if (this.isHEAD) {
            this.insertStatusLine(this.connectionFlag, false);
            try {
                r.close();
            }
            catch (IOException io) {
                Log.logWarning("Can't close a file after the response is sent.", io, this.client.getIP());
            }
            return;
        }
        head = this.insertStatusLine((byte)0, true);
        try {
            if (r_len > (long)this.client.getHttpProperties().getMinLengthForLongData()) {
                longdata = true;
            }
            r.seek(0L);
            this.buffer = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
            readed = r.read(this.buffer);
        }
        catch (IOException io) {
            Log.logWarning("Error reading from file.", io, this.client.getIP());
            String errorPage = this.checkError(io);
            if (errorPage != null) {
                this.handleError(errorPage, io);
            } else {
                this.sendResponse(this.constructError(500, "Can't read from the requested file.".getBytes(), io.toString().getBytes()));
            }
            Processor.poolContext.release(this.buffer);
            return;
        }
        byte[] cbuf = null;
        int cpos = 0;
        if (head != null && head.length > 0 && !this.client.getRequestAnalizer().isProtected() && (long)this.client.getHttpProperties().getMaxCacheFileSize() >= r_len && this.client.getRequestAnalizer().getHostPropertiesInternal().isUseCache()) {
            cpos = head.length;
            cbuf = new byte[cpos + (int)r_len];
            System.arraycopy(head, 0, cbuf, 0, cpos);
        }
        if (readed == -1 && !this.isConnectionMarkedClosed()) {
            this.client.send(new byte[0], 0, 0, (byte)1);
            this.markConnectionClosed();
        }
        while (readed > -1) {
            if (readed < this.buffer.length) {
                if (cbuf != null) {
                    System.arraycopy(this.buffer, 0, cbuf, cpos, readed);
                    cpos += readed;
                }
                this.client.send(this.buffer, 0, readed, this.connectionFlag);
                if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
                    this.markConnectionClosed();
                }
            } else {
                if (longdata) {
                    try {
                        LongDataInfo li = null;
                        li = this.gzipCompression.getFileName() != null ? new LongDataInfo(this.gzipCompression.getFileName(), r.getFilePointer(), r_len, this.connectionFlag) : new LongDataInfo(this.client.getRequestAnalizer().getFilename().toString(), r.getFilePointer(), r_len, this.connectionFlag);
                        Processor.longDataHash.put((long)this.client.getDispatcherId() << 32 | (long)this.client.getRequest().getClientId() & 0xFFFFFFFFL, (Object)li);
                    }
                    catch (IOException t) {
                        Log.logWarning("Can't register long data transfer.", t, this.client.getIP());
                    }
                    this.client.sendPart(this.buffer, 0, readed, (byte)0);
                    break;
                }
                if (cbuf != null) {
                    System.arraycopy(this.buffer, 0, cbuf, cpos, readed);
                    cpos += readed;
                }
                this.client.send(this.buffer, 0, readed, (byte)0);
            }
            this.buffer = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
            try {
                readed = r.read(this.buffer);
            }
            catch (IOException t) {
                Log.logWarning("Error reading file for long data transfer.", t, this.client.getIP());
                Processor.poolContext.release(this.buffer);
                return;
            }
        }
        if (readed == -1) {
            Processor.poolContext.release(this.buffer);
            this.client.send(new byte[0], 0, 0, this.connectionFlag);
            if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
                this.markConnectionClosed();
            }
        }
        if (cbuf != null) {
            int datepos = ByteArrayUtils.indexOfIgnoreCase(head, Constants.dateHeader);
            byte[] abHost = this.client.getRequest().getHost().getBytes();
            datepos += Constants.dateHeader.length;
            while (Ascii.isWhite(head[datepos])) {
                ++datepos;
            }
            int expirespos = ByteArrayUtils.indexOfIgnoreCase(head, HeaderNames.entity_header_expires_);
            if (expirespos > -1) {
                expirespos += HeaderNames.entity_header_expires_.length + 1;
                while (Ascii.isWhite(head[expirespos])) {
                    ++expirespos;
                }
            }
            boolean hasConnection = false;
            if (this.isPersistentConnection()) {
                if (expirespos != -1) {
                    hasConnection = true;
                }
            } else if (expirespos == -1) {
                hasConnection = true;
            }
            long bodySize = cpos - head.length;
            this.client.getRequestAnalizer().getHostDescriptor().getCache().addCache(f, cbuf, cpos, bodySize, this.headers.getDateHeader(HeaderNames.entity_header_last_modified_), datepos, expirespos, this.client.getRequest().getRequestLine().getUrlDecoded(), abHost, isEncodedForCache ? (byte)1 : 0, hasConnection);
        }
        try {
            r.close();
        }
        catch (IOException t) {
            Log.logWarning("Can't close the file " + f.getName() + " after sending the response.", t, this.client.getIP());
        }
    }

    private int getCompressedURLLength(String host, String fileName, String sourceFile) {
        String zipFileName = (this.client.getWorkingDir() + File.separator + host + File.separator + fileName).replace('/', File.separatorChar);
        if (zipFileName.endsWith(File.separator)) {
            zipFileName = zipFileName + sourceFile;
        }
        zipFileName = zipFileName + ".gzip";
        return zipFileName.length();
    }

    private void sendResponse(File f, int start, int finish) {
        int readed;
        if (this.isHEAD) {
            this.insertStatusLine(this.connectionFlag, false);
            return;
        }
        this.insertStatusLine((byte)0, false);
        boolean longdata = false;
        int rest = finish - start + 1;
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(f, "r");
            r.seek(start);
        }
        catch (IOException t) {
            Log.logWarning("Can't open file " + f + " for reading.", t, this.client.getIP());
            String errorPage = this.checkError(t);
            if (errorPage != null) {
                this.handleError(errorPage, t);
            } else {
                this.sendResponse(this.constructError(500, "Can't open the requested file.".getBytes(), t.toString().getBytes()));
            }
            return;
        }
        this.buffer = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
        try {
            readed = r.read(this.buffer);
        }
        catch (IOException t) {
            Log.logWarning("Can't read from file " + f + ".", t, this.client.getIP());
            String errorPage = this.checkError(t);
            if (errorPage != null) {
                this.handleError(errorPage, t);
            } else {
                this.sendResponse(this.constructError(500, "Can't read from the requested file.".getBytes(), t.toString().getBytes()));
            }
            Processor.poolContext.release(this.buffer);
            return;
        }
        if (rest > this.client.getHttpProperties().getMinLengthForLongData()) {
            longdata = true;
        }
        while (rest > 0 && readed > -1) {
            if (rest > readed) {
                if (readed < this.buffer.length) {
                    this.client.send(this.buffer, 0, readed, this.connectionFlag);
                    if ((this.connectionFlag & 1) != 1 || this.isConnectionMarkedClosed()) break;
                    this.markConnectionClosed();
                    break;
                }
                if (longdata) {
                    try {
                        LongDataInfo li = new LongDataInfo(this.client.getRequestAnalizer().getFilename().toString(), r.getFilePointer(), finish, this.connectionFlag);
                        Processor.longDataHash.put((long)this.client.getDispatcherId() << 32 | (long)this.client.getRequest().getClientId() & 0xFFFFFFFFL, (Object)li);
                    }
                    catch (IOException t) {
                        Log.logWarning("Can't reqister long data transfer.", t, this.client.getIP());
                        return;
                    }
                    this.client.sendPart(this.buffer, 0, readed, (byte)0);
                    break;
                }
            } else {
                this.client.send(this.buffer, 0, rest, this.connectionFlag);
                if ((this.connectionFlag & 1) != 1 || this.isConnectionMarkedClosed()) break;
                this.markConnectionClosed();
                break;
            }
            this.client.send(this.buffer, 0, readed, (byte)0);
            rest -= readed;
            this.buffer = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
            try {
                readed = r.read(this.buffer);
            }
            catch (IOException t) {
                Log.logWarning("Can't read from file for long data transfer.", t, this.client.getIP());
                Processor.poolContext.release(this.buffer);
                return;
            }
        }
        if (readed == -1) {
            Processor.poolContext.release(this.buffer);
        }
        try {
            r.close();
        }
        catch (IOException t) {
            Log.logWarning("Can't close the file " + f.getName() + " after sending the response.", t, this.client.getIP());
        }
    }

    private void sendResponse() {
        if (this.client.getHttpProperties().getUseServerHeader()) {
            this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
        }
        this.insertStatusLine(this.connectionFlag, false);
    }

    public void sendResponse(byte[] message) {
        this.headers.putHeader(HeaderNames.entity_header_content_type_, HeaderValues.text_html_);
        this.headers.putIntHeader(HeaderNames.entity_header_content_length_, message.length);
        if (this.client.getHttpProperties().getUseServerHeader()) {
            this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
        }
        if (this.isHEAD) {
            this.insertStatusLine(this.connectionFlag, false);
            return;
        }
        this.insertStatusLine((byte)0, false);
        this.client.send(message, 0, message.length, this.connectionFlag);
        if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
            this.markConnectionClosed();
        } else if (this.connectionFlag != 0) {
            this.notSendAnyMore = true;
        }
    }

    private void sendResponse(byte[] message, byte flag) {
        this.headers.putHeader(HeaderNames.entity_header_content_type_, HeaderValues.text_html_);
        this.headers.putIntHeader(HeaderNames.entity_header_content_length_, message.length);
        this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
        this.insertStatusLine(flag, false);
        this.client.send(message, 0, message.length, flag);
    }

    public byte[] constructError(int code, byte[] msg, byte[] details) {
        this.setConnectionType();
        String aliasName = "";
        if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
            aliasName = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString();
        }
        this.status_code = code;
        this.reason_phrase = ResponseCodes.reasonBytes(code, aliasName);
        this.headers.putHeader(HeaderNames.entity_header_pragma_, HeaderValues.no_cache_);
        this.headers.putHeader(HeaderNames.entity_header_cache_control_, HeaderValues.no_cache_);
        this.headers.putIntHeader(HeaderNames.entity_header_expires_, 0);
        return Responses.getErrorResponse(this.client.getRequestAnalizer().getHostDescriptor().getVersion(), code, aliasName, msg, details);
    }

    public byte[] constructErrorHtmlAllowed(int code, byte[] msg, byte[] details) {
        this.setConnectionType();
        String aliasName = "";
        if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
            aliasName = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString();
        }
        this.status_code = code;
        this.reason_phrase = ResponseCodes.reasonBytes(code, aliasName);
        this.headers.putHeader(HeaderNames.entity_header_pragma_, HeaderValues.no_cache_);
        this.headers.putHeader(HeaderNames.entity_header_cache_control_, HeaderValues.no_cache_);
        this.headers.putIntHeader(HeaderNames.entity_header_expires_, 0);
        return Responses.getErrorResponseHtmlAllowed(this.client.getRequestAnalizer().getHostDescriptor().getVersion(), code, aliasName, msg, details);
    }

    protected void sendChangeLocation(byte[] filename) {
        ByteArrayUtils.replace(filename, (byte)File.separatorChar, (byte)47);
        this.headers.putHeader(HeaderNames.response_header_location_, ProtocolParser.makeAbsolute(this.encodeUrl(new String(filename)), this.client.getRequestAnalizer().getRequestPathMappings().getAliasName(), this.client.getRequest()).getBytes());
        this.status_code = 302;
        this.reason_phrase = ResponseCodes._found;
        this.sendResponse();
    }

    private String encodeUrl(String url) {
        MessageBytes requestUrl = this.client.getRequest().getRequestLine().getFullUrl();
        int semicolon = requestUrl.indexOf(';');
        if (semicolon == -1) {
            return url;
        }
        int questionmmark = requestUrl.indexOf('?');
        if (questionmmark != -1 && questionmmark < semicolon) {
            return url;
        }
        String urlEncoding = requestUrl.toString(semicolon);
        if (questionmmark != -1) {
            urlEncoding = urlEncoding.substring(0, urlEncoding.indexOf(63));
        }
        url = url.indexOf(63) > 0 ? url.substring(0, url.indexOf(63)) + urlEncoding + url.substring(url.indexOf(63)) : url + urlEncoding;
        return url;
    }

    private boolean checkRangeAndSend(File f) {
        byte[] temp = this.client.getRequestAnalizer().getHeader(HeaderNames.request_header_range_);
        String s = null;
        if (temp != null) {
            s = new String(temp);
        }
        int flen = (int)f.length();
        if (s != null && (s = s.toUpperCase()).indexOf("BYTES") > -1) {
            int start;
            int finish;
            s = s.substring(s.indexOf("=") + 1).trim();
            int i = s.indexOf("-");
            String s1 = s.substring(0, i);
            String s2 = s.substring(i + 1);
            if (i == 0) {
                finish = flen - 1;
                start = finish - new Integer(s2);
            } else if (i == s.length() - 1) {
                start = new Integer(s1);
                finish = flen - 1;
            } else {
                start = new Integer(s1);
                finish = new Integer(s2);
            }
            if (finish > flen) {
                finish = flen;
            }
            if (start > finish) {
                return false;
            }
            this.status_code = 206;
            this.reason_phrase = ResponseCodes._partial_content;
            this.headers.putIntHeader(HeaderNames.entity_header_content_length_, finish - start + 1);
            this.headers.putHeader(HeaderNames.entity_header_content_range_, ("bytes " + start + "-" + finish + "/" + flen).getBytes());
            this.sendResponse(f, start, finish);
            return true;
        }
        return false;
    }

    private void listDirectory() {
        String filename = this.client.getRequest().getRequestLine().isEncoded() ? this.client.getRequestAnalizer().getFilename1().toStringUTF8() : this.client.getRequestAnalizer().getFilename1().toString();
        if ((filename = ParseUtils.canonicalize(filename)).endsWith(":")) {
            filename = filename + File.separator;
        }
        boolean first = true;
        byte[] messByte = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
        File f = new File(filename);
        File[] files = f.listFiles();
        boolean flag = false;
        if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
            String pth = this.client.getRequestAnalizer().getHostPropertiesInternal().getAliasValue(this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString());
            if (pth != null && pth.equals(f.toString().replace(File.separatorChar, '/'))) {
                flag = true;
            }
        } else if (this.client.getRequestAnalizer().getHostPropertiesInternal().getRootDir().equals(f.toString().replace(File.separatorChar, '/'))) {
            flag = true;
        }
        String parrentDirectory = ParseUtils.canonicalize(new String(this.client.getRequest().getRequestLine().getUrlDecoded().getBytes(0, this.client.getRequest().getRequestLine().getUrlDecoded().length() - 1)));
        byte[] tmpBytes = Responses.getDirectoryHead(this.client.getRequestAnalizer().getHostDescriptor().getVersion(), ParseUtils.canonicalize(this.client.getRequest().getRequestLine().getUrlDecoded().toString()), flag ? null : parrentDirectory.substring(0, parrentDirectory.lastIndexOf(47) + 1));
        System.arraycopy(tmpBytes, 0, messByte, 0, tmpBytes.length);
        int point = tmpBytes.length;
        int i = 0;
        while (i < files.length) {
            if (!flag || !files[i].getName().equalsIgnoreCase("META-INF") && !files[i].getName().equalsIgnoreCase("WEB-INF")) {
                int size;
                byte[] dateArr = new byte[17];
                this.client.getRequestAnalizer().getHostDescriptor().getDate().getDateCLF(dateArr, 0, files[i].lastModified());
                tmpBytes = files[i].isDirectory() ? Responses.getDirectoryLine(files[i].getName(), new String(dateArr)) : ((size = (int)files[i].length()) == 0 ? Responses.getFileLine(files[i].getName(), Responses.getZero(), new String(dateArr)) : (size < 1024 ? Responses.getFileLine(files[i].getName(), size / 100 > 0 ? "0." + size / 100 : "0.1", new String(dateArr)) : Responses.getFileLine(files[i].getName(), "" + (size /= 1024), new String(dateArr))));
                System.arraycopy(tmpBytes, 0, messByte, point, tmpBytes.length);
                if ((point += tmpBytes.length) > messByte.length - 450) {
                    if (first) {
                        first = false;
                        this.headers.putHeader(HeaderNames.entity_header_content_type_, HeaderValues.text_html_);
                        this.headers.putHeader(HeaderNames.entity_header_pragma_, HeaderValues.no_cache_);
                        if (this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0) {
                            this.headers.putDateHeader(HeaderNames.entity_header_expires_, System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
                        } else {
                            this.headers.putHeader(HeaderNames.entity_header_cache_control_, this.client.getHttpProperties().getCacheValidationTimeString().getBytes());
                        }
                        if (this.client.getHttpProperties().getUseServerHeader()) {
                            this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
                        }
                        this.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.close_);
                        this.insertStatusLine((byte)0, false);
                    }
                    this.client.send(messByte, 0, point, (byte)0);
                    messByte = Processor.poolContext.get(this.client.getHttpProperties().getFileBufferSize());
                    point = 0;
                }
            }
            ++i;
        }
        System.arraycopy(Responses.getTableEnd(), 0, messByte, point, Responses.getTableEnd().length);
        point += Responses.getTableEnd().length;
        if (first) {
            this.headers.putHeader(HeaderNames.entity_header_content_type_, HeaderValues.text_html_);
            if (!ByteArrayUtils.equalsBytes(HeaderValues.close_, this.headers.getHeader(HeaderNames.hop_header_connection_))) {
                this.headers.putIntHeader(HeaderNames.entity_header_content_length_, point);
            }
            this.headers.putHeader(HeaderNames.entity_header_pragma_, HeaderValues.no_cache_);
            if (this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0) {
                this.headers.putDateHeader(HeaderNames.entity_header_expires_, System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
            } else {
                this.headers.putHeader(HeaderNames.entity_header_cache_control_, this.client.getHttpProperties().getCacheValidationTimeString().getBytes());
            }
            if (this.client.getHttpProperties().getUseServerHeader()) {
                this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
            }
            this.insertStatusLine((byte)0, false);
        }
        this.client.send(messByte, 0, point, (byte)1);
    }

    private void answerGET(HttpFile httpFile) {
        if (this.changeLocation != null) {
            this.sendChangeLocation(this.changeLocation);
            return;
        }
        String filename = null;
        if (this.client.getRequestAnalizer().getFilename() != null) {
            filename = this.client.getRequestAnalizer().getFilename().toString();
        }
        if (httpFile != null && !httpFile.isDirectory()) {
            this.status_code = 200;
            this.reason_phrase = ResponseCodes._ok;
            File f = new File(filename);
            if (this.client.getHttpProperties().getUseServerHeader()) {
                this.headers.putHeader(HeaderNames.response_header_server_, this.client.getRequestAnalizer().getHostDescriptor().getVersion());
            }
            boolean bl = this.sendfile = this.checkIfModified(f) || this.name_replaced;
            if (this.sendfile) {
                this.headers.putHeader(HeaderNames.entity_header_content_type_, this.getContentType(filename));
                this.headers.putDateHeaderLM(HeaderNames.entity_header_last_modified_, f.lastModified());
                if (this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0) {
                    this.headers.putDateHeader(HeaderNames.entity_header_expires_, System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
                } else {
                    this.headers.putHeader(HeaderNames.entity_header_cache_control_, this.client.getHttpProperties().getCacheValidationTimeString().getBytes());
                }
                if (!this.client.getRequestAnalizer().isProtected() && this.client.getRequestAnalizer().isICM()) {
                    this.headers.putHeader("sap-cache-control".getBytes(), ("+" + this.client.getHttpProperties().getSapCacheValidationTime()).getBytes());
                    if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() == null) {
                        this.headers.putHeader(Constants.sap_isc_etag, Constants.ETAG_INQMY);
                    } else {
                        byte[] etag = null;
                        if (Constants.ETAG_INQMY.length + this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().length() <= 32) {
                            etag = new byte[Constants.ETAG_INQMY.length + this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().length()];
                            System.arraycopy(Constants.ETAG_INQMY, 0, etag, 0, Constants.ETAG_INQMY.length);
                            System.arraycopy(this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().getBytes(), 0, etag, Constants.ETAG_INQMY.length, this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().length());
                        } else {
                            int hash = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().hashCode();
                            byte[] aliasb = this.client.getRequestAnalizer().getHostDescriptor().getTagAlias(hash);
                            if (aliasb == null) {
                                aliasb = new byte[32 - Constants.ETAG_INQMY.length];
                                byte[] hashAsBytesString = String.valueOf(hash).getBytes();
                                System.arraycopy(this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().getBytes(), 0, aliasb, 0, aliasb.length - hashAsBytesString.length);
                                System.arraycopy(hashAsBytesString, 0, aliasb, aliasb.length - hashAsBytesString.length, hashAsBytesString.length);
                                this.client.getRequestAnalizer().getHostDescriptor().addTagAlias(hash, hashAsBytesString);
                            }
                            etag = new byte[32];
                            System.arraycopy(Constants.ETAG_INQMY, 0, etag, 0, Constants.ETAG_INQMY.length);
                            System.arraycopy(aliasb, 0, etag, 32 - aliasb.length, aliasb.length);
                        }
                        this.headers.putHeader(Constants.sap_isc_etag, etag);
                    }
                }
                this.headers.putIntHeader(HeaderNames.entity_header_content_length_, (int)f.length());
                if (!this.checkRangeAndSend(f)) {
                    this.sendResponse(f);
                }
            } else {
                this.status_code = 304;
                this.reason_phrase = ResponseCodes._not_modified;
                if (this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0) {
                    this.headers.putDateHeader(HeaderNames.entity_header_expires_, System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
                } else {
                    this.headers.putHeader(HeaderNames.entity_header_cache_control_, this.client.getHttpProperties().getCacheValidationTimeString().getBytes());
                }
                this.sendResponse();
            }
        } else if (httpFile != null) {
            if (this.client.getRequestAnalizer().getHostPropertiesInternal().isList()) {
                this.status_code = 200;
                this.reason_phrase = ResponseCodes._ok;
                this.listDirectory();
            } else {
                String errorPage = this.checkError(403);
                if (errorPage != null) {
                    this.handleError(errorPage, 403, "You are not authorized to view the content of the requested directory. Directory listing is not allowed on this server.");
                } else {
                    this.sendResponse(this.constructError(403, "You are not authorized to view the content of the requested directory.".getBytes(), "Directory listing is not allowed on this server.".getBytes()));
                }
            }
        } else if (!this.client.getRequestAnalizer().getHostDescriptor().rootExists() && this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() == null) {
            Log.logWarning("A root directory for http virtual host [" + this.client.getRequestAnalizer().getHostDescriptor().getHostName() + "] is not specified or the specified directory does not exist. Correct the settings of this virtual host in Http Provider service. " + "Http error response [404 Not Found] will be returned for a request to this http virtual host.", null);
            String errorPage = this.checkError(404);
            if (errorPage != null) {
                this.handleError(errorPage, 404, "The requested resource does not exist. The root directory does not exist.");
            } else {
                this.sendResponse(this.constructError(404, "The requested resource does not exist.".getBytes(), "The root directory does not exist.".getBytes()));
            }
        } else {
            String errorPage;
            String alias = "";
            if (this.client.getRequestAnalizer().getRequestPathMappings().getAliasName() != null) {
                alias = this.client.getRequestAnalizer().getRequestPathMappings().getAliasName().toString();
            }
            if (!alias.startsWith("/")) {
                alias = "/" + alias;
            }
            if ((errorPage = this.checkError(404)) != null) {
                this.handleError(errorPage, 404, "The requested resource does not exist. Go to <A HREF=\"" + alias + "\" target=\"_parent\">main page</A> of this application!");
            } else {
                this.sendResponse(this.constructErrorHtmlAllowed(404, "The requested resource does not exist.".getBytes(), ("Go to <A HREF=\"" + alias + "\" target=\"_parent\">main page</A> of this application!").getBytes()));
            }
        }
    }

    protected void makeAnswer(HttpFile httpFile) {
        long processTime;
        if (!this.done) {
            String errorPage;
            if (ByteArrayUtils.equalsBytes(this.client.getRequest().getRequestLine().getMethod(), Methods._GET)) {
                this.answerGET(httpFile);
            } else if (ByteArrayUtils.equalsBytes(this.client.getRequest().getRequestLine().getMethod(), Methods._POST)) {
                this.answerGET(httpFile);
            } else if (ByteArrayUtils.equalsBytes(this.client.getRequest().getRequestLine().getMethod(), Methods._PUT)) {
                errorPage = this.checkError(405);
                if (errorPage != null) {
                    this.handleError(errorPage, 405, "You are not allowed to upload the file.");
                } else {
                    this.sendResponse(this.constructError(405, "You are not allowed to upload the file.".getBytes(), "No details available".getBytes()));
                }
            } else if (ByteArrayUtils.equalsBytes(this.client.getRequest().getRequestLine().getMethod(), Methods._HEAD)) {
                this.isHEAD = true;
                this.answerGET(httpFile);
            } else {
                this.headers.putHeader(HeaderNames.other_header_public_, Constants.allowed1);
                errorPage = this.checkError(501);
                if (errorPage != null) {
                    this.handleError(errorPage, 501, "The request method " + new String(this.client.getRequest().getRequestLine().getMethod()) + " is not implemented.");
                } else {
                    this.sendResponse(this.constructError(501, ("The request method " + new String(this.client.getRequest().getRequestLine().getMethod()) + " is not implemented.").getBytes(), Constants.allowed));
                }
            }
        }
        if ((processTime = this.client.getRequestAnalizer().getStartTime()) != -1L) {
            processTime = System.currentTimeMillis() - processTime;
        }
        String logHeader = null;
        if (this.client.getHttpProperties().getLogHeaderValue() != null) {
            logHeader = this.client.getRequest().getHeaders().getHeader(this.client.getHttpProperties().getLogHeaderValue());
        }
        if (this.responseLength != -1) {
            this.log.saveInLog(this.client.getIP(), this.client.getRequest().getRequestLine().toByteArray(), this.status_code, this.responseLength, processTime, logHeader);
        } else {
            this.log.saveInLog(this.client.getIP(), this.client.getRequest().getRequestLine().toByteArray(), this.status_code, this.headers.getIntHeader(HeaderNames.entity_header_content_length_), processTime, logHeader);
        }
    }

    protected void makeCachedAnswer(CacheQueueItem message) {
        long processTime;
        this.cachedReply = true;
        this.byteArrayOutputStream.reset();
        this.sendfile = true;
        long date1 = this.client.getRequestAnalizer().getDateHeader(HeaderNames.request_header_if_modified_since_);
        if (date1 != -1L) {
            boolean bl = this.sendfile = message.getDate() - date1 > 1000L || date1 - message.getDate() > 1000L;
        }
        if (this.sendfile) {
            this.headers.getDate(message.getEntity(), message.getEntity_date_pos());
            if (message.getExpiresHeaderPos() != -1) {
                this.headers.getDate(message.getEntity(), message.getExpiresHeaderPos(), System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
            }
            this.client.send(message.getEntity(), 0, message.getEntity().length, this.connectionFlag);
            if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
                this.markConnectionClosed();
            }
        } else {
            this.status_code = 304;
            if (message.getNot_modified_entity() == null) {
                this.byteArrayOutputStream.write(Constants.HTTP_11);
                this.byteArrayOutputStream.write(ResponseCodes.status_code_byte[304]);
                this.byteArrayOutputStream.write(32);
                this.byteArrayOutputStream.write(ResponseCodes._not_modified);
                this.byteArrayOutputStream.write(13);
                this.byteArrayOutputStream.write(10);
                this.byteArrayOutputStream.write(HeaderNames.response_header_server_);
                this.byteArrayOutputStream.write(": ".getBytes());
                this.byteArrayOutputStream.write(this.client.getRequestAnalizer().getHostDescriptor().getVersion());
                this.byteArrayOutputStream.write(13);
                this.byteArrayOutputStream.write(10);
                if (this.client.getRequest().getRequestLine().getHttpMajorVersion() > 0 && this.client.getRequest().getRequestLine().getHttpMinorVersion() > 0) {
                    if (!this.isPersistentConnection()) {
                        this.byteArrayOutputStream.write(HeaderNames.hop_header_connection_);
                        this.byteArrayOutputStream.write(": ".getBytes());
                        this.byteArrayOutputStream.write(HeaderValues.close_);
                        this.byteArrayOutputStream.write(13);
                        this.byteArrayOutputStream.write(10);
                    }
                } else if (this.isPersistentConnection()) {
                    this.byteArrayOutputStream.write(HeaderNames.hop_header_connection_);
                    this.byteArrayOutputStream.write(": ".getBytes());
                    this.byteArrayOutputStream.write(HeaderValues.keep_alive_);
                    this.byteArrayOutputStream.write(13);
                    this.byteArrayOutputStream.write(10);
                }
                this.byteArrayOutputStream.write(HeaderNames.entity_header_date_);
                this.byteArrayOutputStream.write(": ".getBytes());
                byte[] res = new byte[this.headers.getDateLength()];
                this.headers.getDate(res, 0);
                this.byteArrayOutputStream.write(res);
                this.byteArrayOutputStream.write(13);
                this.byteArrayOutputStream.write(10);
                message.setNot_modified_entity_date_pos(this.byteArrayOutputStream.size() - this.headers.getDateLength() - 2);
                if (message.getExpiresHeaderPos() != -1) {
                    this.byteArrayOutputStream.write(HeaderNames.entity_header_expires_);
                    this.byteArrayOutputStream.write(": ".getBytes());
                    message.setNot_modified_entity_expires_pos(this.byteArrayOutputStream.size());
                    this.headers.getDate(res, 0, System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
                    this.byteArrayOutputStream.write(res);
                    this.byteArrayOutputStream.write(13);
                    this.byteArrayOutputStream.write(10);
                } else {
                    this.byteArrayOutputStream.write(HeaderNames.entity_header_cache_control_);
                    this.byteArrayOutputStream.write(": ".getBytes());
                    this.byteArrayOutputStream.write(this.client.getHttpProperties().getCacheValidationTimeString().getBytes());
                    this.byteArrayOutputStream.write(13);
                    this.byteArrayOutputStream.write(10);
                }
                this.byteArrayOutputStream.write(13);
                this.byteArrayOutputStream.write(10);
                message.setNot_modified_entity(this.byteArrayOutputStream.toByteArray());
                this.client.send(message.getNot_modified_entity(), 0, message.getNot_modified_entity().length, this.connectionFlag);
                if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
                    this.markConnectionClosed();
                }
            } else {
                this.headers.getDate(message.getNot_modified_entity(), message.getNot_modified_entity_date_pos());
                if (message.getNot_modified_entity_expires_pos() != -1) {
                    this.headers.getDate(message.getNot_modified_entity(), message.getNot_modified_entity_expires_pos(), System.currentTimeMillis() + this.client.getHttpProperties().getCacheValidationTime() * 1000L);
                }
                this.client.send(message.getNot_modified_entity(), 0, message.getNot_modified_entity().length, this.connectionFlag);
                if ((this.connectionFlag & 1) == 1 && !this.isConnectionMarkedClosed()) {
                    this.markConnectionClosed();
                }
            }
        }
        if ((processTime = this.client.getRequestAnalizer().getStartTime()) != -1L) {
            processTime = System.currentTimeMillis() - processTime;
        }
        String logHeader = null;
        if (this.client.getHttpProperties().getLogHeaderValue() != null) {
            logHeader = this.client.getRequest().getHeaders().getHeader(this.client.getHttpProperties().getLogHeaderValue());
        }
        if (this.responseLength != -1) {
            this.log.saveInLog(this.client.getIP(), this.client.getRequest().getRequestLine().toByteArray(), this.status_code, this.responseLength, processTime, logHeader);
        } else {
            this.log.saveInLog(this.client.getIP(), this.client.getRequest().getRequestLine().toByteArray(), this.status_code, this.status_code == 304 ? 0 : (int)message.getSizeBodyOnly(), processTime, logHeader);
        }
    }

    boolean isConnectionMarkedClosed() {
        return this.connectionClosed;
    }

    private void markConnectionClosed() {
        this.connectionClosed = true;
    }

    protected boolean isNotSendAnyMore() {
        return this.notSendAnyMore;
    }

    protected void setResponseLength(int totalCount) {
        this.responseLength = totalCount;
    }

    protected boolean isReplyFromCache() {
        return this.cachedReply;
    }

    protected int getResponseCode() {
        return this.status_code;
    }

    private void checkEOBody() {
        if (this.status_code >= 200 && this.status_code != 204 && this.status_code != 304 && this.getHeaders().getHeader(HeaderNames.entity_header_content_length_) == null && !"close".equalsIgnoreCase(this.getHeaders().getHeader("Connection")) && this.getHeaders().getHeader(HeaderNames.hop_header_transfer_encoding_) == null) {
            this.getHeaders().addIntHeader(HeaderNames.entity_header_content_length_, 0);
        }
    }

    protected String checkError(int errorCode) {
        this.client.getHttpProvider();
        if (HttpProviderImpl.getWebContainer() == null) {
            return null;
        }
        this.client.getHttpProvider();
        return HttpProviderImpl.getWebContainer().checkError(errorCode, (HttpParameters)this.client.getRequestAnalizer());
    }

    protected void handleError(String errorPage, int errorCode, String message) {
        this.client.getHttpProvider();
        HttpProviderImpl.getWebContainer().handleError(errorPage, errorCode, message, this.client.getRequestAnalizer());
        this.finishError();
    }

    protected String checkError(Throwable exception) {
        this.client.getHttpProvider();
        if (HttpProviderImpl.getWebContainer() == null) {
            return null;
        }
        this.client.getHttpProvider();
        return HttpProviderImpl.getWebContainer().checkError(exception, (HttpParameters)this.client.getRequestAnalizer());
    }

    protected void handleError(String errorPage, Throwable exception) {
        this.client.getHttpProvider();
        HttpProviderImpl.getWebContainer().handleError(errorPage, exception, this.client.getRequestAnalizer());
        this.finishError();
    }

    private void finishError() {
        if (this.isLdtUsed()) {
            Processor.longDataHash.remove((long)this.client.getDispatcherId() << 32 | (long)this.client.getClientId() & 0xFFFFFFFFL);
        }
        if (!this.isConnectionMarkedClosed()) {
            if (this.sendAlert()) {
                this.client.send(this.client.getRequestAnalizer().getAlertMessage(), 0, this.client.getRequestAnalizer().getAlertMessage().length, (byte)1);
            } else if (!this.isNotSendAnyMore()) {
                this.client.send(new byte[0], 0, 0, this.getConnectionFlag());
            }
        }
    }

    private void setConnectionType() {
        HttpInputStream requestBody = null;
        try {
            requestBody = (HttpInputStream)this.client.getRequest().getBody();
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            Log.logWarning("Cannot get input stream for reading request body.", t, null);
        }
        if (requestBody != null && !requestBody.isEmpty()) {
            this.setPersistentConnection(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

