/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.interfaces.client.RequestLine;
import com.sap.engine.services.httpserver.interfaces.client.SslAttributes;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.Cookies;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.impl.RequestLineImpl;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.SslAttributesImpl;
import com.sap.engine.services.httpserver.server.io.ChunkedInputStream;
import com.sap.engine.services.httpserver.server.io.HttpInputStream;
import com.sap.engine.services.httpserver.server.properties.ProxyMappings;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import javax.servlet.ServletInputStream;

public class RequestImpl
implements Request {
    private Client client = null;
    private RequestLineImpl requestLine = null;
    private MimeHeaders headers = null;
    private HttpInputStream inputStream = null;
    private ChunkedInputStream chunkedInputStream = null;
    private SslAttributesImpl sslAttributes = null;
    private Cookies cookies = new Cookies();
    private byte[] hostBytes = null;
    private String host = null;
    private int port = -1;
    private boolean portParsed = false;
    private boolean parsedCookies = false;
    private boolean hostBytesParsed = false;
    private boolean readBodyFromStream = false;
    private boolean acceptGzipEncoding = false;
    private MessageBytes paramsBody = null;
    private byte[] input = null;
    private String scheme = "http";

    public RequestImpl(Client client, RequestLineImpl requestLine) {
        this.requestLine = requestLine;
        this.client = client;
        this.headers = new MimeHeaders();
    }

    public void reset() {
        this.inputStream = null;
        this.chunkedInputStream = null;
        this.sslAttributes = null;
        this.readBodyFromStream = false;
        this.acceptGzipEncoding = false;
        this.paramsBody = null;
        this.input = null;
        this.parsedCookies = false;
        this.hostBytes = null;
        this.host = null;
        this.hostBytesParsed = false;
        this.port = -1;
        this.portParsed = false;
        this.scheme = "http";
        this.headers.clear();
        this.cookies.reset();
    }

    public void init(RequestImpl oldRequest) {
        this.requestLine.init(oldRequest.requestLine);
        if (oldRequest.sslAttributes != null) {
            this.sslAttributes = new SslAttributesImpl();
            this.sslAttributes.init(oldRequest.sslAttributes, this.client);
        }
        this.headers = (MimeHeaders)oldRequest.headers.clone();
        this.cookies.init(oldRequest.cookies);
        this.inputStream = oldRequest.inputStream;
        this.chunkedInputStream = oldRequest.chunkedInputStream;
        this.parsedCookies = oldRequest.parsedCookies;
        this.readBodyFromStream = oldRequest.readBodyFromStream;
        this.acceptGzipEncoding = oldRequest.acceptGzipEncoding;
        this.paramsBody = oldRequest.paramsBody;
        this.input = oldRequest.input;
        this.hostBytes = oldRequest.hostBytes;
        this.hostBytesParsed = oldRequest.hostBytesParsed;
        this.port = oldRequest.port;
        this.portParsed = oldRequest.portParsed;
        this.scheme = oldRequest.scheme;
    }

    protected void clearInputStream() {
        if (this.inputStream != null) {
            this.inputStream.releaseBuffers();
        }
    }

    public void setSslAttributes(SslAttributesImpl sslAttributes) {
        this.sslAttributes = sslAttributes;
    }

    public void initSslAttributes() {
        if (this.sslAttributes == null && this.client.getHttpProperties().getProxyServersProperties().acceptClientCertWithoutSSL()) {
            this.sslAttributes = new SslAttributesImpl();
            this.sslAttributes.setClient(this.client);
        }
        if (this.sslAttributes != null) {
            this.sslAttributes.initCertificates();
        }
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public ServletInputStream getBody() {
        if (this.inputStream == null) {
            this.readBody();
        }
        if (this.chunkedInputStream != null) {
            return this.chunkedInputStream;
        }
        return this.inputStream;
    }

    public SslAttributes getSslAttributes() {
        return this.sslAttributes;
    }

    public byte[] getClientIP() {
        return this.client.getIP();
    }

    public int getClientId() {
        return this.client.getClientId();
    }

    public String getHost() {
        if (this.host == null) {
            this.parseHost();
        }
        return this.host;
    }

    public HttpCookie getSessionCookie(boolean urlSessionTracking) {
        HttpCookie sessionCookie;
        if (!this.parsedCookies) {
            this.parseCookies(urlSessionTracking);
            this.parsedCookies = true;
        }
        if ((sessionCookie = this.cookies.getSessionCookie()).getName() == null) {
            return null;
        }
        return sessionCookie;
    }

    public ArrayObject getApplicationCookies(boolean urlSessionTracking) {
        if (!this.parsedCookies) {
            this.parseCookies(urlSessionTracking);
            this.parsedCookies = true;
        }
        return this.cookies.getApplicationCookies();
    }

    public ArrayObject getCookies(boolean urlSessionTracking) {
        if (!this.parsedCookies) {
            this.parseCookies(urlSessionTracking);
            this.parsedCookies = true;
        }
        return this.cookies.getCookies();
    }

    public boolean isGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public int getDispatcherId() {
        return this.client.getDispatcherId();
    }

    protected boolean nextRequestPart(byte[] input, int offset, int len) {
        return this.inputStream.fill(input, offset, len);
    }

    protected void connectionClosed() {
        if (this.inputStream != null) {
            this.inputStream.connectionClosed();
        }
    }

    protected void setAcceptGZipEncoding(boolean acceptGZipEncoding) {
        this.acceptGzipEncoding = acceptGZipEncoding;
    }

    protected void readBody() {
        if (this.paramsBody == null) {
            this.paramsBody = this.readFormData(this.input);
        }
    }

    protected byte[] getHostBytes() {
        if (!this.hostBytesParsed) {
            this.parseHostBytes();
        }
        return this.hostBytes;
    }

    public int getPort() {
        if (!this.portParsed) {
            this.parsePort();
        }
        return this.port;
    }

    public String getScheme() {
        if (!this.hostBytesParsed) {
            this.parseHostBytes();
        }
        return this.scheme;
    }

    protected MessageBytes getRequestParametersBody() {
        if (this.paramsBody == null && this.inputStream == null) {
            this.readBody();
        }
        if (!this.readBodyFromStream) {
            try {
                this.readBodyFromStream();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.logWarning("Error reading request body.", e, this.client.getIP());
            }
            this.readBodyFromStream = true;
        }
        return this.paramsBody;
    }

    protected void setScheme(String schemeFromProxy) {
        this.scheme = schemeFromProxy;
    }

    private void readBodyFromStream() throws IOException {
        int content_len = this.headers.getIntHeader(HeaderNames.entity_header_content_length_);
        if (content_len > 0) {
            byte[] buf = new byte[content_len];
            int ptr = 0;
            int all = 0;
            while (all < content_len && (ptr = this.inputStream.read(buf, all, buf.length - all)) != -1) {
                all += ptr;
            }
            this.paramsBody = new MessageBytes(buf);
        } else {
            this.paramsBody = new MessageBytes();
            byte[] buf = new byte[512];
            int ptr = 0;
            int all = 0;
            while ((ptr = this.inputStream.read(buf, all, buf.length - all)) != -1) {
                if ((all += ptr) != buf.length) continue;
                this.paramsBody.appendAfter(buf);
                ptr = 0;
                all = 0;
            }
            if (all > 0) {
                byte[] bufff = new byte[all];
                System.arraycopy(buf, 0, bufff, 0, all);
                this.paramsBody.appendAfter(bufff);
            }
        }
    }

    private MessageBytes readFormData(byte[] inputstream) {
        byte[] transferEncoding = this.headers.getHeader(HeaderNames.hop_header_transfer_encoding_);
        if (ByteArrayUtils.equalsBytes(HeaderValues.chunked_, transferEncoding)) {
            this.inputStream = new HttpInputStream(this.client.getHttpProperties(), inputstream, inputstream.length, this.client);
            this.chunkedInputStream = new ChunkedInputStream((InputStream)((Object)this.inputStream));
            Processor.connectionInfoHash.put(this.client.getClientId(), (Object)this.client.getResponse());
            this.client.send(new byte[0], 0, 0, (byte)16);
            this.send100();
            return null;
        }
        long content_len = this.headers.getLongHeader(HeaderNames.entity_header_content_length_);
        if (content_len <= 0L) {
            this.readBodyFromStream = true;
            return new MessageBytes();
        }
        if (content_len <= (long)inputstream.length) {
            byte[] formData = new byte[(int)content_len];
            System.arraycopy(inputstream, 0, formData, 0, (int)content_len);
            this.inputStream = new HttpInputStream(this.client.getHttpProperties(), (int)content_len, formData, (int)content_len, this.client);
            return new MessageBytes(formData, 0, (int)content_len);
        }
        this.inputStream = new HttpInputStream(this.client.getHttpProperties(), content_len, inputstream, inputstream.length, this.client);
        Processor.connectionInfoHash.put(this.client.getClientId(), (Object)this.client.getResponse());
        this.client.send(new byte[0], 0, 0, (byte)16);
        this.send100();
        return null;
    }

    private void parseCookies(boolean urlSessionTracking) {
        if (urlSessionTracking) {
            CookieParser.parseCookiesFromURL(this.requestLine.getFullUrl(), this.cookies);
            return;
        }
        CookieParser.parseCookies(this.headers, urlSessionTracking, this.cookies);
        if (this.cookies.getCookies().size() == 0) {
            CookieParser.parseCookiesFromURL(this.requestLine.getFullUrl(), this.cookies);
        }
    }

    private void parseHostBytes() {
        byte[] hostName;
        int ind = -1;
        int result = this.parseProxyMappings();
        if (result == 0) {
            return;
        }
        if (result != 1) {
            String schemeFromProxy = this.getHeaders().getHeader(this.client.getHttpProperties().getProxyServersProperties().getProtocolHeaderName());
            if (schemeFromProxy != null) {
                this.requestLine.setScheme(schemeFromProxy);
                this.setScheme(this.requestLine.getScheme());
            }
            this.scheme = this.requestLine.getScheme();
        }
        if ((hostName = this.headers.getHeader(HeaderNames.request_header_host_)) == null) {
            this.hostBytes = this.requestLine.getHost();
            if (this.hostBytes == null) {
                if (result == 1) {
                    this.parseDefaultProxyMappings();
                } else {
                    this.parseProxyMappings();
                    String schemeFromProxy = this.getHeaders().getHeader(this.client.getHttpProperties().getProxyServersProperties().getProtocolHeaderName());
                    if (schemeFromProxy != null) {
                        this.requestLine.setScheme(schemeFromProxy);
                        this.setScheme(this.requestLine.getScheme());
                    }
                }
            } else {
                this.port = this.requestLine.getPort();
                this.host = null;
            }
        } else {
            this.host = null;
            ind = ByteArrayUtils.indexOf(hostName, (byte)58);
            if (ind != -1) {
                this.hostBytes = new byte[ind];
                System.arraycopy(hostName, 0, this.hostBytes, 0, ind);
                if (ind < hostName.length) {
                    this.port = Ascii.asciiArrToIntNoException(hostName, ind + 1, hostName.length - ind - 1);
                    if (this.port == -1) {
                        this.port = this.client.getPort();
                    }
                }
            } else {
                this.hostBytes = hostName;
                this.port = this.requestLine.isSecure() ? 443 : 80;
            }
        }
        this.hostBytesParsed = true;
        this.portParsed = true;
    }

    private void parseHost() {
        byte[] hostName = this.getHostBytes();
        if (hostName != null) {
            this.host = new String(hostName);
        } else {
            int dispatcherId = this.client.getDispatcherId();
            this.port = this.client.getPort();
            ClusterElement[] ce = this.client.getClusterElements();
            int i = 0;
            while (i < ce.length) {
                if (ce[i].getClusterId() == dispatcherId) {
                    this.host = ce[i].getAddress().getHostName();
                    return;
                }
                ++i;
            }
            InetAddress addr = this.client.getCurrentClusterElement().getAddress();
            if (addr == null) {
                this.host = "localhost";
                Log.logWarning("Can't get the name of the local host.", this.client.getIP());
            } else {
                this.host = addr.getHostName();
            }
        }
    }

    private void parseDefaultProxyMappings() {
        ProxyMappings dp = HttpServerFrame.getDefaultProxyMappings(this.client.getDispatcherId(), this.client.getPort());
        if (dp == null) {
            return;
        }
        this.host = dp.getHost();
        this.port = dp.getPort();
    }

    private int parseProxyMappings() {
        ProxyMappings dp = HttpServerFrame.getProxyMappings(this.client.getDispatcherId(), this.client.getPort());
        if (dp != null) {
            this.host = dp.getHost();
            this.port = dp.getPort();
            this.scheme = dp.getScheme();
            if (dp.isOverride() && dp.getScheme() != null) {
                if (dp.getHost() != null && dp.getPort() != -1) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    private void parsePort() {
        if (!this.hostBytesParsed) {
            this.parseHostBytes();
        }
    }

    private void send100() {
        if (this.requestLine.getHttpMajorVersion() == 0) {
            return;
        }
        byte[] expectValue = this.getHeaders().getHeader(HeaderNames.request_header_expect_);
        if (expectValue == null) {
            return;
        }
        if (!ByteArrayUtils.equalsIgnoreCase(expectValue = ByteArrayUtils.trim(expectValue), HeaderValues._100_continue_)) {
            return;
        }
        byte[] code = ResponseCodes.status_code_byte[100];
        byte[] reason = ResponseCodes.reasonBytes(100, "");
        byte[] response = new byte[Constants.HTTP_11.length + code.length + 1 + reason.length + 4];
        int off = 0;
        System.arraycopy(Constants.HTTP_11, 0, response, 0, Constants.HTTP_11.length);
        System.arraycopy(code, 0, response, off += Constants.HTTP_11.length, code.length);
        off += code.length;
        response[off++] = 32;
        System.arraycopy(reason, 0, response, off, reason.length);
        off += reason.length;
        response[off++] = 13;
        response[off++] = 10;
        response[off++] = 13;
        response[off++] = 10;
        this.client.send(response, 0, response.length);
    }
}

