/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.interfaces.ErrorData;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.interfaces.client.Response;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ProtocolParser;
import com.sap.engine.services.httpserver.lib.RequestPathMappings;
import com.sap.engine.services.httpserver.lib.impl.RequestLineImpl;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.lib.protocol.Methods;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.CharArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.HttpFile;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.RequestImpl;
import com.sap.engine.services.httpserver.server.ResponseImpl;
import com.sap.engine.services.httpserver.server.SslAttributesImpl;
import com.sap.engine.services.httpserver.server.StaticDataProcessor;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItem;
import com.sap.engine.services.httpserver.server.cache.CacheQueueItemKey;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.hosts.HostProperties;
import com.sap.engine.services.httpserver.server.properties.HttpCompressedProperties;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import com.sap.engine.services.httpserver.server.properties.MimeMappings;
import com.sap.engine.services.httpserver.server.properties.ProxyMappings;
import java.io.File;
import java.util.Hashtable;

public class RequestAnalizer
implements HttpParameters,
Constants,
Cloneable {
    private Client client = null;
    private RequestLineImpl requestLine = null;
    private RequestImpl request = null;
    private ResponseImpl response = null;
    private Host host = null;
    private RequestPathMappings requestPathMappings = new RequestPathMappings();
    private StaticDataProcessor staticDataProcessor = null;
    private ErrorData errorData = null;
    private MessageBytes filename = null;
    private MessageBytes aliasPathAndFileName = null;
    private byte[] alertMessageFromServlet = null;
    private boolean isProtected = false;
    private Object applicationSession = null;
    private boolean isICM = false;
    private boolean isApplicationCookie = false;
    private boolean isSessionCookie = false;
    private Hashtable requestAttributes = new Hashtable();
    private long startTime = -1L;
    private boolean isDebugRequest = false;

    public RequestAnalizer(Client client) {
        this.client = client;
        this.requestLine = new RequestLineImpl();
        this.request = new RequestImpl(client, this.requestLine);
        this.staticDataProcessor = new StaticDataProcessor();
    }

    public void init(boolean isICM, SslAttributesImpl sslAttributes, boolean isSsl) {
        this.response = this.client.getResponse();
        this.requestLine.setScheme(isSsl);
        this.isICM = isICM;
        this.request.setSslAttributes(sslAttributes);
        this.staticDataProcessor.init(this.client, this.request, this.response);
    }

    protected void recycle() {
        this.request.clearInputStream();
        this.request.getHeaders().clear();
        this.filename = null;
        this.aliasPathAndFileName = null;
        this.alertMessageFromServlet = null;
        this.isProtected = false;
        this.applicationSession = null;
        this.host = null;
        this.isICM = false;
        this.requestLine.reset();
        this.request.reset();
        this.requestPathMappings.init();
        this.isApplicationCookie = false;
        this.isSessionCookie = false;
        this.errorData = null;
        this.requestAttributes.clear();
        this.startTime = -1L;
        this.isDebugRequest = false;
    }

    public Object clone() {
        Client newClient = new Client();
        System.arraycopy(this.client.getIP(), 0, newClient.getIP(), 0, this.client.getIP().length);
        newClient.init(this.client.getPort(), this.client.getDispatcherId(), this.client.getClientId(), this.isICM, this.requestLine.isSecure(), (SslAttributesImpl)this.request.getSslAttributes());
        newClient.getRequestAnalizer().filename = this.filename;
        newClient.getRequestAnalizer().aliasPathAndFileName = this.aliasPathAndFileName;
        newClient.getRequestAnalizer().requestLine = (RequestLineImpl)this.requestLine.clone();
        newClient.getRequestAnalizer().alertMessageFromServlet = this.alertMessageFromServlet;
        newClient.getRequestAnalizer().isProtected = this.isProtected;
        newClient.getRequestAnalizer().applicationSession = this.applicationSession;
        newClient.getRequestAnalizer().host = this.host;
        newClient.getRequestAnalizer().isICM = this.isICM;
        newClient.getRequestAnalizer().isApplicationCookie = this.isApplicationCookie;
        newClient.getRequestAnalizer().isSessionCookie = this.isSessionCookie;
        newClient.getRequestAnalizer().isDebugRequest = this.isDebugRequest;
        if (this.errorData != null) {
            newClient.getRequestAnalizer().errorData = (ErrorData)this.errorData.clone();
        }
        newClient.getRequestAnalizer().requestAttributes = (Hashtable)this.requestAttributes.clone();
        newClient.getRequestAnalizer().startTime = this.startTime;
        newClient.getRequestAnalizer().requestPathMappings = new RequestPathMappings();
        newClient.getRequestAnalizer().requestPathMappings.setAlias(this.requestPathMappings.getAliasName(), this.requestPathMappings.getAliasValue(), this.requestPathMappings.isZoneExactAlias());
        newClient.getRequestAnalizer().requestPathMappings.setPathInfo(this.requestPathMappings.getPathInfo());
        newClient.getRequestAnalizer().requestPathMappings.setServletPath(this.requestPathMappings.getServletPath());
        newClient.getRequestAnalizer().requestPathMappings.setServletName(this.requestPathMappings.getServletName());
        newClient.getRequestAnalizer().requestPathMappings.setRealPath(this.requestPathMappings.getRealPath());
        newClient.getRequestAnalizer().requestPathMappings.setFilterChain(this.requestPathMappings.getFilterChain());
        newClient.getResponse().init(this.client.getResponse());
        ((RequestImpl)newClient.getRequest()).init((RequestImpl)this.client.getRequest());
        ((RequestLineImpl)newClient.getRequest().getRequestLine()).init((RequestLineImpl)this.client.getRequest().getRequestLine());
        newClient.getRequestAnalizer().staticDataProcessor.init(newClient, (RequestImpl)newClient.getRequest(), newClient.getResponse());
        return newClient.getRequestAnalizer();
    }

    protected boolean isICM() {
        return this.isICM;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public byte[] getHeader(byte[] name) {
        return this.request.getHeaders().getHeader(name);
    }

    public long getDateHeader(byte[] name) {
        return this.request.getHeaders().getDateHeader(name);
    }

    public MessageBytes getFilename() {
        return this.filename;
    }

    public MessageBytes getFilename1() {
        return this.aliasPathAndFileName;
    }

    public boolean initialize(byte[] input, int offset, int length) {
        try {
            if (this.client.getHttpProperties().logResponseTime()) {
                this.startTime = System.currentTimeMillis();
            }
            int inputOffset = this.requestLine.parseRequestLine(input, offset);
            length -= inputOffset - offset;
            offset = inputOffset;
            if (!this.requestLine.isSimpleRequest()) {
                inputOffset = this.request.getHeaders().init(input, offset, length);
                length -= inputOffset - offset;
                offset = inputOffset;
            }
            byte[] newInput = null;
            if (length > 0) {
                newInput = new byte[length];
                System.arraycopy(input, offset, newInput, 0, newInput.length);
            } else {
                newInput = new byte[]{};
            }
            this.request.setInput(newInput);
            this.host = this.client.getHost(this.request.getHostBytes());
            if (this.host == null) {
                this.host = this.client.getHost(Constants.defaultBytes);
            }
            this.request.initSslAttributes();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.host == null) {
                this.host = this.client.getHost(Constants.defaultBytes);
            }
            this.client.getLog();
            Log.logWarning("Cannot parse an http request. Http error response [400 Bad Request] will be returned. The request is [" + new String(input, offset, length) + "].", t, this.requestLine.getHost());
            this.response.sendResponse(this.response.constructError(400, "The request can't be parsed properly.".getBytes(), this.client.getLog().getExceptionStackTrace(t).getBytes()));
            return false;
        }
        return true;
    }

    public void handle() {
        try {
            this.parseInitialHeaders();
            if (this.replyFromCache()) {
                return;
            }
            HttpFile httpFile = null;
            if (!this.findStartPage()) {
                this.findAndInitAlias();
                if (!this.invokeWebContainer()) {
                    httpFile = this.findRequestedFile();
                }
            }
            this.response.makeAnswer(httpFile);
            this.client.getHttpProvider();
            if (HttpProviderImpl.getWebContainer() != null) {
                this.client.getHttpProvider();
                HttpProviderImpl.getWebContainer().endRequest(this);
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.host == null) {
                this.host = this.client.getHost(Constants.defaultBytes);
            }
            this.client.getLog();
            Log.logWarning("Cannot parse and process an http request. Http error response [400 Bad Request] will be returned.", t, this.requestLine.getHost());
            this.response.sendResponse(this.response.constructError(400, "The request can't be parsed properly.".getBytes(), this.client.getLog().getExceptionStackTrace(t).getBytes()));
        }
    }

    public HostProperties getHostProperties() {
        return this.host.getHostProperties();
    }

    public HostProperties getHostPropertiesInternal() {
        return this.host.getHostProperties();
    }

    public Host getHostDescriptor() {
        return this.host;
    }

    public ConcurrentHashMapObjectObject getTranslationTable() {
        return this.host.getTranslationTable();
    }

    public boolean nextRequestPart(byte[] input, int offset, int len) {
        return this.request.nextRequestPart(input, offset, len);
    }

    public void connectionClosed() {
        this.request.connectionClosed();
    }

    private void sendChangeSchemaToSSlAfterCheckMap() {
        this.requestLine.getFullUrl().appendBefore(this.getSslHostPortScheme().getBytes());
        this.response.sendChangeLocation(this.requestLine.getFullUrl().getBytes());
        this.response.done();
    }

    private void startServlet(MessageBytes servletName) {
        if (this.requestPathMappings.getServletPath() == null) {
            if (this.requestLine.isEncoded()) {
                this.requestPathMappings.setServletPath(this.requestLine.getUrlDecoded().toStringUTF8());
            } else {
                this.requestPathMappings.setServletPath(this.requestLine.getUrlDecoded().toString());
            }
            if (!this.requestPathMappings.getAliasName().equals(ParseUtils.separatorBytes) || this.requestPathMappings.getZoneName() != null) {
                int idx;
                MessageBytes aliasName = new MessageBytes(this.requestPathMappings.getAliasName().getBytes());
                aliasName.replace((byte)File.separatorChar, (byte)47);
                if ((this.requestLine.getUrlDecoded().startsWith(aliasName) || this.requestLine.getUrlDecoded().startsWith("/" + aliasName)) && (idx = this.requestLine.getUrlDecoded().indexOf("/", this.requestLine.getUrlDecoded().indexOf(aliasName.toString()) + aliasName.length())) > 0) {
                    if (this.requestLine.isEncoded()) {
                        this.requestPathMappings.setServletPath(this.requestLine.getUrlDecoded().toStringUTF8(idx));
                    } else {
                        this.requestPathMappings.setServletPath(this.requestLine.getUrlDecoded().toString(idx));
                    }
                }
            }
        } else {
            int indPath = this.requestLine.getFullUrl().indexOf((this.requestPathMappings.getServletPath() + "/").getBytes());
            if (indPath > -1) {
                this.requestPathMappings.setPathInfo(this.requestLine.getFullUrl().toString(indPath + this.requestPathMappings.getServletPath().length()));
            }
        }
        this.startServlet(servletName.toString());
        if (this.response.isLdtUsed()) {
            Processor.longDataHash.remove((long)this.client.getDispatcherId() << 32 | (long)this.client.getClientId() & 0xFFFFFFFFL);
        }
        if (!this.response.isConnectionMarkedClosed() && !this.response.isLocked()) {
            if (this.response.sendAlert()) {
                this.client.send(this.alertMessageFromServlet, 0, this.alertMessageFromServlet.length, (byte)1);
            } else if (!this.response.isNotSendAnyMore()) {
                this.client.send(new byte[0], 0, 0, this.response.getConnectionFlag());
            }
        }
        this.response.done();
    }

    private void startServlet(String servletName) {
        this.client.getHttpProvider();
        HttpProviderImpl.getWebContainer().handleRequest(servletName, this);
    }

    private boolean findStartPage() {
        if (this.host.getHostProperties().getStartPage() != null && this.requestLine.getUrlDecoded().equals("/") && !ByteArrayUtils.equalsBytes(this.requestLine.getMethod(), Methods._PUT)) {
            this.response.setChangeLocation(this.host.getHostProperties().getStartPage().getBytes());
            this.filename = new MessageBytes((this.host.getHostProperties().getRootDir() + '/' + this.host.getHostProperties().getStartPage()).getBytes());
            return true;
        }
        return false;
    }

    private void findAndInitAlias() throws Exception {
        this.requestLine.getUrlDecoded().replace((byte)47, (byte)47);
        this.requestLine.getUrlDecoded().replace((byte)92, (byte)47);
        this.aliasPathAndFileName = this.replaceAliases(this.requestLine.getUrlDecoded());
        int indx = this.aliasPathAndFileName.lastIndexOf('/');
        this.requestPathMappings.setRealPath(this.aliasPathAndFileName.getBytes());
        if (indx > 0) {
            this.requestPathMappings.setRealPath(this.aliasPathAndFileName.getBytes(0, indx + 1));
        }
    }

    private HttpFile findRequestedFile() throws Exception {
        if (ByteArrayUtils.equalsBytes(this.requestLine.getMethod(), Methods._PUT)) {
            return null;
        }
        this.client.getHttpProvider();
        if (HttpProviderImpl.getWebContainer() == null && this.requestPathMappings.getAliasName() != null && this.host.getHostProperties().isApplicationAlias(this.requestPathMappings.getAliasName().toString())) {
            this.response.sendResponse(this.response.constructError(503, "Can't process a request for dynamic resources.".getBytes(), "Web container not available!".getBytes()));
            this.response.done();
            return null;
        }
        HttpFile httpFile = this.staticDataProcessor.getFileForRequest();
        if (httpFile != null) {
            this.filename = new MessageBytes(httpFile.getIOFileNameCannonicalBytes());
            this.staticDataProcessor.initForwarding();
        }
        return httpFile;
    }

    public MessageBytes getRequestParametersBody() {
        return this.request.getRequestParametersBody();
    }

    private String getSslHostPortScheme() {
        ProxyMappings dp;
        String scheme = this.request.getScheme();
        String host = this.request.getHost();
        int port = this.request.getPort();
        if (this.response.isSchemeChanged() && (dp = HttpServerFrame.getSslProxyMappings(this.client.getDispatcherId())) != null) {
            port = dp.getPort();
            scheme = dp.getScheme();
            if (dp.isOverride() || null == host) {
                host = dp.getHost();
            }
        }
        return ProtocolParser.makeAbsolute(scheme, host, port);
    }

    public RequestPathMappings getRequestPathMappings() {
        return this.requestPathMappings;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    private MessageBytes replaceAliases(MessageBytes fname) {
        if (fname == null || fname.equals("") || fname.equals(ParseUtils.separatorBytes)) {
            if (this.host.getHostProperties().isApplicationAliasEnabled("/")) {
                String value = this.host.getHostProperties().getAliasValue("/");
                if (value == null) {
                    value = "";
                }
                this.requestPathMappings.setAlias(new MessageBytes(ParseUtils.separatorBytes), value, this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
                }
                return new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
            }
            if (this.host.getHostProperties().getAliasValue("/") != null) {
                this.requestPathMappings.setAlias(new MessageBytes(ParseUtils.separatorBytes), this.host.getHostProperties().getAliasValue("/"), this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
                }
                return new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
            }
            this.requestPathMappings.setAlias(this.requestPathMappings.getAliasName(), this.host.getHostProperties().getRootDir(), this.requestPathMappings.getAliasName() != null && this.client.getHttpProvider().getZoneManagement().isExactAlias(this.requestPathMappings.getAliasName().toString()));
            if (!this.requestPathMappings.isZoneExactAlias() && this.requestPathMappings.getAliasName() != null && this.getHttpProperties().getLogonTable().getGroup(this.requestPathMappings.getAliasName().toString()) != null) {
                this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup(this.requestPathMappings.getAliasName().toString()), true);
            }
            return new MessageBytes(this.host.getHostProperties().getRootDir().getBytes());
        }
        MessageBytes res = this.findAliases(fname);
        if (res != null) {
            if (!res.endsWith("/") && !res.endsWith(File.separator)) {
                res.appendAfter(ParseUtils.separatorBytes);
            }
            return res;
        }
        if (this.host.getHostProperties().isApplicationAliasEnabled("/")) {
            String value = this.host.getHostProperties().getAliasValue("/");
            if (value == null) {
                value = "";
            }
            this.requestPathMappings.setAlias(new MessageBytes("/".getBytes()), value, this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
            if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
            }
            MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
            m.appendAfter(ParseUtils.separatorBytes);
            m.appendAfter(fname.getBytes());
            return m;
        }
        if (this.host.getHostProperties().getAliasValue("/") != null) {
            this.requestPathMappings.setAlias(new MessageBytes("/".getBytes()), this.host.getHostProperties().getAliasValue("/"), this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
            if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
            }
            MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
            m.appendAfter(ParseUtils.separatorBytes);
            m.appendAfter(fname.getBytes());
            return m;
        }
        this.requestPathMappings.setAlias(null, this.host.getHostProperties().getRootDir(), false);
        MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
        m.appendAfter(ParseUtils.separatorBytes);
        m.appendAfter(fname.getBytes());
        return m;
    }

    private MessageBytes findAliases(MessageBytes fname) {
        MessageBytes fnameTemp;
        if (fname.length() == 0) {
            fname = fnameTemp = new MessageBytes(new byte[0]);
        } else if (fname.charAt(0) == '/') {
            fname = fnameTemp = new MessageBytes(fname.getBytes(1, fname.length() - 1));
        }
        int i = fname.indexOf("/");
        if (i == -1) {
            String alpr = this.host.getHostProperties().getAliasValue(fname.toString());
            if (alpr != null) {
                this.requestPathMappings.setAlias(fname, alpr, this.client.getHttpProvider().getZoneManagement().isExactAlias(fname.toString()));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup(fname.toString()) != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup(fname.toString()), true);
                }
                MessageBytes pth = new MessageBytes(Ascii.getBytes(alpr));
                if (!fname.equals("")) {
                    this.response.setChangeLocation(fname.addByteAtBeginAndEnd((byte)47, (byte)47));
                    return pth;
                }
            }
        } else {
            MessageBytes part = new MessageBytes(fname.getBytes());
            int j = part.length();
            do {
                MessageBytes pth;
                part = new MessageBytes(part.getBytes(0, j));
                String alpr = this.host.getHostProperties().getAliasValue(part.toString());
                if (alpr == null) continue;
                this.requestPathMappings.setAlias(new MessageBytes(part.getBytes()), alpr, this.client.getHttpProvider().getZoneManagement().isExactAlias(part.toString()));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup(part.toString()) != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup(part.toString()), true);
                }
                if (!(pth = new MessageBytes(Ascii.getBytes(alpr))).equals("")) {
                    pth.appendAfter(fname.getBytes(part.length()));
                }
                return pth;
            } while ((j = part.lastIndexOf((byte)47)) > -1);
        }
        if (this.client.getHttpProperties().getZoneSeparator() == null) {
            return null;
        }
        int zoneInd = fname.indexOf(this.client.getHttpProperties().getZoneSeparator());
        if (zoneInd <= -1) {
            return null;
        }
        int endInd = fname.indexOf('/', zoneInd + 1);
        if (endInd <= -1) {
            endInd = fname.length();
        }
        String zone = new String(fname.getBytes(), zoneInd + this.client.getHttpProperties().getZoneSeparator().length(), endInd - zoneInd - this.client.getHttpProperties().getZoneSeparator().length());
        String fnameWithoutZone = new String(fname.getBytes(), 0, zoneInd) + new String(fname.getBytes(), endInd, fname.length() - endInd);
        MessageBytes result = this.findAliases(new MessageBytes(fnameWithoutZone.getBytes()));
        this.requestPathMappings.setZoneName(zone, false);
        if (result == null) {
            if (this.host.getHostProperties().isApplicationAliasEnabled("/")) {
                String value = this.host.getHostProperties().getAliasValue("/");
                if (value == null) {
                    value = "";
                }
                this.requestPathMappings.setAlias(new MessageBytes("/".getBytes()), value, this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
                }
                MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
                m.appendAfter(ParseUtils.separatorBytes);
                m.appendAfter(fnameWithoutZone.getBytes());
                return m;
            }
            if (this.host.getHostProperties().getAliasValue("/") != null) {
                this.requestPathMappings.setAlias(new MessageBytes("/".getBytes()), this.host.getHostProperties().getAliasValue("/"), this.client.getHttpProvider().getZoneManagement().isExactAlias("/"));
                if (!this.requestPathMappings.isZoneExactAlias() && this.getHttpProperties().getLogonTable().getGroup("/") != null) {
                    this.requestPathMappings.setZoneName(this.getHttpProperties().getLogonTable().getGroup("/"), true);
                }
                MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
                m.appendAfter(ParseUtils.separatorBytes);
                m.appendAfter(fnameWithoutZone.getBytes());
                return m;
            }
            this.requestPathMappings.setAlias(null, this.host.getHostProperties().getRootDir(), false);
            MessageBytes m = new MessageBytes(this.requestPathMappings.getAliasValue().getBytes());
            m.appendAfter(ParseUtils.separatorBytes);
            m.appendAfter(fnameWithoutZone.getBytes());
            return m;
        }
        return result;
    }

    public void setApplicationSession(Object applicationSession) {
        this.applicationSession = applicationSession;
    }

    public Object getApplicationSession() {
        return this.applicationSession;
    }

    public byte[] getAlertMessage() {
        return this.alertMessageFromServlet;
    }

    public void setResponseLength(int totalCount) {
        this.response.setResponseLength(totalCount);
    }

    private void parseInitialHeaders() throws ParseException {
        if (this.isHttp11OrBigger() && this.requestLine.getHost() == null && this.request.getHeaders().getHeader(HeaderNames.request_header_host_) == null) {
            throw new ParseException("http_0034", new Object[]{"Host"});
        }
        this.initClientIp();
        this.readConnection();
        byte[] encoding = this.request.getHeaders().getHeader(HeaderNames.request_header_accpet_encoding_);
        this.request.setAcceptGZipEncoding(ProtocolParser.parseGzipAcceptEncodingHeader(encoding));
        if (this.request.isGzipEncoding()) {
            this.response.setEncoded(true);
        }
    }

    private void initClientIp() {
        String headerName = this.client.getHttpProperties().getClientIpHeaderName();
        if (headerName == null) {
            return;
        }
        String xForwardedFor = this.request.getHeaders().getHeader(headerName);
        if (xForwardedFor != null && headerName.equals("X-Forwarded-For")) {
            boolean isIP = true;
            int points = 0;
            byte[] tmpDomain = new byte[4];
            String[] clientIps = new String[]{};
            int ind = xForwardedFor.indexOf(44);
            int oldIndex = 0;
            if (ind > 0) {
                String[] tmp;
                while ((ind = xForwardedFor.indexOf(44, oldIndex)) > 0) {
                    String address = xForwardedFor.substring(oldIndex, ind).trim();
                    tmp = new String[clientIps.length + 1];
                    System.arraycopy(clientIps, 0, tmp, 0, clientIps.length);
                    tmp[tmp.length - 1] = address;
                    clientIps = tmp;
                    oldIndex = ind + 1;
                }
                tmp = new String[clientIps.length + 1];
                System.arraycopy(clientIps, 0, tmp, 0, clientIps.length);
                tmp[tmp.length - 1] = xForwardedFor.substring(xForwardedFor.lastIndexOf(44) + 1).trim();
                clientIps = tmp;
            } else {
                clientIps = new String[]{xForwardedFor.trim()};
            }
            int i = 0;
            while (i < clientIps.length) {
                if (!clientIps[i].equalsIgnoreCase("unknown")) {
                    char[] domain = clientIps[i].toCharArray();
                    isIP = true;
                    points = 0;
                    int j = 0;
                    while (j < domain.length) {
                        if (domain[j] == '.') {
                            ++points;
                        } else if (!Character.isDigit(domain[j])) {
                            isIP = false;
                            break;
                        }
                        ++j;
                    }
                    if (isIP && points == 3) {
                        char[] tmp = null;
                        int k = 0;
                        oldIndex = 0;
                        ind = 0;
                        points = 0;
                        while (points < 4) {
                            oldIndex = ind + 1;
                            tmp = (ind = CharArrayUtils.indexOf(domain, '.', oldIndex)) > 0 ? new char[ind - oldIndex + 1] : new char[domain.length - oldIndex + 1];
                            System.arraycopy(domain, oldIndex - 1, tmp, 0, tmp.length);
                            ++ind;
                            ++points;
                            tmpDomain[k++] = (byte)(new Integer(new String(tmp)) & 0xFFFFFFFF);
                        }
                        this.client.initClientIP(tmpDomain, 0, 4);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void readConnection() {
        byte[] con = null;
        if (this.host.getHostProperties().isKeepAliveEnabled()) {
            con = this.request.getHeaders().getHeader(HeaderNames.hop_header_connection_);
        }
        if (con == null) {
            if (this.host.getHostProperties().isKeepAliveEnabled() && this.isHttp11OrBigger()) {
                this.response.setPersistentConnection(true);
            } else {
                this.response.putHeader(HeaderNames.hop_header_connection_, HeaderValues.close_);
                this.response.setPersistentConnection(false);
            }
        } else {
            this.response.setPersistentConnection(ProtocolParser.parseConnectionHeader(con, this.response));
        }
    }

    private boolean isHttp11OrBigger() {
        return this.requestLine.getHttpMajorVersion() > 0 && this.requestLine.getHttpMinorVersion() > 0;
    }

    private boolean replyFromCache() {
        CacheQueueItem cachedResponse = null;
        if (this.host.getHostProperties().isUseCache() && ByteArrayUtils.equalsBytes(this.requestLine.getMethod(), Methods._GET) && this.request.getHeaders().getHeader(HeaderNames.request_header_range_) == null && this.request.getHeaders().getHeader(HeaderNames.request_header_expect_) == null && this.request.getHeaders().getHeader(HeaderNames.entity_header_pragma_) == null && !ByteArrayUtils.equalsIgnoreCase(this.request.getHeaders().getHeader(HeaderNames.entity_header_cache_control_), HeaderValues.no_cache_)) {
            String filename = null;
            filename = this.request.getRequestLine().isEncoded() ? this.request.getRequestLine().getUrlDecoded().toStringUTF8() : this.request.getRequestLine().getUrlDecoded().toString();
            boolean isEncoded = this.response.isEncoded();
            int i = filename.lastIndexOf(".");
            String str_Content_Type = null;
            if (i > 0) {
                str_Content_Type = this.client.getHttpProperties().getMimeMappings().getMimeType(new String(filename.substring(i).toLowerCase().toCharArray()));
            }
            if (isEncoded) {
                isEncoded = this.client.getHttpProperties().getHttpCompressedProperties().isGzip(filename, str_Content_Type);
            }
            byte httpVersion = this.client.getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.client.getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.client.getRequest().getRequestLine().getHttpMinorVersion() == 0 ? (byte)0 : 1;
            boolean hasConnection = false;
            if (this.response.isPersistentConnection()) {
                if (httpVersion == 0) {
                    hasConnection = true;
                }
            } else if (httpVersion == 1) {
                hasConnection = true;
            }
            cachedResponse = this.host.getCache().lookupCache(new CacheQueueItemKey(this.requestLine.getUrlDecoded(), this.request.getHost().getBytes(), isEncoded ? (byte)1 : 0, httpVersion, hasConnection));
        }
        if (cachedResponse == null) {
            return false;
        }
        this.response.makeCachedAnswer(cachedResponse);
        return true;
    }

    public void redirect(byte[] location) {
        if (!ByteArrayUtils.startsWith(location, "http://".getBytes()) && !ByteArrayUtils.startsWith(location, "https://".getBytes())) {
            String redirectLocation = !this.requestLine.isSecure() ? ProtocolParser.makeAbsolute(this.request.getScheme(), this.request.getHost(), this.request.getPort()) : this.getSslHostPortScheme();
            byte[] redirectPortBytes = redirectLocation.getBytes();
            byte[] locationNew = new byte[location.length + redirectPortBytes.length];
            System.arraycopy(redirectPortBytes, 0, locationNew, 0, redirectPortBytes.length);
            System.arraycopy(location, 0, locationNew, redirectPortBytes.length, location.length);
            location = locationNew;
        }
        this.response.sendChangeLocation(location);
        this.response.done();
    }

    public void setAlertMessage(byte[] message) {
        if (message == null) {
            this.response.sendAlert(false);
            this.alertMessageFromServlet = null;
        } else {
            this.response.sendAlert(true);
            this.alertMessageFromServlet = message;
            this.response.setEncoded(false);
        }
    }

    private boolean invokeWebContainer() {
        this.client.getHttpProvider();
        if (HttpProviderImpl.getWebContainer() == null) {
            return false;
        }
        int webContainerReplied = -1;
        try {
            this.client.getHttpProvider();
            webContainerReplied = HttpProviderImpl.getWebContainer().checkRequest(this.aliasPathAndFileName, this);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.client.getLog().logError("Cannot check an http request for mapped servlets and filters. Http error [500 Internal Server Error] will be returned.", e, this.requestLine.getHost());
            String errorPage = this.response.checkError(e);
            if (errorPage != null) {
                this.response.handleError(errorPage, e);
            } else {
                this.response.sendResponse(this.response.constructError(500, "Unexpected error in parsing request for web mappings.".getBytes(), this.client.getLog().getExceptionStackTrace(e).getBytes()));
            }
            this.response.done();
            return true;
        }
        if (webContainerReplied == 8 || this.getErrorData() != null) {
            String errorPage = this.response.checkError(this.getErrorData().getErrorCode());
            if (errorPage != null) {
                this.response.handleError(errorPage, this.errorData.getErrorCode(), this.errorData.getMessage());
            } else {
                this.response.sendError(this.errorData.getErrorCode(), this.errorData.getMainMessage().getBytes(), this.errorData.getAdditionalMessage().getBytes());
            }
            this.response.done();
            return true;
        }
        if (webContainerReplied == 2) {
            this.response.done();
            return true;
        }
        if (this.response.isSchemeChanged()) {
            this.sendChangeSchemaToSSlAfterCheckMap();
            this.response.done();
            return true;
        }
        if (webContainerReplied == 4) {
            this.startServlet(this.requestPathMappings.getServletName());
            this.response.done();
            return true;
        }
        return false;
    }

    public HttpCompressedProperties getCommpressedProperties() {
        return this.client.getHttpProperties().getHttpCompressedProperties();
    }

    public MimeMappings getMimeMappings() {
        return this.client.getHttpProperties().getMimeMappings();
    }

    public HttpProperties getHttpProperties() {
        return this.client.getHttpProperties();
    }

    public boolean isSetApplicationCookie() {
        return this.isApplicationCookie;
    }

    public boolean isSetSessionCookie() {
        return this.isSessionCookie;
    }

    public void setApplicationCookie(boolean isSet) {
        this.isApplicationCookie = isSet;
    }

    public void setSessionCookie(boolean isSet) {
        this.isSessionCookie = isSet;
    }

    public void setErrorData(ErrorData errorData) {
        this.errorData = errorData;
    }

    public ErrorData getErrorData() {
        return this.errorData;
    }

    public void setRequestAttribute(String name, Object value) {
        this.requestAttributes.put(name, value);
    }

    public Hashtable getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setDebugRequest(boolean isDebugRequest) {
        this.isDebugRequest = isDebugRequest;
    }

    public boolean isDebugRequest() {
        return this.isDebugRequest;
    }
}

