/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationSessionContext;
import com.sap.engine.frame.cluster.session.HttpApplicationSessionProcessor;
import com.sap.engine.frame.core.pool.PoolContext;
import com.sap.engine.lib.lang.ObjectPool;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.Responses;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.HttpMonitoring;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.LongDataInfo;
import com.sap.engine.services.httpserver.server.ResponseImpl;
import com.sap.engine.services.httpserver.server.SslAttributesImpl;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;

public class Processor
implements HttpApplicationSessionProcessor {
    private static ApplicationServiceContext sc = null;
    private static ApplicationSessionContext ssc = null;
    private static Log log = null;
    private static HttpProviderImpl httpProvider = null;
    private static HttpProperties httpProperties = null;
    protected static ConcurrentHashMapIntObject connectionInfoHash = new ConcurrentHashMapIntObject();
    public static ConcurrentHashMapLongObject longDataHash = new ConcurrentHashMapLongObject();
    public static PoolContext poolContext;
    private ObjectPool clientsPool = null;
    private static HttpHosts descriptorManager;
    private HttpMonitoring monitoring = null;
    static /* synthetic */ Class class$com$sap$engine$services$httpserver$server$Client;

    public Processor(ApplicationSessionContext ssc, ApplicationServiceContext sc, HttpProviderImpl httpProvider, HttpHosts descriptorManager, HttpProperties httpProperties, HttpMonitoring httpMonitoring, Log log) {
        Processor.ssc = ssc;
        Processor.sc = sc;
        Processor.log = log;
        Processor.httpProperties = httpProperties;
        Processor.descriptorManager = descriptorManager;
        Processor.httpProvider = httpProvider;
        this.monitoring = httpMonitoring;
        this.clientsPool = new ObjectPool(2, 5000, 8, class$com$sap$engine$services$httpserver$server$Client == null ? (class$com$sap$engine$services$httpserver$server$Client = Processor.class$("com.sap.engine.services.httpserver.server.Client")) : class$com$sap$engine$services$httpserver$server$Client);
    }

    public static ApplicationServiceContext getApplicationServiceContext() {
        return sc;
    }

    public static ApplicationSessionContext getApplicationSessionContext() {
        return ssc;
    }

    public static HttpProperties getHttpProperties() {
        return httpProperties;
    }

    public static HttpHosts getHttpHosts() {
        return descriptorManager;
    }

    public static Log getLog() {
        return log;
    }

    public static HttpProviderImpl getHttpProvider() {
        return httpProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void request(int dispatcher_id, int client_id, byte[] request, int offset, int length) {
        long systemTimeOfStart;
        int responseCode;
        boolean fromCache;
        block18: {
            byte connectionInfo;
            if (Constants.debug) {
                log.logDebug("Request from client " + client_id + ".\r\n" + new String(request, offset, length));
            }
            SslAttributesImpl sslAttributes = null;
            boolean isICM = request[offset + length - 1] > 0;
            if (isICM && request[offset + --length] == 2) {
                sslAttributes = new SslAttributesImpl();
                length = sslAttributes.readICMCertificates(request, offset, length);
            }
            boolean isSSL = ((connectionInfo = request[offset + length - 1]) & 1) != 0;
            boolean isVerified = (connectionInfo & 2) != 0;
            --length;
            if (isSSL || isVerified) {
                if (sslAttributes == null) {
                    sslAttributes = new SslAttributesImpl();
                }
                length = sslAttributes.readCertificates(request, offset, length, isSSL, isVerified);
            }
            int port = (request[offset + length - 2] & 0xFF) + ((request[offset + length - 1] & 0xFF) << 8);
            byte first = request[offset + (length -= 2) - 5];
            if (first == 0) {
                ResponseImpl response = (ResponseImpl)connectionInfoHash.get(client_id);
                if (response == null) {
                    Log.logWarning("An http request body part received but the request not found. Probably the request body has not been read by the requested servlet or an internal synchronization error has occurred.", null);
                    return;
                }
                response.nextRequestPart(request, offset, length - 5);
                return;
            }
            if (first == 3) {
                Object response;
                if (HttpProviderImpl.getWebContainer() != null) {
                    HttpProviderImpl.getWebContainer().connectionClosed(client_id);
                }
                if ((response = longDataHash.get((long)dispatcher_id << 32 | (long)client_id & 0xFFFFFFFFL)) != null && response instanceof ResponseImpl) {
                    ((ResponseImpl)response).sendNext();
                }
                if ((response = connectionInfoHash.get(client_id)) == null) return;
                ((ResponseImpl)response).connectionClosed();
                return;
            }
            fromCache = false;
            responseCode = -1;
            systemTimeOfStart = -1L;
            try {
                try {
                    Client client = (Client)this.clientsPool.getObject();
                    client.initClientIP(request, offset, length);
                    length -= 5;
                    if (sslAttributes != null) {
                        sslAttributes.setClient(client);
                    }
                    client.init(port, dispatcher_id, client_id, isICM, isSSL, sslAttributes);
                    if (client.initialize(request, offset, length)) {
                        if (HttpServerFrame.isMonitoringStarted()) {
                            this.monitoring.newRequest(new String(client.getRequest().getRequestLine().getMethod()));
                            systemTimeOfStart = System.currentTimeMillis();
                        }
                        client.handle();
                        fromCache = client.getResponse().isReplyFromCache();
                        responseCode = client.getResponse().getResponseCode();
                    }
                    client.finish();
                    this.clientsPool.returnInPool((Object)client);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    log.logError("The Http Provider service failed to process an http request. The request is [" + new String(request, offset, length) + "]", e, null);
                    connectionInfoHash.remove(client_id);
                    Object var21_21 = null;
                    poolContext.release(request);
                    break block18;
                }
                Object var21_20 = null;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                poolContext.release(request);
                throw throwable;
            }
            poolContext.release(request);
        }
        if (systemTimeOfStart == -1L) return;
        this.requestDone(client_id, systemTimeOfStart, responseCode, fromCache);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int httpRequest(int dispatcher_id, int client_id, byte[] request, int offset, int length) {
        byte first;
        byte connectionInfo;
        if (length == 1 && request[offset] == 2) {
            Object response = longDataHash.get((long)dispatcher_id << 32 | (long)client_id & 0xFFFFFFFFL);
            if (response != null) {
                if (!(response instanceof ResponseImpl)) return 1;
                ((ResponseImpl)response).setClientAlive();
                return 1;
            }
            log.logDebug("Long data transfer client alive callback is received from client [" + client_id + "] but could not find response object for it.");
            return 1;
        }
        if (Constants.debug) {
            log.logDebug("Request from client " + client_id + ".\r\n" + new String(request, offset, length));
        }
        SslAttributesImpl sslAttributes = null;
        boolean isICM = request[offset + length - 1] > 0;
        if (isICM && request[offset + --length] == 2) {
            sslAttributes = new SslAttributesImpl();
            length = sslAttributes.readICMCertificates(request, offset, length);
        }
        boolean isSSL = ((connectionInfo = request[offset + length - 1]) & 1) != 0;
        boolean isVerified = (connectionInfo & 2) != 0;
        --length;
        if (isSSL || isVerified) {
            if (sslAttributes == null) {
                sslAttributes = new SslAttributesImpl();
            }
            length = sslAttributes.readCertificates(request, offset, length, isSSL, isVerified);
        }
        if ((first = request[offset + (length -= 2) - 5]) != 0) {
            log.logError("Illegal internal http message received. Probably an internal synchronization error has occurred. Message type: [" + first + "]. Message: [" + new String(request, offset, length) + "].", null);
            return 1;
        }
        ResponseImpl response = (ResponseImpl)connectionInfoHash.get(client_id);
        if (response == null) {
            Log.logWarning("An http request body part received but the request not found. Probably the request body has not been read by the requested servlet or an internal synchronization error has occurred.", null);
            return 1;
        }
        boolean processStream = response.nextRequestPart(request, offset, length - 5);
        if (!processStream) return 2;
        return 1;
    }

    public void getRequestPart(int dispatcher_id, int client_id) {
        Object response = longDataHash.get((long)dispatcher_id << 32 | (long)client_id & 0xFFFFFFFFL);
        if (response != null && response instanceof ResponseImpl) {
            ((ResponseImpl)response).sendNext();
            return;
        }
        LongDataInfo li = (LongDataInfo)response;
        if (li == null) {
            log.logError("Illegal internal http message received. A response body callback received for unknown client. Probably an internal synchronization error has occurred.", null);
            return;
        }
        LongDataInfo longDataInfo = li;
        synchronized (longDataInfo) {
            byte[] buffer = poolContext.get(httpProperties.getFileBufferSize());
            try {
                RandomAccessFile r = new RandomAccessFile(li.filePath.toString(), "r");
                if (li.filePointer >= li.fileLength) {
                    longDataHash.remove((long)dispatcher_id << 32 | (long)client_id & 0xFFFFFFFFL);
                    poolContext.release(buffer);
                    try {
                        ssc.getConnection().send(dispatcher_id, client_id, new byte[0], 0, 0, li.connectionFlag);
                    }
                    catch (ClusterException e) {
                        log.logError("Downloading an http file failed. Cannot send the last part of the response. Internal communication error has occurred.", e, null);
                    }
                    return;
                }
                r.seek(li.filePointer);
                int readed = r.read(buffer);
                if (readed < buffer.length) {
                    longDataHash.remove((long)dispatcher_id << 32 | (long)client_id & 0xFFFFFFFFL);
                    try {
                        ssc.getConnection().send(dispatcher_id, client_id, buffer, 0, readed, li.connectionFlag);
                    }
                    catch (ClusterException e) {
                        log.logError("Downloading an http file failed. Cannot send the last part of the response. Internal communication error has occurred.", e, null);
                    }
                } else {
                    try {
                        ssc.getConnection().sendPart(dispatcher_id, client_id, buffer, 0, readed, (byte)0);
                    }
                    catch (ClusterException e) {
                        log.logError("Downloading an http file failed. Cannot send the next part of the response. Internal communication error has occurred.", e, null);
                    }
                    li.filePointer = r.getFilePointer();
                }
                r.close();
            }
            catch (IOException e) {
                poolContext.release(buffer);
                Log.logWarning("Downloading an http file failed. Cannot send the next part of the response. File reading has failed or internal communication error has occurred.", e, null);
                try {
                    int code = 500;
                    byte[] body = Responses.getErrorResponse(descriptorManager.getVersion(), code, ("Can't write to file!" + e).getBytes());
                    byte[] headers = ("HTTP/1.1 " + code + " " + ResponseCodes.reason(code, "") + "\r\n" + "Content-Type: text/html;charset=ISO-8859-1\r\n" + "Content-Length: " + body.length + "\r\n\r\n").getBytes();
                    ssc.getConnection().send(dispatcher_id, client_id, headers, 0, headers.length, (byte)0);
                    ssc.getConnection().send(dispatcher_id, client_id, body, 0, body.length, (byte)1);
                }
                catch (ClusterException e1) {
                    log.logError("Cannot send an http error response that a file download has failed. Internal communication error has occurred.", e, null);
                }
            }
        }
    }

    private void requestDone(int client_id, long systemTimeOfStart, int responseCode, boolean fromCache) {
        if (HttpServerFrame.isMonitoringStarted()) {
            try {
                this.monitoring.addResponseTime(System.currentTimeMillis() - systemTimeOfStart, responseCode, fromCache);
            }
            catch (NoSuchElementException e) {
                log.logError("Cannot calculate http response time. Unknown client id [" + client_id + "] found.", null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        descriptorManager = null;
    }
}

