/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.security.SecurityContext;
import com.sap.engine.services.httpserver.exceptions.HttpResourceAccessor;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.server.Date;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class Log {
    private static final String CATEGORY_ACCESS_LOG = "/System/HttpAccess/Access";
    private static final String CATEGORY_CLF_ACCESS_LOG = "/System/HttpAccess/CommonLogFormat";
    private static final String CATEGORY_EXCEPTIONS = "/System/Server";
    private static final String CATEGORY_HTTP = "/System/Server";
    private static final String LOCATION_EXCEPTIONS = "com.sap.engine.services.Http";
    private static final String LOCATION_HTTP = "com.sap.engine.services.httpserver";
    private static ThreadSystem threadSystem = null;
    private static final byte[] logStr1_1 = " - ".getBytes();
    private static final byte[] logStr1_2 = " [".getBytes();
    private static final byte[] logStr2 = "] \"".getBytes();
    private static final byte[] logStr3 = "\"".getBytes();
    private static final byte[] logStr4 = " ".getBytes();
    private static final String delimeter = " : ";
    private static final byte[] logStr5 = " : ".getBytes();
    private static final byte[] zero = "0".getBytes();
    private static final byte[] default_user = "-".getBytes();
    private HttpProperties httpProperties = null;
    private boolean enableLog = true;
    private Date clfDateUtil = null;
    private Category categoryAccessLog = null;
    private Category categoryCLFAccessLog = null;
    private Location locationResponse = null;
    private Location locationResponseCLF = null;
    private static Category categoryHttp = null;
    private static Location locationHttp = null;

    public static void initThreadSystem(ThreadSystem ts) {
        threadSystem = ts;
        HttpResourceAccessor.getResourceAccessor().init(Category.getCategory((String)"/System/Server"), Location.getLocation((String)LOCATION_EXCEPTIONS));
        categoryHttp = Category.getCategory((String)"/System/Server");
        locationHttp = Location.getLocation((String)LOCATION_HTTP);
    }

    public Log(Date clfDateUtil, HttpProperties httpProperties) {
        this.clfDateUtil = clfDateUtil;
        this.httpProperties = httpProperties;
        this.categoryAccessLog = Category.getCategory((String)CATEGORY_ACCESS_LOG);
        this.categoryCLFAccessLog = Category.getCategory((String)CATEGORY_CLF_ACCESS_LOG);
        this.locationResponse = Location.getLocation((String)"com.sap.engine.services.httpserver.server.Log");
        this.locationResponseCLF = Location.getLocation((String)"com.sap.engine.services.httpserver.server.CommonLogFormat");
    }

    private Log(Date clfDateUtil, HttpProperties httpProperties, boolean enableLog) {
        this.clfDateUtil = clfDateUtil;
        this.httpProperties = httpProperties;
        this.enableLog = enableLog;
        this.categoryAccessLog = Category.getCategory((String)CATEGORY_ACCESS_LOG);
        this.categoryCLFAccessLog = Category.getCategory((String)CATEGORY_CLF_ACCESS_LOG);
        this.locationResponse = Location.getLocation((String)"com.sap.engine.services.httpserver.server.Log");
        this.locationResponseCLF = Location.getLocation((String)"com.sap.engine.services.httpserver.server.CommonLogFormat");
    }

    public Log getLog(boolean enableLog) {
        return new Log(this.clfDateUtil, this.httpProperties, enableLog);
    }

    public void enableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public void saveInLog(byte[] ip, byte[] requestLine, int code, int len, long processTime, String logHeader) {
        if (!this.enableLog) {
            return;
        }
        if (len == -1) {
            len = 0;
        }
        byte[] resLength = null;
        resLength = len == 0 ? zero : Ascii.intToAsciiArr(len);
        byte[] hostName = ParseUtils.inetAddressByteToString(ip);
        byte[] tempByte = null;
        if (ResponseCodes.status_code_byte[code] == null) {
            ResponseCodes.status_code_byte[code] = (" " + code).getBytes();
        }
        if (!this.httpProperties.logInCLF()) {
            try {
                byte[] processTimeStr = null;
                int logHeaderValueLogLength = 0;
                if (logHeader != null) {
                    logHeaderValueLogLength = 4 + logHeader.length();
                }
                if (processTime == -1L) {
                    tempByte = new byte[hostName.length + logStr5.length + requestLine.length + ResponseCodes.status_code_byte[code].length + logStr4.length + resLength.length + logHeaderValueLogLength];
                } else {
                    processTimeStr = Ascii.intToAsciiArr((int)processTime);
                    tempByte = new byte[hostName.length + logStr5.length + requestLine.length + ResponseCodes.status_code_byte[code].length + logStr4.length + resLength.length + 3 + processTimeStr.length + logHeaderValueLogLength];
                }
                int index = 0;
                System.arraycopy(hostName, 0, tempByte, index, hostName.length);
                System.arraycopy(logStr5, 0, tempByte, index += hostName.length, logStr5.length);
                System.arraycopy(requestLine, 0, tempByte, index += logStr5.length, requestLine.length);
                System.arraycopy(ResponseCodes.status_code_byte[code], 0, tempByte, index += requestLine.length, ResponseCodes.status_code_byte[code].length);
                System.arraycopy(logStr4, 0, tempByte, index += ResponseCodes.status_code_byte[code].length, logStr4.length);
                System.arraycopy(resLength, 0, tempByte, index += logStr4.length, resLength.length);
                index += resLength.length;
                if (processTimeStr != null) {
                    tempByte[index++] = 32;
                    tempByte[index++] = 91;
                    System.arraycopy(processTimeStr, 0, tempByte, index, processTimeStr.length);
                    index += processTimeStr.length;
                    tempByte[index++] = 93;
                }
                if (logHeader != null) {
                    tempByte[index++] = 32;
                    tempByte[index++] = 104;
                    tempByte[index++] = 91;
                    System.arraycopy(logHeader.getBytes(), 0, tempByte, index, logHeader.length());
                    index += logHeader.length();
                    tempByte[index++] = 93;
                }
                this.categoryAccessLog.infoT(this.locationResponse, new String(tempByte));
            }
            catch (Exception e) {
                System.out.println("HTTP Server: ! Can't write to Log!");
                e.printStackTrace();
            }
        } else {
            try {
                byte[] dateBytes = this.clfDateUtil.getDateCLF();
                byte[] user = this.getUser();
                tempByte = new byte[hostName.length + logStr1_1.length + user.length + logStr1_2.length + dateBytes.length + logStr2.length + requestLine.length + logStr3.length + ResponseCodes.status_code_byte[code].length + logStr4.length + resLength.length];
                int index = 0;
                System.arraycopy(hostName, 0, tempByte, index, hostName.length);
                System.arraycopy(logStr1_1, 0, tempByte, index += hostName.length, logStr1_1.length);
                System.arraycopy(user, 0, tempByte, index += logStr1_1.length, user.length);
                System.arraycopy(logStr1_2, 0, tempByte, index += user.length, logStr1_2.length);
                System.arraycopy(dateBytes, 0, tempByte, index += logStr1_2.length, dateBytes.length);
                System.arraycopy(logStr2, 0, tempByte, index += dateBytes.length, logStr2.length);
                System.arraycopy(requestLine, 0, tempByte, index += logStr2.length, requestLine.length);
                System.arraycopy(logStr3, 0, tempByte, index += requestLine.length, logStr3.length);
                System.arraycopy(ResponseCodes.status_code_byte[code], 0, tempByte, index += logStr3.length, ResponseCodes.status_code_byte[code].length);
                System.arraycopy(logStr4, 0, tempByte, index += ResponseCodes.status_code_byte[code].length, logStr4.length);
                System.arraycopy(resLength, 0, tempByte, index += logStr4.length, resLength.length);
                index += resLength.length;
                this.categoryCLFAccessLog.infoT(this.locationResponseCLF, new String(tempByte));
            }
            catch (Exception e) {
                this.logError("Cannot create a log in Common Log Format for an http request.", e, null);
            }
        }
    }

    public void logDebug(String msg) {
        locationHttp.debugT(msg);
    }

    public void logInfo(String msg) {
        locationHttp.infoT(msg);
    }

    public static void logWarning(String msg, byte[] hostBytes) {
        byte[] hostName = ParseUtils.inetAddressByteToString(hostBytes);
        categoryHttp.warningT(locationHttp, Log.getFirstLine(hostName) + msg);
    }

    public static void logWarning(String msg, Throwable ex, byte[] hostBytes) {
        byte[] hostName = ParseUtils.inetAddressByteToString(hostBytes);
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(ostr));
        categoryHttp.warningT(locationHttp, Log.getFirstLine(hostName) + msg + "\r\n" + ostr);
    }

    public void logError(String msg, byte[] hostBytes) {
        byte[] hostName = ParseUtils.inetAddressByteToString(hostBytes);
        categoryHttp.errorT(locationHttp, Log.getFirstLine(hostName) + msg);
    }

    public void logError(String msg, Throwable ex, byte[] hostBytes) {
        byte[] hostName = ParseUtils.inetAddressByteToString(hostBytes);
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(ostr));
        categoryHttp.errorT(locationHttp, Log.getFirstLine(hostName) + msg + "\r\n" + ostr);
    }

    public void logFatal(String msg, Throwable ex) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(ostr));
        categoryHttp.errorT(locationHttp, Log.getFirstLine(null) + msg + "\r\n" + ostr);
    }

    public String getExceptionStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    private static String getFirstLine(byte[] hostName) {
        return "User " + Log.getUserNameFromThreadContext() + ", IP address " + new String(hostName) + "\r\n";
    }

    private static String getUserNameFromThreadContext() {
        if (threadSystem.getThreadContext() == null) {
            return "<system thread>";
        }
        SecurityContext securityContext = (SecurityContext)threadSystem.getThreadContext().getContextObject("security");
        if (securityContext == null || securityContext.getPrincipal() == null || securityContext.getPrincipal().getName() == null) {
            return "<unauthorized>";
        }
        return securityContext.getPrincipal().getName();
    }

    private byte[] getUser() {
        String user;
        ThreadContext localTC = threadSystem.getThreadContext();
        SecurityContextObject securityContextObject = (SecurityContextObject)localTC.getContextObject(localTC.getContextObjectId("security"));
        SecuritySession ss = securityContextObject.getSession();
        if (ss != null && ss.getAuthenticationConfiguration() != null && (user = ss.getPrincipal().getName()) != null) {
            return user.getBytes();
        }
        return default_user;
    }
}

