/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.session.ApplicationSessionProcessor;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.services.httpserver.HttpRuntimeInterface;
import com.sap.engine.services.httpserver.ZoneManagementInterface;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.Date;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.HttpLock;
import com.sap.engine.services.httpserver.server.HttpMonitoring;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.HttpRuntimeInterfaceImpl;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.cache.CacheTimeoutListener;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import com.sap.engine.services.httpserver.server.properties.ProxyMappings;
import com.sap.engine.services.httpserver.server.shellcommands.ApplicationAliasCommand;
import com.sap.engine.services.httpserver.server.shellcommands.HTTPClearCache;
import com.sap.engine.services.httpserver.server.shellcommands.HostCommand;
import com.sap.engine.services.httpserver.server.shellcommands.HttpAliasCommand;
import com.sap.engine.services.httpserver.server.zones.ZoneManagementImpl;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HttpServerFrame
implements ApplicationServiceFrame,
ServiceEventListener,
ContainerEventListener,
MessageListener {
    private HttpProperties httpProperties = null;
    private ApplicationServiceContext sc = null;
    private HttpProviderImpl httpProvider = null;
    private HttpMonitoring httpMonitoring = new HttpMonitoring();
    private HttpRuntimeInterface runtimeInterface = null;
    private Date date = new Date();
    private Log log = null;
    private int commandId = -1;
    protected ArrayInt dispatchers = new ArrayInt();
    protected MessageContext message = null;
    private int clusterGroupId = -1;
    private HttpHosts descriptorManager = null;
    private CacheTimeoutListener cacheListener = null;
    private ShellInterface shell = null;
    private ConvertTools convert = new ConvertTools(false);
    public static ConcurrentHashMapIntObject ports = new ConcurrentHashMapIntObject();
    public static ConcurrentHashMapIntObject sslPorts = new ConcurrentHashMapIntObject();
    public static ConcurrentHashMapLongObject defaultPorts = new ConcurrentHashMapLongObject();
    private static boolean monitoringStarted = false;
    private static HttpLock httpLock = null;
    private ZoneManagementInterface zoneManagement;

    public void start(ApplicationServiceContext sc) throws ServiceException {
        this.sc = sc;
        this.message = sc.getClusterContext().getMessageContext();
        this.clusterGroupId = sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getGroupId();
        Log.initThreadSystem(sc.getCoreContext().getThreadSystem());
        this.httpProperties = new HttpProperties();
        this.log = new Log(this.date, this.httpProperties);
        this.httpProperties.setLog(this.log);
        this.httpProperties.setProperties(sc.getServiceState().getProperties());
        this.setProperties();
        httpLock = new HttpLock(sc, this.log);
        this.descriptorManager = new HttpHosts();
        this.descriptorManager.init(sc.getCoreContext().getCoreMonitor().getCoreMajorVersion(), this.date, this.log, this.httpProperties, sc);
        Processor.poolContext = sc.getCoreContext().getPoolContext();
        ClusterElement[] ce = sc.getClusterContext().getClusterMonitor().getParticipants();
        int i = 0;
        while (i < ce.length) {
            if (ce[i].getType() == 1 && ce[i].getGroupId() == this.clusterGroupId) {
                this.dispatchers.addElement(ce[i].getClusterId());
            }
            ++i;
        }
        this.httpProvider = new HttpProviderImpl(this.message, this.descriptorManager, this.log, this, sc.getClusterContext().getClusterMonitor());
        try {
            sc.getClusterContext().getApplicationSessionContext().registerProcessor((ApplicationSessionProcessor)new Processor(sc.getClusterContext().getApplicationSessionContext(), sc, this.httpProvider, this.descriptorManager, this.httpProperties, this.httpMonitoring, this.log));
        }
        catch (ListenerAlreadyRegisteredException e) {
            this.log.logFatal("Cannot register Http Provider service for session processor. The service cannot run correctly.", e);
        }
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.descriptorManager.readAllHostsFromConfiguration();
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
        this.sendGroupSeparator(-1);
        this.sendAcceptCerts();
        int count2 = 0;
        while ((long)count2 < 100L) {
            try {
                this.synchronizeUploadedFiles();
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.log.logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                }
                if ((long)count2 == 99L) {
                    throw e;
                }
                ++count2;
            }
        }
        sc.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        sc.getContainerContext().getObjectRegistry().registerInterface((Object)this.httpProvider);
        sc.getServiceState().registerManagementInterface((ManagementInterface)this.getHttpRuntimeInterface());
        sc.getServiceState().registerServiceEventListener((ServiceEventListener)this);
        int mask = 109;
        HashSet<String> names = new HashSet<String>(3);
        names.add("servlet_jsp");
        names.add("shell");
        names.add("monitor");
        sc.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        if (sc.getContainerContext().getSystemMonitor().getService("monitor") != null && sc.getContainerContext().getSystemMonitor().getService("monitor").getStatus() == 5) {
            this.serviceStarted("monitor", null);
        }
    }

    public HttpProperties getHttpProperties() {
        return this.httpProperties;
    }

    public Date getDate() {
        return this.date;
    }

    public Log getLog() {
        return this.log;
    }

    public static HttpLock getHttpLock() {
        return httpLock;
    }

    public int[] getServers(int group) {
        ArrayInt servers = new ArrayInt();
        ClusterElement[] clusterElements = this.sc.getClusterContext().getClusterMonitor().getParticipants();
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i] != null && clusterElements[i].getGroupId() == group) {
                servers.add(clusterElements[i].getClusterId());
            }
            ++i;
        }
        return servers.toArray();
    }

    public int getGroup(int server) {
        ClusterElement clusterElement = this.sc.getClusterContext().getClusterMonitor().getParticipant(server);
        if (clusterElement == null) {
            return -1;
        }
        return clusterElement.getGroupId();
    }

    private void setProperties() {
        if (this.httpProperties.getCacheTimeout() > 0L) {
            TimeoutManager timectx = (TimeoutManager)this.sc.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
            if (this.cacheListener == null) {
                this.cacheListener = new CacheTimeoutListener();
                timectx.registerTimeoutListener((TimeoutListener)this.cacheListener, 10000L, this.httpProperties.getCacheTimeout());
            } else {
                timectx.changeRepeatTime((TimeoutListener)this.cacheListener, this.httpProperties.getCacheTimeout());
            }
        } else if (this.cacheListener != null) {
            TimeoutManager timectx = (TimeoutManager)this.sc.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
            timectx.unregisterTimeoutListener((TimeoutListener)this.cacheListener);
            this.cacheListener = null;
        }
        this.sendGroupSeparator(-1);
        if (this.httpProvider != null) {
            this.httpProvider.resendLoadBalance(-1);
        }
    }

    protected void clearRemoteCache() {
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        try {
            byte[][] aliases = this.descriptorManager.getAllTagAliases();
            int i = 0;
            while (i < aliases.length) {
                byte[] nextb = aliases[i];
                byte[] msg = new byte[Constants.ETAG_INQMY.length + nextb.length];
                System.arraycopy(Constants.ETAG_INQMY, 0, msg, 0, Constants.ETAG_INQMY.length);
                System.arraycopy(nextb, 0, msg, Constants.ETAG_INQMY.length, nextb.length);
                this.message.send(-1, (byte)1, 1, msg, 0, msg.length);
                ++i;
            }
            byte[] msg = new byte[Constants.ETAG_INQMY.length];
            System.arraycopy(Constants.ETAG_INQMY, 0, msg, 0, Constants.ETAG_INQMY.length);
            this.message.send(-1, (byte)1, 1, msg, 0, msg.length);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.logError("Cannot clear the objects cached for the j2ee engine from the ICM http cache. Probably a communication error has occured.", e, null);
        }
    }

    protected void clearRemoteCache(String alias) {
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        try {
            int hash = new MessageBytes(alias.getBytes()).hashCode();
            byte[] aliasb = this.descriptorManager.getTagAlias(hash);
            if (aliasb == null) {
                aliasb = String.valueOf(hash).getBytes();
                this.descriptorManager.addTagAlias(hash, aliasb);
            }
            byte[] msg = new byte[Constants.ETAG_INQMY.length + aliasb.length];
            System.arraycopy(Constants.ETAG_INQMY, 0, msg, 0, Constants.ETAG_INQMY.length);
            System.arraycopy(aliasb, 0, msg, Constants.ETAG_INQMY.length, aliasb.length);
            this.message.send(-1, (byte)1, 1, msg, 0, msg.length);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.logError("Cannot clear the objects cached for the j2ee engine from the ICM http cache. Probably a communication error has occured.", e, null);
        }
    }

    private void setCommands(ShellInterface shell) {
        this.shell = shell;
        Command[] cmds = new Command[]{new HTTPClearCache(this.httpProvider), new HostCommand(this.getHttpRuntimeInterface()), new HttpAliasCommand(this.getHttpRuntimeInterface()), new ApplicationAliasCommand(this.sc, this.getHttpRuntimeInterface())};
        this.commandId = shell.registerCommands(cmds);
    }

    public void serviceStarted(ClusterElement newElement) {
        if (newElement.getType() == 1 && newElement.getGroupId() == this.clusterGroupId) {
            this.dispatchers.addElement(newElement.getClusterId());
            this.httpProvider.resendLoadBalance(newElement.getClusterId());
            if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
                return;
            }
            this.sendGroupSeparator(newElement.getClusterId());
            byte[] msg = new byte[]{this.httpProperties.getProxyServersProperties().acceptClientCertWithoutSSL() ? (byte)1 : -1};
            try {
                this.message.send(newElement.getClusterId(), 6, msg, 0, 1);
            }
            catch (ClusterException e) {
                this.log.logError("Cannot send the value of the Http Provider service property [AcceptClientCertWithoutSSL] to dispatcher [" + newElement.getClusterId() + "]. The value of this property will be ignored on this dispatcher and incorrect ssl sockets handling may be caused.", e, null);
            }
        }
    }

    public void serviceStopped(ClusterElement oldElement) {
        if (oldElement.getType() == 1) {
            this.dispatchers.removeElement(oldElement.getClusterId());
        }
    }

    public void clearCache() {
        this.descriptorManager.clearCache();
    }

    protected HttpRuntimeInterface getHttpRuntimeInterface() {
        if (this.runtimeInterface == null) {
            try {
                this.zoneManagement = new ZoneManagementImpl(this.sc.getCoreContext().getConfigurationHandlerFactory(), this.log, this.httpProvider);
                this.runtimeInterface = new HttpRuntimeInterfaceImpl(this, this.descriptorManager, this.httpMonitoring, this.httpProperties, this.zoneManagement);
            }
            catch (RemoteException _) {
                this.log.logError("Cannot load the remote interfaces of Http Provider service. The features they provide will not be accessible.", _, null);
            }
        }
        return this.runtimeInterface;
    }

    public void stop() {
        this.clearRemoteCache();
        this.sc.getClusterContext().getApplicationSessionContext().unregisterProcessor();
        this.sc.getContainerContext().getObjectRegistry().unregisterInterface();
        this.sc.getServiceState().unregisterContainerEventListener();
        this.sc.getClusterContext().getMessageContext().unregisterListener();
        this.shell.unregisterCommands(this.commandId);
        this.sc.getServiceState().unregisterServiceEventListener();
        this.sc.getServiceState().unregisterManagementInterface();
    }

    public MessageAnswer receiveWait(int clusterId, int msgType, byte[] msg, int off, int length) {
        switch (msgType) {
            case 523: {
                this.httpProvider.removeSession(new String(msg, off, length));
                return new MessageAnswer();
            }
        }
        return null;
    }

    public void receive(int clusterId, int msgType, byte[] msg, int off, int length) {
        switch (msgType) {
            case 512: {
                this.setPorts(clusterId, new String(msg, off, length));
            }
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if ("monitor".equalsIgnoreCase(serviceName)) {
            monitoringStarted = true;
        }
    }

    public void serviceNotStarted(String serviceName) {
        if ("servlet_jsp".equalsIgnoreCase(serviceName)) {
            this.httpProvider.allApplicationsStarted();
        }
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
        if ("servlet_jsp".equalsIgnoreCase(serviceName)) {
            if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
                return;
            }
            byte[] msg = new byte[12];
            this.convert.intToArr(0, msg, 0);
            this.convert.intToArr(1, msg, 4);
            this.convert.intToArr(0, msg, 8);
            try {
                this.message.send(-1, (byte)1, 5, new byte[0], 0, 0);
            }
            catch (ClusterException t) {
                this.log.logError("Cannot send load balancing information to j2ee dispatchers that the Web Container service is not available on this server node.", null);
            }
        } else if ("monitor".equalsIgnoreCase(serviceName)) {
            monitoringStarted = false;
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.setCommands((ShellInterface)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperty(String key, String value) {
        this.httpProperties.setProperty(key, value);
        this.setProperties();
        return true;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        this.httpProperties.setProperties(serviceProperties);
        this.setProperties();
        return true;
    }

    public int getServerID() {
        return this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
    }

    public int getGroupID() {
        return this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getGroupId();
    }

    private void sendAcceptCerts() {
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        byte[] msg = new byte[]{this.httpProperties.getProxyServersProperties().acceptClientCertWithoutSSL() ? (byte)1 : -1};
        try {
            this.message.send(-1, (byte)1, 6, msg, 0, 1);
        }
        catch (ClusterException e) {
            this.log.logError("Cannot send the value of the Http Provider service property [AcceptClientCertWithoutSSL] to all dispatchers. The value of this property will be ignored and incorrect ssl sockets handling may be caused.", e, null);
        }
    }

    private void sendGroupSeparator(int dispatcherId) {
        if (this.sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        byte[] msg = null;
        if (this.httpProperties.getZoneSeparator() == null) {
            msg = new byte[]{};
        } else {
            msg = new byte[this.httpProperties.getZoneSeparator().length()];
            System.arraycopy(this.httpProperties.getZoneSeparator().getBytes(), 0, msg, 0, msg.length);
        }
        try {
            if (dispatcherId == -1) {
                this.message.send(dispatcherId, (byte)1, 9, msg, 0, msg.length);
            } else {
                this.message.send(dispatcherId, 9, msg, 0, msg.length);
            }
        }
        catch (ClusterException e) {
            this.log.logError("Cannot send the value of the Http Provider service property [ZoneSeparator] to dispatcher [" + dispatcherId + "]. " + "The value of this property will be ignored and load balancing groups will be used.", e, null);
        }
    }

    private synchronized void synchronizeUploadedFiles() throws InconsistentReadException {
        try {
            ConfigurationHandlerFactory factory = this.sc.getCoreContext().getConfigurationHandlerFactory();
            if (factory == null) {
                this.log.logFatal("Cannot load and initialize the uploaded files to Http Provider service. Configuration manager is not available.", null);
                return;
            }
            Configuration configHost = null;
            ConfigurationHandler handler = factory.getConfigurationHandler();
            Configuration configApps = null;
            try {
                configApps = handler.openConfiguration("HttpAliases", 0);
            }
            catch (NameNotFoundException e) {
                return;
            }
            catch (Exception e) {
                this.log.logError("Cannot open a configuration with name [HttpAliases]. Files uploaded to the j2ee engine cannot be read.", e, null);
                return;
            }
            Host[] descriptors = this.descriptorManager.getAllHosts();
            int j = 0;
            while (j < descriptors.length) {
                block18: {
                    try {
                        configHost = configApps.getSubConfiguration(descriptors[j].getHostName());
                    }
                    catch (InconsistentReadException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.log.logError("Cannot open a configuration with name [HttpAliases/" + descriptors[j].getHostName() + "]. Files uploaded to the j2ee engine cannot be read.", e, null);
                        break block18;
                    }
                    String[] aliases = configHost.getAllSubConfigurationNames();
                    if (aliases != null && aliases.length != 0) {
                        Configuration configAlias = null;
                        int i = 0;
                        while (i < aliases.length) {
                            String rootDir;
                            Map fileEntries = null;
                            configAlias = configHost.getSubConfiguration(aliases[i]);
                            fileEntries = configAlias.getAllFileEntries();
                            if (!fileEntries.isEmpty() && (rootDir = descriptors[j].getHostProperties().getAliasValue(aliases[i])) != null) {
                                Set keySet = fileEntries.keySet();
                                Iterator iter = keySet.iterator();
                                while (iter.hasNext()) {
                                    byte[] crcDBFile;
                                    byte[] crcHDDFile;
                                    String nextFilename = (String)iter.next();
                                    String file = (String)configAlias.getConfigEntry(nextFilename.substring(1));
                                    File hddFile = new File(rootDir + file);
                                    if (hddFile.exists() && ByteArrayUtils.equalsBytes(crcHDDFile = HashUtils.generateFileHash((File)hddFile), crcDBFile = (byte[])configAlias.getConfigEntry(nextFilename.replace('#', '$')))) continue;
                                    new File(hddFile.getParent()).mkdirs();
                                    FileOutputStream fileout = new FileOutputStream(hddFile);
                                    InputStream in = configAlias.getFile(nextFilename);
                                    byte[] buf = new byte[1024];
                                    int received = 0;
                                    while ((received = in.read(buf)) != -1) {
                                        fileout.write(buf, 0, received);
                                    }
                                    fileout.close();
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (InconsistentReadException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.logError("Cannot load the uploaded files to the http server from configuration.", e, null);
        }
    }

    public static boolean isMonitoringStarted() {
        return monitoringStarted;
    }

    public static ProxyMappings getProxyMappings(int dispatcherId, int port) {
        ConcurrentHashMapIntObject p = (ConcurrentHashMapIntObject)ports.get(dispatcherId);
        if (p == null) {
            return null;
        }
        return (ProxyMappings)p.get(port);
    }

    public static ProxyMappings getSslProxyMappings(int dispatcherId) {
        return (ProxyMappings)sslPorts.get(dispatcherId);
    }

    public static ProxyMappings getDefaultProxyMappings(int dispatcherId, int port) {
        long key = dispatcherId * 100000 + port;
        return (ProxyMappings)defaultPorts.get(key);
    }

    /*
     * Unable to fully structure code
     */
    private void setPorts(int dispatcherId, String proxyMappings) {
        sslFound = false;
        p = new ConcurrentHashMapIntObject();
        dp = null;
        errorPrefix = "ERROR: Cannot parse property ProxyMappings from dispatcher node " + dispatcherId + ": ";
        errorSuffix = " Please correct the ProxyMapping property of HttpProvider service on J2EE dispatcher node " + dispatcherId + ".";
        j = 0;
        errors = new ArrayObject();
        while (j < proxyMappings.length() && (i = proxyMappings.indexOf("=", j)) > -1) {
            block20: {
                block22: {
                    block21: {
                        portStr = proxyMappings.substring(j, (int)var4_11).trim();
                        try {
                            port = Integer.parseInt(portStr);
                        }
                        catch (NumberFormatException e) {
                            port = -1;
                            this.log.logError(errorPrefix + "The specified port " + portStr + " is not a number. The mapping for this port will be ignored." + errorSuffix, null);
                        }
                        if (port == -1 || (i = proxyMappings.indexOf("(", (int)(++var4_11))) <= -1 || (j = proxyMappings.indexOf(41, i)) <= -1) break block20;
                        isDefault = false;
                        s = proxyMappings.substring(i + 1, j);
                        if (this.isProxyMappingsSyntaxCorrect(s, errorPrefix2 = errorPrefix + "The specified mapping for port " + port + ": \"" + s + "\" is not correct. The error is: ", errorSuffix)) break block21;
                        this.log.logError(errorPrefix2 + "Incorrect syntax. The mapping for this port will be ignored." + errorSuffix, null);
                        break block20;
                    }
                    hostValue = HttpServerFrame.getValue(s, "Host");
                    if (hostValue == null || hostValue.length() == 0) {
                        errors.add((Object)(errorPrefix2 + "\"Host\" is null or empty string. The mapping for this port will be ignored." + errorSuffix));
                    }
                    proxyPort = -1;
                    portValue = HttpServerFrame.getValue(s, "Port");
                    if (portValue != null && portValue.length() != 0) break block22;
                    errors.add((Object)(errorPrefix2 + "\"Port\" is null or empty string. The mapping for this port will be ignored." + errorSuffix));
                    ** GOTO lbl-1000
                }
                try {
                    proxyPort = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e1) {
                    this.log.logError(errorPrefix2 + "\"Port\" value==" + proxyPort + " is not a valid integer. The mapping for this port will be ignored." + errorSuffix, null);
                    break block20;
                }
                if (proxyPort < 0 || proxyPort > 65535) {
                    this.log.logError(errorPrefix2 + "\"Port\" value==" + proxyPort + " is not a valid TCP port (0-65535). The mapping for this port will be ignored." + errorSuffix, null);
                } else lbl-1000:
                // 2 sources

                {
                    schemeValue = HttpServerFrame.getValue(s, "Scheme");
                    if (schemeValue == null || !schemeValue.equalsIgnoreCase("http") && !schemeValue.equalsIgnoreCase("https")) {
                        this.log.logError(errorPrefix2 + " Unknown \"Scheme\"==\"" + schemeValue + "\", assuming default schema \"http\"." + errorSuffix, null);
                        schemeValue = "http";
                    }
                    proxyOverride = false;
                    overrideValue = HttpServerFrame.getValue(s, "Override");
                    if ("default".equals(overrideValue)) {
                        isDefault = true;
                    }
                    if ("true".equalsIgnoreCase(overrideValue)) {
                        proxyOverride = true;
                    } else if (!"false".equalsIgnoreCase(overrideValue)) {
                        this.log.logError(errorPrefix2 + " Unknown \"Override\"==\"" + overrideValue + "\", assuming default: \"Override:false\"." + errorSuffix, null);
                    }
                    if (!(hostValue != null && proxyPort != -1 || schemeValue != null && proxyOverride)) {
                        e = 0;
                        while (e < errors.size()) {
                            this.log.logError((String)errors.get(e), null);
                            ++e;
                        }
                        errors.clear();
                    } else {
                        dp = new ProxyMappings(hostValue, proxyPort, schemeValue, proxyOverride);
                        if (!isDefault) {
                            p.put(port, (Object)dp);
                        } else {
                            key = dispatcherId * 100000 + port;
                            HttpServerFrame.defaultPorts.put(key, (Object)dp);
                        }
                        this.log.logInfo("Parsed ProxyMappings property from Dispatcher==" + dispatcherId + " for port " + port + ": Host==\"" + dp.getHost() + "\", Port==" + dp.getPort() + ", Scheme==\"" + dp.getScheme() + "\", Override==" + dp.isOverride() + ".");
                        if (!sslFound && "https".equals(dp.getScheme())) {
                            HttpServerFrame.sslPorts.put(dispatcherId, (Object)dp);
                            sslFound = true;
                        }
                    }
                }
            }
            if ((j = proxyMappings.indexOf(44, j + 1)) == -1) break;
            ++j;
        }
        if (p.isEmpty()) {
            this.log.logInfo("No ProxyMappings property for Dispatcher==" + dispatcherId + ".");
        }
        HttpServerFrame.ports.put(dispatcherId, (Object)p);
    }

    private static String getValue(String data, String key) {
        int i = 0;
        int j = 0;
        while ((i = data.indexOf(key + ":", j)) > -1) {
            if (i == 0 || Character.isWhitespace(data.charAt(i - 1)) || data.charAt(i - 1) == ',') break;
            j += key.length() + 1;
        }
        if (i > -1) {
            j = data.indexOf(44, i += key.length() + 1);
            if (j == -1) {
                j = data.length();
            }
            return data.substring(i, j).trim();
        }
        return null;
    }

    private boolean isProxyMappingsSyntaxCorrect(String s, String errorPrefix, String errorSuffix) {
        int sLen = s.length();
        if (sLen < 13) {
            return false;
        }
        char first = s.charAt(0);
        char last = s.charAt(sLen - 1);
        if (first == ':' || last == ':' || first == ',' || last == ',') {
            this.log.logError(errorPrefix + "Separator symbol (':' or ',') at string edge. The mapping for this port will be ignored." + errorSuffix, null);
            return false;
        }
        boolean foundHost = false;
        boolean foundPort = false;
        boolean foundScheme = false;
        boolean foundOverride = false;
        int left = 0;
        while (left < sLen) {
            int right;
            block8: {
                String key;
                String keyValuePair;
                int keyValueSplit;
                block11: {
                    block16: {
                        block17: {
                            block14: {
                                block15: {
                                    block12: {
                                        block13: {
                                            block9: {
                                                block10: {
                                                    block7: {
                                                        right = s.indexOf(44, left);
                                                        if (right == -1) {
                                                            right = sLen;
                                                        }
                                                        if ((keyValueSplit = (keyValuePair = s.substring(left, right)).indexOf(58)) != -1) break block7;
                                                        this.log.logError(errorPrefix + "Not a key-value token==\"" + keyValuePair + "\", token ignored." + errorSuffix, null);
                                                        break block8;
                                                    }
                                                    key = keyValuePair.substring(0, keyValueSplit).trim();
                                                    if (!key.equals("Host")) break block9;
                                                    if (!foundHost) break block10;
                                                    this.log.logError(errorPrefix + "Duplicate key \"Host\" found, the first value is used." + errorSuffix, null);
                                                    break block8;
                                                }
                                                foundHost = true;
                                                break block11;
                                            }
                                            if (!key.equals("Port")) break block12;
                                            if (!foundPort) break block13;
                                            this.log.logError(errorPrefix + "Duplicate key \"Port\" found, the first value is used." + errorSuffix, null);
                                            break block8;
                                        }
                                        foundPort = true;
                                        break block11;
                                    }
                                    if (!key.equals("Scheme")) break block14;
                                    if (!foundScheme) break block15;
                                    this.log.logError(errorPrefix + "Duplicate key \"Scheme\" found, the first value is used." + errorSuffix, null);
                                    break block8;
                                }
                                foundScheme = true;
                                break block11;
                            }
                            if (!key.equals("Override")) break block16;
                            if (!foundOverride) break block17;
                            this.log.logError(errorPrefix + "Duplicate key \"Override\" found, the first value is used." + errorSuffix, null);
                            break block8;
                        }
                        foundOverride = true;
                        break block11;
                    }
                    this.log.logError(errorPrefix + "Unknown key==\"" + key + "\", key is ignored." + errorSuffix, null);
                    break block8;
                }
                if (keyValueSplit == keyValuePair.length() - 1) {
                    this.log.logError(errorPrefix + "Missing value for \"" + key + "\", error ignored." + errorSuffix, null);
                } else {
                    String value = keyValuePair.substring(keyValueSplit + 1).trim();
                    if (value.length() == 0) {
                        this.log.logError(errorPrefix + "Missing value for \"" + key + "\", error ignored." + errorSuffix, null);
                    }
                }
            }
            left = right + 1;
        }
        return true;
    }
}

