/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.services.httpserver.HostPropertiesRuntimeInterface;
import com.sap.engine.services.httpserver.HttpRuntimeInterface;
import com.sap.engine.services.httpserver.ZoneManagementInterface;
import com.sap.engine.services.httpserver.exceptions.HttpRemoteException;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.HttpMonitoring;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.hosts.impl.HostPropertiesRuntimeInterfaceImpl;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class HttpRuntimeInterfaceImpl
extends PortableRemoteObject
implements HttpRuntimeInterface {
    private HttpServerFrame http = null;
    private HttpMonitoring httpMonitoring = null;
    private HttpHosts httpManager = null;
    private HttpProperties httpProperties = null;
    private ZoneManagementInterface zoneManagementInterface = null;

    public HttpRuntimeInterfaceImpl(HttpServerFrame http, HttpHosts httpManager, HttpMonitoring httpMonitoring, HttpProperties httpProperties, ZoneManagementInterface zoneManagementInterface) throws RemoteException {
        this.httpManager = httpManager;
        this.http = http;
        this.httpMonitoring = httpMonitoring;
        this.httpProperties = httpProperties;
        this.zoneManagementInterface = zoneManagementInterface;
    }

    public HttpProvider getHttpProvider() {
        return Processor.getHttpProvider();
    }

    public HostPropertiesRuntimeInterface[] getAllHostsTemp() throws RemoteException {
        Host[] hosts = this.httpManager.getAllHosts();
        HostPropertiesRuntimeInterface[] res = new HostPropertiesRuntimeInterface[hosts.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new HostPropertiesRuntimeInterfaceImpl(this.httpProperties, hosts[i].getHostProperties(), hosts[i].getHostPropertiesModyfier());
            ++i;
        }
        return res;
    }

    public HostPropertiesRuntimeInterface createHost(String hostName) throws IllegalHostArgumentsException, ConfigurationException, RemoteException {
        Host newHost = this.httpManager.createAndStoreHost(hostName);
        return new HostPropertiesRuntimeInterfaceImpl(this.httpProperties, newHost.getHostProperties(), newHost.getHostPropertiesModyfier());
    }

    public void removeHost(String hostName) throws IllegalHostArgumentsException, RemoteException {
        if ("default".endsWith(hostName)) {
            throw new IllegalHostArgumentsException(IllegalHostArgumentsException.ILLEGAL_TO_REMOVE_DEFAULT_VIRTUAL_HOST);
        }
        if (HttpHosts.getCS().getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7) {
            return;
        }
        int count = 0;
        while ((long)count < 100L) {
            try {
                this.httpManager.removeHost(hostName, false);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.http.getLog().logError("A thread interrupted while waiting for cluster lock for Http Provider service for configuration access.", ie, null);
                }
                if ((long)count == 99L) {
                    throw new HttpRemoteException(HttpRemoteException.CANNOT_REMOVE_DESCRIPTOR_FOR_HOST, e);
                }
            }
            catch (ConfigurationException t) {
                throw new HttpRemoteException(HttpRemoteException.CANNOT_REMOVE_DESCRIPTOR_FOR_HOST, t);
            }
            ++count;
        }
    }

    public void clearCache() throws RemoteException {
        this.httpManager.clearCache();
        this.http.clearRemoteCache();
    }

    public void clearCache(String hostName) throws RemoteException {
        this.httpManager.clearCache(hostName);
        this.http.clearRemoteCache();
    }

    public void clearCacheByAlias(String alias) throws RemoteException {
        this.httpManager.clearCache();
        this.http.clearRemoteCache(alias);
    }

    public ZoneManagementInterface getZoneManagementInterface() {
        return this.zoneManagementInterface;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public long getAllRequestsCount() throws RemoteException {
        return this.httpMonitoring.getAllRequestsCount();
    }

    public long getAllResponsesCount() throws RemoteException {
        return this.httpMonitoring.getAllResponsesCount();
    }

    public long getTotalResponseTime() throws RemoteException {
        return this.httpMonitoring.getTotalResponseTime();
    }

    public String[] getMethodNames() throws RemoteException {
        return this.httpMonitoring.getMethodNames();
    }

    public long getRequestsCount(String methodName) throws RemoteException {
        return this.httpMonitoring.getRequestsCount(methodName);
    }

    public int[] getResponseCodes() throws RemoteException {
        return this.httpMonitoring.getResponseCodes();
    }

    public long getResponsesCount(int responseCode) throws RemoteException {
        return this.httpMonitoring.getResponsesCount(responseCode);
    }

    public long getResponsesFromCacheCount() throws RemoteException {
        return this.httpMonitoring.getResponsesFromCacheCount();
    }
}

