/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.Zone;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.interfaces.HttpHandler;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import com.sap.engine.services.httpserver.server.zones.ZoneManagementImpl;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class HttpProviderImpl
implements HttpProvider {
    private MessageContext message = null;
    private Log log = null;
    private HttpServerFrame frame = null;
    private static HttpHandler servletJSPService = null;
    private HttpHosts httpManager = null;
    private ConvertTools convert = new ConvertTools(false);
    private ConcurrentHashMapObjectObject startedApplications = new ConcurrentHashMapObjectObject();
    private ConcurrentHashMapObjectObject urlSessionTrackingApplications = new ConcurrentHashMapObjectObject();
    private ClusterMonitor clusterMonitor = null;
    private boolean allApplicationsStarted = false;

    public HttpProviderImpl(MessageContext message, HttpHosts httpManager, Log log, HttpServerFrame frame, ClusterMonitor clusterMonitor) {
        this.message = message;
        this.httpManager = httpManager;
        this.log = log;
        this.frame = frame;
        this.clusterMonitor = clusterMonitor;
    }

    public ZoneManagementImpl getZoneManagement() {
        try {
            return (ZoneManagementImpl)this.frame.getHttpRuntimeInterface().getZoneManagementInterface();
        }
        catch (RemoteException e) {
            Log.logWarning("Cannot get ZoneManagementInterface!", e, null);
            return null;
        }
    }

    public int[] getServers(int group) {
        return this.frame.getServers(group);
    }

    public int getGroup(int server) {
        return this.frame.getGroup(server);
    }

    public void removeSession(String cookie) {
        if (servletJSPService != null) {
            servletJSPService.removeSession(cookie);
        }
    }

    public void registerHttpHandler(HttpHandler servletAndJsp) {
        if (servletAndJsp == null) {
            this.startedApplications.clear();
        } else {
            this.sendWebContainerStarted(-1);
        }
        servletJSPService = servletAndJsp;
    }

    public void zonesChanged() {
        Object[] applications = this.startedApplications.getAllKeys();
        int i = 0;
        while (applications != null && i < applications.length) {
            String applicationName = (String)applications[i];
            String[] aliases = (String[])this.startedApplications.get((Object)applicationName);
            try {
                this.changeLoadBalance(applicationName, aliases, false, false);
                this.changeLoadBalance(applicationName, aliases, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.logError("Cannot send load balancing information to j2ee dispatchers for application [" + applicationName + "] after http zones settigns are changed.", e, null);
            }
            ++i;
        }
    }

    public void allApplicationsStarted() {
        if (this.clusterMonitor.getCurrentParticipant().getState() == 7) {
            return;
        }
        this.allApplicationsStarted = true;
        this.sendToDispatchers(8, new byte[]{0});
    }

    public void sendAllApplicationsStarted(int dispatcherId) {
        if (this.clusterMonitor.getCurrentParticipant().getState() == 7) {
            return;
        }
        if (this.allApplicationsStarted) {
            try {
                this.message.send(-1, (byte)1, 8, new byte[0], 0, 0);
            }
            catch (ClusterException t) {
                this.log.logError("Cannot send a notification to all j2ee dispatchers that the synchronization and initialization of the deployed applications has finished. The current server node may not be added to http requests load balancing.", t, null);
            }
        }
    }

    public void changeLoadBalance(String applicationName, String[] aliases, boolean start) {
        this.doChangeLoadBalance(applicationName, aliases, start, true);
    }

    public void doChangeLoadBalance(String applicationName, String[] aliases, boolean start, boolean checkZones) {
        if (this.clusterMonitor.getCurrentParticipant().getState() == 7) {
            return;
        }
        if (aliases == null || aliases.length == 0) {
            return;
        }
        if (checkZones) {
            HashMapObjectObject zonesToExactAliases;
            HashMapObjectObject zonesToAliases = this.checkZones(aliases);
            if (zonesToAliases != null && zonesToAliases.size() != 0) {
                Object[] zones = zonesToAliases.getAllKeys();
                int i = 0;
                while (i < zones.length) {
                    String[] tmp = (String[])zonesToAliases.get(zones[i]);
                    int j = 0;
                    while (j < tmp.length) {
                        int n = j++;
                        tmp[n] = tmp[n] + this.frame.getHttpProperties().getZoneSeparator() + zones[i];
                    }
                    this.changeLoadBalance(applicationName + this.frame.getHttpProperties().getZoneSeparator() + zones[i], tmp, start);
                    ++i;
                }
            }
            if ((zonesToExactAliases = this.checkExactZones(aliases)) != null && zonesToExactAliases.size() != 0) {
                Object[] zones = zonesToExactAliases.getAllKeys();
                int i = 0;
                while (i < zones.length) {
                    String[] tmp = (String[])zonesToExactAliases.get(zones[i]);
                    this.doChangeLoadBalance(applicationName + this.frame.getHttpProperties().getZoneSeparator() + zones[i], tmp, start, false);
                    ++i;
                }
            }
        }
        if (start) {
            this.startedApplications.put((Object)applicationName, (Object)aliases);
            int alLen = 0;
            int i = 0;
            while (i < aliases.length) {
                alLen += aliases[i].length();
                ++i;
            }
            byte[] msg = new byte[4 + applicationName.length() + 4 + 4 * aliases.length + alLen];
            int off = 0;
            this.convert.intToArr(applicationName.length(), msg, off);
            byte[] app = applicationName.getBytes();
            System.arraycopy(app, 0, msg, off += 4, app.length);
            this.convert.intToArr(aliases.length, msg, off += app.length);
            off += 4;
            int i2 = 0;
            while (i2 < aliases.length) {
                this.convert.intToArr(aliases[i2].length(), msg, off);
                byte[] al = aliases[i2].getBytes();
                System.arraycopy(al, 0, msg, off += 4, al.length);
                off += al.length;
                ++i2;
            }
            this.sendToDispatchers(3, msg);
        } else {
            this.httpManager.notifyStopApplicationAlias(aliases);
            byte[] msg = applicationName.getBytes();
            this.startedApplications.remove((Object)applicationName);
            int i = 0;
            while (i < aliases.length) {
                this.urlSessionTrackingApplications.remove((Object)aliases[i]);
                ++i;
            }
            this.sendToDispatchers(4, msg);
        }
    }

    private void changeLoadBalance(String applicationName, String[] aliases, boolean start, boolean removeFromServer) {
        if (start || removeFromServer) {
            this.changeLoadBalance(applicationName, aliases, start);
        } else {
            byte[] msg = applicationName.getBytes();
            this.startedApplications.remove((Object)applicationName);
            int i = 0;
            while (i < aliases.length) {
                this.urlSessionTrackingApplications.remove((Object)aliases[i]);
                ++i;
            }
            this.sendToDispatchers(4, msg);
        }
    }

    public void urlSessionTracking(String webApplication, boolean isURLSessionTracking) {
        byte[] msg = new byte[4 + webApplication.length() + 1];
        this.convert.intToArr(webApplication.length(), msg, 0);
        byte[] app = webApplication.getBytes();
        System.arraycopy(app, 0, msg, 4, app.length);
        msg[msg.length - 1] = isURLSessionTracking ? (byte)1 : 0;
        this.urlSessionTrackingApplications.put((Object)webApplication, (Object)new Boolean(isURLSessionTracking));
        this.sendToDispatchers(7, msg);
    }

    public void clearCache() {
        this.httpManager.clearCache();
        this.frame.clearRemoteCache();
    }

    public void clearCacheByAlias(String alias) {
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public void addApplicationAlias(String alias) throws ConfigurationException, IllegalHostArgumentsException {
        this.httpManager.addApplicationAlias(alias);
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public void checkApplicationAlias(String alias) throws IllegalHostArgumentsException {
        this.httpManager.checkApplicationAlias(alias);
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public void startApplicationAlias(String alias, String dir) {
        this.httpManager.startApplicationAlias(alias, dir);
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public void removeApplicationAlias(String alias) throws ConfigurationException {
        this.httpManager.removeApplicationAlias(alias);
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public void addHttpAlias(String alias, String value) throws ConfigurationException, IllegalHostArgumentsException {
        Host[] allHosts = this.httpManager.getAllHosts();
        int i = 0;
        while (i < allHosts.length) {
            allHosts[i].getHostPropertiesModyfier().addHttpAlias(alias, value);
            ++i;
        }
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public boolean containsHttpAlias(String alias) {
        Host[] allHosts = this.httpManager.getAllHosts();
        int i = 0;
        while (i < allHosts.length) {
            if (allHosts[i].getHostProperties().getHttpAliases().containsKey((Object)alias)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeHttpAlias(String alias) throws ConfigurationException {
        Host[] allHosts = this.httpManager.getAllHosts();
        int i = 0;
        while (i < allHosts.length) {
            allHosts[i].getHostPropertiesModyfier().removeHttpAlias(alias);
            ++i;
        }
        this.httpManager.clearCache();
        this.frame.clearRemoteCache(alias);
    }

    public HttpProperties getHttpProperties() {
        return this.frame.getHttpProperties();
    }

    public static HttpHandler getWebContainer() {
        return servletJSPService;
    }

    public void setWebContainer(HttpHandler servletJSPService) {
        HttpProviderImpl.servletJSPService = servletJSPService;
    }

    protected void resendLoadBalance(int dispatcherId) {
        if (this.clusterMonitor.getCurrentParticipant().getState() == 7) {
            return;
        }
        Object[] apps = this.startedApplications.getAllKeys();
        if ((apps == null || apps.length == 0) && servletJSPService != null) {
            this.sendWebContainerStarted(dispatcherId);
        }
        int j = 0;
        while (j < apps.length) {
            String applicationName = (String)apps[j];
            String[] aliases = (String[])this.startedApplications.get((Object)applicationName);
            this.resendLoadBalance(dispatcherId, applicationName, aliases);
            ++j;
        }
        this.sendWebContainerStarted(dispatcherId);
        this.resendURLSessionTracking();
        this.sendAllApplicationsStarted(dispatcherId);
    }

    private void resendLoadBalance(int dispatcherId, String applicationName, String[] aliases) {
        HashMapObjectObject zonesToExactAliases;
        HashMapObjectObject zonesToAliases = this.checkZones(aliases);
        if (zonesToAliases != null && zonesToAliases.size() != 0) {
            Object[] zones = zonesToAliases.getAllKeys();
            int i = 0;
            while (i < zones.length) {
                String[] tmp = (String[])zonesToAliases.get(zones[i]);
                int j = 0;
                while (j < tmp.length) {
                    int n = j++;
                    tmp[n] = tmp[n] + this.frame.getHttpProperties().getZoneSeparator() + zones[i];
                }
                this.resendLoadBalance(dispatcherId, applicationName + this.frame.getHttpProperties().getZoneSeparator() + zones[i], tmp);
                ++i;
            }
        }
        if ((zonesToExactAliases = this.checkExactZones(aliases)) != null && zonesToExactAliases.size() != 0) {
            Object[] zones = zonesToExactAliases.getAllKeys();
            int i = 0;
            while (i < zones.length) {
                String[] tmp = (String[])zonesToExactAliases.get(zones[i]);
                int j = 0;
                while (j < tmp.length) {
                    int n = j++;
                    tmp[n] = tmp[n] + this.frame.getHttpProperties().getZoneSeparator() + zones[i];
                }
                this.resendLoadBalance(dispatcherId, applicationName + this.frame.getHttpProperties().getZoneSeparator() + zones[i], tmp);
                ++i;
            }
        }
        int alLen = 0;
        int i = 0;
        while (i < aliases.length) {
            alLen += aliases[i].length();
            ++i;
        }
        byte[] msg = new byte[4 + applicationName.length() + 4 + 4 * aliases.length + alLen];
        int off = 0;
        this.convert.intToArr(applicationName.length(), msg, off);
        byte[] app = applicationName.getBytes();
        System.arraycopy(app, 0, msg, off += 4, app.length);
        this.convert.intToArr(aliases.length, msg, off += app.length);
        off += 4;
        int i2 = 0;
        while (i2 < aliases.length) {
            this.convert.intToArr(aliases[i2].length(), msg, off);
            byte[] al = aliases[i2].getBytes();
            System.arraycopy(al, 0, msg, off += 4, al.length);
            off += al.length;
            ++i2;
        }
        try {
            this.message.send(dispatcherId, 3, msg, 0, msg.length);
        }
        catch (ClusterException t) {
            this.log.logError("Cannot send load balancing information of the current server node to the dispatcher [" + dispatcherId + "]. " + "Incorrect http requests load balancing may be caused.", t, null);
        }
    }

    private void resendURLSessionTracking() {
        Object[] webApps = this.urlSessionTrackingApplications.getAllKeys();
        int i = 0;
        while (i < webApps.length) {
            this.urlSessionTracking((String)webApps[i], (Boolean)this.urlSessionTrackingApplications.get(webApps[i]));
            ++i;
        }
    }

    private void sendWebContainerStarted(int dispatcherId) {
    }

    private void sendToDispatchers(int type, byte[] msg) {
        if (this.clusterMonitor.getCurrentParticipant().getState() == 7) {
            return;
        }
        try {
            this.message.send(-1, (byte)1, type, msg, 0, msg.length);
        }
        catch (ClusterException t) {
            this.log.logError("Cannot send load balancing information of the current server node to all dispatchers. Incorrect http requests load balancing may be caused.", t, null);
        }
    }

    private HashMapObjectObject checkZones(String[] aliases) {
        if (aliases == null || aliases.length == 0) {
            return null;
        }
        if (this.frame.getHttpProperties().getZoneSeparator() == null || this.frame.getHttpProperties().getZoneSeparator().trim().length() == 0) {
            return null;
        }
        HashMapObjectObject res = new HashMapObjectObject();
        Zone[] allZones = null;
        try {
            allZones = this.frame.getHttpRuntimeInterface().getZoneManagementInterface().getAllZones();
            if (allZones == null || allZones.length == 0) {
                return null;
            }
            int i = 0;
            while (i < allZones.length) {
                Zone zone = allZones[i];
                String[] zoneAliases = zone.getAliases();
                if (zoneAliases != null && zoneAliases.length != 0) {
                    int j = 0;
                    while (j < zoneAliases.length) {
                        if (this.contains(aliases, zoneAliases[j]) && this.contains(zone.getInstances(), this.frame.getGroupID())) {
                            String[] aliasesForZone = (String[])res.get((Object)zone.getZoneName());
                            if (aliasesForZone == null) {
                                aliasesForZone = new String[]{zoneAliases[j]};
                            } else {
                                String[] tmp = new String[aliasesForZone.length + 1];
                                System.arraycopy(aliasesForZone, 0, tmp, 0, aliasesForZone.length);
                                tmp[aliasesForZone.length] = zoneAliases[j];
                                aliasesForZone = tmp;
                            }
                            res.put((Object)zone.getZoneName(), (Object)aliasesForZone);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            this.log.logError("Cannot update http load balancing data with http zones information. Incorrect http requests load balancing may be caused.", e, null);
        }
        return res;
    }

    private HashMapObjectObject checkExactZones(String[] aliases) {
        if (aliases == null || aliases.length == 0) {
            return null;
        }
        if (this.frame.getHttpProperties().getZoneSeparator() == null || this.frame.getHttpProperties().getZoneSeparator().trim().length() == 0) {
            return null;
        }
        HashMapObjectObject res = new HashMapObjectObject();
        Zone[] allZones = null;
        try {
            allZones = this.frame.getHttpRuntimeInterface().getZoneManagementInterface().getAllZones();
            if (allZones == null || allZones.length == 0) {
                return this.checkLogonGroups(aliases, res);
            }
            int i = 0;
            while (i < allZones.length) {
                Zone zone = allZones[i];
                String[] zoneAliases = zone.getExactAliases();
                if (zoneAliases != null && zoneAliases.length != 0) {
                    int j = 0;
                    while (j < zoneAliases.length) {
                        if (this.contains(aliases, zoneAliases[j]) && this.contains(zone.getInstances(), this.frame.getGroupID())) {
                            String[] aliasesForZone = (String[])res.get((Object)zone.getZoneName());
                            if (aliasesForZone == null) {
                                aliasesForZone = new String[]{zoneAliases[j]};
                            } else {
                                String[] tmp = new String[aliasesForZone.length + 1];
                                System.arraycopy(aliasesForZone, 0, tmp, 0, aliasesForZone.length);
                                tmp[aliasesForZone.length] = zoneAliases[j];
                                aliasesForZone = tmp;
                            }
                            res.put((Object)zone.getZoneName(), (Object)aliasesForZone);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            this.log.logError("Cannot update http load balancing data with http zones information. Incorrect http requests load balancing may be caused.", e, null);
        }
        return this.checkLogonGroups(aliases, res);
    }

    private HashMapObjectObject checkLogonGroups(String[] aliases, HashMapObjectObject res) {
        if ((res = this.doCheckLogonGroups(aliases, res)).size() == 0) {
            return null;
        }
        return res;
    }

    private HashMapObjectObject doCheckLogonGroups(String[] aliases, HashMapObjectObject res) {
        if (aliases == null || aliases.length == 0) {
            return res;
        }
        Vector logonGroups = this.getHttpProperties().getLogonTable().getGroups();
        if (logonGroups == null || logonGroups.size() == 0) {
            return res;
        }
        Enumeration en = logonGroups.elements();
        while (en.hasMoreElements()) {
            String logonGroup = (String)en.nextElement();
            if (logonGroup == null || logonGroup.length() == 0) continue;
            String[] groupAliases = this.getHttpProperties().getLogonTable().getAliases(logonGroup);
            int j = 0;
            while (groupAliases != null && j < groupAliases.length) {
                int zoneInd;
                if (this.contains(aliases, groupAliases[j]) && this.contains(this.getHttpProperties().getLogonTable().getInstances(logonGroup), this.frame.getGroupID())) {
                    String[] aliasesForZone = (String[])res.get((Object)logonGroup);
                    if (aliasesForZone == null) {
                        aliasesForZone = new String[]{groupAliases[j]};
                    } else {
                        String[] tmp = new String[aliasesForZone.length + 1];
                        System.arraycopy(aliasesForZone, 0, tmp, 0, aliasesForZone.length);
                        tmp[aliasesForZone.length] = groupAliases[j];
                        aliasesForZone = tmp;
                    }
                    res.put((Object)logonGroup, (Object)aliasesForZone);
                } else if (this.getHttpProperties().getZoneSeparator() != null && (zoneInd = groupAliases[j].indexOf(this.getHttpProperties().getZoneSeparator())) != -1 && groupAliases[j].substring(zoneInd + 1).equals(logonGroup) && this.contains(aliases, groupAliases[j].substring(0, zoneInd)) && this.contains(this.getHttpProperties().getLogonTable().getInstances(logonGroup), this.frame.getGroupID())) {
                    String[] aliasesForZone = (String[])res.get((Object)logonGroup);
                    if (aliasesForZone == null) {
                        aliasesForZone = new String[]{groupAliases[j]};
                    } else {
                        String[] tmp = new String[aliasesForZone.length + 1];
                        System.arraycopy(aliasesForZone, 0, tmp, 0, aliasesForZone.length);
                        tmp[aliasesForZone.length] = groupAliases[j];
                        aliasesForZone = tmp;
                    }
                    res.put((Object)logonGroup, (Object)aliasesForZone);
                }
                ++j;
            }
        }
        return res;
    }

    private boolean contains(String[] aliases, String alias) {
        if (aliases != null && alias != null) {
            int i = 0;
            while (i < aliases.length) {
                if (alias.equalsIgnoreCase(aliases[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean contains(int[] servers, int server) {
        int i = 0;
        while (servers != null && i < servers.length) {
            if (servers[i] == server) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(String[] instanceName, int groupId) {
        String instanceNameToSearch = SBasic.getInstanceNameForGroup((int)groupId);
        if (instanceNameToSearch == null) {
            return false;
        }
        int i = 0;
        while (instanceName != null && i < instanceName.length) {
            if (instanceNameToSearch.equalsIgnoreCase(instanceName[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

