/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.lib.util.ConcurrentHashMapIntLong;
import com.sap.engine.lib.util.ConcurrentHashMapObjectLong;
import com.sap.engine.services.httpserver.ServerMonitoring;
import java.util.NoSuchElementException;

public class HttpMonitoring
implements ServerMonitoring {
    private long allResponsesCount = 0L;
    private long allResponseTime = 0L;
    private long allRequestsCount = 0L;
    private ConcurrentHashMapObjectLong requestMethodToRequestsCount = new ConcurrentHashMapObjectLong();
    private ConcurrentHashMapIntLong responseCodeToResponsesCount = new ConcurrentHashMapIntLong();
    private long responsesFromCache = 0L;

    public long getAllRequestsCount() {
        return this.allRequestsCount;
    }

    public long getAllResponsesCount() {
        return this.allResponsesCount;
    }

    public long getTotalResponseTime() {
        return this.allResponseTime;
    }

    public String[] getMethodNames() {
        ConcurrentHashMapObjectLong concurrentHashMapObjectLong = this.requestMethodToRequestsCount;
        synchronized (concurrentHashMapObjectLong) {
            int methodsCount = this.requestMethodToRequestsCount.size();
            if (methodsCount == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            if (methodsCount == 1) {
                String[] stringArray = new String[]{(String)this.requestMethodToRequestsCount.getAllKeys()[0]};
                return stringArray;
            }
            Object[] keys = this.requestMethodToRequestsCount.getAllKeys();
            String[] methodNames = new String[keys.length];
            System.arraycopy(keys, 0, methodNames, 0, keys.length);
            String[] stringArray = methodNames;
            return stringArray;
        }
    }

    public synchronized long getRequestsCount(String methodName) {
        try {
            return this.requestMethodToRequestsCount.get((Object)methodName);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    public synchronized int[] getResponseCodes() {
        ConcurrentHashMapIntLong concurrentHashMapIntLong = this.responseCodeToResponsesCount;
        synchronized (concurrentHashMapIntLong) {
            int responseCodesCount = this.responseCodeToResponsesCount.size();
            if (responseCodesCount == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            if (responseCodesCount == 1) {
                int[] nArray = new int[]{this.responseCodeToResponsesCount.getAllKeys()[0]};
                return nArray;
            }
            int[] nArray = this.responseCodeToResponsesCount.getAllKeys();
            return nArray;
        }
    }

    public synchronized long getResponsesCount(int responseCode) {
        ConcurrentHashMapIntLong concurrentHashMapIntLong = this.responseCodeToResponsesCount;
        synchronized (concurrentHashMapIntLong) {
            try {
                long l = this.responseCodeToResponsesCount.get(responseCode);
                return l;
            }
            catch (NoSuchElementException e) {
                long l = 0L;
                return l;
            }
        }
    }

    public long getResponsesFromCacheCount() {
        return this.responsesFromCache;
    }

    protected void newRequest(String requestMethod) {
        ++this.allRequestsCount;
        ConcurrentHashMapObjectLong concurrentHashMapObjectLong = this.requestMethodToRequestsCount;
        synchronized (concurrentHashMapObjectLong) {
            if (this.requestMethodToRequestsCount.containsKey((Object)requestMethod)) {
                long count = this.requestMethodToRequestsCount.get((Object)requestMethod);
                this.requestMethodToRequestsCount.put((Object)requestMethod, count + 1L);
            } else {
                this.requestMethodToRequestsCount.put((Object)requestMethod, 1L);
            }
        }
    }

    protected void addResponseTime(long responseTime, int responseCode, boolean fromCache) {
        ++this.allResponsesCount;
        this.allResponseTime += responseTime;
        if (this.allResponseTime < 0L) {
            this.allResponsesCount = 1L;
            this.allResponseTime = responseTime;
        }
        if (fromCache) {
            ++this.responsesFromCache;
        }
        ConcurrentHashMapIntLong concurrentHashMapIntLong = this.responseCodeToResponsesCount;
        synchronized (concurrentHashMapIntLong) {
            if (this.responseCodeToResponsesCount.containsKey(responseCode)) {
                long count = 0L;
                try {
                    count = this.responseCodeToResponsesCount.get(responseCode);
                }
                catch (NoSuchElementException e) {
                    count = 0L;
                }
                this.responseCodeToResponsesCount.put(responseCode, count + 1L);
            } else {
                this.responseCodeToResponsesCount.put(responseCode, 1L);
            }
        }
    }
}

