/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.httpserver.server.Log;

public class HttpLock {
    public static String LOCK_AREA = "_HTTP_LOCK_AREA_";
    public static String HTTP_VIRTUAL_HOSTS_LOCK = "_HTTP_VIRTUAL_HOSTS_LOCK_";
    public static String HTTP_UPLOADED_FILES_LOCK = "_HTTP_UPLOADED_FILES_LOCK_";
    public static String ZONES_LOCK = "_ZONES_LOCK_";
    private static final long LOCK_WAIT_TIMEOUT = 1000L;
    public static final long READ_LOCK_WAIT_TIMEOUT = 100L;
    public static final long READ_LOCK_ITER_COUNT = 100L;
    private LockingContext lock = null;
    private String httpOwner = null;
    private Log log = null;

    public HttpLock(ApplicationServiceContext sc, Log log) {
        this.lock = sc.getCoreContext().getLockingContext();
        this.log = log;
        try {
            this.httpOwner = this.lock.getAdministrativeLocking().createUniqueOwner();
        }
        catch (TechnicalLockException tlex) {
            this.httpOwner = LOCK_AREA;
        }
    }

    public void lock(String name) throws LockException, TechnicalLockException {
        if (this.lock != null) {
            this.lock.getAdministrativeLocking().lock(this.httpOwner, LOCK_AREA, name, 'X');
        } else {
            this.log.logError("Cannot get a cluster lock for Http Provider service. The Locking Manager is not available or not initialized. Possible synchronization problems can occur.", null);
        }
    }

    public void enterLockArea(String name) throws TechnicalLockException, InterruptedException {
        boolean areaLocked = false;
        while (!areaLocked) {
            try {
                this.lock(name);
                areaLocked = true;
            }
            catch (LockException e) {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
    }

    public void unlock(String name) throws TechnicalLockException {
        if (this.lock != null) {
            this.lock.getAdministrativeLocking().unlock(this.httpOwner, LOCK_AREA, name, 'X', true);
        } else {
            this.log.logError("Cannot release a cluster lock for Http Provider service. The Locking Manager is not available or not initialized. Possible synchronization problems can occur.", null);
        }
    }

    public void leaveLockArea(String name) throws TechnicalLockException {
        this.unlock(name);
    }
}

