/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.httpserver.exceptions.HttpServiceException;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.Constants;
import com.sap.engine.services.httpserver.server.Date;
import com.sap.engine.services.httpserver.server.HttpLock;
import com.sap.engine.services.httpserver.server.HttpServerFrame;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.hosts.impl.HttpHostListener;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;
import java.io.File;
import java.io.IOException;

public class HttpHosts {
    private Log log = null;
    private Date date = null;
    private ConcurrentHashMapIntObject mapHashToMB = new ConcurrentHashMapIntObject();
    private byte[] version = null;
    private Host[] hosts = new Host[0];
    private ConcurrentHashMapObjectObject applicationAliases = new ConcurrentHashMapObjectObject();
    private static ApplicationServiceContext sc = null;
    private ConfigurationHandlerFactory factory = null;
    private HttpProperties httpProperties = null;

    public synchronized void init(String majorVer, Date date, Log log, HttpProperties httpProperties, ApplicationServiceContext sc) throws ServiceException {
        this.version = ("SAP J2EE Engine/" + majorVer).getBytes();
        this.log = log;
        this.date = date;
        HttpHosts.sc = sc;
        this.httpProperties = httpProperties;
        this.factory = sc.getCoreContext().getConfigurationHandlerFactory();
        if (this.factory == null) {
            throw new HttpServiceException(HttpServiceException.CONFIGURATION_MANAGER_IS_NOT_AVAILABLE);
        }
        ConfigurationHandler handler = null;
        try {
            handler = this.factory.getConfigurationHandler();
            handler.addConfigurationChangedListener((ConfigurationChangedListener)new HttpHostListener(this, this.factory), "HttpHosts");
            handler.commit();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            handler.closeAllConfigurations();
            throw throwable;
        }
        handler.closeAllConfigurations();
    }

    public String getApplicationAliasValue(String alias) {
        return (String)this.applicationAliases.get((Object)alias);
    }

    public void readAllHostsFromConfiguration() throws ConfigurationException, ServiceException {
        Object v1;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration hosts = null;
        try {
            hosts = handler.openConfiguration("HttpHosts", 0);
        }
        catch (NameNotFoundException nnfe) {
            handler.closeAllConfigurations();
            try {
                Host host = this.createAndStoreHost("default");
                HttpHostListener listener = new HttpHostListener(host.getConfigurationReader());
                handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/default");
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.log.logFatal("Cannot create a default http virtual host. The Http Provider service cannot run properly without a virtual host specified. Probably a configuration access problem.", e);
                throw new HttpServiceException(HttpServiceException.UNABLE_TO_INIT_THE_DEFAULT_HTTP_HOST_CANNOT_START_HTTP_SERVICE_ON_SERVER, e);
            }
            return;
        }
        try {
            String[] hostNames = hosts.getAllSubConfigurationNames();
            int i = 0;
            while (i < hostNames.length) {
                try {
                    Host host = this.createHost(hostNames[i]);
                    HttpHostListener listener = new HttpHostListener(host.getConfigurationReader());
                    handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/" + hostNames[i]);
                }
                catch (Exception e) {
                    if (hostNames[i].equals("default")) {
                        this.log.logFatal("Cannot read settings and initialize a default http virtual host. The Http Provider service cannot run properly without a virtual host specified. Probably incorrect settings are specified or cannot read from configuration.", e);
                        throw new HttpServiceException(HttpServiceException.UNABLE_TO_INIT_THE_DEFAULT_HTTP_HOST_CANNOT_START_HTTP_SERVICE_ON_SERVER, e);
                    }
                    Log.logWarning("Cannot read settings and initialize http virtual host [" + hostNames[i] + "]. Probably incorrect settings are specified or cannot read from configuration.", e, null);
                }
                ++i;
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var8_15 = null;
            try {
                handler.closeAllConfigurations();
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var10_19;
                v0 = var10_19 = null;
            }
            if (this.getHost("default") == null) {
                try {
                    Host host = this.createAndStoreHost("default");
                    HttpHostListener listener = new HttpHostListener(host.getConfigurationReader());
                    handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/default");
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.log.logFatal("Cannot create a default http virtual host. The Http Provider service cannot run properly without a virtual host specified. Probably a configuration access problem.", e);
                    throw new HttpServiceException(HttpServiceException.UNABLE_TO_INIT_THE_DEFAULT_HTTP_HOST_CANNOT_START_HTTP_SERVICE_ON_SERVER, e);
                }
            }
            throw throwable;
        }
        try {
            handler.closeAllConfigurations();
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var10_18;
            v1 = var10_18 = null;
        }
        if (this.getHost("default") == null) {
            try {
                Host host = this.createAndStoreHost("default");
                HttpHostListener listener = new HttpHostListener(host.getConfigurationReader());
                handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/default");
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.log.logFatal("Cannot create a default http virtual host. The Http Provider service cannot run properly without a virtual host specified. Probably a configuration access problem.", e);
                throw new HttpServiceException(HttpServiceException.UNABLE_TO_INIT_THE_DEFAULT_HTTP_HOST_CANNOT_START_HTTP_SERVICE_ON_SERVER, e);
            }
        }
    }

    public static ApplicationServiceContext getCS() {
        return sc;
    }

    private Host createHost(String hostName) throws ConfigurationException {
        Host host = this.newHost(hostName, false);
        HttpHostListener listener = new HttpHostListener(host.getConfigurationReader());
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/" + hostName);
        return host;
    }

    public synchronized Host createAndStoreHost(String newHostName) throws ConfigurationException, IllegalHostArgumentsException {
        int i = 0;
        while (i < this.hosts.length) {
            if (this.hosts[i].getHostName().equalsIgnoreCase(newHostName)) {
                throw new IllegalHostArgumentsException(IllegalHostArgumentsException.HOST_WITH_NAME_ALREADY_EXISTS, new Object[]{newHostName});
            }
            ++i;
        }
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Host newHost = this.newHost(newHostName, true);
        HttpHostListener listener = new HttpHostListener(newHost.getConfigurationReader());
        handler.addConfigurationChangedListener((ConfigurationChangedListener)listener, "HttpHosts/" + newHostName);
        return newHost;
    }

    private Host newHost(String hostName, boolean toCreate) throws ConfigurationException {
        Host newDescriptor = new Host(hostName, this.version, this.log, this.httpProperties, this, this.date, this.factory, sc);
        if (toCreate) {
            newDescriptor.store();
        }
        int count = 0;
        while ((long)count < 100L) {
            try {
                newDescriptor.getConfigurationReader().readConfiguration(false);
                break;
            }
            catch (InconsistentReadException e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    this.log.logError("A thread was interrupted while waiting for cluster lock for Http Provider service.", ie, null);
                }
                if ((long)count == 99L) {
                    throw e;
                }
                ++count;
            }
        }
        if (toCreate && !"default".equals(hostName)) {
            this.initAppAliases(newDescriptor);
        }
        newDescriptor.startCache();
        Host[] temp = new Host[this.hosts.length + 1];
        System.arraycopy(this.hosts, 0, temp, 0, this.hosts.length);
        temp[this.hosts.length] = newDescriptor;
        this.hosts = temp;
        return newDescriptor;
    }

    private void initAppAliases(Host newDescriptor) throws ConfigurationException {
        Host defaultHost = this.getHost("default");
        String[] defaultAliases = defaultHost.getHostProperties().getAliasNames();
        int i = 0;
        while (defaultAliases != null && i < defaultAliases.length) {
            if (defaultHost.getHostProperties().isApplicationAlias(defaultAliases[i])) {
                newDescriptor.getHostPropertiesModyfier().enableApplicationAlias(defaultAliases[i]);
            }
            ++i;
        }
    }

    public Host getHost(String host) {
        if (this.hosts.length == 1) {
            return this.hosts[0];
        }
        int i = 0;
        while (i < this.hosts.length) {
            if (this.hosts[i].getHostName().equalsIgnoreCase(host)) {
                return this.hosts[i];
            }
            ++i;
        }
        return null;
    }

    public Host getHost(byte[] host) {
        if (this.hosts.length == 1) {
            return this.hosts[0];
        }
        int i = 0;
        while (i < this.hosts.length) {
            if (ByteArrayUtils.equalsIgnoreCase(this.hosts[i].getHostProperties().getHostNameBytes(), host)) {
                return this.hosts[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Host[] getAllHosts() {
        Host[] res = new Host[this.hosts.length];
        int i = 0;
        while (i < res.length) {
            res[i] = this.hosts[i];
            ++i;
        }
        return res;
    }

    /*
     * Loose catch block
     */
    public synchronized void removeHost(String host, boolean inListener) throws ConfigurationException {
        block49: {
            HttpLock httpLock;
            ConfigurationHandler handler;
            block47: {
                Object v1;
                block45: {
                    boolean found = false;
                    int i = 0;
                    while (i < this.hosts.length) {
                        if (this.hosts[i].getHostName().equalsIgnoreCase(host)) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) break block49;
                    Host[] temp = new Host[this.hosts.length - 1];
                    int tempi = 0;
                    int i2 = 0;
                    while (i2 < this.hosts.length) {
                        if (!this.hosts[i2].getHostName().equalsIgnoreCase(host)) {
                            temp[tempi] = this.hosts[i2];
                            ++tempi;
                        }
                        ++i2;
                    }
                    this.hosts = temp;
                    handler = this.factory.getConfigurationHandler();
                    Configuration hostsConfig = null;
                    httpLock = HttpServerFrame.getHttpLock();
                    try {
                        httpLock.enterLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                    }
                    catch (Exception e) {
                        this.log.logError("Cannot get a cluster lock for Http Provider service for storing http virtual hosts settings. Synchronization problems may be caused.", e, null);
                    }
                    try {
                        try {
                            hostsConfig = handler.openConfiguration("HttpHosts", 1);
                        }
                        catch (NameNotFoundException nnfe) {
                            this.log.logError("Cannot remove http virtual host [" + host + "]. Cannot open configuration [" + "HttpHosts" + "].", nnfe, null);
                        }
                        if (hostsConfig.existsSubConfiguration(host)) {
                            hostsConfig.deleteConfiguration(host);
                        }
                        handler.commit();
                        Object var13_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object v0;
                        Object var13_15 = null;
                        try {
                            try {
                                httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                            }
                            catch (Exception e) {
                                this.log.logError("Cannot release a cluster lock for Http Provider service for storing http virtual hosts settings. Synchronization problems may be caused.", e, null);
                            }
                            v0 = null;
                        }
                        catch (Throwable throwable2) {
                            v0 = null;
                        }
                        Object var16_25 = v0;
                        handler.closeAllConfigurations();
                        throw throwable;
                    }
                    try {
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_VIRTUAL_HOSTS_LOCK);
                        }
                        catch (Exception e) {
                            this.log.logError("Cannot release a cluster lock for Http Provider service for storing http virtual hosts settings. Synchronization problems may be caused.", e, null);
                        }
                        v1 = null;
                        break block45;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    {
                    }
                }
                Object var16_24 = v1;
                handler.closeAllConfigurations();
                Configuration configApps = null;
                httpLock = HttpServerFrame.getHttpLock();
                try {
                    httpLock.enterLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e) {
                    this.log.logError("Cannot get a cluster lock for Http Provider service. Possible synchronization problems can occur.", e, null);
                }
                try {
                    configApps = handler.openConfiguration("HttpAliases", 1);
                }
                catch (NameNotFoundException ne) {
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e) {
                        this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e, null);
                    }
                    Object var18_31 = null;
                    try {
                        handler.closeAllConfigurations();
                        Object var20_35 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_36 = null;
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                        }
                        catch (Exception e2) {
                            this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                        }
                        throw throwable;
                    }
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                    }
                    return;
                }
                if (!configApps.existsSubConfiguration(host)) break block47;
                String[] subconfigs = configApps.getSubConfiguration(host).getAllSubConfigurationNames();
                int i22 = 0;
                while (i22 < subconfigs.length) {
                    configApps.getSubConfiguration(host).getSubConfiguration(subconfigs[i22]).deleteAllConfigEntries();
                    configApps.getSubConfiguration(host).deleteConfiguration(subconfigs[i22]);
                    ++i22;
                }
                configApps.getSubConfiguration(host).deleteAllConfigEntries();
                configApps.deleteConfiguration(host);
                handler.commit();
            }
            Object var18_32 = null;
            try {
                handler.closeAllConfigurations();
                Object var20_37 = null;
            }
            catch (Throwable throwable) {
                Object var20_38 = null;
                try {
                    httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e2) {
                    this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                }
                throw throwable;
            }
            try {
                httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
            }
            catch (Exception e2) {
                this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
            }
            break block49;
            {
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.log.logError("Cannot delete http virtual host [" + host + "]. Cannot delete configuration [" + "HttpAliases" + "/" + host + "] or its content.", e, null);
                    Object var18_33 = null;
                    try {
                        handler.closeAllConfigurations();
                        Object var20_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_40 = null;
                        try {
                            httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                        }
                        catch (Exception e2) {
                            this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                        }
                        throw throwable;
                    }
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                    }
                    break block49;
                }
            }
            catch (Throwable throwable) {
                Object var18_34 = null;
                try {
                    handler.closeAllConfigurations();
                    Object var20_41 = null;
                }
                catch (Throwable throwable3) {
                    Object var20_42 = null;
                    try {
                        httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                    }
                    catch (Exception e2) {
                        this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                    }
                    throw throwable3;
                }
                try {
                    httpLock.leaveLockArea(HttpLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (Exception e2) {
                    this.log.logError("Cannot release a cluster lock for Http Provider service. Possible synchronization problems can occur.", e2, null);
                }
                throw throwable;
            }
        }
    }

    public void storeAll() throws ConfigurationException {
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].store();
            ++i;
        }
    }

    public void clearCache() {
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].clearCache();
            ++i;
        }
    }

    public void clearCache(String host) {
        int i = 0;
        while (i < this.hosts.length) {
            if (this.hosts[i].getHostName().equalsIgnoreCase(host)) {
                this.hosts[i].clearCache();
            }
            ++i;
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void addTagAlias(int hashCode, byte[] tagAlias) {
        this.mapHashToMB.put(hashCode, (Object)tagAlias);
    }

    public void removeTagAlias(int hashCode) {
        this.mapHashToMB.remove(hashCode);
    }

    public byte[] getTagAlias(int hashCode) {
        return (byte[])this.mapHashToMB.get(hashCode);
    }

    public byte[][] getAllTagAliases() {
        Object[] temp = this.mapHashToMB.getAllValues();
        byte[][] res = new byte[temp.length][];
        System.arraycopy(temp, 0, res, 0, temp.length);
        return res;
    }

    public void addApplicationAlias(String alias) throws ConfigurationException, IllegalHostArgumentsException {
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].getHostPropertiesModyfier().checkAlias(alias);
            this.hosts[i].getHostPropertiesModyfier().enableApplicationAlias(alias);
            ++i;
        }
    }

    public void checkApplicationAlias(String alias) throws IllegalHostArgumentsException {
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].getHostPropertiesModyfier().checkAlias(alias);
            ++i;
        }
    }

    public void startApplicationAlias(String alias, String filePath) {
        if ("".equals(alias)) {
            return;
        }
        File file = new File(filePath);
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException io) {
            Log.logWarning("Cannot read the root directory [" + filePath + "] of the web application [" + alias + "].", io, null);
        }
        filePath = filePath.replace('/', '/').replace('\\', '/');
        this.applicationAliases.put((Object)alias, (Object)filePath);
        if (Constants.ETAG_INQMY.length + alias.length() <= 32) {
            this.addTagAlias(new MessageBytes(alias.getBytes()).hashCode(), alias.getBytes());
        } else {
            int hash = new MessageBytes(alias.getBytes()).hashCode();
            byte[] aliasb = this.getTagAlias(hash);
            if (aliasb == null) {
                aliasb = new byte[32 - Constants.ETAG_INQMY.length];
                byte[] hashAsBytesString = String.valueOf(hash).getBytes();
                System.arraycopy(alias.getBytes(), 0, aliasb, 0, aliasb.length - hashAsBytesString.length);
                System.arraycopy(hashAsBytesString, 0, aliasb, aliasb.length - hashAsBytesString.length, hashAsBytesString.length);
                this.addTagAlias(hash, aliasb);
            }
        }
    }

    public void notifyStopApplicationAlias(String[] aliases) {
        int i = 0;
        while (i < aliases.length) {
            this.applicationAliases.remove((Object)aliases[i]);
            if ("".equals(aliases[i])) {
                this.removeTagAlias(new MessageBytes("default".getBytes()).hashCode());
            } else {
                this.removeTagAlias(new MessageBytes(aliases[i].getBytes()).hashCode());
            }
            ++i;
        }
    }

    public void removeApplicationAlias(String alias) throws ConfigurationException {
        this.applicationAliases.remove((Object)alias);
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].getHostPropertiesModyfier().removeApplicationAlias(alias);
            ++i;
        }
    }

    public void changeHttpRoot(String newRoot) throws IOException, ConfigurationException {
        int i = 0;
        while (i < this.hosts.length) {
            this.hosts[i].getHostPropertiesModyfier().setRootDir(newRoot);
            ++i;
        }
    }
}

