/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.server.Client;
import com.sap.engine.services.httpserver.server.Constants;
import java.io.File;
import java.io.IOException;

public class HttpFile {
    private Client client = null;
    private Request request = null;
    private String fileNameCannonical = null;
    private byte[] fileNameCannonicalBytes = null;
    private String ioFileNameCannonical = null;
    private byte[] ioFileNameCannonicalBytes = null;
    private File file = null;
    private boolean exists = false;
    private boolean existsParsed = false;
    private boolean isDirectory = false;
    private boolean isDirectoryParsed = false;
    private byte[] rootDirectory = null;

    public void init(Client client) {
        this.client = client;
        this.request = client.getRequest();
        this.init();
    }

    public void init() {
        this.fileNameCannonical = null;
        this.fileNameCannonicalBytes = null;
        this.ioFileNameCannonical = null;
        this.ioFileNameCannonicalBytes = null;
        this.file = null;
        this.exists = false;
        this.existsParsed = false;
        this.isDirectory = false;
        this.isDirectoryParsed = false;
        this.rootDirectory = null;
    }

    public String getFileNameCannonical() {
        return this.fileNameCannonical;
    }

    public byte[] getFileNameCannonicalBytes() {
        return this.fileNameCannonicalBytes;
    }

    public String getIOFileNameCannonical() {
        return this.ioFileNameCannonical;
    }

    public byte[] getIOFileNameCannonicalBytes() {
        return this.ioFileNameCannonicalBytes;
    }

    public boolean exists() {
        if (!this.existsParsed) {
            this.existsParsed = true;
            this.exists = this.file.exists();
        }
        return this.exists;
    }

    public boolean isDirectory() {
        if (!this.isDirectoryParsed) {
            this.isDirectoryParsed = true;
            this.isDirectory = this.file.isDirectory();
        }
        return this.isDirectory;
    }

    protected void initFile() throws IOException {
        this.fileNameCannonical = this.request.getRequestLine().isEncoded() ? this.client.getRequestAnalizer().getFilename1().toStringUTF8() : this.client.getRequestAnalizer().getFilename1().toString();
        this.fileNameCannonical = ParseUtils.canonicalize(this.fileNameCannonical);
        if (this.fileNameCannonical.endsWith(":")) {
            this.fileNameCannonical = this.fileNameCannonical + File.separator;
        }
        this.fileNameCannonicalBytes = ParseUtils.separatorsToFS(this.fileNameCannonical);
        this.fileNameCannonical = new String(this.fileNameCannonicalBytes);
        this.file = new File(this.fileNameCannonical);
        this.ioFileNameCannonical = this.file.getCanonicalPath();
        this.ioFileNameCannonicalBytes = ParseUtils.separatorsToFS(this.ioFileNameCannonical);
        this.ioFileNameCannonical = new String(this.ioFileNameCannonicalBytes);
    }

    protected boolean requestMathesFileName() {
        return this.exists() && ByteArrayUtils.equalsBytes(this.fileNameCannonicalBytes, this.ioFileNameCannonicalBytes);
    }

    protected void setRootDirectory(byte[] rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    protected boolean isInRootDirectory() {
        return ByteArrayUtils.startsWith(this.ioFileNameCannonicalBytes, this.rootDirectory);
    }

    protected boolean isInWebForbiddenDirs() {
        return ByteArrayUtils.startsWithIgnoreCase(this.ioFileNameCannonicalBytes, (new String(this.rootDirectory) + '/' + "web-inf").getBytes()) || ByteArrayUtils.startsWithIgnoreCase(this.ioFileNameCannonicalBytes, (new String(this.rootDirectory) + '/' + "meta-inf").getBytes());
    }

    protected boolean hasForbiddenExtension() {
        return ByteArrayUtils.endsWithIgnoreCase(this.ioFileNameCannonicalBytes, Constants.jspExtension);
    }
}

