/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.properties.HttpCompressedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;

public class GzipCompression {
    private String workDir = null;
    private String zipFileName = null;
    private static HttpCompressedProperties compressedProperties = null;

    public GzipCompression(String workDir, HttpCompressedProperties props) {
        this.workDir = workDir;
        compressedProperties = props;
    }

    public void init() {
        this.zipFileName = null;
    }

    public String getFileName() {
        return this.zipFileName;
    }

    public RandomAccessFile compressFile(String host, String fileName, File sourceFile, MimeHeaders headers) throws IOException {
        this.zipFileName = (this.workDir + File.separator + host + File.separator + fileName).replace('/', File.separatorChar);
        if (this.zipFileName.endsWith(File.separator)) {
            this.zipFileName = this.zipFileName + sourceFile.getName();
        }
        this.zipFileName = this.zipFileName + ".gzip";
        RandomAccessFile r = null;
        GzipCompression gzipCompression = this;
        synchronized (gzipCompression) {
            File compressedFile = new File(this.zipFileName);
            if (!compressedFile.exists() || sourceFile.lastModified() != compressedFile.lastModified()) {
                GzipCompression.compress(sourceFile, this.zipFileName);
            }
        }
        try {
            r = new RandomAccessFile(this.zipFileName, "r");
            headers.putIntHeader(HeaderNames.entity_header_content_length_, (int)r.length());
            headers.addHeader(HeaderNames.entity_header_content_encoding_, HeaderValues.gzip_);
        }
        catch (IOException ex) {
            throw new HttpIOException("http_0053", new Object[]{this.zipFileName});
        }
        return r;
    }

    public RandomAccessFile compressFile(String host, String fileName, File sourceFile, MimeHeaders headers, HashMapObjectObject translationTable) throws IOException {
        String infoFileName = null;
        String realZipFileName = (this.workDir + File.separator + host + File.separator + fileName).replace('/', File.separatorChar);
        if (realZipFileName.endsWith(File.separator)) {
            realZipFileName = realZipFileName + sourceFile.getName();
        }
        realZipFileName = realZipFileName + ".gzip";
        this.zipFileName = (String)translationTable.get((Object)realZipFileName);
        if (this.zipFileName == null) {
            this.zipFileName = fileName;
            if (this.zipFileName.endsWith(File.separator)) {
                this.zipFileName = this.zipFileName + sourceFile.getName();
            }
            this.zipFileName = this.zipFileName.hashCode() + "";
            this.zipFileName = (this.workDir + File.separator + host + File.separator + this.zipFileName).replace('/', File.separatorChar);
            this.zipFileName = this.zipFileName + ".gzip";
        }
        infoFileName = this.zipFileName + ".txt";
        RandomAccessFile r = null;
        GzipCompression gzipCompression = this;
        synchronized (gzipCompression) {
            File compressedFile = new File(this.zipFileName);
            if (!compressedFile.exists() || sourceFile.lastModified() != compressedFile.lastModified()) {
                GzipCompression.compress(sourceFile, this.zipFileName);
            } else {
                BufferedReader br;
                String info;
                File infoFile = new File(infoFileName);
                if (infoFile.exists() && !(info = (br = new BufferedReader(new FileReader(infoFile))).readLine()).equals(realZipFileName)) {
                    GzipCompression.compress(sourceFile, this.zipFileName);
                }
            }
        }
        try {
            r = new RandomAccessFile(this.zipFileName, "r");
            headers.putIntHeader(HeaderNames.entity_header_content_length_, (int)r.length());
            headers.addHeader(HeaderNames.entity_header_content_encoding_, HeaderValues.gzip_);
            translationTable.put((Object)realZipFileName, (Object)this.zipFileName);
        }
        catch (IOException ex) {
            throw new HttpIOException("http_0053", new Object[]{this.zipFileName});
        }
        try {
            FileOutputStream fos = new FileOutputStream(infoFileName);
            fos.write(realZipFileName.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            Log.logWarning("Cannot write info file for compressed resource [" + realZipFileName + "].", ioe, null);
        }
        return r;
    }

    private static void compress(File f, String newFileName) throws IOException {
        String fileName = f.getAbsolutePath().replace('/', '/').replace('\\', '/');
        FileInputStream fInStream = new FileInputStream(fileName);
        new File(newFileName.substring(0, newFileName.lastIndexOf(File.separator))).mkdirs();
        FilterOutputStream gzipOutStream = GzipCompression.getZipStream(newFileName);
        byte[] buffer = new byte[1024];
        int readed = fInStream.read(buffer, 0, buffer.length);
        while (readed != -1) {
            gzipOutStream.write(buffer, 0, readed);
            readed = fInStream.read(buffer, 0, buffer.length);
        }
        gzipOutStream.flush();
        gzipOutStream.close();
        fInStream.close();
        new File(newFileName).setLastModified(f.lastModified());
    }

    private static FilterOutputStream getZipStream(String newFileName) throws IOException {
        FilterOutputStream gzipstream = null;
        FileOutputStream outputStream = new FileOutputStream(newFileName, false);
        if (compressedProperties.getGZipImpConstructor() == null) {
            gzipstream = new GZIPOutputStream(outputStream);
        } else {
            try {
                gzipstream = (FilterOutputStream)compressedProperties.getGZipImpConstructor().newInstance(outputStream);
            }
            catch (Exception e) {
                Log.logWarning("Cannot instantiate GZIP implementation class [" + compressedProperties.getGZipImplementation() + "].", e, null);
                gzipstream = new GZIPOutputStream(outputStream);
            }
        }
        return gzipstream;
    }
}

