/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationSessionContext;
import com.sap.engine.library.bytecode.tracing.Tracer;
import com.sap.engine.services.httpserver.DSRHttpRequestContext;
import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.server.DSRHttpRequestContextImpl;
import com.sap.engine.services.httpserver.server.HttpHosts;
import com.sap.engine.services.httpserver.server.HttpProviderImpl;
import com.sap.engine.services.httpserver.server.Log;
import com.sap.engine.services.httpserver.server.Processor;
import com.sap.engine.services.httpserver.server.RequestAnalizer;
import com.sap.engine.services.httpserver.server.ResponseImpl;
import com.sap.engine.services.httpserver.server.SslAttributesImpl;
import com.sap.engine.services.httpserver.server.hosts.Host;
import com.sap.engine.services.httpserver.server.properties.HttpProperties;

public class Client {
    private ApplicationServiceContext ctx = null;
    private ApplicationSessionContext sc = null;
    private HttpProviderImpl httpProvider = null;
    private String serviceWorkDir = null;
    private HttpProperties httpProperties = null;
    private HttpHosts httpHosts = null;
    private Log log = null;
    private RequestAnalizer request = null;
    private ResponseImpl response = null;
    private DSRHttpRequestContextImpl dsrHttpRequestContext;
    private int dispatcher_id = -1;
    private int client_id = -1;
    private byte[] clientIP = new byte[4];
    private int port = -1;
    private static final long serialVersionUID = 7266188949066616635L;
    private static transient /* synthetic */ int t$classId;

    public Client() {
        this.ctx = Processor.getApplicationServiceContext();
        this.sc = Processor.getApplicationSessionContext();
        this.httpProperties = Processor.getHttpProperties();
        this.log = Processor.getLog();
        this.serviceWorkDir = this.ctx.getServiceState().getWorkingDirectoryName();
        this.request = new RequestAnalizer(this);
        this.response = new ResponseImpl(this, this.log);
        this.httpHosts = Processor.getHttpHosts();
        this.httpProvider = Processor.getHttpProvider();
    }

    public void initClientIP(byte[] request, int offset, int length) {
        System.arraycopy(request, offset + length - 4, this.clientIP, 0, 4);
    }

    public void init(int port, int dispatcher_id, int client_id, boolean isICM, boolean isSsl, SslAttributesImpl sslAttributes) {
        this.dispatcher_id = dispatcher_id;
        this.client_id = client_id;
        this.port = port;
        this.request.init(isICM, sslAttributes, isSsl);
        this.dsrHttpRequestContext = null;
    }

    public HttpProperties getHttpProperties() {
        return this.httpProperties;
    }

    public HttpProviderImpl getHttpProvider() {
        return this.httpProvider;
    }

    public Log getLog() {
        return this.log;
    }

    public Host getHost(byte[] hostName) {
        return this.httpHosts.getHost(hostName);
    }

    public boolean initialize(byte[] input, int offset, int length) {
        return this.request.initialize(input, offset, length);
    }

    /*
     * WARNING - void declaration
     */
    public void handle() {
        Tracer.methodStart((int)t$classId, (int)0, (Object)this, (Object[])Tracer.OBJECT_ARRAY_0);
        try {
            this.request.handle();
            Object t$returned = null;
            Tracer.methodEnd((int)t$classId, (int)0, t$returned, null);
            return;
        }
        catch (Throwable t$throwable) {
            void var1_2;
            Tracer.methodEnd((int)t$classId, (int)0, null, (Throwable)t$throwable);
            throw var1_2;
        }
    }

    public void finish() {
        this.request.recycle();
        this.response.recycle();
    }

    public DSRHttpRequestContext getDsrHttpRequestContext() {
        if (this.dsrHttpRequestContext == null) {
            this.dsrHttpRequestContext = new DSRHttpRequestContextImpl();
            this.dsrHttpRequestContext.init(this.getRequest());
        }
        return this.dsrHttpRequestContext;
    }

    public int getClientId() {
        return this.client_id;
    }

    public int getDispatcherId() {
        return this.dispatcher_id;
    }

    public byte[] getIP() {
        return this.clientIP;
    }

    public int getPort() {
        return this.port;
    }

    public RequestAnalizer getRequestAnalizer() {
        return this.request;
    }

    public Request getRequest() {
        return this.request.getRequest();
    }

    public ResponseImpl getResponse() {
        return this.response;
    }

    public void send(byte[] msg, int off, int len, byte connectionFlag) {
        if ((connectionFlag & 1) == 1 || (connectionFlag & 2) == 2) {
            Processor.connectionInfoHash.remove(this.client_id);
        }
        try {
            this.sc.getConnection().send(this.dispatcher_id, this.client_id, msg, off, len, connectionFlag);
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void send(byte[] msg, int off, int len) {
        try {
            this.sc.getConnection().send(this.dispatcher_id, this.client_id, msg, off, len);
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void sendPart(byte[] msg, int off, int len, byte connectionFlag) {
        try {
            this.sc.getConnection().sendPart(this.dispatcher_id, this.client_id, msg, off, len, connectionFlag);
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void sendPart(byte[] msg, int off, int len) {
        try {
            this.sc.getConnection().sendPart(this.dispatcher_id, this.client_id, msg, off, len);
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void sendStartReadCallback() {
        try {
            this.sc.getConnection().send(this.dispatcher_id, this.client_id, new byte[0], 0, 0, (byte)16);
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public ClusterElement[] getClusterElements() {
        return this.ctx.getClusterContext().getClusterMonitor().getParticipants();
    }

    public ClusterElement getCurrentClusterElement() {
        return this.ctx.getClusterContext().getClusterMonitor().getCurrentParticipant();
    }

    public String getHostName(int clusterId) {
        ClusterElement clusterElement = this.ctx.getClusterContext().getClusterMonitor().getParticipant(clusterId);
        if (clusterElement == null) {
            return null;
        }
        return clusterElement.getAddress().getHostName();
    }

    public String getWorkingDir() {
        return this.serviceWorkDir;
    }

    static {
        t$classId = Tracer.register(Class.forName("com.sap.engine.services.httpserver.server.Client"), (String)"com.sap.engine.services.httpserver.server.Client", (String[])new String[]{"handle"}, (String[])new String[]{"()V"});
    }
}

