/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.util;

import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MessageBytes
extends Ascii {
    private byte[] bytes = null;
    private int offset = -1;
    private int length = -1;

    public MessageBytes() {
        this.bytes = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public MessageBytes(byte[] byteArray) {
        if (byteArray == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"MessageBytes", "" + byteArray});
        }
        this.setBytes(byteArray, 0, byteArray.length);
    }

    public MessageBytes(byte[] byteArray, int i, int j) {
        if (byteArray == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"MessageBytes", "" + byteArray});
        }
        this.setBytes(byteArray, i, j);
    }

    public void reset() {
        this.offset = 0;
        this.length = 0;
    }

    public void setBytes(byte[] byteArray, int i, int j) {
        this.bytes = byteArray;
        this.offset = i;
        this.length = j;
    }

    public void setBytes(byte[] byteArray) {
        this.setBytes(byteArray, 0, byteArray.length);
    }

    public void incOffset(int inc) {
        if (inc < 0 || inc > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"setLength", "" + this.length});
        }
        this.offset += inc;
        this.length -= inc;
    }

    public void setLength(int length) {
        if (length < 0 || length > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"setLength", "" + length});
        }
        this.length = length;
    }

    public byte[] getBytes() {
        byte[] res = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, res, 0, this.length);
        return res;
    }

    public int getBytes(byte[] toByteArr, int off) {
        if (toByteArr == null || toByteArr.length < off) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"getBytes", "" + toByteArr + ", " + off});
        }
        if (toByteArr.length - off < this.length) {
            System.arraycopy(this.bytes, this.offset, toByteArr, off, toByteArr.length - off);
            return toByteArr.length - off;
        }
        System.arraycopy(this.bytes, this.offset, toByteArr, off, this.length);
        return this.length;
    }

    public byte[] getBytes(int off, int len) {
        if (off < 0 || len < 0 || off + len > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"getBytes", "" + off + ", " + len});
        }
        byte[] res = new byte[len];
        System.arraycopy(this.bytes, this.offset + off, res, 0, len);
        return res;
    }

    public byte[] getBytes(int off) {
        if (off < 0 || off > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"getBytes", "" + off});
        }
        byte[] res = new byte[this.length - off];
        System.arraycopy(this.bytes, this.offset + off, res, 0, res.length);
        return res;
    }

    public void appendAfter(byte[] newBytes) {
        if (newBytes == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"appendAfter", "" + newBytes});
        }
        byte[] newByteArr = new byte[this.length + newBytes.length];
        System.arraycopy(this.bytes, this.offset, newByteArr, 0, this.length);
        System.arraycopy(newBytes, 0, newByteArr, this.length, newBytes.length);
        this.bytes = newByteArr;
        this.offset = 0;
        this.length = newByteArr.length;
    }

    public void appendBefore(byte[] newBytes) {
        if (newBytes == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"appendBefore", "" + newBytes});
        }
        byte[] newByteArr = new byte[this.length + newBytes.length];
        System.arraycopy(newBytes, 0, newByteArr, 0, newBytes.length);
        System.arraycopy(this.bytes, this.offset, newByteArr, newBytes.length, this.length);
        this.bytes = newByteArr;
        this.offset = 0;
        this.length = newByteArr.length;
    }

    public void deleteByteAt(int off) {
        if (off < 0 || off > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"deleteByteAt", "" + off});
        }
        int i = this.offset + off + 1;
        while (i < this.length) {
            this.bytes[i - 1] = this.bytes[i];
            ++i;
        }
        --this.length;
    }

    public byte[] addByteAtBeginAndEnd(byte b1, byte b2) {
        byte[] newByteArr = new byte[this.length + 2];
        newByteArr[0] = b1;
        System.arraycopy(this.bytes, this.offset, newByteArr, 1, this.length);
        newByteArr[this.length + 1] = b2;
        return newByteArr;
    }

    public String toString() {
        char[] res = new char[this.length];
        int i = 0;
        while (i < this.length) {
            res[i] = (char)(this.bytes[this.offset + i] & 0xFF);
            ++i;
        }
        return new String(res);
    }

    /*
     * Unable to fully structure code
     */
    public String toStringUTF8() {
        try {
            return new String(this.bytes, this.offset, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            res = new char[this.length];
            i = 0;
            ** while (i < this.length)
        }
lbl-1000:
        // 1 sources

        {
            res[i] = (char)(this.bytes[this.offset + i] & 255);
            ++i;
            continue;
        }
lbl10:
        // 1 sources

        return new String(res);
    }

    public String toString(int off) {
        if (off < 0 || off > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"toString", "" + off});
        }
        char[] res = new char[this.length - off];
        int i = 0;
        while (i < this.length - off) {
            res[i] = (char)(this.bytes[this.offset + off + i] & 0xFF);
            ++i;
        }
        return new String(res);
    }

    /*
     * Unable to fully structure code
     */
    public String toStringUTF8(int off) {
        if (off < 0 || off > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"toStringUTF8", "" + off});
        }
        try {
            return new String(this.bytes, this.offset + off, this.length - off, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            res = new char[this.length - off];
            i = 0;
            ** while (i < this.length - off)
        }
lbl-1000:
        // 1 sources

        {
            res[i] = (char)(this.bytes[this.offset + off + i] & 255);
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        return new String(res);
    }

    public int toInteger() throws NumberFormatException {
        return Ascii.asciiArrToInt(this.bytes, this.offset, this.length);
    }

    public boolean equalsIgnoreCase(String s) {
        if (s == null || this.length != s.length()) {
            return false;
        }
        int k = 0;
        while (k < this.length) {
            if (Ascii.toLower(this.bytes[this.offset + k]) != Ascii.toLower((byte)s.charAt(k))) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean equals(byte[] byteArr) {
        if (byteArr == null || this.length != byteArr.length) {
            return false;
        }
        int k = 0;
        while (k < this.length) {
            if (this.bytes[this.offset + k] != byteArr[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] byteArr, int off, int len) {
        if (off < 0 || len < 0 || byteArr == null || off + len > byteArr.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"equalsIgnoreCase", "" + byteArr + ", " + off + ", " + len});
        }
        if (this.length != len) {
            return false;
        }
        int k = 0;
        while (k < this.length) {
            if (Ascii.toLower(this.bytes[this.offset + k]) != Ascii.toLower(byteArr[off + k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean startsWith(String s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"startsWith", "" + s});
        }
        int sLen = s.length();
        if (sLen > this.length) {
            return false;
        }
        int k = 0;
        while (k < sLen) {
            if (this.bytes[this.offset + k] != s.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean startsWith(MessageBytes s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"startsWith", "" + s});
        }
        int sLen = s.length();
        if (sLen > this.length) {
            return false;
        }
        int k = 0;
        while (k < sLen) {
            if (this.bytes[this.offset + k] != s.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"startsWithIgnoreCase", "" + s});
        }
        int sLen = s.length();
        if (sLen > this.length) {
            return false;
        }
        int k = 0;
        while (k < sLen) {
            if (Ascii.toLower(this.bytes[this.offset + k]) != Ascii.toLower(s.charAt(k))) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(byte[] s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"startsWithIgnoreCase", "" + s});
        }
        if (s.length > this.length) {
            return false;
        }
        int k = 0;
        while (k < s.length) {
            if (Ascii.toLower(this.bytes[this.offset + k]) != Ascii.toLower(s[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public int indexOf(String s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"indexOf", "" + s});
        }
        int k = this.offset;
        while (k < this.length + this.offset) {
            if (s.charAt(0) == this.bytes[k]) {
                int j = 1;
                while (j < s.length() && j + k < this.length) {
                    if (s.charAt(j) != this.bytes[k + j]) break;
                    ++j;
                }
                if (j == s.length()) {
                    return k - this.offset;
                }
            }
            ++k;
        }
        return -1;
    }

    public int indexOf(String s, int fromIndex) {
        if (s == null || fromIndex > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"indexOf", "" + s + ", " + fromIndex});
        }
        int k = fromIndex + this.offset;
        while (k < this.length + this.offset) {
            if (s.charAt(0) == this.bytes[k]) {
                int j = 1;
                while (j < s.length() && j + k < this.length) {
                    if (s.charAt(j) != this.bytes[k + j]) break;
                    ++j;
                }
                if (j == s.length()) {
                    return k - this.offset;
                }
            }
            ++k;
        }
        return -1;
    }

    public int indexOf(byte[] sbyte) {
        if (sbyte == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"indexOf", "" + sbyte});
        }
        int k = this.offset;
        while (k < this.length + this.offset) {
            if (sbyte[0] == this.bytes[k]) {
                int j = 1;
                while (j < sbyte.length && j + k < this.length) {
                    if (sbyte[j] != this.bytes[k + j]) break;
                    ++j;
                }
                if (j == sbyte.length) {
                    return k - this.offset;
                }
            }
            ++k;
        }
        return -1;
    }

    public int indexOf(char ch) {
        int k = this.offset;
        while (k < this.length + this.offset) {
            if (this.bytes[k] == ch) {
                return k - this.offset;
            }
            ++k;
        }
        return -1;
    }

    public int indexOf(char ch, int off) {
        if (off > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"indexOf", "" + ch + ", " + off});
        }
        int k = off + this.offset;
        while (k < this.length + this.offset) {
            if (this.bytes[k] == ch) {
                return k - this.offset;
            }
            ++k;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        int k = this.length + this.offset - 1;
        while (k >= this.offset) {
            if (this.bytes[k] == ch) {
                return k - this.offset;
            }
            --k;
        }
        return -1;
    }

    public int lastIndexOf(byte b) {
        int k = this.length + this.offset - 1;
        while (k >= this.offset) {
            if (this.bytes[k] == b) {
                return k - this.offset;
            }
            --k;
        }
        return -1;
    }

    public char charAt(int i) {
        if (i > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"charAt", "" + i});
        }
        return (char)this.bytes[this.offset + i];
    }

    public void write(OutputStream outputstream) throws IOException {
        outputstream.write(this.bytes, this.offset, this.length);
    }

    public int length() {
        return this.length;
    }

    public void replace(byte first, byte second) {
        int i = this.offset;
        while (i < this.length + this.offset) {
            if (this.bytes[i] == first) {
                this.bytes[i] = second;
            }
            ++i;
        }
    }

    public void replace(byte first, byte second, int off, int len) {
        if (off < 0 || len < 0 || off + len > this.length) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"replace", "" + first + ", " + second + ", " + off + ", " + len});
        }
        int i = this.offset;
        while (i < len + this.offset) {
            if (this.bytes[i] == first) {
                this.bytes[i] = second;
            }
            ++i;
        }
    }

    public boolean endsWith(String s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"endsWith", "" + s});
        }
        int sLen = s.length();
        if (sLen > this.length) {
            return false;
        }
        int endOffset = this.offset + this.length - sLen;
        int k = 0;
        while (k < sLen) {
            if (this.bytes[endOffset + k] != s.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean endsWith(byte[] s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"endsWith", "" + s});
        }
        int sLen = s.length;
        if (sLen > this.length) {
            return false;
        }
        int endOffset = this.offset + this.length - sLen;
        int k = 0;
        while (k < sLen) {
            if (this.bytes[endOffset + k] != s[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean endsWith(byte b) {
        if (this.length == 0) {
            return false;
        }
        return this.bytes[this.offset + this.length - 1] == b;
    }

    public boolean endsWithIgnoreCase(byte[] s) {
        if (s == null) {
            throw new HttpIllegalArgumentException("http_0051", new Object[]{"endsWithIgnoreCase", "" + s});
        }
        int sLen = s.length;
        if (sLen > this.length) {
            return false;
        }
        int endOffset = this.offset + this.length - sLen;
        int k = 0;
        while (k < sLen) {
            if (Ascii.toLower(this.bytes[endOffset + k]) != Ascii.toLower(s[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        if (this.bytes != null) {
            int i = this.offset;
            while (i < this.offset + this.length) {
                hash += (hash << 13) + (this.bytes[i] & 0xFF);
                ++i;
            }
        }
        return hash;
    }

    public boolean equals(MessageBytes s) {
        if (s == null || this.length != s.length()) {
            return false;
        }
        int k = 0;
        while (k < this.length) {
            if (this.bytes[this.offset + k] != s.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean equals(String s) {
        if (s == null || this.length != s.length()) {
            return false;
        }
        int k = 0;
        while (k < this.length) {
            if (this.bytes[this.offset + k] != s.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageBytes) {
            return this.equals((MessageBytes)obj);
        }
        if (obj instanceof String) {
            return this.equals((String)obj);
        }
        return false;
    }
}

