/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.util;

public class HexPrinter {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return "";
        }
        short address = 0;
        StringBuffer sb = new StringBuffer();
        HexPrinter.appendHex(sb, address);
        sb.append(": ");
        int i = offset;
        int j = offset;
        int end = offset + length;
        int lineEnd = offset + 16;
        while (i < end) {
            if (i == lineEnd) {
                sb.append("| ");
                while (j < lineEnd) {
                    HexPrinter.appendAscii(sb, bytes[j]);
                    ++j;
                }
                sb.append("\r\n");
                HexPrinter.appendHex(sb, address);
                sb.append(": ");
                lineEnd += 16;
                address = (short)(address + 16);
            }
            HexPrinter.appendHex(sb, bytes[i]);
            sb.append(" ");
            ++i;
        }
        while (i < lineEnd) {
            sb.append("   ");
            ++i;
        }
        sb.append("| ");
        while (j < end) {
            HexPrinter.appendAscii(sb, bytes[j]);
            ++j;
        }
        return sb.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(hexChars[(b & 0xF0) >>> 4]);
        sb.append(hexChars[b & 0xF]);
    }

    private static void appendHex(StringBuffer sb, short s) {
        sb.append(hexChars[(s & 0xF000) >>> 12]);
        sb.append(hexChars[(s & 0xF00) >>> 8]);
        sb.append(hexChars[(s & 0xF0) >>> 4]);
        sb.append(hexChars[s & 0xF]);
    }

    private static void appendAscii(StringBuffer sb, byte b) {
        if (32 <= b && b <= 127) {
            sb.append((char)b);
        } else {
            sb.append('.');
        }
    }
}

