/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.util;

import com.sap.engine.services.httpserver.lib.util.Ascii;

public class ByteArrayUtils {
    public static byte[] append(byte[] first, byte[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        byte[] newByteArr = new byte[first.length + second.length];
        System.arraycopy(first, 0, newByteArr, 0, first.length);
        System.arraycopy(second, 0, newByteArr, first.length, second.length);
        return newByteArr;
    }

    public static boolean startsWith(byte[] arr, byte[] prefix) {
        if (arr == null) {
            return false;
        }
        return ByteArrayUtils.startsWith(arr, 0, arr.length, prefix);
    }

    public static boolean startsWith(byte[] arr, int off, int len, byte[] prefix) {
        if (arr == null || prefix == null) {
            return false;
        }
        if (prefix.length > len) {
            return false;
        }
        int i = 1;
        while (i < prefix.length) {
            if (prefix[i] != arr[off + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(byte[] arr, byte[] prefix) {
        if (arr == null) {
            return false;
        }
        return ByteArrayUtils.startsWithIgnoreCase(arr, 0, arr.length, prefix);
    }

    public static boolean startsWithIgnoreCase(byte[] arr, int off, int len, byte[] prefix) {
        if (arr == null || prefix == null) {
            return false;
        }
        if (prefix.length > len) {
            return false;
        }
        int i = 1;
        while (i < prefix.length) {
            if (Ascii.toLower(prefix[i]) != Ascii.toLower(arr[off + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(byte[] arr, byte[] toend) {
        if (arr == null || toend == null) {
            return false;
        }
        if (toend.length > arr.length) {
            return false;
        }
        int toendLen = toend.length;
        int arrLen = arr.length;
        int i = 1;
        while (i < toendLen + 1) {
            if (toend[toendLen - i] != arr[arrLen - i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(byte[] arr, byte[] toend) {
        if (arr == null || toend == null) {
            return false;
        }
        if (toend.length > arr.length) {
            return false;
        }
        int toendLen = toend.length;
        int arrLen = arr.length;
        int i = 1;
        while (i < toendLen + 1) {
            if (Ascii.toLower(toend[toendLen - i]) != Ascii.toLower(arr[arrLen - i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsBytes(byte[] abyte0, byte[] abyte1) {
        if (abyte0 == null || abyte1 == null || abyte0.length != abyte1.length) {
            return false;
        }
        int i = -1;
        while (++i < abyte0.length) {
            if (abyte0[i] == abyte1[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsBytes(byte[] abyte0, int off, int len, byte[] abyte1) {
        if (abyte0 == null || abyte1 == null || len != abyte1.length) {
            return false;
        }
        int i = -1;
        while (++i < len) {
            if (abyte0[off + i] == abyte1[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equalsIgnoreCase(byte[] first, byte[] sec) {
        i = -1;
        if (first != null && sec != null && (i = first.length) == sec.length) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Ascii.toLower(first[i]) == Ascii.toLower(sec[i])) continue;
            return false;
lbl6:
            // 2 sources

            ** while (--i >= 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equalsIgnoreCaseAndTrim(byte[] first, byte[] sec) {
        if (first == null || sec == null) {
            return false;
        }
        i = 0;
        while (i < first.length && Ascii.isWhite(first[i])) {
            ++i;
        }
        off = i;
        if (first.length - off <= 0 || first.length < sec.length) {
            return false;
        }
        i = 0;
        while (i < sec.length) {
            if (Ascii.toLower(first[off + i]) != Ascii.toLower(sec[i])) {
                return false;
            }
            ++i;
        }
        if (i != sec.length) ** GOTO lbl21
        return true;
lbl-1000:
        // 1 sources

        {
            if (!Ascii.isWhite(first[i])) {
                return false;
            }
            ++i;
lbl21:
            // 2 sources

            ** while (i < first.length)
        }
lbl22:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equalsIgnoreCase(byte[] first, int off, int len, byte[] sec) {
        i = -1;
        if (first != null && sec != null && (i = len) == sec.length) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Ascii.toLower(first[off + i]) == Ascii.toLower(sec[i])) continue;
            return false;
lbl6:
            // 2 sources

            ** while (--i >= 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equalsIgnoreCaseAndTrim(byte[] first, int off, int len, byte[] sec) {
        if (first == null || sec == null) {
            return false;
        }
        i = 0;
        while (i < len && Ascii.isWhite(first[off + i])) {
            ++i;
        }
        off += i;
        if ((len -= i) <= 0 || len < sec.length) {
            return false;
        }
        i = 0;
        while (i < sec.length) {
            if (Ascii.toLower(first[off + i]) != Ascii.toLower(sec[i])) {
                return false;
            }
            ++i;
        }
        if (i != sec.length) ** GOTO lbl21
        return true;
lbl-1000:
        // 1 sources

        {
            if (!Ascii.isWhite(first[off + i])) {
                return false;
            }
            ++i;
lbl21:
            // 2 sources

            ** while (i < len)
        }
lbl22:
        // 1 sources

        return true;
    }

    public static int indexOf(byte[] array, byte toSearch) {
        if (array == null) {
            return -1;
        }
        int k = 0;
        while (k < array.length) {
            if (array[k] == toSearch) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int off, int len, byte toSearch) {
        if (array == null) {
            return -1;
        }
        int k = off;
        while (k < off + len) {
            if (array[k] == toSearch) {
                return k - off;
            }
            ++k;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] toSearch) {
        if (array == null || toSearch == null) {
            return -1;
        }
        int arrayLen = array.length;
        int toSearchLen = toSearch.length;
        if (arrayLen < toSearchLen) {
            return -1;
        }
        int k = 0;
        while (k < arrayLen - toSearchLen + 1) {
            if (toSearch[0] == array[k]) {
                int j = 1;
                while (j < toSearch.length) {
                    if (toSearch[j] != array[k + j]) break;
                    ++j;
                }
                if (j == toSearchLen) {
                    return k;
                }
            }
            ++k;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int off, int len, byte[] toSearch) {
        if (array == null || toSearch == null || toSearch.length > len) {
            return -1;
        }
        int toSearchLen = toSearch.length;
        int k = 0;
        while (k < len - toSearchLen + 1) {
            if (toSearch[0] == array[off + k]) {
                int j = 1;
                while (j < toSearch.length) {
                    if (toSearch[j] != array[off + k + j]) break;
                    ++j;
                }
                if (j == toSearchLen) {
                    return k;
                }
            }
            ++k;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte toSearch, int fromIndex) {
        if (array == null || fromIndex >= array.length) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int k = fromIndex;
        while (k < array.length) {
            if (toSearch == array[k]) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(byte[] array, int offset, int length, byte[] toSearch) {
        if (array == null || toSearch == null) {
            return -1;
        }
        int arrayLen = length;
        int toSearchLen = toSearch.length;
        if (arrayLen < toSearchLen) {
            return -1;
        }
        int k = offset;
        while (k < arrayLen - toSearchLen + 1) {
            if (Ascii.toLower(toSearch[0]) == Ascii.toLower(array[k])) {
                int j = 1;
                while (j < toSearch.length) {
                    if (Ascii.toLower(toSearch[j]) != Ascii.toLower(array[k + j])) break;
                    ++j;
                }
                if (j == toSearchLen) {
                    return k - offset;
                }
            }
            ++k;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(byte[] array, byte[] toSearch) {
        if (array == null || toSearch == null) {
            return -1;
        }
        int arrayLen = array.length;
        int toSearchLen = toSearch.length;
        if (arrayLen < toSearchLen) {
            return -1;
        }
        int k = 0;
        while (k < arrayLen - toSearchLen + 1) {
            if (Ascii.toLower(toSearch[0]) == Ascii.toLower(array[k])) {
                int j = 1;
                while (j < toSearch.length) {
                    if (Ascii.toLower(toSearch[j]) != Ascii.toLower(array[k + j])) break;
                    ++j;
                }
                if (j == toSearchLen) {
                    return k;
                }
            }
            ++k;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] arr, int len, byte toSearch) {
        if (arr == null) {
            return -1;
        }
        int i = len - 1;
        while (i >= 0) {
            if (arr[i] == toSearch) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static byte[] trim(byte[] array) {
        int len;
        if (array == null) {
            return null;
        }
        int st = 0;
        int all = len = array.length;
        while (st < len && array[st] <= 32) {
            ++st;
        }
        while (st < len && array[len - 1] <= 32) {
            --len;
        }
        if (st > 0 || len < all) {
            byte[] newArray = new byte[len - st];
            System.arraycopy(array, st, newArray, 0, newArray.length);
            return newArray;
        }
        return array;
    }

    public static void replace(byte[] array, byte oldByte, byte newByte) {
        if (array == null) {
            return;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == oldByte) {
                array[i] = newByte;
            }
            ++i;
        }
    }

    public static int bytesToInt(byte b1, byte b2) {
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }
}

