/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.util;

import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.exceptions.HttpNumberFormatException;
import com.sap.engine.services.servlets_jsp.server.runtime.client.InternalOutputStream;

public class Ascii {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];
    private static final char[] digits;
    private static final byte[] digitBytes;

    public static int toUpper(int i) {
        return toUpper[i & 0xFF] & 0xFF;
    }

    public static int toLower(int i) {
        return toLower[i & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int i) {
        return isAlpha[i & 0xFF];
    }

    public static boolean isUpper(int i) {
        return isUpper[i & 0xFF];
    }

    public static boolean isLower(int i) {
        return isLower[i & 0xFF];
    }

    public static boolean isWhite(int i) {
        return isWhite[i & 0xFF];
    }

    public static boolean isDigit(int i) {
        return isDigit[i & 0xFF];
    }

    public static byte[] getBytes(String s) {
        char[] ch = s.toCharArray();
        byte[] toBytes = new byte[ch.length];
        int i = 0;
        while (i < ch.length) {
            toBytes[i] = (byte)ch[i];
            ++i;
        }
        return toBytes;
    }

    public static int asciiArrToInt(byte[] abyte0, int i, int j) throws NumberFormatException {
        int byte0 = -1;
        if (abyte0 == null || j <= 0 || !Ascii.isDigit(byte0 = abyte0[i++])) {
            throw new HttpNumberFormatException(HttpNumberFormatException.PARAMETERS_DO_NOT_SPECIFY_INTEGER);
        }
        int result = byte0 - 48;
        while (--j > 0) {
            if (!Ascii.isDigit(byte0 = abyte0[i++])) {
                throw new HttpNumberFormatException(HttpNumberFormatException.SYMBOL_IS_NOT_INTEGER, new Object[]{byte0 + ""});
            }
            result = result * 10 + byte0 - 48;
        }
        return result;
    }

    public static int asciiArrToIntNoException(byte[] abyte0, int i, int j) {
        byte byte0;
        if (abyte0 == null || j <= 0 || !Ascii.isDigit(byte0 = abyte0[i++])) {
            return -1;
        }
        int k = byte0 - 48;
        while (--j > 0) {
            if (!Ascii.isDigit(byte0 = abyte0[i++])) {
                return -1;
            }
            k = k * 10 + byte0 - 48;
        }
        return k;
    }

    public static long asciiArrToLongNoException(byte[] abyte0, int i, int j) {
        byte byte0;
        if (abyte0 == null || j <= 0 || !Ascii.isDigit(byte0 = abyte0[i++])) {
            return -1L;
        }
        long k = byte0 - 48;
        while (--j > 0) {
            if (!Ascii.isDigit(byte0 = abyte0[i++])) {
                return -1L;
            }
            k = k * 10L + (long)byte0 - 48L;
        }
        return k;
    }

    public static byte[] intToAsciiArr(int integer) {
        int length = 1;
        int temp = integer / 10;
        while (temp != 0) {
            temp /= 10;
            ++length;
        }
        byte[] newNum = new byte[length];
        int i = length - 1;
        while (i >= 0) {
            newNum[i] = (byte)(integer % 10 + 48);
            integer /= 10;
            --i;
        }
        return newNum;
    }

    public static void hexIntToAsciiArr(int i, InternalOutputStream internalOutputStream, byte[] buf) {
        int charPos = 10;
        int mask = 15;
        do {
            buf[--charPos] = digitBytes[i & mask];
        } while ((i >>>= 4) != 0);
        internalOutputStream.write(buf, charPos, 10 - charPos);
    }

    public static int asciiArrHexToInt(byte[] buf, int off, int len) {
        int res = 0;
        int coef = 1;
        int i = len - 1;
        while (i >= 0) {
            int toInt = buf[off + i] & 0xFF;
            if (toInt > 96 && toInt < 103) {
                res += (toInt - 87) * coef;
            } else if (toInt > 64 && toInt < 71) {
                res += (toInt - 55) * coef;
            } else if (toInt > 47 && toInt < 58) {
                res += (toInt - 48) * coef;
            } else {
                throw new HttpIllegalArgumentException("http_0008", new Object[]{new String(buf, off, len)});
            }
            coef *= 16;
            --i;
        }
        return res;
    }

    public static byte makeHexDigit(byte[] input, int inputOff) {
        return (byte)((Ascii.convertHexDigit(input[inputOff + 1]) << 4) + Ascii.convertHexDigit(input[inputOff + 2]));
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    static {
        int i = 0;
        while (i < 256) {
            Ascii.toUpper[i] = (byte)i;
            Ascii.toLower[i] = (byte)i;
            ++i;
        }
        int j = 97;
        while (j <= 122) {
            int k = j + 65 - 97;
            Ascii.toUpper[j] = (byte)k;
            Ascii.toLower[k] = (byte)j;
            Ascii.isAlpha[j] = true;
            Ascii.isAlpha[k] = true;
            Ascii.isLower[j] = true;
            Ascii.isUpper[k] = true;
            ++j;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        int l = 48;
        while (l <= 57) {
            Ascii.isDigit[l] = true;
            ++l;
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        digitBytes = new String(digits).getBytes();
    }
}

