/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.impl;

import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.interfaces.client.RequestLine;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;

public class RequestLineImpl
implements RequestLine,
Cloneable {
    private MessageBytes requestLine = null;
    private MessageBytes requestLineDecoded = null;
    private byte[] method = null;
    private MessageBytes fullUrl = null;
    private MessageBytes urlDecoded = null;
    private MessageBytes urlNotDecoded = null;
    private String scheme = null;
    private boolean isSecure = false;
    private byte[] hostAndPort = null;
    private byte[] host = null;
    private int port = -1;
    private MessageBytes query = null;
    private int httpMinorVersion = -1;
    private int httpMajorVersion = -1;
    private boolean simpleRequest = false;
    private boolean isURLEncoded = false;
    private boolean hostAndPortParsed = false;
    private boolean urlNotDecodedParsed = false;

    public RequestLineImpl() {
        this.reset();
    }

    public void reset() {
        this.requestLine = null;
        this.requestLineDecoded = null;
        this.urlDecoded = null;
        this.fullUrl = null;
        this.hostAndPort = null;
        this.scheme = null;
        this.isSecure = false;
        this.query = null;
        this.urlNotDecoded = null;
        this.method = null;
        this.isURLEncoded = false;
        this.httpMinorVersion = -1;
        this.httpMajorVersion = -1;
        this.port = -1;
        this.host = null;
        this.hostAndPortParsed = false;
        this.urlNotDecodedParsed = false;
        this.simpleRequest = false;
    }

    public void init(RequestLineImpl olRequestLine) {
        this.requestLine = olRequestLine.requestLine;
        this.requestLineDecoded = olRequestLine.requestLineDecoded;
        this.urlDecoded = olRequestLine.urlDecoded;
        this.fullUrl = olRequestLine.fullUrl;
        this.hostAndPort = olRequestLine.hostAndPort;
        this.scheme = olRequestLine.scheme;
        this.isSecure = olRequestLine.isSecure;
        this.query = olRequestLine.query;
        this.urlNotDecoded = olRequestLine.urlNotDecoded;
        this.method = olRequestLine.method;
        this.isURLEncoded = olRequestLine.isURLEncoded;
        this.httpMinorVersion = olRequestLine.httpMinorVersion;
        this.httpMajorVersion = olRequestLine.httpMajorVersion;
        this.port = olRequestLine.port;
        this.host = olRequestLine.host;
        this.hostAndPortParsed = olRequestLine.hostAndPortParsed;
        this.urlNotDecodedParsed = olRequestLine.urlNotDecodedParsed;
        this.simpleRequest = olRequestLine.simpleRequest;
    }

    public Object clone() {
        RequestLineImpl newRequestLine = new RequestLineImpl();
        newRequestLine.requestLine = this.requestLine;
        newRequestLine.requestLineDecoded = this.requestLineDecoded;
        newRequestLine.urlDecoded = this.urlDecoded;
        newRequestLine.fullUrl = this.fullUrl;
        newRequestLine.hostAndPort = this.hostAndPort;
        newRequestLine.port = this.port;
        newRequestLine.scheme = this.scheme;
        newRequestLine.isSecure = this.isSecure;
        newRequestLine.query = this.query;
        newRequestLine.urlNotDecoded = this.urlNotDecoded;
        newRequestLine.method = this.method;
        newRequestLine.isURLEncoded = this.isURLEncoded;
        newRequestLine.httpMinorVersion = this.httpMinorVersion;
        newRequestLine.httpMajorVersion = this.httpMajorVersion;
        newRequestLine.host = this.host;
        newRequestLine.hostAndPortParsed = this.hostAndPortParsed;
        newRequestLine.urlNotDecodedParsed = this.urlNotDecodedParsed;
        newRequestLine.simpleRequest = this.simpleRequest;
        return newRequestLine;
    }

    public byte[] toByteArray() {
        return this.requestLine.getBytes();
    }

    public byte[] getMethod() {
        return this.method;
    }

    public int getHttpMinorVersion() {
        return this.httpMinorVersion;
    }

    public int getHttpMajorVersion() {
        return this.httpMajorVersion;
    }

    public MessageBytes getFullUrl() {
        return this.fullUrl;
    }

    public byte[] getHost() {
        if (!this.hostAndPortParsed) {
            this.parseHostAndPort();
        }
        return this.host;
    }

    public int getPort() {
        if (!this.hostAndPortParsed) {
            this.parseHostAndPort();
        }
        return this.port;
    }

    public MessageBytes getQuery() {
        return this.query;
    }

    public MessageBytes getUrlNotDecoded() throws ParseException {
        if (!this.urlNotDecodedParsed) {
            this.parseUrlNotDecoded();
        }
        return this.urlNotDecoded;
    }

    public MessageBytes getUrlDecoded() {
        return this.urlDecoded;
    }

    public boolean isEncoded() {
        return this.isURLEncoded;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public MessageBytes getRequestLine() {
        return this.requestLine;
    }

    public void setScheme(boolean isSsl) {
        this.isSecure = isSsl;
        this.scheme = this.isSecure ? "https" : "http";
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.isSecure = !"http".equalsIgnoreCase(scheme);
    }

    public boolean isSimpleRequest() {
        return this.simpleRequest;
    }

    public int parseRequestLine(byte[] input, int offset) throws ParseException {
        int read = this.readRequestLine(input, offset);
        this.init();
        return read;
    }

    private int readRequestLine(byte[] input, int inputOff) {
        byte[] notDecodedInput = null;
        int inputLen = ByteArrayUtils.indexOf(input, (byte)10, inputOff) - inputOff - 1;
        while (inputLen == 0) {
            inputLen = ByteArrayUtils.indexOf(input, (byte)10, inputOff += 2) - inputOff - 1;
        }
        int offset = inputOff;
        boolean parsingQuery = false;
        int decodedOff = inputOff;
        int endIndex = inputOff + inputLen - 2;
        while (inputOff < endIndex) {
            byte currentByte;
            input[decodedOff] = currentByte = input[inputOff];
            if (!parsingQuery && currentByte == 37 && inputOff < endIndex - 1) {
                byte encodedByte = Ascii.makeHexDigit(input, inputOff);
                if (encodedByte == 0) {
                    input[decodedOff + 1] = input[inputOff + 1];
                    input[decodedOff + 2] = input[inputOff + 2];
                    decodedOff += 2;
                } else {
                    if (!this.isURLEncoded) {
                        notDecodedInput = new byte[inputLen];
                        System.arraycopy(input, offset, notDecodedInput, 0, notDecodedInput.length);
                    }
                    this.isURLEncoded = true;
                    input[decodedOff] = encodedByte;
                }
                inputOff += 2;
            } else if (currentByte == 63) {
                parsingQuery = true;
            }
            ++inputOff;
            ++decodedOff;
        }
        if (this.isURLEncoded) {
            this.requestLine = new MessageBytes(notDecodedInput);
            byte[] requestLineDecodedBytes = new byte[decodedOff - offset];
            System.arraycopy(input, offset, requestLineDecodedBytes, 0, requestLineDecodedBytes.length);
            this.requestLineDecoded = new MessageBytes(requestLineDecodedBytes);
        } else {
            this.requestLineDecoded = this.requestLine = new MessageBytes(input, offset, inputLen);
        }
        return offset + inputLen + 2;
    }

    private void init() throws ParseException {
        int k;
        int firstSpace = this.requestLineDecoded.indexOf(' ');
        int lastSpace = this.requestLineDecoded.lastIndexOf(' ');
        if (firstSpace == -1) {
            throw new ParseException("http_0050", new Object[]{this.requestLine});
        }
        if (firstSpace == lastSpace) {
            lastSpace = this.requestLineDecoded.length();
            this.simpleRequest = true;
        } else {
            int dotInd = this.requestLineDecoded.indexOf('.', lastSpace + 1 + 5);
            if (dotInd == -1) {
                this.httpMajorVersion = Ascii.asciiArrToIntNoException(this.requestLineDecoded.getBytes(), lastSpace + 1 + 5, this.requestLineDecoded.length() - lastSpace - 1 - 5);
                this.httpMinorVersion = -1;
            } else {
                this.httpMajorVersion = Ascii.asciiArrToIntNoException(this.requestLineDecoded.getBytes(), lastSpace + 1 + 5, dotInd - lastSpace - 1 - 5);
                this.httpMinorVersion = Ascii.asciiArrToIntNoException(this.requestLineDecoded.getBytes(), dotInd + 1, this.requestLineDecoded.length() - dotInd - 1);
            }
        }
        this.method = this.requestLineDecoded.getBytes(0, firstSpace);
        this.urlDecoded = new MessageBytes(this.requestLineDecoded.getBytes(firstSpace + 1, lastSpace - firstSpace - 1));
        int questionInd = this.urlDecoded.indexOf('?');
        int semiColonInd = this.urlDecoded.indexOf(';');
        int endInd = -1;
        endInd = questionInd == -1 ? (semiColonInd == -1 ? this.urlDecoded.length() : semiColonInd) : (semiColonInd == -1 ? questionInd : (questionInd < semiColonInd ? questionInd : semiColonInd));
        this.urlDecoded.replace((byte)92, (byte)47, 0, endInd);
        byte[] schemeBytes = null;
        if (this.urlDecoded.startsWithIgnoreCase(RequestLine.scheme_http_)) {
            schemeBytes = RequestLine.scheme_http_;
            this.scheme = "http";
        } else if (this.urlDecoded.startsWithIgnoreCase(RequestLine.scheme_https_)) {
            schemeBytes = RequestLine.scheme_https_;
            this.scheme = "https";
        }
        if (schemeBytes != null) {
            k = schemeBytes.length - 1;
        } else {
            if (!this.urlDecoded.startsWith("/")) {
                throw new ParseException("http_0050", new Object[]{this.requestLine});
            }
            k = 0;
        }
        while ((k = this.urlDecoded.indexOf("//", k)) > -1) {
            if (endInd > -1) {
                if (k >= endInd) break;
                --questionInd;
                --semiColonInd;
                --endInd;
            }
            this.urlDecoded.deleteByteAt(k);
        }
        if (schemeBytes != null) {
            k = this.urlDecoded.indexOf('/', schemeBytes.length);
            if (k > -1 && k < endInd) {
                this.hostAndPort = this.urlDecoded.getBytes(schemeBytes.length, k - schemeBytes.length);
                this.urlDecoded = new MessageBytes(this.urlDecoded.getBytes(k, this.urlDecoded.length() - k));
            } else {
                k = endInd - 1;
                this.hostAndPort = this.urlDecoded.getBytes(schemeBytes.length, endInd - schemeBytes.length);
                this.urlDecoded = new MessageBytes(this.urlDecoded.getBytes(endInd));
                this.urlDecoded.appendBefore(ParseUtils.separatorBytes);
            }
            questionInd -= k;
            semiColonInd -= k;
            endInd -= k;
        }
        this.fullUrl = new MessageBytes(this.urlDecoded.getBytes());
        if (questionInd > -1) {
            this.query = new MessageBytes(this.urlDecoded.getBytes(questionInd + 1));
            this.urlDecoded.setLength(questionInd);
        }
        if (semiColonInd > -1 && (questionInd < 0 || semiColonInd < questionInd)) {
            this.urlDecoded.setLength(semiColonInd);
        }
    }

    private void parseHostAndPort() {
        this.hostAndPortParsed = true;
        if (this.hostAndPort == null) {
            return;
        }
        int colonInd = ByteArrayUtils.indexOf(this.hostAndPort, (byte)58);
        if (colonInd == -1) {
            this.host = this.hostAndPort;
            this.port = this.isSecure ? 443 : 80;
        } else {
            this.host = new byte[colonInd];
            System.arraycopy(this.hostAndPort, 0, this.host, 0, colonInd);
            this.port = Ascii.asciiArrToIntNoException(this.hostAndPort, colonInd + 1, this.hostAndPort.length - colonInd - 1);
        }
    }

    private void parseUrlNotDecoded() throws ParseException {
        int lastSpace;
        int firstSpace = this.requestLine.indexOf(' ');
        if (firstSpace == (lastSpace = this.requestLine.lastIndexOf(' '))) {
            throw new ParseException("http_0050", new Object[]{this.requestLine});
        }
        this.urlNotDecoded = new MessageBytes(this.requestLine.getBytes(firstSpace + 1, lastSpace - firstSpace - 1));
        int ind = this.urlNotDecoded.indexOf('?');
        if (ind > -1) {
            this.urlNotDecoded.setLength(ind);
        }
        if ((ind = this.urlNotDecoded.indexOf(';')) > -1) {
            this.urlNotDecoded.setLength(ind);
        }
        byte[] schemeBytes = null;
        if (this.urlNotDecoded.startsWithIgnoreCase(RequestLine.scheme_http_)) {
            schemeBytes = RequestLine.scheme_http_;
        } else if (this.urlNotDecoded.startsWithIgnoreCase(RequestLine.scheme_https_)) {
            schemeBytes = RequestLine.scheme_https_;
        } else {
            return;
        }
        int k = this.urlNotDecoded.indexOf('/', schemeBytes.length);
        this.urlNotDecoded = k != -1 ? new MessageBytes(this.urlNotDecoded.getBytes(k, this.urlNotDecoded.length() - k)) : new MessageBytes(ParseUtils.separatorBytes);
    }
}

