/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.headers;

import com.sap.engine.lib.text.FastDateFormat;
import com.sap.engine.services.httpserver.exceptions.HttpIOException;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaderField;
import com.sap.engine.services.httpserver.lib.headers.MimeHeadersEnumerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class MimeHeaders
implements Cloneable {
    private static final Locale loc = Locale.US;
    private static final TimeZone zone = TimeZone.getTimeZone("GMT");
    private final FastDateFormat rfc1123Format = new FastDateFormat("EEE, dd MMM yyyy HH:mm:ss z", zone, loc, false);
    private final FastDateFormat rfc1123FormatLM = new FastDateFormat("EEE, dd MMM yyyy HH:mm:ss z", zone, loc, false);
    private static final byte SP = 32;
    private static final byte HT = 9;
    private MimeHeaderField[] headers = new MimeHeaderField[7];
    private int count = 0;
    private byte[] buf;

    public MimeHeaders() {
        int i = 0;
        while (i < this.headers.length) {
            this.headers[i] = new MimeHeaderField(this.rfc1123Format, this.rfc1123FormatLM);
            ++i;
        }
        this.buf = new byte[512];
    }

    public Object clone() {
        int i;
        MimeHeaders newmMimeHeaders = new MimeHeaders();
        newmMimeHeaders.buf = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, newmMimeHeaders.buf, 0, this.buf.length);
        if (this.headers.length > newmMimeHeaders.headers.length) {
            newmMimeHeaders.headers = new MimeHeaderField[this.headers.length];
            i = 0;
            while (i < this.headers.length) {
                newmMimeHeaders.headers[i] = new MimeHeaderField(this.rfc1123Format, this.rfc1123FormatLM);
                ++i;
            }
        }
        i = 0;
        while (i < this.headers.length) {
            if (this.headers[i] != null) {
                newmMimeHeaders.headers[i].init(this.headers[i]);
            }
            ++i;
        }
        return newmMimeHeaders;
    }

    public void getDate(byte[] inByteArr, int off) {
        this.rfc1123Format.getDate(inByteArr, off);
    }

    public void getDate(byte[] inByteArr, int off, long l) {
        this.rfc1123Format.getDate(inByteArr, off, l);
    }

    public int getDateLength() {
        return this.rfc1123Format.getLength();
    }

    public void clear() {
        int i = 0;
        while (i < this.count) {
            this.headers[i].reset();
            ++i;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putHeader(byte[] s, byte[] s1) {
        this.putHeader(s).setValue(s1, 0, s1.length);
    }

    public void addHeader(byte[] s, byte[] s1) {
        MimeHeaderField mimeheaderfield = this.putHeader();
        mimeheaderfield.setName(s, 0, s.length);
        mimeheaderfield.setValue(s1, 0, s1.length);
    }

    public void putIntHeader(byte[] s, int i) {
        this.putHeader(s).setIntValue(i);
    }

    public void addIntHeader(byte[] s, int i) {
        MimeHeaderField mimeheaderfield = this.putHeader();
        mimeheaderfield.setName(s, 0, s.length);
        mimeheaderfield.setIntValue(i);
    }

    public void putDateHeader(byte[] s, long l) {
        this.putHeader(s).setDateValue(l);
    }

    public void addDateHeader(byte[] s, long l) {
        MimeHeaderField mimeheaderfield = this.putHeader();
        mimeheaderfield.setName(s, 0, s.length);
        mimeheaderfield.setDateValue(l);
    }

    public void putDateHeaderLM(byte[] s, long l) {
        this.putHeader(s).setDateValueLM(l);
    }

    public void putDateHeader(byte[] s) {
        this.putHeader(s).setDateValue();
    }

    public String getHeader(String s) {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getValue();
        }
        return null;
    }

    public byte[] getHeader(byte[] s) {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getByteValue();
        }
        return null;
    }

    public String[] getHeaders(String s) {
        Vector<String> vector = new Vector<String>();
        String[] as = null;
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(s)) {
                vector.addElement(this.headers[i].getValue());
            }
            ++i;
        }
        if (vector.size() > 0) {
            as = new String[vector.size()];
            as = vector.toArray(as);
        } else {
            as = new String[]{};
        }
        return as;
    }

    public int getIntHeader(String s) throws NumberFormatException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getIntValue();
        }
        return -1;
    }

    public int getIntHeader(byte[] s) throws NumberFormatException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getIntValue();
        }
        return -1;
    }

    public long getLongHeader(String s) throws NumberFormatException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getLongValue();
        }
        return -1L;
    }

    public long getLongHeader(byte[] s) throws NumberFormatException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getLongValue();
        }
        return -1L;
    }

    public long getDateHeader(String s) throws IllegalArgumentException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getDateValue();
        }
        return -1L;
    }

    public long getDateHeader(byte[] s) throws IllegalArgumentException {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield != null) {
            return mimeheaderfield.getDateValue();
        }
        return -1L;
    }

    public String getHeaderName(int i) {
        if (i >= 0 && i < this.count) {
            return this.headers[i].getName();
        }
        return null;
    }

    public String getHeader(int i) {
        if (i >= 0 && i < this.count) {
            return this.headers[i].getValue();
        }
        return null;
    }

    protected MimeHeaderField find(String s) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(s)) {
                return this.headers[i];
            }
            ++i;
        }
        return null;
    }

    protected MimeHeaderField find(byte[] s) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(s, 0, s.length)) {
                return this.headers[i];
            }
            ++i;
        }
        return null;
    }

    public void removeHeader(String s) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(s)) {
                MimeHeaderField mimeheaderfield = this.headers[i];
                mimeheaderfield.reset();
                this.headers[i] = this.headers[--this.count];
                this.headers[this.count] = mimeheaderfield;
                this.removeHeader(s);
            }
            ++i;
        }
    }

    public void removeHeader(String name, String value) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(name) && this.headers[i].getValue().equals(value)) {
                MimeHeaderField mimeheaderfield = this.headers[i];
                mimeheaderfield.reset();
                this.headers[i] = this.headers[--this.count];
                this.headers[this.count] = mimeheaderfield;
                this.removeHeader(name, value);
            }
            ++i;
        }
    }

    public boolean containsHeader(String s) {
        return this.find(s) != null;
    }

    public int init(byte[] httpinputstream, int offset, int length) throws IOException {
        int i = 0;
        int temp = -1;
        int k = -1;
        while (true) {
            int j = i;
            while (true) {
                k = this.buf.length - i;
                if (temp != -1) {
                    this.buf[i] = (byte)temp;
                    ++i;
                    --k;
                }
                if (k > 0) {
                    if ((k = this.readLine(httpinputstream, offset, length, this.buf, i, k)) == -1) {
                        throw new HttpIOException("http_0017");
                    }
                    offset += k;
                }
                i += k;
                if (k <= 0) break;
                if (this.buf[i - 1] == 10) {
                    if (k == 1 || k == 2) {
                        temp = -1;
                        break;
                    }
                    if ((temp = httpinputstream[offset++]) == -1 || temp != 32 && temp != 9) break;
                    k += 2;
                    i -= 2;
                }
                byte[] abyte1 = new byte[this.buf.length * 2];
                System.arraycopy(this.buf, 0, abyte1, 0, this.buf.length);
                temp = -1;
                this.buf = abyte1;
            }
            if (--i > j && this.buf[i - 1] == 13) {
                --i;
            }
            if (i == j) break;
            this.putHeader().parse(this.buf, j, i - j);
        }
        return offset;
    }

    public int readLine(byte[] httpinputstream, int inputOffset, int inputLength, byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while (count < len && count < inputLength) {
            b[off++] = httpinputstream[inputOffset + count];
            if (httpinputstream[inputOffset + count] == 10) {
                ++count;
                break;
            }
            ++count;
        }
        return count > 0 ? count : -1;
    }

    public void write(OutputStream httpoutputstream) throws IOException {
        int i = 0;
        while (i < this.count) {
            this.headers[i].write(httpoutputstream);
            ++i;
        }
    }

    protected MimeHeaderField putHeader(byte[] s) {
        MimeHeaderField mimeheaderfield = this.find(s);
        if (mimeheaderfield == null) {
            mimeheaderfield = this.putHeader();
            mimeheaderfield.setName(s, 0, s.length);
        }
        return mimeheaderfield;
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mimeheaderfield;
        int i = this.headers.length;
        if (this.count >= i) {
            MimeHeaderField[] amimeheaderfield = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, amimeheaderfield, 0, i);
            this.headers = amimeheaderfield;
        }
        if ((mimeheaderfield = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeheaderfield = new MimeHeaderField(this.rfc1123Format, this.rfc1123FormatLM);
        }
        ++this.count;
        return mimeheaderfield;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("{");
        int i = 0;
        while (i < this.count) {
            stringbuffer.append("{");
            stringbuffer.append(this.headers[i].toString());
            stringbuffer.append("}");
            if (i < this.count - 1) {
                stringbuffer.append(",");
            }
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

