/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib.headers;

import com.sap.engine.lib.text.FastDateFormat;
import com.sap.engine.services.httpserver.exceptions.HttpCharConversionException;
import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import com.sap.engine.services.httpserver.exceptions.HttpNumberFormatException;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MimeHeaderField {
    private static final Locale loc = Locale.US;
    private final SimpleDateFormat rfc1123FormatSimple = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", loc);
    private static final SimpleDateFormat rfc1036FormatSimple = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", loc);
    private static final SimpleDateFormat asctimeFormatSimple = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyyy", loc);
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private FastDateFormat rfc1123Format = null;
    private FastDateFormat rfc1123FormatLM = null;
    private final MessageBytes name = new MessageBytes();
    private final MessageBytes value = new MessageBytes();
    private int intValue = -1;
    private long dateValue = 0L;
    private long dateValueLM = 0L;
    private int type = 0;

    public MimeHeaderField(FastDateFormat rfc1123Format, FastDateFormat rfc1123FormatLM) {
        this.rfc1123Format = rfc1123Format;
        this.rfc1123FormatLM = rfc1123FormatLM;
    }

    public void init(MimeHeaderField mimeHeaderField) {
        this.name.setBytes(mimeHeaderField.name.getBytes());
        this.value.setBytes(mimeHeaderField.value.getBytes());
        this.intValue = mimeHeaderField.intValue;
        this.dateValue = mimeHeaderField.dateValue;
        this.dateValueLM = mimeHeaderField.dateValueLM;
        this.type = mimeHeaderField.type;
    }

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.type = 0;
    }

    public void setName(byte[] abyte0, int i, int j) {
        this.name.setBytes(abyte0, i, j);
    }

    public void setValue(byte[] abyte0, int i, int j) {
        this.value.setBytes(abyte0, i, j);
        this.type = 1;
    }

    public void setIntValue(int i) {
        this.intValue = i;
        this.type = 2;
    }

    public void setDateValue(long l) {
        this.dateValue = l;
        this.type = 3;
    }

    public void setDateValueLM(long l) {
        this.dateValueLM = l;
        this.type = 4;
    }

    public void setDateValue() {
        this.dateValue = new Date(System.currentTimeMillis()).getTime();
        this.type = 3;
    }

    public void setDateValueLM() {
        this.dateValueLM = new Date(System.currentTimeMillis()).getTime();
        this.type = 4;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                byte[] res = new byte[this.rfc1123Format.getLength()];
                this.rfc1123Format.getDate(res, 0, this.dateValue);
                return new String(res);
            }
            case 4: {
                byte[] res = new byte[this.rfc1123FormatLM.getLength()];
                this.rfc1123FormatLM.getDate(res, 0, this.dateValueLM);
                return new String(res);
            }
        }
        return null;
    }

    public byte[] getByteValue() {
        if (this.type == 1) {
            return this.value.getBytes();
        }
        String res = this.getValue();
        if (res != null) {
            return res.getBytes();
        }
        return null;
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
        }
        throw new HttpNumberFormatException(HttpNumberFormatException.UNKNOWN_OR_INCOMPATIBLE_FIELD_TYPE);
    }

    public long getLongValue() throws NumberFormatException {
        if (this.type != 3 && this.type != 4) {
            return Long.parseLong(new String(this.value.getBytes()));
        }
        throw new HttpNumberFormatException(HttpNumberFormatException.UNKNOWN_OR_INCOMPATIBLE_FIELD_TYPE);
    }

    private long parse(String s) {
        try {
            return this.rfc1123FormatSimple.parse(s).getTime();
        }
        catch (ParseException ex) {
            try {
                SimpleDateFormat simpleDateFormat = rfc1036FormatSimple;
                synchronized (simpleDateFormat) {
                    long l = rfc1036FormatSimple.parse(s).getTime();
                    return l;
                }
            }
            catch (ParseException ex2) {
                try {
                    SimpleDateFormat simpleDateFormat = asctimeFormatSimple;
                    synchronized (simpleDateFormat) {
                        long l = asctimeFormatSimple.parse(s).getTime();
                        return l;
                    }
                }
                catch (ParseException ex3) {
                    throw new HttpIllegalArgumentException("http_0012");
                }
            }
        }
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 4: {
                return this.dateValueLM;
            }
            case 3: {
                return this.dateValue;
            }
            case 1: {
                return this.parse(this.value.toString());
            }
        }
        throw new HttpIllegalArgumentException("http_0013");
    }

    /*
     * Unable to fully structure code
     */
    private int intGetBytes(int i, byte[] abyte0, int j) {
        k = 1000000000;
        i1 = 0;
        if (i != 0) ** GOTO lbl11
        abyte0[j] = MimeHeaderField.charval[0];
        return 1;
lbl-1000:
        // 1 sources

        {
            l = i / k;
            if (l != 0 || i1 > 0) {
                abyte0[j + i1++] = MimeHeaderField.charval[l];
            }
            i %= k;
            k /= 10;
lbl11:
            // 2 sources

            ** while (k > 0)
        }
lbl12:
        // 1 sources

        return i1;
    }

    public int getBytes(byte[] abyte0, int i) {
        int j = i;
        i += this.name.getBytes(abyte0, i);
        abyte0[i++] = 58;
        abyte0[i++] = 32;
        switch (this.type) {
            case 1: {
                i += this.value.getBytes(abyte0, i);
                break;
            }
            case 2: {
                i += this.intGetBytes(this.intValue, abyte0, i);
                break;
            }
            case 3: {
                this.rfc1123Format.getDate(abyte0, i, this.dateValue);
                i += this.rfc1123Format.getLength();
                break;
            }
            case 4: {
                this.rfc1123FormatLM.getDate(abyte0, i, this.dateValueLM);
                i += this.rfc1123Format.getLength();
            }
        }
        abyte0[i++] = 13;
        abyte0[i++] = 10;
        return i - j;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(byte[] abyte0, int i, int j) throws IllegalArgumentException {
        k = i;
        while ((byte0 = abyte0[i++]) != 58 && byte0 != 32) {
            if (var5_5 != 10) continue;
            throw new HttpIllegalArgumentException("http_0013");
        }
        this.setName(abyte0, k, i - k - 1);
        while (byte0 == 32) {
            byte0 = abyte0[i++];
        }
        if (byte0 == 58) ** GOTO lbl12
        throw new HttpIllegalArgumentException("http_0015");
lbl-1000:
        // 1 sources

        {
            ++i;
lbl12:
            // 2 sources

            ** while (abyte0[i] == 32)
        }
lbl13:
        // 1 sources

        j += k;
        while (abyte0[j - 1] == 32) {
            --j;
        }
        if (i < j) {
            this.setValue(abyte0, i, j - i);
        } else {
            this.setValue(abyte0, i, 0);
        }
    }

    public void write(OutputStream httpoutputstream) throws IOException {
        this.name.write(httpoutputstream);
        this.print(httpoutputstream, ": ");
        switch (this.type) {
            case 1: {
                this.value.write(httpoutputstream);
                this.println(httpoutputstream);
                return;
            }
            case 2: {
                this.println(httpoutputstream, this.intValue);
                return;
            }
            case 3: {
                byte[] res = new byte[this.rfc1123Format.getLength()];
                this.rfc1123Format.getDate(res, 0, this.dateValue);
                httpoutputstream.write(res);
                this.println(httpoutputstream);
                return;
            }
            case 4: {
                byte[] res = new byte[this.rfc1123FormatLM.getLength()];
                this.rfc1123FormatLM.getDate(res, 0, this.dateValueLM);
                httpoutputstream.write(res);
                this.println(httpoutputstream);
                return;
            }
        }
        this.println(httpoutputstream);
    }

    public void print(OutputStream httpoutputstream, String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                throw new HttpCharConversionException(HttpCharConversionException.FIRST_BYTE_MUST_BE_ZERO);
            }
            httpoutputstream.write(c);
            ++i;
        }
    }

    public void print(OutputStream httpoutputstream, boolean b) throws IOException {
        String msg = b ? "true" : "false";
        this.print(httpoutputstream, msg);
    }

    public void print(OutputStream httpoutputstream, char c) throws IOException {
        this.print(httpoutputstream, String.valueOf(c));
    }

    public void print(OutputStream httpoutputstream, int i) throws IOException {
        this.print(httpoutputstream, String.valueOf(i));
    }

    public void print(OutputStream httpoutputstream, long l) throws IOException {
        this.print(httpoutputstream, String.valueOf(l));
    }

    public void print(OutputStream httpoutputstream, float f) throws IOException {
        this.print(httpoutputstream, String.valueOf(f));
    }

    public void print(OutputStream httpoutputstream, double d) throws IOException {
        this.print(httpoutputstream, String.valueOf(d));
    }

    public void println(OutputStream httpoutputstream) throws IOException {
        this.print(httpoutputstream, "\r\n");
    }

    public void println(OutputStream httpoutputstream, String s) throws IOException {
        this.print(httpoutputstream, s);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, boolean b) throws IOException {
        this.print(httpoutputstream, b);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, char c) throws IOException {
        this.print(httpoutputstream, c);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, int i) throws IOException {
        this.print(httpoutputstream, i);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, long l) throws IOException {
        this.print(httpoutputstream, l);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, float f) throws IOException {
        this.print(httpoutputstream, f);
        this.println(httpoutputstream);
    }

    public void println(OutputStream httpoutputstream, double d) throws IOException {
        this.print(httpoutputstream, d);
        this.println(httpoutputstream);
    }

    public boolean nameEquals(String s) {
        return this.name.equalsIgnoreCase(s);
    }

    public boolean nameEquals(byte[] abyte0, int i, int j) {
        return this.name.equalsIgnoreCase(abyte0, i, j);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(this.name.toString());
        stringbuffer.append(": ");
        stringbuffer.append(this.getValue());
        return stringbuffer.toString();
    }
}

