/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

public class WebCookieConfig {
    public static final int COOKIE_TYPE_OTHER = 1;
    public static final int COOKIE_TYPE_SESSION = 2;
    public static final int COOKIE_TYPE_APPLICATION = 3;
    public static final byte NONE = 1;
    public static final byte SERVER = 2;
    public static final byte APPLICATION = 4;
    public static final byte OTHER = 8;
    private static final String slash = "/";
    private String aliasName = null;
    private int cookieType = -1;
    private byte pathType = (byte)2;
    private String path = null;
    private byte domainType = (byte)2;
    private String domain = null;
    private int maxAge = -1;

    public WebCookieConfig(String aliasName, int cookieType) {
        this.aliasName = aliasName;
        this.cookieType = cookieType;
        this.init();
    }

    private void init() {
        this.pathType = (byte)2;
        this.path = slash;
        this.domainType = this.cookieType == 2 ? (byte)2 : (this.cookieType == 3 ? (byte)1 : (byte)2);
        this.domain = null;
        this.maxAge = -1;
    }

    public void setPath(byte type, String path) {
        this.pathType = type;
        this.path = path;
        if (type == 2) {
            this.path = slash;
        } else if (type == 4) {
            this.path = this.aliasName == null || this.aliasName.length() == 0 ? slash : slash + this.aliasName + slash;
        }
    }

    public void setDomain(byte type, String domain) {
        this.domainType = type;
        this.domain = domain;
    }

    public void setMaxAgen(int maxAge) {
        this.maxAge = maxAge;
    }

    public byte getPathType() {
        return this.pathType;
    }

    public String getPath() {
        return this.path;
    }

    public byte getDomainType() {
        return this.domainType;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }
}

