/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.interfaces.client.Response;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.lib.util.SortUtils;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class ProtocolParser {
    private static final byte[] close = "close".getBytes();
    private static final byte[] keep_alive = "Keep-Alive".getBytes();
    private static final byte[] gzip = "gzip".getBytes();
    private static final byte[] identity = "identity".getBytes();
    private static final byte[] qSeparator = ";q=".getBytes();

    public static String makeAbsolute(String s, MessageBytes aliasName, Request request) {
        if (!s.startsWith("http://") && !s.startsWith("https://")) {
            if ((s = new String(ParseUtils.separatorsToFS(s))).startsWith("/")) {
                if (!(aliasName == null || aliasName.length() <= 0 || aliasName.equals("/") || s.startsWith("/" + aliasName + "/") || s.startsWith("/" + aliasName + ";") || s.startsWith("/" + aliasName + "?"))) {
                    s = "/" + aliasName + s;
                }
            } else {
                s = aliasName != null && aliasName.length() > 0 && !s.startsWith(aliasName + "/") ? "/" + aliasName + "/" + s : "/" + s;
            }
            s = ProtocolParser.makeAbsolute(request.getScheme(), request.getHost(), request.getPort()) + s;
        }
        return s;
    }

    public static String makeAbsolute(String scheme, String host, int port) {
        if (scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443) {
            return scheme + "://" + host;
        }
        return scheme + "://" + host + ":" + port;
    }

    public static boolean parseConnectionHeader(byte[] con, Response response) {
        if (con.length < close.length) {
            return false;
        }
        if (ByteArrayUtils.equalsIgnoreCaseAndTrim(con, close)) {
            response.getHeaders().putHeader(HeaderNames.hop_header_connection_, close);
            return false;
        }
        if (ByteArrayUtils.equalsIgnoreCaseAndTrim(con, keep_alive)) {
            return true;
        }
        boolean foundClose = false;
        int off = 0;
        int len = 0;
        int i = 0;
        while (i <= con.length) {
            if (i == con.length || con[i] == 44) {
                if (ByteArrayUtils.equalsIgnoreCaseAndTrim(con, off, len, keep_alive)) {
                    return true;
                }
                if (!foundClose && ByteArrayUtils.equalsIgnoreCaseAndTrim(con, off, len, close)) {
                    foundClose = true;
                }
                off += len + 1;
                len = 0;
            } else {
                ++len;
            }
            ++i;
        }
        if (foundClose) {
            response.getHeaders().putHeader(HeaderNames.hop_header_connection_, close);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parseGzipAcceptEncodingHeader(byte[] encoding) {
        if (encoding == null || encoding.length == 0) {
            return false;
        }
        gzipQvalue = 0;
        identityQvalue = 1000;
        starQvalue = 1000;
        identityFound = false;
        gzipFound = false;
        startFound = false;
        off = 0;
        len = 0;
        i = 0;
        while (i <= encoding.length) {
            block20: {
                block16: {
                    block18: {
                        block19: {
                            block17: {
                                if (i != encoding.length && encoding[i] != 44) break block16;
                                sep = ByteArrayUtils.indexOf(encoding, off, len, ProtocolParser.qSeparator);
                                if (sep != -1) ** GOTO lbl37
                                while (encoding[off] == 32) {
                                    ++off;
                                    --len;
                                }
                                if (!ByteArrayUtils.equalsIgnoreCase(encoding, off, len, ProtocolParser.gzip)) break block17;
                                gzipFound = true;
                                gzipQvalue = 1000;
                                break block18;
                            }
                            if (!ByteArrayUtils.equalsIgnoreCase(encoding, off, len, ProtocolParser.identity)) break block19;
                            identityFound = true;
                            identityQvalue = 1000;
                            break block18;
                        }
                        if (encoding[off] != 42) break block18;
                        startFound = true;
                        starQvalue = 1000;
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            ++off;
                            --len;
                            --sep;
lbl37:
                            // 2 sources

                            ** while (encoding[off] == 32)
                        }
lbl38:
                        // 1 sources

                        if (ByteArrayUtils.equalsIgnoreCase(encoding, off, sep, ProtocolParser.gzip)) {
                            gzipFound = true;
                            gzipQvalue = ProtocolParser.parseQValue(encoding, off + sep + 3, len - sep - 3);
                        } else if (ByteArrayUtils.equalsIgnoreCase(encoding, off, sep, ProtocolParser.identity)) {
                            identityFound = true;
                            identityQvalue = ProtocolParser.parseQValue(encoding, off + sep + 3, len - sep - 3);
                        } else if (encoding[off] == 42) {
                            startFound = true;
                            starQvalue = ProtocolParser.parseQValue(encoding, off + sep + 3, len - sep - 3);
                        }
                    }
                    off += len + 1;
                    len = 0;
                    break block20;
                }
                ++len;
            }
            ++i;
        }
        if (startFound) {
            if (!identityFound) {
                identityQvalue = starQvalue;
            }
            if (!gzipFound) {
                gzipQvalue = starQvalue;
            }
        }
        if (gzipQvalue == 0 && identityQvalue == 0) {
            return false;
        }
        return gzipQvalue >= identityQvalue;
    }

    public static Vector getLocalesVector(byte[] acceptLanguage) {
        if (acceptLanguage == null || acceptLanguage.length == 0) {
            return null;
        }
        HashMapIntObject languages = ProtocolParser.processAcceptLanguage(acceptLanguage);
        int[] sortedQs = SortUtils.sort(languages.getAllKeys());
        return ProtocolParser.extractLocales(languages, sortedQs);
    }

    /*
     * Unable to fully structure code
     */
    private static HashMapIntObject processAcceptLanguage(byte[] acceptLanguage) {
        off = 0;
        len = 0;
        languages = new HashMapIntObject(2);
        i = 0;
        while (i <= acceptLanguage.length) {
            block10: {
                block7: {
                    block8: {
                        block9: {
                            if (i != acceptLanguage.length && acceptLanguage[i] != 44) break block7;
                            sep = ByteArrayUtils.indexOf(acceptLanguage, off, len, ProtocolParser.qSeparator);
                            qValue = 1000;
                            language = null;
                            if (sep != -1) break block8;
                            if (len - off != 1 || acceptLanguage[off] != 42) break block9;
                            off += len + 1;
                            len = 0;
                            break block10;
                        }
                        language = new String(acceptLanguage, off, len);
                        ** GOTO lbl25
                    }
                    if (sep == 1 && acceptLanguage[off] == 42) {
                        off += len + 1;
                        len = 0;
                    } else {
                        qValue = ProtocolParser.parseQValue(acceptLanguage, off + sep + 3, len - sep - 3);
                        language = new String(acceptLanguage, off, sep);
lbl25:
                        // 2 sources

                        languagesWithSameQ = languages.containsKey(qValue) != false ? (Vector)languages.get(qValue) : new Vector();
                        languagesWithSameQ.addElement(language);
                        languages.put(qValue, (Object)languagesWithSameQ);
                        off += len + 1;
                        len = 0;
                    }
                    break block10;
                }
                if (acceptLanguage[i] == 32) {
                    if (len == 0) {
                        ++off;
                    } else {
                        ++len;
                    }
                } else {
                    ++len;
                }
            }
            ++i;
        }
        return languages;
    }

    private static int parseQValue(byte[] q, int off, int len) {
        if (q == null || len == 0) {
            return 1000;
        }
        if (q[off] == 48) {
            if (len > 1) {
                return Ascii.asciiArrToInt(q, off + 2, len - 2);
            }
            return 0;
        }
        if (q[off] == 49) {
            return 1000;
        }
        return 0;
    }

    private static Vector extractLocales(HashMapIntObject languages, int[] sortedQs) {
        Vector<Locale> localesSorted = new Vector<Locale>();
        int i = 0;
        while (i < sortedQs.length) {
            Vector languagesWithSameQ = (Vector)languages.get(sortedQs[i]);
            Enumeration le = languagesWithSameQ.elements();
            while (le.hasMoreElements()) {
                String language = (String)le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                localesSorted.addElement(new Locale(language, country));
            }
            ++i;
        }
        return localesSorted;
    }
}

