/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

public class ParseUtils {
    public static final String separator = "/";
    public static final byte[] separatorBytes = "/".getBytes();
    public static final char separatorChar = '/';
    public static final byte separatorByte = 47;
    private static final byte oppositeSlash = 92;

    public static String canonicalize(String path) {
        int di;
        char[] dest = path.toCharArray();
        int omit = 0;
        int dots = 0;
        boolean slash = true;
        int si = di = dest.length - 1;
        while (si >= 0) {
            char temp = dest[si];
            if (temp == '\\' || temp == '/') {
                if (slash) {
                    if (dots == 2) {
                        ++omit;
                    } else if (dots > 2 && omit > 0) {
                        --omit;
                    }
                } else {
                    slash = true;
                    if (omit == 0) {
                        dest[di--] = temp;
                    } else {
                        --omit;
                    }
                }
                dots = 0;
            } else if (slash) {
                if (temp == '.') {
                    ++dots;
                } else {
                    slash = false;
                    if (omit == 0) {
                        while (dots > 0) {
                            dest[di--] = 46;
                            --dots;
                        }
                        dest[di--] = temp;
                    }
                }
            } else if (omit == 0) {
                dest[di--] = temp;
            }
            --si;
        }
        return new String(dest, di + 1, dest.length - di - 1);
    }

    public static byte[] separatorsToFS(String path) {
        byte[] pathBytes = path.getBytes();
        int ptr = 0;
        boolean previousIsSlash = false;
        int i = 0;
        while (i < pathBytes.length) {
            if (previousIsSlash) {
                if (pathBytes[i] != 47 && pathBytes[i] != 92) {
                    previousIsSlash = false;
                    pathBytes[ptr++] = pathBytes[i];
                }
            } else if (pathBytes[i] == 47 || pathBytes[i] == 92) {
                previousIsSlash = true;
                pathBytes[ptr++] = 47;
            } else {
                pathBytes[ptr++] = pathBytes[i];
            }
            ++i;
        }
        if (ptr != pathBytes.length) {
            byte[] tmp = new byte[ptr];
            System.arraycopy(pathBytes, 0, tmp, 0, ptr);
            pathBytes = tmp;
        }
        return pathBytes;
    }

    public static byte[] inetAddressByteToString(byte[] address) {
        if (address == null || address.length == 0) {
            return "".getBytes();
        }
        int length = 3;
        int i = 0;
        while (i < 4) {
            length = address[i] == 0 ? ++length : (length += (int)(Math.log(address[i] & 0xFF) / Math.log(10.0) + 1.0));
            ++i;
        }
        byte[] newAddress = new byte[length];
        int pos = 0;
        int i2 = 0;
        while (i2 < 4) {
            if (address[i2] == 0) {
                newAddress[pos++] = 48;
            } else {
                byte[] temp = ParseUtils.intToByteArr(address[i2] & 0xFF);
                int j = 0;
                while (j < temp.length) {
                    newAddress[pos++] = temp[j];
                    ++j;
                }
            }
            if (i2 != 3) {
                newAddress[pos++] = 46;
            }
            ++i2;
        }
        return newAddress;
    }

    public static String convertAlias(String alias) {
        if (alias.equals(separator) || alias.equals("\\")) {
            return separator;
        }
        return alias.replace('/', '/').replace('\\', '/');
    }

    private static byte[] intToByteArr(int integer) {
        int length = (int)(Math.log(integer) / Math.log(10.0)) + 1;
        byte[] newNum = new byte[length];
        int i = length - 1;
        while (i >= 0) {
            newNum[i] = (byte)(integer % 10 + 48);
            integer /= 10;
            --i;
        }
        return newNum;
    }
}

