/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

import com.sap.engine.services.httpserver.exceptions.HttpIllegalArgumentException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HttpParseUtil {
    public static String hashToString(Hashtable tempHash) {
        if (tempHash.size() == 0) {
            return "{}";
        }
        String sReturn = "{";
        Enumeration resEnum = tempHash.keys();
        while (resEnum.hasMoreElements()) {
            String key = (String)resEnum.nextElement();
            sReturn = sReturn + "{" + key + "," + tempHash.get(key) + "},";
        }
        return sReturn.substring(0, sReturn.length() - 1) + "}";
    }

    public static Hashtable stringToHashtable(String sProps) {
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        int iBegin = sProps.indexOf("{");
        int iEnd = sProps.lastIndexOf("}");
        if (iBegin == -1 && iEnd == -1) {
            return hashTable;
        }
        if (iBegin == -1 || iEnd == -1) {
            throw new HttpIllegalArgumentException("http_0000", new Object[]{"{", "}"});
        }
        String sRestList = sProps.substring(iBegin + 1, iEnd);
        while (sRestList.indexOf("{") != -1) {
            int iElemBegin = sRestList.indexOf("{");
            int iElemEnd = sRestList.indexOf("}");
            if (iElemEnd == -1) continue;
            String sSubElem = sRestList.substring(iElemBegin + 1, iElemEnd);
            sRestList = sRestList.substring(iElemEnd + 1);
            int index = sSubElem.indexOf(",");
            hashTable.put(sSubElem.substring(0, index).trim(), sSubElem.substring(index + 1).trim());
        }
        return hashTable;
    }

    public static Vector commpressedStringToExtensions(String str) {
        Vector<String> vReturn = new Vector<String>();
        StringTokenizer user = new StringTokenizer(str, ",");
        while (user.hasMoreElements()) {
            String nextEl = (String)user.nextElement();
            if (!nextEl.startsWith("*.")) continue;
            vReturn.add(nextEl.substring(1));
        }
        return vReturn;
    }

    public static Vector commpressedStringToMIMEType(String str) {
        Vector<String> vReturn = new Vector<String>();
        StringTokenizer user = new StringTokenizer(str, ",");
        while (user.hasMoreElements()) {
            String nextEl = (String)user.nextElement();
            if (nextEl.startsWith("*.")) continue;
            vReturn.add(nextEl);
        }
        return vReturn;
    }

    public static String[] stringToArray(String sProps) {
        Vector<String> vect = new Vector<String>();
        int iBegin = sProps.indexOf("{");
        int iEnd = sProps.lastIndexOf("}");
        if (iBegin == -1 && iEnd == -1) {
            return new String[0];
        }
        if (iBegin == -1 || iEnd == -1) {
            throw new HttpIllegalArgumentException("http_0001", new Object[]{"{", "}"});
        }
        StringTokenizer tokenizer = new StringTokenizer(sProps.substring(iBegin + 1, iEnd), ",");
        while (tokenizer.hasMoreTokens()) {
            vect.addElement(tokenizer.nextToken());
        }
        Object[] sArray = new String[vect.size()];
        vect.copyInto(sArray);
        return sArray;
    }

    public static String[] stringToList(String sProps) {
        Vector<String> vect = new Vector<String>();
        int iBegin = sProps.indexOf("{");
        int iEnd = sProps.lastIndexOf("}");
        if (iBegin != -1 && iEnd != -1) {
            StringTokenizer tokenizer = new StringTokenizer(sProps.substring(iBegin + 1, iEnd), "{");
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                if ((next = next.trim()).endsWith(",")) {
                    next = next.substring(0, next.length() - 1);
                    next = next.trim();
                }
                if (!next.endsWith("}")) continue;
                vect.addElement(next.substring(0, next.length() - 1));
            }
        }
        Object[] sArray = new String[vect.size()];
        vect.copyInto(sArray);
        return sArray;
    }
}

