/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.lib.HttpCookie;

public class Cookies {
    private static final int MAX_APP_COOKIES = 4;
    private static final int MAX_COOKIES = 8;
    private ArrayObject cookies = new ArrayObject(4, 2);
    private HttpCookie sessionCookie = new HttpCookie();
    private ArrayObject applicationCookies = new ArrayObject(2, 2);

    public void reset() {
        if (this.cookies.size() > 8) {
            this.cookies = new ArrayObject(4, 2);
        } else {
            this.cookies.clear();
        }
        if (this.applicationCookies.size() > 4) {
            this.applicationCookies = new ArrayObject(2, 2);
        } else {
            this.applicationCookies.clear();
        }
        this.sessionCookie.setName(null);
    }

    public void init(Cookies oldCookies) {
        this.sessionCookie.setName(oldCookies.sessionCookie.getName());
        this.sessionCookie.setValue(oldCookies.sessionCookie.getValue());
        this.sessionCookie.setComment(oldCookies.sessionCookie.getComment());
        this.sessionCookie.setDomain(oldCookies.sessionCookie.getDomain());
        this.sessionCookie.setMaxAge(oldCookies.sessionCookie.getMaxAge());
        this.sessionCookie.setPath(oldCookies.sessionCookie.getPath());
        this.sessionCookie.setSecure(oldCookies.sessionCookie.getSecure());
        this.sessionCookie.setVersion(oldCookies.sessionCookie.getVersion());
        int i = 0;
        while (i < oldCookies.cookies.size()) {
            this.cookies.add(oldCookies.cookies.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < oldCookies.applicationCookies.size()) {
            this.applicationCookies.add(oldCookies.applicationCookies.elementAt(i2));
            ++i2;
        }
    }

    public HttpCookie getSessionCookie() {
        return this.sessionCookie;
    }

    public HttpCookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.cookies.size()) {
            HttpCookie httpCookie = (HttpCookie)this.cookies.elementAt(i);
            if (name.equalsIgnoreCase(httpCookie.getName())) {
                return httpCookie;
            }
            ++i;
        }
        return null;
    }

    public ArrayObject getCookies() {
        return this.cookies;
    }

    public int getCookiesSize() {
        return this.cookies.size();
    }

    public HttpCookie getCookie(int ind) {
        return (HttpCookie)this.cookies.elementAt(ind);
    }

    public HttpCookie getApplicationCookie(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.applicationCookies.size()) {
            HttpCookie httpCookie = (HttpCookie)this.applicationCookies.elementAt(i);
            if (name.equalsIgnoreCase(httpCookie.getName())) {
                return httpCookie;
            }
            ++i;
        }
        return null;
    }

    public ArrayObject getApplicationCookies() {
        return this.applicationCookies;
    }

    public int getApplicationCookiesSize() {
        return this.applicationCookies.size();
    }

    public HttpCookie getApplicationCookie(int ind) {
        return (HttpCookie)this.applicationCookies.elementAt(ind);
    }
}

