/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CookieUtils {
    private static final byte[] comment = "; Comment=".getBytes();
    private static final byte[] domain = "; Domain=".getBytes();
    private static final byte[] expires = "; Expires=".getBytes();
    private static final byte[] maxAge = "; Max-Age=".getBytes();
    private static final byte[] discard = "; Discard".getBytes();
    private static final byte[] path = "; Path=".getBytes();
    private static final byte[] secure = "; Secure".getBytes();
    private static final byte[] versionS = "; Version=1".getBytes();
    private static final byte[] s_c = "Set-Cookie: ".getBytes();
    private static final byte[] rn = "\r\n".getBytes();
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final Locale locale = Locale.US;
    private static final SimpleDateFormat simpledateformat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", locale);

    public static byte[] getCookieHeader(HttpCookie cookie) {
        int version = cookie.getVersion();
        if (cookie.getValue() == null) {
            cookie.setValue("null");
        }
        byte[] retValue = Ascii.getBytes(cookie.getName());
        byte[] temp = new byte[]{61};
        retValue = ByteArrayUtils.append(retValue, temp);
        retValue = ByteArrayUtils.append(retValue, Ascii.getBytes(cookie.getValue()));
        if (version == 1) {
            retValue = ByteArrayUtils.append(retValue, versionS);
            if (cookie.getComment() != null) {
                retValue = ByteArrayUtils.append(retValue, comment);
                retValue = ByteArrayUtils.append(retValue, Ascii.getBytes(cookie.getComment()));
            }
        }
        if (cookie.getDomain() != null) {
            retValue = ByteArrayUtils.append(retValue, domain);
            retValue = ByteArrayUtils.append(retValue, Ascii.getBytes(cookie.getDomain()));
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                retValue = ByteArrayUtils.append(retValue, expires);
                if (cookie.getMaxAge() == 0) {
                    temp = CookieUtils.getCookieExpiry(0L);
                    retValue = ByteArrayUtils.append(retValue, temp);
                } else {
                    temp = CookieUtils.getCookieExpiry(cookie.getMaxAge());
                    retValue = ByteArrayUtils.append(retValue, temp);
                }
            } else if (cookie.getMaxAge() >= 0) {
                retValue = ByteArrayUtils.append(retValue, maxAge);
                temp = CookieUtils.getCookieExpiry(cookie.getMaxAge());
                retValue = ByteArrayUtils.append(retValue, temp);
            }
        }
        if (cookie.getPath() != null) {
            retValue = ByteArrayUtils.append(retValue, path);
            retValue = ByteArrayUtils.append(retValue, Ascii.getBytes(cookie.getPath()));
        }
        if (cookie.getSecure()) {
            retValue = ByteArrayUtils.append(retValue, secure);
        }
        return ByteArrayUtils.append(s_c, retValue);
    }

    public static byte[] getAllCookieHeaders(ArrayObject cookies) {
        if (cookies != null) {
            Object[] enumeration = cookies.toArray();
            byte[] cookieHeaders = new byte[]{};
            int i = 0;
            while (enumeration != null && i < enumeration.length) {
                byte[] oneHeader = CookieUtils.getCookieHeader((HttpCookie)enumeration[i]);
                cookieHeaders = ByteArrayUtils.append(cookieHeaders, oneHeader);
                cookieHeaders = ByteArrayUtils.append(cookieHeaders, rn);
                ++i;
            }
            return cookieHeaders;
        }
        return null;
    }

    private static byte[] getCookieExpiry(long l) {
        long time = 0L;
        if (l != 0L) {
            time = System.currentTimeMillis() + l * 1000L;
        }
        if (time == 0L) {
            return simpledateformat.format(new Date(10000L)).getBytes();
        }
        return simpledateformat.format(new Date(time)).getBytes();
    }

    static {
        simpledateformat.setTimeZone(GMT_ZONE);
    }
}

