/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.lib;

import com.sap.engine.services.httpserver.lib.Cookies;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.CharArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;

public class CookieParser {
    public static final String jsessionid_cookie = "JSESSIONID";
    public static final byte[] jsessionid_cookie_ = "JSESSIONID".getBytes();
    public static final String jsessionid_url = "jsessionid";
    public static final byte[] jsessionid_url_ = "jsessionid".getBytes();
    public static final String jsessionid_url_sep = ";jsessionid=";
    public static final byte[] jsessionid_url_sep_ = ";jsessionid=".getBytes();
    public static String app_cookie_prefix = "saplb_";
    public static byte[] app_cookie_prefix_ = app_cookie_prefix.getBytes();
    public static String app_cookie_prefix_old = "sapj2ee_";
    public static byte[] app_cookie_prefix_old_ = app_cookie_prefix_old.getBytes();
    private static final byte attribute_prefix = 36;
    private static final byte[] comment = "Comment".getBytes();
    private static final byte[] discard = "Discard".getBytes();
    private static final byte[] domain = "Domain".getBytes();
    private static final byte[] expires = "Expires".getBytes();
    private static final byte[] max_age = "Max-Age".getBytes();
    private static final byte[] path = "Path".getBytes();
    private static final byte[] secure = "Secure".getBytes();
    private static final byte[] version = "Version".getBytes();
    private static final byte cookie_separator_old = 59;
    private static final byte cookie_separator_new = 44;

    public static void parseCookies(MimeHeaders headers, boolean urlSessionTracking, Cookies cookies) {
        String[] cookie = headers.getHeaders("Cookie");
        if (cookie == null) {
            return;
        }
        int i = 0;
        while (i < cookie.length) {
            if (cookie[i] != null && cookie[i].length() != 0) {
                int cookieHeaderVersion = -1;
                byte[] cookieHeader = Ascii.getBytes(cookie[i]);
                int off = 0;
                int len = 0;
                int j = 0;
                while (cookieHeader[j] == 32) {
                    ++j;
                }
                if (cookieHeader[j] == 36 && ByteArrayUtils.startsWith(cookieHeader, j + 1, cookieHeader.length - j - 1, version) && cookieHeader.length > j + 1 + version.length && cookieHeader[j + 1 + version.length] == 61) {
                    int versionOffset = j += version.length + 2;
                    while (j < cookieHeader.length) {
                        if (cookieHeader[j] == 59 || cookieHeader[j] == 44) {
                            cookieHeaderVersion = Ascii.asciiArrToIntNoException(cookieHeader, versionOffset, j - versionOffset);
                            break;
                        }
                        ++j;
                    }
                }
                while (j <= cookieHeader.length) {
                    if (j == cookieHeader.length || cookieHeader[j] == 44 || cookieHeader[j] == 59) {
                        int valueOff = ByteArrayUtils.indexOf(cookieHeader, off, len, (byte)61) + 1;
                        if (valueOff != 0) {
                            boolean quotes = false;
                            if (len - valueOff > 0 && cookieHeader[off + valueOff] == 34 && cookieHeader[off + len - 1] == 34) {
                                quotes = true;
                            }
                            HttpCookie newCookie = null;
                            if (!CookieParser.isReserved(cookieHeader, off, valueOff - 1)) {
                                newCookie = quotes ? new HttpCookie(new String(cookieHeader, off, valueOff - 1), new String(cookieHeader, off + valueOff + 1, len - valueOff - 2)) : new HttpCookie(new String(cookieHeader, off, valueOff - 1), new String(cookieHeader, off + valueOff, len - valueOff));
                                ++j;
                                while (j < cookieHeader.length && cookieHeader[j] == 32) {
                                    ++j;
                                }
                                if (j < cookieHeader.length && cookieHeader[j] == 36 && ByteArrayUtils.startsWith(cookieHeader, j + 1, cookieHeader.length - j - 1, path)) {
                                    if (cookieHeader.length > j + 1 + path.length && cookieHeader[j + 1 + path.length] == 61) {
                                        j += path.length + 2;
                                    }
                                    int pathOffset = j;
                                    while (j < cookieHeader.length) {
                                        if (cookieHeader[j] == 59 || cookieHeader[j] == 44) break;
                                        ++j;
                                    }
                                    newCookie.setPath(new String(cookieHeader, pathOffset, j - pathOffset));
                                    ++j;
                                }
                                if (j < cookieHeader.length && cookieHeader[j - 1] == 59) {
                                    while (j < cookieHeader.length && cookieHeader[j] == 32) {
                                        ++j;
                                    }
                                }
                                if (j < cookieHeader.length && cookieHeader[j] == 36 && ByteArrayUtils.startsWith(cookieHeader, j + 1, cookieHeader.length - j - 1, domain)) {
                                    if (cookieHeader.length > j + 1 + domain.length && cookieHeader[j + 1 + domain.length] == 61) {
                                        j += domain.length + 2;
                                    }
                                    int domainOffset = j;
                                    while (j < cookieHeader.length) {
                                        if (cookieHeader[j] == 59 || cookieHeader[j] == 44) break;
                                        ++j;
                                    }
                                    newCookie.setDomain(new String(cookieHeader, domainOffset, j - domainOffset));
                                }
                                --j;
                                newCookie.setVersion(cookieHeaderVersion);
                                cookies.getCookies().add((Object)newCookie);
                            }
                            if (cookies.getSessionCookie().getName() == null && !urlSessionTracking && ByteArrayUtils.equalsBytes(cookieHeader, off, valueOff - 1, jsessionid_cookie_)) {
                                if (quotes) {
                                    if (CookieParser.isValidSessionCookieValue(cookieHeader, off + valueOff + 1, len - valueOff - 2)) {
                                        cookies.getSessionCookie().setName(newCookie.getName());
                                        cookies.getSessionCookie().setValue(newCookie.getValue());
                                    }
                                } else if (CookieParser.isValidSessionCookieValue(cookieHeader, off + valueOff, len - valueOff)) {
                                    cookies.getSessionCookie().setName(newCookie.getName());
                                    cookies.getSessionCookie().setValue(newCookie.getValue());
                                }
                            }
                            if (ByteArrayUtils.startsWithIgnoreCase(cookieHeader, off, valueOff - 1, app_cookie_prefix_)) {
                                cookies.getApplicationCookies().add(newCookie);
                            }
                        }
                        off = j + 1;
                        len = 0;
                    } else if (cookieHeader[j] == 32 && len == 0) {
                        ++off;
                    } else {
                        ++len;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void parseCookiesFromURL(MessageBytes fullRequestURI, Cookies cookies) {
        int begInd = fullRequestURI.indexOf(jsessionid_url_sep_);
        if (begInd == -1) {
            return;
        }
        begInd += 12;
        int endInd = fullRequestURI.indexOf('?');
        if (endInd == -1) {
            endInd = fullRequestURI.length();
        } else if (endInd < begInd) {
            return;
        }
        int nextCookieInd = fullRequestURI.indexOf(';', begInd);
        if (nextCookieInd > 0 && nextCookieInd < endInd) {
            endInd = nextCookieInd;
        }
        if (fullRequestURI.charAt(begInd) == '\"' && fullRequestURI.charAt(endInd - 1) == '\"') {
            ++begInd;
            --endInd;
        }
        if (fullRequestURI.length() == begInd) {
            return;
        }
        byte[] value = fullRequestURI.getBytes(begInd, endInd - begInd);
        if (cookies.getSessionCookie().getName() == null && CookieParser.isValidSessionCookieValue(value, 0, value.length)) {
            cookies.getSessionCookie().setName(jsessionid_url);
            cookies.getSessionCookie().setValue(new String(value));
        }
        if (++endInd < fullRequestURI.length()) {
            CookieParser.parseApplicationCookies(fullRequestURI.getBytes(endInd), cookies);
        }
    }

    public static HttpCookie createSessionCookie(String val, String domainName, WebCookieConfig cookieConfig) {
        return CookieParser.createCookie(jsessionid_cookie, val, domainName, cookieConfig);
    }

    public static HttpCookie createCookie(String name, String val, String hostName, WebCookieConfig cookieConfig) {
        HttpCookie cok = null;
        byte[] nameBytes = Ascii.getBytes(name);
        if (CookieParser.isReserved(nameBytes, 0, nameBytes.length)) {
            return null;
        }
        cok = new HttpCookie(name, val);
        cok.setMaxAge(cookieConfig.getMaxAge());
        cok.setVersion(1);
        CookieParser.setCookieDomain(cok, hostName, cookieConfig);
        CookieParser.setCookiePath(cok, cookieConfig);
        return cok;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isValidSessionCookieValue(byte[] arr, int off, int len) {
        block12: {
            beg = 0;
            if (len < 8) {
                return false;
            }
            quotes = false;
            if (arr[off + beg] == 34) {
                quotes = true;
                ++beg;
            }
            if (arr[off + beg] == 40) {
                while (beg < len) {
                    if (arr[off + beg] == 41) {
                        ++beg;
                        break;
                    }
                    ++beg;
                }
                if (beg == len) {
                    return false;
                }
            }
            if (arr[off + beg] != 73 || arr[off + beg + 1] != 68) break block12;
            beg += 2;
            wrongValue = false;
            while (beg < len - 1 && arr[off + beg] != 68) {
                if (arr[off + beg] == 59 || arr[off + beg] == 44) {
                    wrongValue = true;
                    break;
                }
                ++beg;
            }
            if (wrongValue) break block12;
            if (++beg < len - 5 && arr[off + beg] == 66) ** GOTO lbl33
            return false;
lbl-1000:
            // 1 sources

            {
                if (arr[off + beg] == 59 || arr[off + beg] == 44) {
                    wrongValue = true;
                    break;
                }
                ++beg;
lbl33:
                // 2 sources

                ** while (beg < len && arr[off + beg] != 69)
            }
lbl34:
            // 2 sources

            if (!wrongValue) {
                if (++beg + 1 >= len) {
                    return false;
                }
                return arr[off + beg] == 110 && arr[off + beg + 1] == 100 && (quotes == false || beg + 2 < len && arr[off + beg + 2] == 34);
            }
        }
        return false;
    }

    private static void parseApplicationCookies(byte[] url, Cookies cookies) {
        String value;
        String key;
        int nameOff = 0;
        int valueOff = -1;
        int nameLen = -1;
        int off = 0;
        while (off < url.length) {
            if (url[off] == 59) {
                if (nameOff > -1 && nameLen > -1 && valueOff > -1 && CookieParser.isApplicationCookie(url, valueOff, off - valueOff) && !CookieParser.isReserved(url, nameOff, nameLen)) {
                    key = new String(url, nameOff, nameLen);
                    value = new String(url, valueOff, off - valueOff);
                    cookies.getApplicationCookies().add((Object)new HttpCookie(key, value));
                }
                nameOff = off + 1;
                nameLen = -1;
                valueOff = -1;
            } else {
                if (url[off] == 32) {
                    if (nameOff <= -1 || nameLen <= -1 || valueOff <= -1 || !CookieParser.isApplicationCookie(url, valueOff, off - valueOff) || CookieParser.isReserved(url, nameOff, nameLen)) break;
                    key = new String(url, nameOff, nameLen);
                    value = new String(url, valueOff, off - valueOff);
                    cookies.getApplicationCookies().add((Object)new HttpCookie(key, value));
                    break;
                }
                if (url[off] == 61) {
                    nameLen = off - nameOff;
                    valueOff = off + 1;
                }
            }
            ++off;
        }
        if (nameOff > -1 && nameLen > -1 && valueOff > -1 && CookieParser.isApplicationCookie(url, valueOff, off - valueOff) && !CookieParser.isReserved(url, nameOff, nameLen)) {
            key = new String(url, nameOff, nameLen);
            value = new String(url, valueOff, off - valueOff);
            cookies.getApplicationCookies().add((Object)new HttpCookie(key, value));
        }
    }

    private static boolean isApplicationCookie(byte[] value, int off, int len) {
        return Ascii.asciiArrToIntNoException(value, off, len) != -1;
    }

    private static boolean isReserved(byte[] cookieName, int off, int len) {
        return ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, comment) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, discard) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, domain) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, expires) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, max_age) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, path) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, secure) || ByteArrayUtils.equalsIgnoreCase(cookieName, off, len, version);
    }

    private static void setCookieDomain(HttpCookie cok, String hostName, WebCookieConfig cookieConfig) {
        if (cookieConfig.getDomainType() == 1) {
            return;
        }
        if (cookieConfig.getDomainType() == 8) {
            cok.setDomain(cookieConfig.getDomain());
            return;
        }
        boolean isIP = true;
        int points = 0;
        boolean domainHasPort = false;
        char[] domain = hostName.toCharArray();
        int ind = CharArrayUtils.indexOf(domain, ':');
        if (ind > 0) {
            domainHasPort = true;
            char[] tmpDomain = new char[ind];
            System.arraycopy(domain, 0, tmpDomain, 0, ind);
            domain = tmpDomain;
        }
        int i = 0;
        while (i < domain.length) {
            if (domain[i] == '.') {
                ++points;
            } else if (!Character.isDigit(domain[i])) {
                isIP = false;
                break;
            }
            ++i;
        }
        if (isIP && points == 3) {
            if (domainHasPort) {
                cok.setDomain(new String(domain));
            } else {
                cok.setDomain(hostName);
            }
        } else {
            int dotInd = CharArrayUtils.indexOf(domain, '.');
            if (dotInd >= 0 && CharArrayUtils.indexOf(domain, '.', dotInd) >= 0) {
                cok.setDomain(new String(domain, dotInd, domain.length - dotInd));
            }
        }
    }

    private static void setCookiePath(HttpCookie cok, WebCookieConfig cookieConfig) {
        if (cookieConfig.getPathType() == 1) {
            return;
        }
        cok.setPath(cookieConfig.getPath());
    }
}

