/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.interfaces;

public class ErrorData
implements Cloneable {
    private boolean errorByCode = false;
    private int errorCode = -1;
    private String message = null;
    private String additionalMessage = null;
    private Throwable exception = null;

    public ErrorData(int errorCode, String message, String additionalMessage) {
        this.errorByCode = true;
        this.errorCode = errorCode;
        this.message = message;
        if (additionalMessage == null) {
            additionalMessage = "";
        }
        this.additionalMessage = additionalMessage;
    }

    public Object clone() {
        if (this.errorByCode) {
            return new ErrorData(this.errorCode, this.message, this.additionalMessage);
        }
        return new ErrorData(this.exception);
    }

    public boolean isErrorByCode() {
        return this.errorByCode;
    }

    public ErrorData(Throwable exception) {
        this.errorByCode = false;
        this.exception = exception;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message + this.additionalMessage;
    }

    public String getMainMessage() {
        return this.message;
    }

    public String getAdditionalMessage() {
        return this.additionalMessage;
    }

    public Throwable getException() {
        return this.exception;
    }
}

