/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.gui;

import com.sap.engine.services.httpserver.Zone;
import com.sap.engine.services.httpserver.ZoneManagementInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ZonesConfigurator
implements ListSelectionListener,
ActionListener {
    private ZoneManagementInterface zoneManagementInterface = null;
    private JList zonesList = null;
    private JList serversList = null;
    private JList aliasesList = null;
    private JButton addZoneButton = null;
    private JButton removeZoneButton = null;
    private JButton addServerButton = null;
    private JButton removeServerButton = null;
    private JButton addAliasButton = null;
    private JButton removeAliasButton = null;

    public void setZonesManagementInterface(ZoneManagementInterface zoneManagementInterface) {
        this.zoneManagementInterface = zoneManagementInterface;
        this.refresh();
    }

    public void setZonesList(JList zonesList) {
        this.zonesList = zonesList;
    }

    public void setServersList(JList serversList) {
        this.serversList = serversList;
    }

    public void setAliasesList(JList aliasesList) {
        this.aliasesList = aliasesList;
    }

    public void setZoneButtons(JButton addZoneButton, JButton removeZoneButton) {
        this.addZoneButton = addZoneButton;
        this.removeZoneButton = removeZoneButton;
        removeZoneButton.setEnabled(false);
    }

    public void setServerButtons(JButton addServerButton, JButton removeServerButton) {
        this.addServerButton = addServerButton;
        this.removeServerButton = removeServerButton;
        addServerButton.setEnabled(false);
        removeServerButton.setEnabled(false);
    }

    public void setAliasButtons(JButton addAliasButton, JButton removeAliasButton) {
        this.addAliasButton = addAliasButton;
        this.removeAliasButton = removeAliasButton;
        addAliasButton.setEnabled(false);
        removeAliasButton.setEnabled(false);
    }

    public void actionPerformed(ActionEvent ae) {
        block35: {
            try {
                if (ae.getActionCommand().equals("Refresh")) {
                    this.refresh();
                    break block35;
                }
                if (ae.getActionCommand().equals("Add Zone")) {
                    String zoneName = JOptionPane.showInputDialog(null, "Enter a new zone name:", "Enter", -1);
                    if (zoneName == null) {
                        JOptionPane.showMessageDialog(null, "Please, specify a zone to add!");
                        return;
                    }
                    try {
                        this.zoneManagementInterface.registerZone(zoneName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Cannot register zone [" + zoneName + "]! " + e);
                        return;
                    }
                    this.refresh();
                    break block35;
                }
                if (ae.getActionCommand().equals("Remove Zone")) {
                    String zoneName = (String)this.zonesList.getSelectedValue();
                    if (zoneName == null) {
                        JOptionPane.showMessageDialog(null, "Please, select a zone to remove!");
                        return;
                    }
                    try {
                        this.zoneManagementInterface.unregisterZone(zoneName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Error unregistering zone [" + zoneName + "]! " + e);
                        return;
                    }
                    this.refresh();
                    break block35;
                }
                if (ae.getActionCommand().equals("Add Server")) {
                    String serverId = JOptionPane.showInputDialog(null, "Enter a new server ID:", "Enter", -1);
                    if (serverId == null) {
                        JOptionPane.showMessageDialog(null, "Please, specify a server id to add!");
                        return;
                    }
                    int serverIdInt = -1;
                    try {
                        serverIdInt = Integer.valueOf(serverId);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Please, specify a valid server id! " + e);
                        return;
                    }
                    if (serverIdInt <= 0) {
                        JOptionPane.showMessageDialog(null, "Please, specify a valid positive server id! ");
                        return;
                    }
                    String zoneName = (String)this.zonesList.getSelectedValue();
                    if (zoneName == null) {
                        JOptionPane.showMessageDialog(null, "Please, select a zone!");
                        return;
                    }
                    try {
                        this.zoneManagementInterface.getZone(zoneName).addServer(serverIdInt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Cannot add server id [" + serverIdInt + "] to zone [" + zoneName + "]! " + e);
                        return;
                    }
                    this.setActive(zoneName);
                    break block35;
                }
                if (ae.getActionCommand().equals("Remove Server")) {
                    String zoneName = (String)this.zonesList.getSelectedValue();
                    if (zoneName == null) {
                        JOptionPane.showMessageDialog(null, "Please, select a zone!");
                        return;
                    }
                    Integer serverId = (Integer)this.serversList.getSelectedValue();
                    if (serverId == null) {
                        JOptionPane.showMessageDialog(null, "Please, select a server to remove!");
                        return;
                    }
                    try {
                        Zone zone = this.zoneManagementInterface.getZone(zoneName);
                        zone.removeServer(serverId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Error unregistering server from zone [" + zoneName + "]! " + e);
                        return;
                    }
                    this.setActive(zoneName);
                    break block35;
                }
                if (ae.getActionCommand().equals("Add Alias")) {
                    String aliasName = JOptionPane.showInputDialog(null, "Enter a new alias ID:", "Enter", -1);
                    if (aliasName == null) {
                        JOptionPane.showMessageDialog(null, "Please, specify an alias to add!");
                        return;
                    }
                    String zoneName = (String)this.zonesList.getSelectedValue();
                    if (zoneName == null) {
                        JOptionPane.showMessageDialog(null, "Please, select a zone!");
                        return;
                    }
                    try {
                        this.zoneManagementInterface.getZone(zoneName).addAlias(aliasName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Cannot add alias [" + aliasName + "] to zone [" + zoneName + "]! " + e);
                        return;
                    }
                    this.setActive(zoneName);
                    break block35;
                }
                if (!ae.getActionCommand().equals("Remove Alias")) break block35;
                String zoneName = (String)this.zonesList.getSelectedValue();
                if (zoneName == null) {
                    JOptionPane.showMessageDialog(null, "Please, select a zone!");
                    return;
                }
                String alias = (String)this.aliasesList.getSelectedValue();
                if (alias == null) {
                    JOptionPane.showMessageDialog(null, "Please, select an alias to remove!");
                    return;
                }
                try {
                    Zone zone = this.zoneManagementInterface.getZone(zoneName);
                    zone.removeAlias(alias);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error unregistering alias from zone [" + zoneName + "]! " + e);
                    return;
                }
                this.setActive(zoneName);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Unexpected error! " + e);
                return;
            }
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        try {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            if (lse.getSource().equals(this.zonesList)) {
                String selected = (String)this.zonesList.getSelectedValue();
                this.removeZoneButton.setEnabled(selected != null);
                if (selected == null) {
                    this.serversList.setListData(new Integer[0]);
                    this.aliasesList.setListData(new String[0]);
                } else {
                    this.setActive(selected);
                }
            } else if (lse.getSource().equals(this.serversList)) {
                Integer selected = (Integer)this.serversList.getSelectedValue();
                this.removeServerButton.setEnabled(selected != null);
            } else if (lse.getSource().equals(this.aliasesList)) {
                String selected = (String)this.aliasesList.getSelectedValue();
                this.removeAliasButton.setEnabled(selected != null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unexpected error! " + e);
            return;
        }
    }

    private void refresh() {
        this.zonesList.setListData(new String[0]);
        this.serversList.setListData(new Integer[0]);
        this.aliasesList.setListData(new String[0]);
        try {
            Zone[] zones = this.zoneManagementInterface.getAllZones();
            if (zones == null) {
                zones = new Zone[]{};
            }
            String[] zoneNames = new String[zones.length];
            int i = 0;
            while (i < zoneNames.length) {
                zoneNames[i] = zones[i].getZoneName();
                ++i;
            }
            this.zonesList.setListData(zoneNames);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot read available zones from server! " + e);
            return;
        }
        this.removeZoneButton.setEnabled(false);
        this.addServerButton.setEnabled(false);
        this.removeServerButton.setEnabled(false);
        this.addAliasButton.setEnabled(false);
        this.removeAliasButton.setEnabled(false);
    }

    private void setActive(String zoneName) {
        this.zonesList.setSelectedValue(zoneName, false);
        Zone activeZone = null;
        try {
            activeZone = this.zoneManagementInterface.getZone(zoneName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot read zone [" + zoneName + "] from server! " + e);
            return;
        }
        if (activeZone == null) {
            JOptionPane.showMessageDialog(null, "Zone [" + zoneName + "] not found!");
            return;
        }
        this.serversList.setListData(new Integer[0]);
        try {
            int[] servers = activeZone.getServers();
            if (servers == null) {
                servers = new int[]{};
            }
            Integer[] serversObj = new Integer[servers.length];
            int i = 0;
            while (i < serversObj.length) {
                serversObj[i] = new Integer(servers[i]);
                ++i;
            }
            this.serversList.setListData(serversObj);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot get servers for zone [" + zoneName + "] from server! " + e);
        }
        this.aliasesList.setListData(new String[0]);
        try {
            this.aliasesList.setListData(activeZone.getAliases());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot get aliases for zone [" + zoneName + "] from server! " + e);
        }
        this.removeZoneButton.setEnabled(true);
        this.addServerButton.setEnabled(true);
        this.removeServerButton.setEnabled(false);
        this.addAliasButton.setEnabled(true);
        this.removeAliasButton.setEnabled(false);
    }
}

