/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.editorproperties.PropertyEditor;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.httpserver.gui.AliasTable;
import com.sap.engine.services.httpserver.gui.AliasTableModel;
import com.sap.engine.services.httpserver.gui.HttpImageHolder;
import com.sap.engine.services.httpserver.gui.RowChangedListener;
import com.sap.engine.services.httpserver.gui.ZonesConfigurator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class HttpRuntimeView
extends JPanel
implements ActionListener,
ListSelectionListener,
DocumentListener,
VisualRuntimeControl,
RowChangedListener {
    protected static final String ENABLE_ZIPPED_RESPONSE_CHECKBOX_CMD = "ENABLE ZIPPED RESPONSE";
    protected static final String USE_CACHE_CHECKBOX_CMD = "USE CACHE";
    protected static final String ADD_HOST_CMD = "add host cmd";
    protected static final String ADD_NEW_HOST_CMD = "add new host cmd";
    protected static final String ADD_COPY_HOST_CMD = "add copy new host cmd";
    protected static final String REMOVE_HOST_CMD = "remove host cmd";
    protected static final String CLEAR_CACHE_CMD = "claer cache cmd";
    protected static final String CLEAR_HOST_CACHE_CMD = "claer host cache cmd";
    protected static final String RESET_PROPS_CMD = "reset cmd";
    protected static final String SET_ALL_HOST_CMD = "set all host cmd";
    protected static final String CERT_NO_SSL_CMD = "CERT NO SSL CMD";
    protected static final String SET_CERT_HEADER = "SET CERT HEADER";
    protected JList hostsList;
    protected JButton addHostBtn;
    protected JButton removeHostBtn;
    protected Vector appListData;
    protected JLabel rootLabel;
    protected JTextField rootField;
    protected JLabel startPageLabel;
    protected JTextField startPageField;
    protected PropertyEditor aliasesEditor;
    protected AliasTable applAliasesTable;
    protected AliasTableModel aliasModel;
    protected JButton[] runtimeButtons = new JButton[4];
    protected JButton resetBtn;
    protected JButton setAllHostsBtn;
    protected JButton clearCacheBtn;
    protected JButton newHostBtn;
    protected JButton clearHostCacheButton;
    protected JCheckBox enableLogCheckBox;
    protected JCheckBox dirListCheckBox;
    protected JCheckBox useCacheCheckBox;
    protected JCheckBox keepAliveCheckBox;
    protected JLabel extraLayersLabel;
    protected JTextField extraLayersField;
    protected JLabel keepAliveTimeoutLabel;
    protected CScrollField keepAliveTimeoutField;
    protected ZonesConfigurator zonesConfigurator = new ZonesConfigurator();

    public HttpRuntimeView() {
        this.initView();
        LookAndFeelHandler.add((Component)this);
    }

    protected void initView() {
        this.clearCacheBtn = new JButton(HttpImageHolder.clearIcon);
        this.clearCacheBtn.setToolTipText("Clear Cache on All Hosts");
        this.clearCacheBtn.setActionCommand(CLEAR_CACHE_CMD);
        this.clearCacheBtn.addActionListener(this);
        this.runtimeButtons[0] = this.clearCacheBtn;
        this.newHostBtn = new JButton("New Host");
        this.newHostBtn.setToolTipText("Add New Host with Default Properties");
        this.newHostBtn.setActionCommand(ADD_NEW_HOST_CMD);
        this.newHostBtn.addActionListener(this);
        this.runtimeButtons[1] = this.newHostBtn;
        this.newHostBtn = new JButton("Copy Host");
        this.newHostBtn.setToolTipText("Add New Host with Properties of the Selected Host");
        this.newHostBtn.setActionCommand(ADD_COPY_HOST_CMD);
        this.newHostBtn.addActionListener(this);
        this.runtimeButtons[2] = this.newHostBtn;
        this.removeHostBtn = new JButton("Remove Host");
        this.removeHostBtn.setActionCommand(REMOVE_HOST_CMD);
        this.removeHostBtn.setToolTipText("Remove Host");
        this.removeHostBtn.addActionListener(this);
        this.runtimeButtons[3] = this.removeHostBtn;
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, true, this.getHostsPanel(), this.getPropertiesPanel());
        splitPane.setDividerLocation(0.1);
        splitPane.setResizeWeight(0.5);
        JTabbedPane root = new JTabbedPane();
        JPanel zonesPanel = this.initZonesPanel();
        root.add(" Virtual Hosts ", splitPane);
        root.add(" Zones ", zonesPanel);
        this.add(root);
    }

    private JPanel initZonesPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JPanel main = new JPanel(new BorderLayout());
        result.add((Component)main, new GridBagConstraints(0, 14, 2, 2, 0.8, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add((Component)this.getButtonsPanel(), new GridBagConstraints(0, 16, 1, 1, 0.2, 0.2, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JSplitPane zonesPanel = new JSplitPane(1, true, this.getZonesListPanel(), this.getZonesPropertiesPanel());
        zonesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        zonesPanel.setDividerLocation(0.1);
        zonesPanel.setResizeWeight(0.2);
        main.add(zonesPanel);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new FlowLayout());
        JButton add = new JButton("Add Zone");
        add.setActionCommand("Add Zone");
        add.addActionListener(this.zonesConfigurator);
        JButton remove = new JButton("Remove Zone");
        remove.setActionCommand("Remove Zone");
        remove.addActionListener(this.zonesConfigurator);
        JButton refresh = new JButton("Refresh");
        refresh.setActionCommand("Refresh");
        refresh.addActionListener(this.zonesConfigurator);
        this.zonesConfigurator.setZoneButtons(add, remove);
        result.add(add);
        result.add(remove);
        result.add(refresh);
        return result;
    }

    private JPanel getZonesListPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Zones "));
        JList zonesList = new JList();
        zonesList.getSelectionModel().setSelectionMode(0);
        this.zonesConfigurator.setZonesList(zonesList);
        zonesList.addListSelectionListener(this.zonesConfigurator);
        JScrollPane scroll = new JScrollPane(zonesList);
        scroll.setPreferredSize(new Dimension(20, 40));
        result.add((Component)scroll, "Center");
        return result;
    }

    private JPanel getZonesPropertiesPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Configurations "));
        JPanel servers = new JPanel(new GridBagLayout());
        servers.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Server IDs "));
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton addServer = new JButton("Add Server");
        addServer.setActionCommand("Add Server");
        addServer.addActionListener(this.zonesConfigurator);
        buttonsPanel.add(addServer);
        JButton removeServer = new JButton("Remove Server");
        removeServer.setActionCommand("Remove Server");
        removeServer.addActionListener(this.zonesConfigurator);
        this.zonesConfigurator.setServerButtons(addServer, removeServer);
        buttonsPanel.add(removeServer);
        JList serversList = new JList();
        this.zonesConfigurator.setServersList(serversList);
        serversList.addListSelectionListener(this.zonesConfigurator);
        servers.add(serversList, new GridBagConstraints(1, 10, 2, 2, 0.8, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        servers.add((Component)buttonsPanel, new GridBagConstraints(1, 12, 1, 1, 0.1, 0.1, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel aliases = new JPanel(new GridBagLayout());
        aliases.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Aliases "));
        buttonsPanel = new JPanel(new FlowLayout());
        JButton addAliasServer = new JButton("Add Alias");
        addAliasServer.setActionCommand("Add Alias");
        addAliasServer.addActionListener(this.zonesConfigurator);
        buttonsPanel.add(addAliasServer);
        JButton removeAlias = new JButton("Remove Alias");
        removeAlias.setActionCommand("Remove Alias");
        removeAlias.addActionListener(this.zonesConfigurator);
        this.zonesConfigurator.setAliasButtons(addAliasServer, removeAlias);
        buttonsPanel.add(removeAlias);
        JList aliaseList = new JList();
        this.zonesConfigurator.setAliasesList(aliaseList);
        aliaseList.addListSelectionListener(this.zonesConfigurator);
        aliases.add(aliaseList, new GridBagConstraints(1, 10, 2, 2, 0.8, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        aliases.add((Component)buttonsPanel, new GridBagConstraints(1, 12, 1, 1, 0.1, 0.1, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add((Component)servers, new GridBagConstraints(1, 0, 2, 2, 0.8, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add((Component)aliases, new GridBagConstraints(5, 0, 2, 2, 0.8, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    protected JPanel getHostsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Hosts "));
        this.hostsList = new JList();
        this.hostsList.getSelectionModel().setSelectionMode(0);
        this.hostsList.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.hostsList);
        scroll.setPreferredSize(new Dimension(20, 40));
        result.add((Component)scroll, "Center");
        return result;
    }

    protected JPanel getPropertiesPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Properties "));
        result.add((Component)this.getLocationPanel(), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("General", this.getGeneralPanel());
        tabbedPane.add("Aliases", this.getAliasesPanel());
        tabbedPane.add("Application Aliases", this.getAppAliasesPanel());
        result.add((Component)tabbedPane, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.addHostBtn = new JButton("Save Properties");
        this.addHostBtn.setActionCommand(ADD_HOST_CMD);
        this.addHostBtn.setToolTipText("Save Properties");
        this.addHostBtn.addActionListener(this);
        buttonsPanel.add(this.addHostBtn);
        this.resetBtn = new JButton("Reset Properties");
        this.resetBtn.setActionCommand(RESET_PROPS_CMD);
        this.resetBtn.setToolTipText("Reset Properties");
        this.resetBtn.addActionListener(this);
        buttonsPanel.add(this.resetBtn);
        this.clearHostCacheButton = new JButton("Clear Cache");
        this.clearHostCacheButton.setToolTipText("Clear This Host Cache");
        this.clearHostCacheButton.setActionCommand(CLEAR_HOST_CACHE_CMD);
        this.clearHostCacheButton.addActionListener(this);
        buttonsPanel.add(this.clearHostCacheButton);
        result.add((Component)buttonsPanel, "South");
        return result;
    }

    private JPanel getLocationPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Location "));
        this.rootLabel = new JLabel("Root Directory:");
        result.add((Component)this.rootLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.rootField = new JTextField();
        result.add((Component)this.rootField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.startPageLabel = new JLabel("Start Page:");
        result.add((Component)this.startPageLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.startPageField = new JTextField();
        result.add((Component)this.startPageField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    protected JPanel getGeneralPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JPanel row = new JPanel(new GridBagLayout());
        this.enableLogCheckBox = new JCheckBox("Log Responses");
        this.enableLogCheckBox.setHorizontalTextPosition(2);
        this.enableLogCheckBox.setSelected(true);
        this.enableLogCheckBox.addActionListener(this);
        row.add((Component)this.enableLogCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.useCacheCheckBox = new JCheckBox("Use Cache");
        this.useCacheCheckBox.setHorizontalTextPosition(2);
        this.useCacheCheckBox.setSelected(true);
        this.useCacheCheckBox.setActionCommand(USE_CACHE_CHECKBOX_CMD);
        this.useCacheCheckBox.addActionListener(this);
        row.add((Component)this.useCacheCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.keepAliveCheckBox = new JCheckBox("Keep Alive");
        this.keepAliveCheckBox.setHorizontalTextPosition(2);
        this.keepAliveCheckBox.setSelected(true);
        this.keepAliveCheckBox.addActionListener(this);
        row.add((Component)this.keepAliveCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)row, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.dirListCheckBox = new JCheckBox("Directory List");
        this.dirListCheckBox.setHorizontalTextPosition(2);
        row.add((Component)this.dirListCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)row, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    private JPanel getAliasesPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.aliasesEditor = new PropertyEditor("Alias", "Path");
        result.add((Component)this.aliasesEditor);
        return result;
    }

    private JPanel getAppAliasesPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.applAliasesTable = new AliasTable(this);
        this.applAliasesTable.getSelectionModel().addListSelectionListener(this);
        this.aliasModel = (AliasTableModel)this.applAliasesTable.getModel();
        result.add((Component)new JScrollPane(this.applAliasesTable), "Center");
        return result;
    }

    public void rowChanged(int row, boolean value) {
        this.repaint();
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);

    public abstract void changedUpdate(DocumentEvent var1);

    public abstract void removeUpdate(DocumentEvent var1);

    public abstract void insertUpdate(DocumentEvent var1);

    public abstract void setTaskManager(EditorViewManager var1);

    public abstract void freeResources();

    public abstract void setFrame(Frame var1);

    public abstract JButton[] getRuntimeButtons();

    public abstract JMenu getRuntimeMenu();

    public abstract JComponent getRuntimeControlComponent();

    public abstract void show(ManagementInterface var1);

    public abstract void setEnvironment(String var1, Object var2) throws UnsupportedEditorException;
}

