/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.gui;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.services.httpserver.HostPropertiesRuntimeInterface;
import com.sap.engine.services.httpserver.HttpRuntimeInterface;
import com.sap.engine.services.httpserver.ZoneManagementInterface;
import com.sap.engine.services.httpserver.exceptions.IllegalHostArgumentsException;
import com.sap.engine.services.httpserver.gui.HttpRuntimeView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class HttpRuntimeLogical
extends HttpRuntimeView {
    protected Frame frame;
    protected HttpRuntimeInterface hri;
    private Hashtable hosts = new Hashtable();
    private Vector hostsListData = new Vector();
    private String lastSelectedHost = null;

    public HttpRuntimeLogical() {
        this.removeHostBtn.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        if (lse.getSource() == this.hostsList) {
            String selectedHost = (String)this.hostsList.getSelectedValue();
            if (this.lastSelectedHost != null) {
                try {
                    this.updateHostAction();
                }
                catch (Exception io) {
                    JOptionPane.showConfirmDialog(this.frame, "Cannot set the new configuration. Error is: " + io.getMessage(), "Confirmation", -1);
                    return;
                }
            }
            if (selectedHost != null) {
                try {
                    this.updatePropertiesPanel((HostPropertiesRuntimeInterface)this.hosts.get(selectedHost));
                    this.removeHostBtn.setEnabled(true);
                }
                catch (RemoteException e) {
                    JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error in initializing the properties. Error is: " + e.getMessage(), "Confirmation", -1);
                    this.lastSelectedHost = null;
                    this.updateHostsPanel();
                }
            } else {
                this.removeHostBtn.setEnabled(false);
            }
            this.lastSelectedHost = selectedHost;
        }
    }

    public void insertUpdate(DocumentEvent de) {
        this.addHostBtn.setEnabled(true);
        this.updateAddBtn(this.hostsList.getSelectedValue().toString().trim());
    }

    public void removeUpdate(DocumentEvent de) {
        this.updateAddBtn(this.hostsList.getSelectedValue().toString().trim());
    }

    public void changedUpdate(DocumentEvent de) {
    }

    protected void updateAddBtn(String host) {
        this.addHostBtn.setText("Set");
    }

    public void actionPerformed(ActionEvent ae) {
        String hostName;
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals("reset cmd")) {
            try {
                this.updatePropertiesPanel((HostPropertiesRuntimeInterface)this.hosts.get(((String)this.hostsList.getSelectedValue()).trim()));
            }
            catch (Exception e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot reset the host properties. Error is: " + e, "Confirmation", -1);
            }
        }
        if (actionCmd.equals("add host cmd")) {
            try {
                this.updateHostAction();
            }
            catch (Exception e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error in initializing the properties. Error is: " + e, "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
        }
        if (actionCmd.equals("add new host cmd")) {
            try {
                hostName = JOptionPane.showInputDialog(this, "Enter a host name:", "Add", -1);
                if (hostName == null) {
                    return;
                }
                this.createHostAction(hostName);
            }
            catch (RemoteException rex) {
                throw new RuntimeException(rex.toString());
            }
            catch (IllegalHostArgumentsException e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
            catch (ConfigurationException e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
        }
        if (actionCmd.equals("add copy new host cmd")) {
            try {
                hostName = JOptionPane.showInputDialog(this, "Enter a new host name:", "Enter", -1);
                if (hostName == null) {
                    return;
                }
                this.createCopyHostAction(hostName);
            }
            catch (RemoteException rex) {
                throw new RuntimeException(rex.toString());
            }
            catch (IllegalHostArgumentsException e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
            catch (IOException e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
            catch (ConfigurationException e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
        }
        if (actionCmd.equals("remove host cmd")) {
            this.removeHostAction();
        }
        if (actionCmd.equals("claer cache cmd")) {
            try {
                this.hri.clearCache();
            }
            catch (RemoteException rex) {
                throw new RuntimeException(rex.toString());
            }
        }
        if (actionCmd.equals("claer host cache cmd")) {
            try {
                this.clearHostCacheAction();
            }
            catch (Exception e) {
                JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error in initializing the properties. Error is: " + e, "Confirmation", -1);
                this.lastSelectedHost = null;
                this.updateHostsPanel();
            }
        }
        this.setEnabled();
    }

    protected void updateHostAction() throws ConfigurationException, IOException, IllegalHostArgumentsException {
        this.updateHostProperties(this.lastSelectedHost);
    }

    protected void createHostAction(String host) throws ConfigurationException, IllegalHostArgumentsException, RemoteException {
        try {
            if (host.indexOf("/") > -1 || host.indexOf("\\") > -1 || host.indexOf(":") > -1 || host.indexOf("*") > -1 || host.indexOf("?") > -1 || host.indexOf("\"") > -1 || host.indexOf("<") > -1 || host.indexOf(">") > -1 || host.indexOf("|") > -1) {
                throw new Exception("Wrong server name");
            }
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
            this.lastSelectedHost = null;
            this.updateHostsPanel();
            return;
        }
        HostPropertiesRuntimeInterface newHost = this.hri.createHost(host);
        this.hosts.put(host, newHost);
        if (!this.hostsListData.contains(host)) {
            this.hostsListData.add(host);
            this.updateHostsPanel();
        }
    }

    protected void createCopyHostAction(String host) throws IOException, ConfigurationException, IllegalHostArgumentsException {
        try {
            if (host.indexOf("/") > -1 || host.indexOf("\\") > -1 || host.indexOf(":") > -1 || host.indexOf("*") > -1 || host.indexOf("?") > -1 || host.indexOf("\"") > -1 || host.indexOf("<") > -1 || host.indexOf(">") > -1 || host.indexOf("|") > -1) {
                throw new Exception("Wrong server name");
            }
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this.frame, "Cannot add or set the host. Error is: " + e.getMessage(), "Confirmation", -1);
            this.lastSelectedHost = null;
            this.updateHostsPanel();
            return;
        }
        if (this.lastSelectedHost == null) {
            return;
        }
        HostPropertiesRuntimeInterface newHost = this.hri.createHost(host);
        HostPropertiesRuntimeInterface fromHost = (HostPropertiesRuntimeInterface)this.hosts.get(this.lastSelectedHost);
        this.copy(fromHost, newHost);
        this.hosts.put(host, newHost);
        if (!this.hostsListData.contains(host)) {
            this.hostsListData.add(host);
            this.updateHostsPanel();
        }
    }

    private void copy(HostPropertiesRuntimeInterface fromhost, HostPropertiesRuntimeInterface result) throws ConfigurationException, IOException, RemoteException, IllegalHostArgumentsException {
        result.setRootDir(fromhost.getRootDir());
        result.setStartPage(fromhost.getStartPage());
        result.setLogEnabled(fromhost.isLogEnabled());
        result.setUseCache(fromhost.isUseCache());
        result.setList(fromhost.isList());
        String[] keys = fromhost.getAliasNames();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                if (!fromhost.isApplicationAlias(keys[i])) {
                    result.addHttpAlias(keys[i], fromhost.getAliasValue(keys[i]));
                }
                ++i;
            }
        }
    }

    protected void removeHostAction() {
        String host = ((String)this.hostsList.getSelectedValue()).trim();
        if (host.equals("default")) {
            return;
        }
        try {
            this.hri.removeHost(host);
        }
        catch (Exception t) {
            JOptionPane.showConfirmDialog(this.frame, "Cannot remove the host. Error is: " + t, "Confirmation", -1);
            this.lastSelectedHost = null;
            this.updateHostsPanel();
            return;
        }
        this.hosts.remove(host);
        this.lastSelectedHost = null;
        this.hostsListData.remove(host);
        this.updateHostsPanel();
    }

    protected void clearHostCacheAction() throws IllegalHostArgumentsException, RemoteException {
        String host = ((String)this.hostsList.getSelectedValue()).trim();
        this.hri.clearCache(host);
    }

    private void setEnabled() {
        this.useCacheCheckBox.isSelected();
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return this.runtimeButtons;
    }

    public void freeResources() {
        this.lastSelectedHost = null;
        this.hosts.clear();
        this.hostsListData.clear();
        this.updateHostsPanel();
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setUserTree(UserNode root) {
    }

    private void initHostsPanel() {
        Enumeration hostNames = this.hosts.keys();
        while (hostNames.hasMoreElements()) {
            String hostName = (String)hostNames.nextElement();
            this.hostsListData.add(hostName);
        }
        this.updateHostsPanel();
    }

    private void updateHostsPanel() {
        this.hostsList.setListData(this.hostsListData);
        this.hostsList.setSelectedIndex(this.hostsListData.size() - 1);
    }

    private void updatePropertiesPanel(HostPropertiesRuntimeInterface props) throws RemoteException {
        if (props != null) {
            this.rootField.setText(props.getRootDir());
            this.startPageField.setText(props.getStartPage());
            this.enableLogCheckBox.setSelected(props.isLogEnabled());
            this.useCacheCheckBox.setSelected(props.isUseCache());
            this.keepAliveCheckBox.setSelected(props.isKeepAliveEnabled());
            this.dirListCheckBox.setSelected(props.isList());
            this.aliasesEditor.initProperties(this.aliasesToProps(props));
            this.aliasModel.initAliases(this.appAliasesToProps(props));
        } else {
            this.rootField.setText("");
            this.startPageField.setText("");
            this.enableLogCheckBox.setSelected(true);
            this.useCacheCheckBox.setSelected(false);
            this.keepAliveCheckBox.setSelected(false);
            this.dirListCheckBox.setSelected(false);
            this.aliasesEditor.initProperties(null);
            this.aliasModel.initAliases(null);
        }
        this.setEnabled();
    }

    private synchronized HostPropertiesRuntimeInterface updateHostProperties(String host) throws ConfigurationException, IllegalHostArgumentsException, IOException, RemoteException {
        HostPropertiesRuntimeInterface result = (HostPropertiesRuntimeInterface)this.hosts.get(host);
        result.setRootDir(this.rootField.getText());
        result.setStartPage(this.startPageField.getText());
        result.setLogEnabled(this.enableLogCheckBox.isSelected());
        result.setUseCache(this.useCacheCheckBox.isSelected());
        result.setKeepAliveEnabled(this.keepAliveCheckBox.isSelected());
        result.setList(this.dirListCheckBox.isSelected());
        this.updateHttpAliases(result);
        this.updateAppAliases(result);
        return result;
    }

    private void updateHttpAliases(HostPropertiesRuntimeInterface result) throws ConfigurationException, IllegalHostArgumentsException, RemoteException {
        String[] oldAliases = result.getAliasNames();
        if (oldAliases == null) {
            oldAliases = new String[]{};
        }
        String[] newAliases = this.getAllKeys(this.aliasesEditor.getProps());
        int i = 0;
        while (i < newAliases.length) {
            if (!this.contains(oldAliases, newAliases[i])) {
                result.addHttpAlias(newAliases[i], this.aliasesEditor.getProps().getProperty(newAliases[i]));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < oldAliases.length) {
            if (!this.contains(newAliases, oldAliases[i2])) {
                result.removeHttpAlias(oldAliases[i2]);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < newAliases.length) {
            String newAliasValue = this.aliasesEditor.getProps().getProperty(newAliases[i3]);
            if (!newAliasValue.equals(result.getAliasValue(newAliases[i3]))) {
                result.changeHttpAlias(newAliases[i3], newAliasValue);
            }
            ++i3;
        }
    }

    private void updateAppAliases(HostPropertiesRuntimeInterface result) throws ConfigurationException, RemoteException {
        Hashtable appAliases = this.aliasModel.getAppAliases();
        Enumeration en = appAliases.keys();
        while (en.hasMoreElements()) {
            String alias = (String)en.nextElement();
            boolean isEnabled = (Boolean)appAliases.get(alias);
            if (isEnabled) {
                result.enableApplicationAlias(alias);
                continue;
            }
            result.disableApplicationAlias(alias);
        }
    }

    private String[] getAllKeys(Properties props) {
        String[] res = new String[((Hashtable)props).size()];
        Enumeration en = ((Hashtable)props).keys();
        int i = 0;
        while (i < res.length) {
            res[i] = (String)en.nextElement();
            ++i;
        }
        return res;
    }

    private boolean contains(String[] array, String toSearch) {
        if (toSearch == null) {
            return true;
        }
        int i = 0;
        while (i < array.length) {
            if (toSearch.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Properties aliasesToProps(HostPropertiesRuntimeInterface props) throws RemoteException {
        Properties result = null;
        if (props != null) {
            result = new Properties();
            String[] keys = props.getAliasNames();
            int i = 0;
            while (keys != null && i < keys.length) {
                if (!props.isApplicationAlias(keys[i])) {
                    ((Hashtable)result).put(keys[i], props.getAliasValue(keys[i]));
                }
                ++i;
            }
        }
        return result;
    }

    private Properties appAliasesToProps(HostPropertiesRuntimeInterface props) throws RemoteException {
        Properties result = new Properties();
        if (props == null) {
            return null;
        }
        String[] keys = props.getAliasNames();
        int i = 0;
        while (keys != null && i < keys.length) {
            String key = keys[i];
            if (props.isApplicationAliasEnabled(key)) {
                ((Hashtable)result).put(key, new Boolean(true));
            } else if (props.isApplicationAlias(key)) {
                ((Hashtable)result).put(key, new Boolean(false));
            }
            ++i;
        }
        return result;
    }

    private void setHRIVector(HostPropertiesRuntimeInterface[] allHosts) throws RemoteException {
        int i = 0;
        while (i < allHosts.length) {
            HostPropertiesRuntimeInterface props = allHosts[i];
            this.hosts.put(props.getHostName(), props);
            ++i;
        }
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public void show(ManagementInterface ri) {
        try {
            this.hri = (HttpRuntimeInterface)ri;
            this.setHRIVector(this.hri.getAllHostsTemp());
            this.initHostsPanel();
            ZoneManagementInterface zoneManagementInterface = this.hri.getZoneManagementInterface();
            this.zonesConfigurator.setZonesManagementInterface(zoneManagementInterface);
        }
        catch (Exception rex) {
            throw new RuntimeException(rex.toString());
        }
    }

    public void setTaskManager(EditorViewManager man) {
    }

    protected static Properties hashToProps(Hashtable ht) {
        Properties result = null;
        if (ht != null) {
            result = new Properties();
            Enumeration keys = ht.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ((Hashtable)result).put(key, ht.get(key));
            }
        }
        return result;
    }

    protected static Hashtable propsToHash(Properties props) {
        Hashtable result = null;
        if (props != null) {
            result = new Hashtable();
            Enumeration keys = ((Hashtable)props).keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                result.put(key, ((Hashtable)props).get(key));
            }
        }
        return result;
    }
}

