/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.gui;

import com.sap.engine.services.httpserver.gui.AliasRow;
import com.sap.engine.services.httpserver.gui.RowChangedListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class AliasTableModel
extends AbstractTableModel {
    protected static final String[] colnames = new String[]{"Active", "Application Aliases"};
    protected Vector aliasRows = new Vector();
    protected RowChangedListener listener;

    public AliasTableModel() {
        this(null, null);
    }

    public AliasTableModel(RowChangedListener listener) {
        this(null, listener);
    }

    public AliasTableModel(Vector aliasRows, RowChangedListener listener) {
        this.listener = listener;
        if (aliasRows != null) {
            int i = 0;
            while (i < aliasRows.size()) {
                this.addRow((AliasRow)aliasRows.elementAt(i));
                ++i;
            }
        }
    }

    public void initAliases(Properties aliases) {
        this.aliasRows = new Vector();
        if (aliases == null) {
            return;
        }
        Enumeration en = ((Hashtable)aliases).keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            AliasRow aliasRow = new AliasRow((Boolean)((Hashtable)aliases).get(key), key);
            this.addRow(aliasRow);
        }
    }

    public Hashtable getAppAliases() {
        Hashtable<String, Boolean> result = new Hashtable<String, Boolean>();
        if (this.aliasRows == null) {
            return null;
        }
        int i = 0;
        while (i < this.aliasRows.size()) {
            AliasRow alRow = (AliasRow)this.aliasRows.elementAt(i);
            result.put(alRow.getName(), new Boolean(alRow.getSelected()));
            ++i;
        }
        return result;
    }

    public int getColumnCount() {
        return colnames.length;
    }

    public int getRowCount() {
        return this.aliasRows.size();
    }

    public Object getValueAt(int row, int col) {
        AliasRow aliasRow = (AliasRow)this.aliasRows.elementAt(row);
        switch (col) {
            case 0: {
                return aliasRow.getSelected();
            }
            case 1: {
                return aliasRow.getName();
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int column) {
        if (value instanceof Boolean) {
            AliasRow aliasRow = (AliasRow)this.aliasRows.elementAt(row);
            aliasRow.setSelected((Boolean)value);
            this.fireRowChanged(row, (Boolean)value);
        }
    }

    public String getColumnName(int column) {
        return colnames[column];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public void addRow(AliasRow row) {
        String alias = row.getName();
        if (alias == null || alias.trim().length() == 0) {
            return;
        }
        int aliasIndex = this.aliasRows.indexOf(alias.trim());
        if (aliasIndex < 0) {
            aliasIndex = 0;
            while (aliasIndex < this.aliasRows.size() && ((AliasRow)this.aliasRows.elementAt(aliasIndex)).getName().compareTo(alias) < 0) {
                ++aliasIndex;
            }
            this.aliasRows.add(aliasIndex, row);
        }
        this.fireTableDataChanged();
    }

    public AliasRow getRow(int row) {
        if (row < 0 || row >= this.aliasRows.size()) {
            return null;
        }
        return (AliasRow)this.aliasRows.elementAt(row);
    }

    public boolean nothingSelected() {
        int i = 0;
        while (i < this.aliasRows.size()) {
            if (((AliasRow)this.aliasRows.elementAt(i)).getSelected().booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getSelectedRows() {
        Vector<String> selectedRows = new Vector<String>();
        int i = 0;
        while (i < this.aliasRows.size()) {
            AliasRow row = (AliasRow)this.aliasRows.elementAt(i);
            if (row.getSelected().booleanValue()) {
                selectedRows.add(row.getName());
            }
            ++i;
        }
        return selectedRows;
    }

    protected void fireRowChanged(int row, boolean value) {
        if (this.listener != null) {
            this.listener.rowChanged(row, value);
        }
    }
}

