/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher.shellcommands;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.HttpLoadbalance;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class ListLoadBalancing
implements Command {
    private HttpLoadbalance httpLoadbalance;

    public ListLoadBalancing(HttpLoadbalance http) {
        this.httpLoadbalance = http;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0) {
            pw.println(this.getHelpMessage());
        } else {
            try {
                String result = this.httpLoadbalance.listLoadBalanceSettings(SystemProperties.getProperty((String)"line.separator"));
                pw.println(result);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(ostr));
                pw.println("ERROR: " + ostr);
                pw.println(this.getHelpMessage());
            }
        }
    }

    public String getName() {
        return "LIST_APP_LOAD_BALANCING";
    }

    public String getGroup() {
        return "http";
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        return "Lists application settings for HTTP load balancing. For each started J2EE application displays: name, web application aliases, and a list of servers on which the application is running." + nl + nl + "Usage: " + this.getName();
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

