/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher.loadbalance;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.balance.ApplicationDestination;
import com.sap.engine.frame.cluster.balance.Destination;
import com.sap.engine.frame.cluster.balance.Loadbalance;
import com.sap.engine.frame.cluster.balance.SuspensionListener;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.httpserver.dispatcher.Constants;
import com.sap.engine.services.httpserver.dispatcher.Utils;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.ApplicationLoadBalance;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.Cookie;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import java.util.Vector;

public class HttpLoadbalance
implements SuspensionListener {
    private CommunicationServiceContext csc = null;
    private int currentGroupId = -1;
    private Loadbalance loadbalance = null;
    private int loadBalanceId = -1;
    private ConcurrentHashMapObjectObject webToAppLB = new ConcurrentHashMapObjectObject();
    private ArrayObject urlSessionTracking = new ArrayObject(3, 2);
    private int[] allSuspendedInCluster = null;
    private int[] allDebugingElements = null;
    private byte[] zoneSeparator = null;

    public HttpLoadbalance(Loadbalance loadbalance, CommunicationServiceContext csc) {
        this.csc = csc;
        this.currentGroupId = csc.getClusterContext().getClusterMonitor().getCurrentParticipant().getGroupId();
        this.loadbalance = loadbalance;
        this.loadBalanceId = loadbalance.registerConsumer("httpserver", (Destination)new ApplicationDestination(), "http");
        ClusterElement[] suspendedElements = loadbalance.getSuspendedElements();
        if (suspendedElements != null && suspendedElements.length > 0) {
            this.allSuspendedInCluster = new int[suspendedElements.length];
            int i = 0;
            while (i < suspendedElements.length) {
                this.allSuspendedInCluster[i] = suspendedElements[i].getClusterId();
                ++i;
            }
        }
        loadbalance.registerListener((SuspensionListener)this);
        Vector<ClusterElement> debugingElements = new Vector<ClusterElement>();
        ClusterElement[] ci = csc.getClusterContext().getClusterMonitor().getServiceNodes();
        int i = 0;
        while (i < ci.length) {
            if (ci[i].getType() == 7) {
                debugingElements.addElement(ci[i]);
            }
            ++i;
        }
        if (debugingElements != null && debugingElements.size() != 0) {
            this.allDebugingElements = new int[debugingElements.size()];
            int i2 = 0;
            while (i2 < debugingElements.size()) {
                this.allDebugingElements[i2] = ((ClusterElement)debugingElements.elementAt(i2)).getClusterId();
                ++i2;
            }
        }
    }

    public boolean containsAliasName(byte[] cookieGroupName) {
        Object[] appsLBDestinations = this.webToAppLB.getAllValues();
        int i = 0;
        while (i < appsLBDestinations.length) {
            ApplicationLoadBalance appsLBDestination = (ApplicationLoadBalance)appsLBDestinations[i];
            if (appsLBDestination.contains(cookieGroupName, 0, cookieGroupName.length)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getZoneNameFromAlias(byte[] cookieGroupName) {
        if (this.zoneSeparator == null) {
            return null;
        }
        int ind = ByteArrayUtils.indexOf(cookieGroupName, this.zoneSeparator);
        if (ind == -1) {
            return null;
        }
        byte[] zoneFromCookieEncoded = new byte[cookieGroupName.length - ind];
        System.arraycopy(cookieGroupName, ind, zoneFromCookieEncoded, 0, zoneFromCookieEncoded.length);
        Object[] appsLBDestinations = this.webToAppLB.getAllValues();
        int i = 0;
        while (i < appsLBDestinations.length) {
            ApplicationLoadBalance appsLBDestination = (ApplicationLoadBalance)appsLBDestinations[i];
            if (appsLBDestination.containsGroup(zoneFromCookieEncoded)) {
                return new String(zoneFromCookieEncoded, 1, zoneFromCookieEncoded.length - 1);
            }
            ++i;
        }
        return null;
    }

    public void setZoneSeparator(byte[] zoneSeparator) {
        this.zoneSeparator = zoneSeparator;
    }

    public void unregisterLBListener() {
        this.loadbalance.unregisterListener((SuspensionListener)this);
    }

    public int getSuspended() {
        return this.loadbalance.getSuspended();
    }

    public int getDebuged() {
        if (this.hasDebugServer()) {
            return this.allDebugingElements[0];
        }
        return -1;
    }

    public int getLeastBusyServerId() {
        return this.loadbalance.getLessBusyElement(this.loadBalanceId);
    }

    public void serverSuspended(int id) {
        HttpLoadbalance httpLoadbalance = this;
        synchronized (httpLoadbalance) {
            this.serverResumed(id);
            if (this.allSuspendedInCluster == null) {
                this.allSuspendedInCluster = new int[]{id};
            } else {
                int[] allSuspendedInClusterTmp = new int[this.allSuspendedInCluster.length + 1];
                System.arraycopy(this.allSuspendedInCluster, 0, allSuspendedInClusterTmp, 0, this.allSuspendedInCluster.length);
                allSuspendedInClusterTmp[this.allSuspendedInCluster.length] = id;
                this.allSuspendedInCluster = allSuspendedInClusterTmp;
            }
            Object[] appsLBDestinations = this.webToAppLB.getAllValues();
            int i = 0;
            while (i < appsLBDestinations.length) {
                ApplicationLoadBalance appsLBDestination = (ApplicationLoadBalance)appsLBDestinations[i];
                appsLBDestination.suspendServer(id);
                ++i;
            }
        }
    }

    public void serverResumed(int id) {
        HttpLoadbalance httpLoadbalance = this;
        synchronized (httpLoadbalance) {
            if (this.allSuspendedInCluster == null || this.allSuspendedInCluster.length == 0) {
                return;
            }
            int ind = -1;
            int i = 0;
            while (i < this.allSuspendedInCluster.length) {
                if (this.allSuspendedInCluster[i] == id) {
                    ind = i;
                    break;
                }
                ++i;
            }
            if (ind == -1) {
                return;
            }
            int[] suspendedServersTmp = new int[this.allSuspendedInCluster.length - 1];
            int iTmp = 0;
            int i2 = 0;
            while (i2 < this.allSuspendedInCluster.length) {
                if (i2 != ind) {
                    suspendedServersTmp[iTmp] = this.allSuspendedInCluster[i2];
                    ++iTmp;
                }
                ++i2;
            }
            this.allSuspendedInCluster = suspendedServersTmp;
            if (this.allSuspendedInCluster.length == 0) {
                this.allSuspendedInCluster = null;
            }
            Object[] appsLBDestinations = this.webToAppLB.getAllValues();
            int i3 = 0;
            while (i3 < appsLBDestinations.length) {
                ApplicationLoadBalance appsLBDestination = (ApplicationLoadBalance)appsLBDestinations[i3];
                appsLBDestination.resumeServer(id);
                ++i3;
            }
        }
    }

    public boolean hasSuspendedServer() {
        return this.allSuspendedInCluster != null && this.allSuspendedInCluster.length > 0;
    }

    public boolean hasDebugServer() {
        return this.allDebugingElements != null && this.allDebugingElements.length > 0;
    }

    public int getServerIdFromRequest(byte[] request) throws ParseException {
        int serverId;
        int urlOffset = this.getAliasOffset(request);
        int urlLen = this.getAliasLength(request, urlOffset);
        String alias = this.findAlias(request, urlOffset, urlLen);
        Cookie[] cookies = null;
        int cookieHeaderOffset = -1;
        boolean cookiesFound = false;
        if (!this.urlSessionTracking.contains((Object)alias)) {
            cookieHeaderOffset = this.getCookieHeaderOffset(request, urlOffset + urlLen);
            while (cookieHeaderOffset != -1) {
                cookiesFound = true;
                Cookie[] cookiesTmp = this.getCookies(request, cookieHeaderOffset);
                if (cookies == null || cookies.length == 0) {
                    cookies = cookiesTmp;
                } else {
                    Cookie[] cookiesAll = new Cookie[cookies.length + cookiesTmp.length];
                    System.arraycopy(cookies, 0, cookiesAll, 0, cookies.length);
                    System.arraycopy(cookiesTmp, 0, cookiesAll, cookies.length, cookiesTmp.length);
                    cookies = cookiesAll;
                }
                cookieHeaderOffset = this.getCookieHeaderOffset(request, cookieHeaderOffset + 6);
            }
        }
        if (!cookiesFound) {
            cookies = this.getCookiesFromURL(request, urlOffset + urlLen);
        }
        if ((serverId = this.getServerFromCookie(request, urlOffset, urlLen, cookies)) == -1) {
            serverId = this.getServerFromCookieOfMyApplication(request, urlOffset, urlLen, cookies);
        }
        return serverId;
    }

    public int getServerId(byte[] request) throws ParseException {
        int aliasOffset = this.getAliasOffset(request);
        int aliasLen = this.getAliasLength(request, aliasOffset);
        return this.getServer(request, aliasOffset, aliasLen);
    }

    public void register(int serverId, byte[] applicationName, byte[][] webApplications) throws ParseException {
        try {
            if (webApplications == null) {
                return;
            }
            ClusterElement el = this.csc.getClusterContext().getClusterMonitor().getParticipant(serverId);
            if (el == null || el.getGroupId() != this.currentGroupId) {
                return;
            }
            ApplicationLoadBalance dest = (ApplicationLoadBalance)this.webToAppLB.get((Object)new String(webApplications[0]));
            if (dest == null) {
                dest = new ApplicationLoadBalance(this, applicationName, webApplications);
            }
            if (this.allSuspendedInCluster == null || this.allSuspendedInCluster.length == 0) {
                dest.addServer(serverId, false);
            } else {
                boolean isSuspended = false;
                HttpLoadbalance httpLoadbalance = this;
                synchronized (httpLoadbalance) {
                    int i = 0;
                    while (i < this.allSuspendedInCluster.length) {
                        if (this.allSuspendedInCluster[i] == serverId) {
                            isSuspended = true;
                            break;
                        }
                        ++i;
                    }
                }
                dest.addServer(serverId, isSuspended);
            }
            int i = 0;
            while (i < webApplications.length) {
                dest.addAlias(webApplications[i]);
                this.webToAppLB.put((Object)new String(webApplications[i]), (Object)dest);
                ++i;
            }
        }
        catch (Exception t) {
            throw new ParseException("http_0054", new Object[]{new String(applicationName), "" + serverId}, t);
        }
    }

    public void unregisterServer(int serverId) throws ParseException {
        try {
            Object[] allDestinations = this.webToAppLB.getAllValues();
            int i = 0;
            while (i < allDestinations.length) {
                ApplicationLoadBalance destination = (ApplicationLoadBalance)allDestinations[i];
                destination.removeServer(serverId);
                ++i;
            }
        }
        catch (Exception t) {
            throw new ParseException("http_0055", new Object[]{"" + serverId}, t);
        }
    }

    public void unregister(int serverId, byte[] applicationName) throws ParseException {
        try {
            Object[] allDestinations = this.webToAppLB.getAllValues();
            int i = 0;
            while (i < allDestinations.length) {
                ApplicationLoadBalance destination = (ApplicationLoadBalance)allDestinations[i];
                if (ByteArrayUtils.equalsBytes(destination.getName(), applicationName)) {
                    destination.removeServer(serverId);
                }
                ++i;
            }
        }
        catch (Exception t) {
            throw new ParseException("http_0056", new Object[]{new String(applicationName), "" + serverId}, t);
        }
    }

    public void removeWebApp(byte[] webName) {
        this.webToAppLB.remove((Object)new String(webName));
    }

    public void urlSessionTracking(byte[] webAppName, boolean urlSessionTracking) {
        if (urlSessionTracking) {
            this.urlSessionTracking.add((Object)new String(webAppName));
        } else {
            this.urlSessionTracking.remove((Object)new String(webAppName));
        }
    }

    public String listLoadBalanceSettings(String nl) {
        StringBuffer result = new StringBuffer();
        result.append("The number of available web applications is " + this.webToAppLB.size());
        result.append(nl);
        Object[] allDestinations = this.webToAppLB.getAllValues();
        if (allDestinations != null && allDestinations.length > 0) {
            result.append(nl);
            Vector<String> listedApps = new Vector<String>();
            int i = 0;
            while (i < allDestinations.length) {
                ApplicationLoadBalance destination = (ApplicationLoadBalance)allDestinations[i];
                String appName = new String(destination.getName());
                if (!listedApps.contains(appName)) {
                    listedApps.add(appName);
                    result.append(destination.toString(nl));
                    result.append(nl);
                }
                ++i;
            }
        }
        return result.toString();
    }

    public void elementLoss(ClusterElement element) {
        if (element.getState() == 7) {
            if (this.allDebugingElements == null || this.allDebugingElements.length == 0) {
                return;
            }
            int[] newAllDebugingElements = new int[this.allDebugingElements.length - 1];
            boolean afterRemovedElement = false;
            int i = 0;
            while (i < this.allDebugingElements.length) {
                if (afterRemovedElement) {
                    newAllDebugingElements[i - 1] = this.allDebugingElements[i];
                } else if (element.getClusterId() != this.allDebugingElements[i]) {
                    newAllDebugingElements[i] = this.allDebugingElements[i];
                }
                ++i;
            }
            this.allDebugingElements = new int[newAllDebugingElements.length];
            System.arraycopy(newAllDebugingElements, 0, this.allDebugingElements, 0, newAllDebugingElements.length);
        }
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        if (element.getState() == 7) {
            if (this.allDebugingElements == null || this.allDebugingElements.length == 0) {
                this.allDebugingElements = new int[]{element.getClusterId()};
                return;
            }
            int[] newAllDebugingElements = new int[this.allDebugingElements.length + 1];
            System.arraycopy(this.allDebugingElements, 0, newAllDebugingElements, 0, this.allDebugingElements.length);
            newAllDebugingElements[this.allDebugingElements.length] = element.getClusterId();
            this.allDebugingElements = new int[newAllDebugingElements.length];
            System.arraycopy(newAllDebugingElements, 0, this.allDebugingElements, 0, newAllDebugingElements.length);
        } else if (oldState == 7) {
            if (this.allDebugingElements == null || this.allDebugingElements.length == 0) {
                return;
            }
            int[] newAllDebugingElements = new int[this.allDebugingElements.length - 1];
            boolean afterRemovedElement = false;
            int i = 0;
            while (i < this.allDebugingElements.length) {
                if (afterRemovedElement) {
                    newAllDebugingElements[i - 1] = this.allDebugingElements[i];
                } else if (element.getClusterId() != this.allDebugingElements[i]) {
                    newAllDebugingElements[i] = this.allDebugingElements[i];
                }
                ++i;
            }
            this.allDebugingElements = new int[newAllDebugingElements.length];
            System.arraycopy(newAllDebugingElements, 0, this.allDebugingElements, 0, newAllDebugingElements.length);
        }
    }

    public String findAlias(byte[] request, int off, int len) {
        if (len <= 0) {
            return "";
        }
        int sepCount = 0;
        String aliasBeg = this.getAlias(request, off, len, sepCount++);
        while (aliasBeg != null) {
            if (this.webToAppLB.containsKey((Object)aliasBeg)) {
                return aliasBeg;
            }
            aliasBeg = this.getAlias(request, off, len, sepCount++);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public int getAliasOffset(byte[] request) throws ParseException {
        i = 0;
        while (request[i] == 13 && request[i + 1] == 10) {
            if ((i += 2) <= request.length - 2) continue;
            throw new ParseException("http_0007", new Object[]{"Request Line"});
        }
        while (request[i] != 32 && (request[i] != 13 || request[i + 1] != 10)) {
            ++i;
        }
        if (request[i] != 32) {
            throw new ParseException("http_0007", new Object[]{"URI"});
        }
        ++i;
        while (request[i] == 32) {
            ++i;
        }
        if (request[i] == 47 || request[i] == 92) {
            ++i;
            while (request[i] == 47 || request[i] == 92) {
                ++i;
            }
            return i;
        }
        if (request[i++] != 104 || request[i++] != 116 || request[i++] != 116 || request[i++] != 112) {
            throw new ParseException("http_0007", new Object[]{"A request scheme"});
        }
        if (request[i] == 115) {
            // empty if block
        }
        v0 = ++i;
        ++i;
        if (request[v0] == 58 && request[i++] == 47 && request[i++] == 47) ** GOTO lbl29
        throw new ParseException("http_0007", new Object[]{"A request scheme"});
lbl-1000:
        // 1 sources

        {
            ++i;
lbl29:
            // 2 sources

            ** while (request[i] == 47 || request[i] == 92)
        }
lbl30:
        // 2 sources

        while (request[i] != 47 && request[i] != 92 && request[i] != 32) {
            ++i;
        }
        if (request[i] == 32) {
            return i;
        }
        ++i;
        while (request[i] == 47 || request[i] == 92) {
            ++i;
        }
        return i;
    }

    public int getAliasLength(byte[] request, int aliasOffset) throws ParseException {
        int i = aliasOffset;
        while (request[i] != 13 || request[i + 1] != 10) {
            if (request[i] == 63 || request[i] == 32 || request[i] == 59) {
                return i - aliasOffset;
            }
            ++i;
        }
        throw new ParseException("http_0007", new Object[]{"HTTP version"});
    }

    private int getServer(byte[] request, int aliasOffset, int aliasLen) {
        ApplicationLoadBalance applb = this.findAppByAlias(request, aliasOffset, aliasLen);
        if (applb == null) {
            return this.loadbalance.getLessBusyElement(this.loadBalanceId);
        }
        return applb.getLessBusy();
    }

    private int getServerFromCookie(byte[] request, int aliasOffset, int aliasLen, Cookie[] cooks) {
        int i;
        if (cooks == null) {
            return -1;
        }
        int sepCount = 0;
        String aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        while (aliasBeg != null) {
            i = 0;
            while (i < cooks.length) {
                String groupName;
                if (cooks[i].getAliasName() != null && cooks[i].getAliasName().equalsIgnoreCase(aliasBeg)) {
                    if (this.isStarted(aliasBeg, cooks[i].getValue())) {
                        return cooks[i].getValue();
                    }
                } else if (aliasBeg.endsWith(cooks[i].getName())) {
                    int sepInd;
                    if (this.isStarted(aliasBeg, cooks[i].getValue())) {
                        return cooks[i].getValue();
                    }
                    if (this.zoneSeparator != null && (sepInd = aliasBeg.indexOf(new String(this.zoneSeparator))) > -1 && this.isStarted(aliasBeg.substring(0, sepInd), cooks[i].getValue())) {
                        return cooks[i].getValue();
                    }
                } else if (this.zoneSeparator != null && (groupName = this.getGroupName(aliasBeg)) != null && groupName.endsWith(new String(this.zoneSeparator) + cooks[i].getName()) && this.isStarted(aliasBeg, cooks[i].getValue())) {
                    return cooks[i].getValue();
                }
                ++i;
            }
            aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        }
        i = 0;
        while (cooks != null && i < cooks.length) {
            if (cooks[i].getName().equals("/")) {
                sepCount = 0;
                aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
                while (aliasBeg != null) {
                    if (this.isStarted(aliasBeg, cooks[i].getValue())) {
                        return cooks[i].getValue();
                    }
                    aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (cooks != null && i2 < cooks.length) {
            if (cooks[i2].getAliasName() != null && cooks[i2].getAliasName().equals("/")) {
                sepCount = 0;
                aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
                while (aliasBeg != null) {
                    if (!aliasBeg.equals("/") && !aliasBeg.equals("\\") && this.webToAppLB.containsKey((Object)aliasBeg)) {
                        return -1;
                    }
                    aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
                }
                if (this.isStarted("/", cooks[i2].getValue())) {
                    return cooks[i2].getValue();
                }
            }
            ++i2;
        }
        return -1;
    }

    private int getServerFromCookieOfMyApplication(byte[] request, int aliasOffset, int aliasLen, Cookie[] cooks) {
        if (cooks == null || cooks.length == 0) {
            return -1;
        }
        int serverId = this.getServerIdFromApplication(request, aliasOffset, aliasLen, cooks);
        if (serverId != -1) {
            return serverId;
        }
        int i = 0;
        while (i < cooks.length) {
            if (this.isStarted(request, aliasOffset, aliasLen, cooks[i].getValue())) {
                return cooks[i].getValue();
            }
            ++i;
        }
        return -1;
    }

    private int getServerIdFromApplication(byte[] request, int aliasOffset, int aliasLen, Cookie[] cookies) {
        byte[] myApplNametmp;
        int ind;
        byte[] myApplName = null;
        int sepCount = 0;
        String aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        while (aliasBeg != null) {
            myApplName = this.getApplicationName(aliasBeg.getBytes());
            if (myApplName != null) break;
            aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        }
        if (this.zoneSeparator != null && (myApplName == null || ByteArrayUtils.equalsBytes(myApplName, ParseUtils.separatorBytes) || myApplName.length == 0) && (ind = ByteArrayUtils.indexOf(request, aliasOffset, aliasLen, this.zoneSeparator)) > -1 && (myApplNametmp = this.getApplicationName((aliasBeg = this.getAlias(request, aliasOffset, ind, 0)).getBytes())) != null) {
            myApplName = myApplNametmp;
        }
        if (myApplName == null) {
            return -1;
        }
        int i = 0;
        while (i < cookies.length) {
            byte[] appl;
            if (cookies[i].getAliasName() != null && (appl = this.getApplicationName(cookies[i].getAliasName().getBytes())) != null && ByteArrayUtils.equalsBytes(appl, myApplName)) {
                if (this.isStarted(cookies[i].getAliasName(), cookies[i].getValue())) {
                    return cookies[i].getValue();
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    private byte[] getApplicationName(byte[] aliasName) {
        Object[] appsLBDestinations = this.webToAppLB.getAllValues();
        int i = 0;
        while (i < appsLBDestinations.length) {
            if (((ApplicationLoadBalance)appsLBDestinations[i]).contains(aliasName, 0, aliasName.length)) {
                return ((ApplicationLoadBalance)appsLBDestinations[i]).getName();
            }
            ++i;
        }
        return null;
    }

    private boolean isStarted(byte[] request, int aliasOffset, int aliasLen, int serverId) {
        int sepCount = 0;
        String aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        while (aliasBeg != null) {
            if (this.isStarted(aliasBeg, serverId)) {
                return true;
            }
            aliasBeg = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        }
        return false;
    }

    private boolean isStarted(String webApp, int serverId) {
        ApplicationLoadBalance lb = (ApplicationLoadBalance)this.webToAppLB.get((Object)webApp);
        if (lb == null) {
            return false;
        }
        return lb.contains(serverId);
    }

    private String getGroupName(String aliasName) {
        ApplicationLoadBalance lb = (ApplicationLoadBalance)this.webToAppLB.get((Object)aliasName);
        if (lb == null) {
            return null;
        }
        return new String(lb.getName());
    }

    private String getAlias(byte[] request, int aliasOffset, int aliasLen, int separatorsToSkip) {
        String aliasStr = new String(request, aliasOffset, aliasLen);
        aliasStr = this.skipSeparators(aliasStr);
        if (separatorsToSkip == 0) {
            return aliasStr;
        }
        int sepOff = aliasStr.indexOf("/", 1);
        int i = 0;
        while (sepOff != -1 && i < separatorsToSkip - 1) {
            sepOff = aliasStr.indexOf("/", sepOff + 1);
            ++i;
        }
        if (sepOff == -1) {
            return null;
        }
        return aliasStr.substring(0, sepOff);
    }

    private Cookie[] getCookies(byte[] request, int off) {
        int i;
        ArrayObject cookies = new ArrayObject(3);
        while (off < request.length) {
            Cookie newCookie;
            int valLen;
            if (request[off] == 13 && request[off + 1] == 10) {
                if (request[off + 2] == 32) {
                    off += 2;
                    continue;
                }
                Cookie[] res = new Cookie[cookies.size()];
                i = 0;
                while (i < res.length) {
                    res[i] = (Cookie)cookies.elementAt(i);
                    ++i;
                }
                return res;
            }
            if (request[off] == 32 || request[off] == 9) {
                ++off;
                continue;
            }
            int keyOff = off;
            while (off < request.length) {
                if (request[off] == 61) break;
                if (request[off] == 13 && request[off + 1] == 10) {
                    if (request[off + 2] == 32) {
                        off += 2;
                    } else {
                        Cookie[] res = new Cookie[cookies.size()];
                        int i2 = 0;
                        while (i2 < res.length) {
                            res[i2] = (Cookie)cookies.elementAt(i2);
                            ++i2;
                        }
                        return res;
                    }
                }
                ++off;
            }
            int keyLen = off - keyOff;
            int valOff = ++off;
            while (off < request.length) {
                if (request[off] == 59 || request[off] == 44) {
                    ++off;
                    break;
                }
                if (request[off] == 13 && request[off + 1] == 10) {
                    if (request[off + 2] == 32) {
                        off += 2;
                    } else {
                        valLen = off - valOff;
                        newCookie = new Cookie(request, keyOff, keyLen, request, valOff, valLen, this);
                        if (newCookie.isApplicationCookie()) {
                            cookies.add((Object)newCookie);
                        }
                        Cookie[] res = new Cookie[cookies.size()];
                        int i3 = 0;
                        while (i3 < res.length) {
                            res[i3] = (Cookie)cookies.elementAt(i3);
                            ++i3;
                        }
                        return res;
                    }
                }
                ++off;
            }
            valLen = off - valOff - 1;
            newCookie = new Cookie(request, keyOff, keyLen, request, valOff, valLen, this);
            if (!newCookie.isApplicationCookie()) continue;
            cookies.add((Object)newCookie);
        }
        Cookie[] res = new Cookie[cookies.size()];
        i = 0;
        while (i < res.length) {
            res[i] = (Cookie)cookies.elementAt(i);
            ++i;
        }
        return res;
    }

    private Cookie[] getCookiesFromURL(byte[] request, int off) {
        while (off < request.length) {
            if (request[off] == 32 || request[off] == 63) {
                return null;
            }
            if (request[off] == 59) {
                int i = 1;
                while (i < CookieParser.jsessionid_url_sep_.length) {
                    if (request[off + i] != CookieParser.jsessionid_url_sep_[i]) break;
                    ++i;
                }
                if (i == CookieParser.jsessionid_url_sep_.length) {
                    off += CookieParser.jsessionid_url_sep_.length;
                    while (off < request.length) {
                        if (request[off] == 32) {
                            return null;
                        }
                        if (request[off] == 59) {
                            return this.parseCookiesURL(request, off + 1);
                        }
                        ++off;
                    }
                } else {
                    return this.parseCookiesURL(request, off + 1);
                }
            }
            ++off;
        }
        return null;
    }

    private Cookie[] parseCookiesURL(byte[] request, int off) {
        ArrayObject cookies = new ArrayObject(3, 2);
        int nameOff = off;
        int valueOff = -1;
        int nameLen = -1;
        while (off < request.length) {
            Cookie newCookie;
            if (request[off] == 59) {
                if (nameOff > -1 && nameLen > -1 && valueOff > -1 && (newCookie = new Cookie(request, nameOff, nameLen, request, valueOff, off - valueOff, this)).isApplicationCookie()) {
                    cookies.add((Object)newCookie);
                }
                nameOff = off + 1;
                nameLen = -1;
                valueOff = -1;
            } else {
                if (request[off] == 32 || request[off] == 63) {
                    if (nameOff <= -1 || nameLen <= -1 || valueOff <= -1 || !(newCookie = new Cookie(request, nameOff, nameLen, request, valueOff, off - valueOff, this)).isApplicationCookie()) break;
                    cookies.add((Object)newCookie);
                    break;
                }
                if (request[off] == 61) {
                    nameLen = off - nameOff;
                    valueOff = off + 1;
                }
            }
            ++off;
        }
        Cookie[] res = new Cookie[cookies.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = (Cookie)cookies.elementAt(i);
            ++i;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private int getCookieHeaderOffset(byte[] request, int off) {
        if (request[off] == 13 && request[off + 1] == 10) {
            return -1;
        }
        if (!Utils.equalsIgnoreCase(request[off], Constants.cookieHeader[0]) || !Utils.startsWith(request, off + 1, Constants.cookieHeader, 1)) ** GOTO lbl17
        if (request[off += Constants.cookieHeader.length] == 32) {
            ++off;
        }
        if (request[off] != 58) ** GOTO lbl17
        if (request[++off] == 32) {
            ++off;
        }
        return off;
lbl-1000:
        // 1 sources

        {
            if (request[off] == 13 && request[off + 1] == 10) {
                if (request[off + 2] == 32) {
                    off += 3;
                    continue;
                }
                off += 2;
                break;
            }
            ++off;
lbl17:
            // 4 sources

            ** while (off < request.length)
        }
lbl18:
        // 2 sources

        return this.getCookieHeaderOffset(request, off);
    }

    private ApplicationLoadBalance findAppByAlias(byte[] request, int aliasOffset, int aliasLen) {
        int ind;
        if (request == null || aliasOffset < 0 || aliasLen < 0 || aliasOffset + aliasLen > request.length) {
            return null;
        }
        int sepCount = 0;
        String alias = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        ApplicationLoadBalance appLB = null;
        while (alias != null) {
            appLB = (ApplicationLoadBalance)this.webToAppLB.get((Object)alias);
            if (appLB != null) {
                return appLB;
            }
            alias = this.getAlias(request, aliasOffset, aliasLen, sepCount++);
        }
        if (this.zoneSeparator != null && (ind = ByteArrayUtils.indexOf(request, aliasOffset, aliasLen, this.zoneSeparator)) > -1 && (appLB = (ApplicationLoadBalance)this.webToAppLB.get((Object)(alias = this.getAlias(request, aliasOffset, ind, 0)))) != null) {
            return appLB;
        }
        return (ApplicationLoadBalance)this.webToAppLB.get((Object)"/");
    }

    private String skipSeparators(String str) {
        char toSearch = '/';
        if (toSearch == '/') {
            toSearch = '\\';
        }
        str = str.replace(toSearch, '/');
        String doubleSep = "//";
        int ind = -1;
        while ((ind = str.indexOf(doubleSep)) > -1) {
            str = str.substring(0, ind) + str.substring(ind + 1);
        }
        return str;
    }
}

