/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher.loadbalance;

import com.sap.engine.services.httpserver.dispatcher.loadbalance.HttpLoadbalance;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;

public class Cookie {
    private HttpLoadbalance httpLoadbalance = null;
    private String name = null;
    private int value = -1;
    private boolean isApplicationCookie = true;
    private String aliasName = null;
    private boolean aliasNameChecked = false;
    private String zoneName = null;
    private boolean zoneNameChecked = false;

    public Cookie(byte[] name, int nameOff, int nameLen, byte[] value, int valueOff, int valueLen, HttpLoadbalance httpLoadbalance) {
        this.httpLoadbalance = httpLoadbalance;
        if (nameLen <= CookieParser.app_cookie_prefix_.length) {
            this.isApplicationCookie = false;
            return;
        }
        if (ByteArrayUtils.startsWithIgnoreCase(name, nameOff, nameLen, CookieParser.app_cookie_prefix_)) {
            this.name = new String(name, nameOff + CookieParser.app_cookie_prefix_.length, nameLen - CookieParser.app_cookie_prefix_.length).trim();
            try {
                if (value[valueOff] == 34 && value[valueOff + valueLen - 1] == 34) {
                    ++valueOff;
                    valueLen -= 2;
                }
                if (ByteArrayUtils.startsWith(value, valueOff, valueLen, "(".getBytes()) && ByteArrayUtils.indexOf(value, valueOff, valueLen, (byte)41) > 0) {
                    int off = ByteArrayUtils.indexOf(value, valueOff, valueLen, (byte)41) + 1;
                    valueOff += off;
                    valueLen -= off;
                }
                this.value = Integer.valueOf(new String(value, valueOff, valueLen).trim());
            }
            catch (NumberFormatException e) {
                this.isApplicationCookie = false;
            }
            this.name = this.name.replace('*', '/');
        } else if (ByteArrayUtils.startsWithIgnoreCase(name, nameOff, nameLen, CookieParser.app_cookie_prefix_old_)) {
            this.name = new String(name, nameOff + CookieParser.app_cookie_prefix_old_.length, nameLen - CookieParser.app_cookie_prefix_old_.length).trim();
            try {
                if (value[valueOff] == 34 && value[valueOff + valueLen - 1] == 34) {
                    ++valueOff;
                    valueLen -= 2;
                }
                if (ByteArrayUtils.startsWith(value, valueOff, valueLen, "(".getBytes()) && ByteArrayUtils.indexOf(value, valueOff, valueLen, (byte)41) > 0) {
                    valueOff += ByteArrayUtils.indexOf(value, valueOff, valueLen, (byte)41) + 1;
                    valueLen -= ByteArrayUtils.indexOf(value, valueOff, valueLen, (byte)41) + 1;
                }
                this.value = Integer.valueOf(new String(value, valueOff, valueLen).trim());
            }
            catch (NumberFormatException e) {
                this.isApplicationCookie = false;
            }
            this.name = this.name.replace('*', '/');
        } else {
            this.isApplicationCookie = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAliasName() {
        if (this.aliasNameChecked) {
            return this.aliasName;
        }
        this.aliasNameChecked = true;
        if (this.httpLoadbalance.containsAliasName(this.name.getBytes())) {
            this.aliasName = this.name;
        }
        return this.aliasName;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isApplicationCookie() {
        return this.isApplicationCookie;
    }
}

