/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher.loadbalance;

import com.sap.engine.frame.cluster.balance.MersenneTwisterDestination;
import com.sap.engine.services.httpserver.dispatcher.loadbalance.HttpLoadbalance;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;

public class ApplicationLoadBalance {
    private byte[] name = null;
    private byte[][] webNames = null;
    private HttpLoadbalance loadBalance = null;
    private MersenneTwisterDestination rr = new MersenneTwisterDestination();
    private int[] suspendedServers = null;

    public ApplicationLoadBalance(HttpLoadbalance loadBalance, byte[] name, byte[][] webNames) {
        this.loadBalance = loadBalance;
        this.name = name;
        this.webNames = webNames;
    }

    public void addAlias(byte[] alias) {
        if (!this.contains(alias, 0, alias.length)) {
            byte[][] tmp = new byte[this.webNames.length + 1][];
            System.arraycopy(this.webNames, 0, tmp, 0, this.webNames.length);
            tmp[this.webNames.length] = alias;
            this.webNames = tmp;
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public boolean contains(byte[] alias, int offset, int len) {
        int i = 0;
        while (i < this.webNames.length) {
            byte[] webName = this.webNames[i];
            if (this.startsWith(alias, offset, len, webName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsGroup(byte[] groupEncoded) {
        int i = 0;
        while (i < this.webNames.length) {
            if (ByteArrayUtils.endsWith(this.webNames[i], groupEncoded)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(int serverId) {
        if (this.rr.hasClusterId(serverId)) {
            return true;
        }
        if (this.suspendedServers == null) {
            return false;
        }
        ApplicationLoadBalance applicationLoadBalance = this;
        synchronized (applicationLoadBalance) {
            int i = 0;
            while (i < this.suspendedServers.length) {
                if (this.suspendedServers[i] == serverId) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        return false;
    }

    public int getLessBusy() {
        return this.rr.getNext();
    }

    public void addServer(int serverId, boolean isSuspended) {
        if (isSuspended) {
            this.rr.addElement(serverId);
            this.suspendServer(serverId);
        } else {
            this.rr.addElement(serverId);
        }
    }

    public void removeServer(int serverId) {
        if (this.suspendedServers != null) {
            this.resumeServer(serverId);
        }
        this.rr.removeElement(serverId);
        int[] sids = this.rr.getClusterIds();
        if (!(sids != null && sids.length != 0 || this.suspendedServers != null && this.suspendedServers.length != 0)) {
            int i = 0;
            while (i < this.webNames.length) {
                this.loadBalance.removeWebApp(this.webNames[i]);
                ++i;
            }
        }
    }

    public void suspendServer(int serverId) {
        if (!this.rr.hasClusterId(serverId)) {
            return;
        }
        ApplicationLoadBalance applicationLoadBalance = this;
        synchronized (applicationLoadBalance) {
            if (this.suspendedServers == null) {
                this.suspendedServers = new int[]{serverId};
            } else {
                int i = 0;
                while (i < this.suspendedServers.length) {
                    if (this.suspendedServers[i] == serverId) {
                        this.rr.removeElement(serverId);
                        return;
                    }
                    ++i;
                }
                int[] suspendedServersTmp = new int[this.suspendedServers.length + 1];
                System.arraycopy(this.suspendedServers, 0, suspendedServersTmp, 0, this.suspendedServers.length);
                suspendedServersTmp[this.suspendedServers.length] = serverId;
                this.suspendedServers = suspendedServersTmp;
            }
            this.rr.removeElement(serverId);
        }
    }

    public void resumeServer(int serverId) {
        ApplicationLoadBalance applicationLoadBalance = this;
        synchronized (applicationLoadBalance) {
            if (this.suspendedServers == null) {
                return;
            }
            int ind = -1;
            int i = 0;
            while (i < this.suspendedServers.length) {
                if (this.suspendedServers[i] == serverId) {
                    ind = i;
                    break;
                }
                ++i;
            }
            if (ind == -1) {
                return;
            }
            if (this.suspendedServers.length == 1) {
                this.suspendedServers = null;
            } else {
                int[] suspendedServersTmp = new int[this.suspendedServers.length - 1];
                int iTmp = 0;
                int i2 = 0;
                while (i2 < this.suspendedServers.length) {
                    if (i2 != ind) {
                        suspendedServersTmp[iTmp] = this.suspendedServers[i2];
                        ++iTmp;
                    }
                    ++i2;
                }
                this.suspendedServers = suspendedServersTmp;
            }
            this.rr.addElement(serverId);
        }
    }

    public String toString(String ln) {
        String res = ln + "Application: " + new String(this.name) + ln;
        res = res + ln + "    Web Applications: ";
        int i = 0;
        while (i < this.webNames.length) {
            res = res + new String(this.webNames[i]);
            if (i != this.webNames.length - 1) {
                res = res + ", ";
            }
            ++i;
        }
        res = res + ln;
        res = res + ln + "    Server Nodes: ";
        int[] sids = this.rr.getClusterIds();
        int i2 = 0;
        while (sids != null && i2 < sids.length) {
            res = res + sids[i2];
            if (i2 != sids.length - 1) {
                res = res + ", ";
            }
            ++i2;
        }
        res = res + ln + "    Suspended Server Nodes: ";
        sids = this.suspendedServers;
        int i3 = 0;
        while (this.suspendedServers != null && i3 < sids.length) {
            res = res + sids[i3];
            if (i3 != sids.length - 1) {
                res = res + ", ";
            }
            ++i3;
        }
        res = res + ln;
        return res;
    }

    private boolean startsWith(byte[] alias, int offset, int len, byte[] webName) {
        if (offset < 0 || len < 0 || alias == null || webName == null || len < webName.length) {
            return false;
        }
        int i = 0;
        while (i < len && i < webName.length) {
            if (alias[offset + i] != webName[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

