/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher.icm;

import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.services.httpserver.dispatcher.ConnectionInfo;
import com.sap.engine.services.httpserver.dispatcher.icm.ExtraLayer;
import com.sap.tc.logging.Location;

public class ICMExtraLayerV1
implements ExtraLayer {
    public static final int COM_REQ_BLOCK_HEADER_LENGTH = 40;
    private static final int COM_RES_BLOCK_HEADER_LENGTH = 32;
    private static final byte[] EYECATCHER = new byte[]{-34, -83, -66, -17};
    private static final byte[] HEADER_VERSION = new byte[4];
    private static final byte[][] PROTOCOL;
    private static final byte BODY_TYPE_HTTP = 0;
    private static final byte BODY_TYPE_SSL = 1;
    private static final byte TRACE_LEVEL_NO = 0;
    private static final byte TRACE_LEVEL_ERRORS = 1;
    private static final byte TRACE_LEVEL_200BYTES = 2;
    private static final byte TRACE_LEVEL_FULL = 3;
    private static final byte STATUS_OK = 0;
    private static final byte STATUS_ERROR = 1;
    private static final byte STATUS_EOD = 6;
    private static final byte[] ERROR_HEADER_VERSION;
    private static final byte[] ERROR_PROTOCOL;
    private static final byte[] ERROR_BODY_LENGTH;
    private static final byte[] ERROR_BODY_TYPE;
    private static final byte[] ERROR_TRACE_LEVEL;
    private static final byte[] ERROR_STATUS;
    private static final int EXTRA_LAYER_CODE = 1;
    static final int INTFLAG = 127;
    private static String ICMMessage;
    private static String Error;
    private Location location = null;

    public void setLocation(Location location) {
        this.location = location;
    }

    public int getLayerCode() {
        return 1;
    }

    public boolean unpackExtraLayer(Connection cc) {
        int tmplength = cc.getRequestData().getOffset() + cc.getRequestData().getLength();
        int tmpoffset = 0;
        if (((ConnectionInfo)cc.getPrivateData()).getOffset() != -1) {
            tmpoffset = ((ConnectionInfo)cc.getPrivateData()).getOffset();
            tmplength = cc.getRequestData().getLength() + cc.getRequestData().getOffset() - tmpoffset;
        }
        if (tmplength < 4) {
            ((ConnectionInfo)cc.getPrivateData()).setWaiting(true);
            return true;
        }
        if (!this.checkEyeCatcher(cc.getRequestData().getBytes(), tmpoffset)) {
            ((ConnectionInfo)cc.getPrivateData()).setProtocol(false);
            return false;
        }
        if (tmplength < 40) {
            ((ConnectionInfo)cc.getPrivateData()).setWaiting(true);
            return true;
        }
        if (!this.checkTraceLevel(cc.getRequestData().getBytes(), tmpoffset, (ConnectionInfo)cc.getPrivateData())) {
            ((ConnectionInfo)cc.getPrivateData()).setErrorMessage(this.constructErrorMessage(ERROR_TRACE_LEVEL, this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset)));
            return true;
        }
        if (!this.checkHeaderVersion(cc.getRequestData().getBytes(), tmpoffset)) {
            ((ConnectionInfo)cc.getPrivateData()).setErrorMessage(this.constructErrorMessage(ERROR_HEADER_VERSION, this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset)));
            return false;
        }
        if (!this.checkProtocol(cc, tmpoffset)) {
            ((ConnectionInfo)cc.getPrivateData()).setErrorMessage(this.constructErrorMessage(ERROR_PROTOCOL, this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset)));
            return true;
        }
        if (!this.checkBodyType(cc.getRequestData().getBytes(), tmpoffset)) {
            ((ConnectionInfo)cc.getPrivateData()).setErrorMessage(this.constructErrorMessage(ERROR_BODY_TYPE, this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset)));
            return true;
        }
        if (!this.checkStatus(cc.getRequestData().getBytes(), tmpoffset)) {
            ((ConnectionInfo)cc.getPrivateData()).setErrorMessage(this.constructErrorMessage(ERROR_STATUS, this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset)));
            return true;
        }
        if (!this.checkBodyLength(cc.getRequestData().getBytes(), tmpoffset, tmplength, (ConnectionInfo)cc.getPrivateData())) {
            ((ConnectionInfo)cc.getPrivateData()).setWaiting(true);
            return true;
        }
        if (((ConnectionInfo)cc.getPrivateData()).getOffset() != -1) {
            System.arraycopy(cc.getRequestData().getBytes(), ((ConnectionInfo)cc.getPrivateData()).getOffset(), cc.getRequestData().getBytes(), ((ConnectionInfo)cc.getPrivateData()).getOffset() + 40, tmpoffset - ((ConnectionInfo)cc.getPrivateData()).getOffset());
            ((ConnectionInfo)cc.getPrivateData()).setOffset(((ConnectionInfo)cc.getPrivateData()).getOffset() + 40);
        } else {
            ((ConnectionInfo)cc.getPrivateData()).setOffset(40);
        }
        ((ConnectionInfo)cc.getPrivateData()).setConnectionGuid(this.getConnectionGuid(cc.getRequestData().getBytes(), tmpoffset));
        ((ConnectionInfo)cc.getPrivateData()).setInetaddress(this.getClientIP(cc.getRequestData().getBytes(), tmpoffset));
        ((ConnectionInfo)cc.getPrivateData()).setExtraLayerCode(1);
        ((ConnectionInfo)cc.getPrivateData()).setWaiting(false);
        return true;
    }

    public byte[] packError(Connection cc, byte[] theError) {
        if (((ConnectionInfo)cc.getPrivateData()).getExtraLayerCode() != 1) {
            return null;
        }
        byte[] msg = new byte[32 + theError.length];
        System.arraycopy(EYECATCHER, 0, msg, 0, EYECATCHER.length);
        System.arraycopy(HEADER_VERSION, 0, msg, EYECATCHER.length, HEADER_VERSION.length);
        System.arraycopy(((ConnectionInfo)cc.getPrivateData()).getConnectionGuid(), 0, msg, EYECATCHER.length + HEADER_VERSION.length, ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length);
        byte[] bodyLength = new byte[4];
        ICMExtraLayerV1.writeIntToByteArr(bodyLength, 0, theError.length);
        System.arraycopy(bodyLength, 0, msg, EYECATCHER.length + HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length, bodyLength.length);
        msg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length + bodyLength.length] = 0;
        msg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length + bodyLength.length + 1] = 6;
        System.arraycopy(EYECATCHER, 0, msg, 28, EYECATCHER.length);
        System.arraycopy(theError, 0, msg, 32, theError.length);
        return msg;
    }

    public byte[] packExtraLayer(Connection cc, byte[] reply, int offset, int length, boolean eod) {
        if (((ConnectionInfo)cc.getPrivateData()).getExtraLayerCode() != 1) {
            return null;
        }
        byte[] msg = new byte[32 + length];
        System.arraycopy(EYECATCHER, 0, msg, 0, EYECATCHER.length);
        System.arraycopy(HEADER_VERSION, 0, msg, EYECATCHER.length, HEADER_VERSION.length);
        System.arraycopy(((ConnectionInfo)cc.getPrivateData()).getConnectionGuid(), 0, msg, EYECATCHER.length + HEADER_VERSION.length, ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length);
        byte[] bodyLength = new byte[4];
        ICMExtraLayerV1.writeIntToByteArr(bodyLength, 0, length);
        System.arraycopy(bodyLength, 0, msg, EYECATCHER.length + HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length, bodyLength.length);
        msg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length + bodyLength.length] = 0;
        msg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + ((ConnectionInfo)cc.getPrivateData()).getConnectionGuid().length + bodyLength.length + 1] = eod ? 6 : 0;
        System.arraycopy(EYECATCHER, 0, msg, 28, EYECATCHER.length);
        System.arraycopy(reply, offset, msg, 32, length);
        return msg;
    }

    public void trace(ConnectionInfo ci, String message, boolean isError) {
        switch (ci.getTraceLevel()) {
            case 3: {
                if (isError) {
                    this.location.errorT(this.getHostLine(ci.getInetaddress()) + ICMMessage + Error + "\r\n" + message);
                } else {
                    this.location.infoT(this.getHostLine(ci.getInetaddress()) + ICMMessage + "\r\n" + message);
                }
            }
            case 2: {
                int index = message.indexOf("\n");
                if (index == -1) {
                    index = message.length();
                }
                if (isError) {
                    this.location.errorT(this.getHostLine(ci.getInetaddress()) + ICMMessage + Error + "\r\n" + message.substring(0, index));
                } else {
                    this.location.infoT(this.getHostLine(ci.getInetaddress()) + ICMMessage + "\r\n" + message.substring(0, index));
                }
            }
            case 1: {
                if (!isError) break;
                this.location.errorT(this.getHostLine(ci.getInetaddress()) + ICMMessage + Error + "\r\n" + message);
            }
        }
        if (isError) {
            this.location.errorT(this.getHostLine(ci.getInetaddress()) + ICMMessage + Error + "\r\n" + message);
        } else {
            this.location.debugT(this.getHostLine(ci.getInetaddress()) + ICMMessage + "\r\n" + message);
        }
    }

    private boolean checkEyeCatcher(byte[] body, int offset) {
        return body[offset + 0] == EYECATCHER[0] && body[offset + 1] == EYECATCHER[1] && body[offset + 2] == EYECATCHER[2] && body[offset + 3] == EYECATCHER[3];
    }

    private boolean checkHeaderVersion(byte[] body, int offset) {
        return body[offset + 4] == HEADER_VERSION[0] && body[offset + 5] == HEADER_VERSION[1] && body[offset + 6] == HEADER_VERSION[2] && body[offset + 7] == HEADER_VERSION[3];
    }

    private boolean checkProtocol(Connection cc, int offset) {
        byte[] body = cc.getRequestData().getBytes();
        int i = 0;
        while (i < PROTOCOL.length) {
            if (body[offset + 12] == PROTOCOL[i][0] && body[offset + 13] == PROTOCOL[i][1] && body[offset + 14] == PROTOCOL[i][2] && body[offset + 15] == PROTOCOL[i][3]) {
                if (i == 1) {
                    ((ConnectionInfo)cc.getPrivateData()).setSSL(true);
                } else {
                    ((ConnectionInfo)cc.getPrivateData()).setSSL(false);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkBodyLength(byte[] body, int offset, int length, ConnectionInfo ci) {
        if (ICMExtraLayerV1.byteArrToInt(body, offset + 24) <= length - 40) {
            ci.setLength(ICMExtraLayerV1.byteArrToInt(body, offset + 24));
            return true;
        }
        return false;
    }

    private boolean checkBodyType(byte[] body, int offset) {
        return body[offset + 28] == 0 || body[offset + 28] == 1;
    }

    private boolean checkTraceLevel(byte[] body, int offset, ConnectionInfo ci) {
        if (body[offset + 29] >= 0 && body[offset + 29] <= 3) {
            ci.setTraceLevel(body[offset + 29]);
            return true;
        }
        return false;
    }

    private boolean checkStatus(byte[] body, int offset) {
        return body[offset + 30] == 0 || body[offset + 30] == 6;
    }

    private byte[] getConnectionGuid(byte[] body, int offset) {
        byte[] guid = new byte[8];
        System.arraycopy(body, offset + 16, guid, 0, 8);
        return guid;
    }

    private byte[] getClientIP(byte[] body, int offset) {
        byte[] ipBytes = new byte[4];
        System.arraycopy(body, offset + 8, ipBytes, 0, 4);
        return ipBytes;
    }

    public boolean retrieveClientCert(Connection cc, ConnectionInfo ci) {
        if (ci.getExtraLayerCode() != 1) {
            return false;
        }
        byte[] tempBytes = cc.getRequestData().getBytes();
        if (tempBytes[28] != 1) {
            return false;
        }
        byte[] tmp = new byte[ci.getLength()];
        System.arraycopy(cc.getRequestData().getBytes(), ci.getOffset(), tmp, 0, tmp.length);
        ci.setCertFromICM(tmp);
        return true;
    }

    private byte[] constructErrorMessage(byte[] reason, byte[] guid) {
        byte[] errmsg = new byte[32 + reason.length];
        System.arraycopy(EYECATCHER, 0, errmsg, 0, EYECATCHER.length);
        System.arraycopy(HEADER_VERSION, 0, errmsg, EYECATCHER.length, HEADER_VERSION.length);
        System.arraycopy(guid, 0, errmsg, EYECATCHER.length + HEADER_VERSION.length, guid.length);
        byte[] bodyLength = new byte[4];
        ICMExtraLayerV1.writeIntToByteArr(bodyLength, 0, reason.length);
        System.arraycopy(bodyLength, 0, errmsg, EYECATCHER.length + HEADER_VERSION.length + guid.length, bodyLength.length);
        errmsg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + guid.length + bodyLength.length] = 0;
        errmsg[ICMExtraLayerV1.EYECATCHER.length + ICMExtraLayerV1.HEADER_VERSION.length + guid.length + bodyLength.length + 1] = 1;
        System.arraycopy(EYECATCHER, 0, errmsg, 28, EYECATCHER.length);
        System.arraycopy(reason, 0, errmsg, 32, reason.length);
        return errmsg;
    }

    private static final int byteArrToInt(byte[] b, int off) {
        return b[off + 3] & 0xFF | (b[off + 2] & 0xFF) << 8 | (b[off + 1] & 0xFF) << 16 | (b[off] & 0x7F) << 24;
    }

    private static final void writeIntToByteArr(byte[] b, int off, int i) {
        b[off + 3] = (byte)i;
        b[off + 2] = (byte)(i >> 8);
        b[off + 1] = (byte)(i >> 16);
        b[off] = (byte)(i >> 24);
    }

    private String getHostLine(byte[] hostName) {
        return "IP address " + new String(hostName) + "\r\n";
    }

    static {
        ICMExtraLayerV1.writeIntToByteArr(HEADER_VERSION, 0, 1);
        PROTOCOL = new byte[2][4];
        ICMExtraLayerV1.writeIntToByteArr(PROTOCOL[0], 0, 1);
        ICMExtraLayerV1.writeIntToByteArr(PROTOCOL[1], 0, 2);
        ERROR_HEADER_VERSION = "ERROR_HEADER_VERSION".getBytes();
        ERROR_PROTOCOL = "ERROR_PROTOCOL".getBytes();
        ERROR_BODY_LENGTH = "ERROR_BODY_LENGTH".getBytes();
        ERROR_BODY_TYPE = "ERROR_BODY_TYPE".getBytes();
        ERROR_TRACE_LEVEL = "ERROR_TRACE_LEVEL".getBytes();
        ERROR_STATUS = "ERROR_STATUS".getBytes();
        ICMMessage = "[SAP J2EE Engine (Dispatcher) with ICM 1.0]  ";
        Error = "  Error  ";
    }
}

