/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httpserver.dispatcher;

import com.sap.engine.services.httpserver.dispatcher.ConnectionInfo;
import com.sap.engine.services.httpserver.dispatcher.Constants;
import com.sap.engine.services.httpserver.dispatcher.HttpDispatcherFrame;
import com.sap.engine.services.httpserver.exceptions.ParseException;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.protocol.Methods;
import com.sap.engine.services.httpserver.lib.util.Ascii;

public class Utils
implements Constants {
    public static boolean isNonBodyCommand(byte[] tempBytes) {
        return Utils.startsWith(tempBytes, Methods._HEAD) && tempBytes[Methods._HEAD.length] == 32;
    }

    public static boolean containsRN(byte[] arr, int length) {
        if (arr == null) {
            return false;
        }
        int k = length - 1;
        while (k > 2) {
            if (arr[k] == 10 && arr[k - 1] == 13 && arr[k - 2] == 10 && arr[k - 3] == 13) {
                return true;
            }
            --k;
        }
        return Utils.isSimpleHttpRequest(arr, length);
    }

    public static int getContentLength(byte[] arr, int length) {
        int k = 0;
        while (k < length) {
            if (Constants.contentLength[0] == arr[k]) {
                int j = 0;
                j = 1;
                while (j < Constants.contentLength.length && j + k < length) {
                    if (Constants.contentLength[j] != Ascii.toLower(arr[k + j])) break;
                    ++j;
                }
                if (j == Constants.contentLength.length) {
                    j += k;
                    while (arr[j++] == 32) {
                    }
                    if (arr[j - 1] == 58) {
                        while (arr[j] == 32) {
                            ++j;
                        }
                        int n = j;
                        while (n < length - 3) {
                            if (arr[n] == 13 && arr[n + 1] == 10) {
                                while (arr[n - 1] == 32) {
                                    --n;
                                }
                                return Ascii.asciiArrToIntNoException(arr, j, n - j);
                            }
                            ++n;
                        }
                    }
                }
            }
            ++k;
        }
        return -1;
    }

    public static long getContentLengthLong(byte[] arr, int length) {
        int k = 0;
        while (k < length) {
            if (Constants.contentLength[0] == arr[k]) {
                int j = 0;
                j = 1;
                while (j < Constants.contentLength.length && j + k < length) {
                    if (Constants.contentLength[j] != Ascii.toLower(arr[k + j])) break;
                    ++j;
                }
                if (j == Constants.contentLength.length) {
                    j += k;
                    while (arr[j++] == 32) {
                    }
                    if (arr[j - 1] == 58) {
                        while (arr[j] == 32) {
                            ++j;
                        }
                        int n = j;
                        while (n < length - 3) {
                            if (arr[n] == 13 && arr[n + 1] == 10) {
                                while (arr[n - 1] == 32) {
                                    --n;
                                }
                                return Ascii.asciiArrToLongNoException(arr, j, n - j);
                            }
                            ++n;
                        }
                    }
                }
            }
            ++k;
        }
        return -1L;
    }

    public static byte[] getTransferEncoding(byte[] arr, int length) {
        int k = 0;
        while (k < length) {
            if (Constants.transferEncoding[0] == arr[k]) {
                int j = 0;
                j = 1;
                while (j < Constants.transferEncoding.length && j + k < length) {
                    if (Constants.transferEncoding[j] != Ascii.toLower(arr[k + j])) break;
                    ++j;
                }
                if (j == Constants.transferEncoding.length) {
                    if (arr[k + j] == 32) {
                        ++j;
                    }
                    int n = k + j;
                    while (n < length - 3) {
                        if (arr[n] == 13 && arr[n + 1] == 10) {
                            byte[] res = new byte[n - k - j - 2];
                            System.arraycopy(arr, k + j + 2, res, 0, res.length);
                            return res;
                        }
                        ++n;
                    }
                }
            }
            ++k;
        }
        return null;
    }

    public static boolean searchEndOfChunk(byte[] arr, int off, int allLen, ConnectionInfo ci) throws ParseException {
        if (off == allLen) {
            return false;
        }
        if (ci.getChunkBytesWaiting() > 0) {
            if (ci.getChunkBytesWaiting() <= allLen - off) {
                int bytesRead = ci.getChunkBytesWaiting();
                ci.setChunkBytesWaiting(-1);
                ci.chenkedBodyRead(bytesRead);
                return Utils.searchEndOfChunk(arr, off + bytesRead, allLen, ci);
            }
            ci.setChunkBytesWaiting(ci.getChunkBytesWaiting() - (allLen - off));
            return false;
        }
        if (ci.getBuffer() == null) {
            if (allLen - off < 3) {
                ci.setBuffer(arr, off, allLen - off);
                return false;
            }
            int headerLen = 0;
            while (off + headerLen < allLen - 1 && (arr[off + headerLen] != 13 || arr[off + headerLen + 1] != 10)) {
                ++headerLen;
            }
            if (off + headerLen == allLen - 1) {
                ci.setBuffer(arr, off, allLen - off);
                return false;
            }
            int nextPartLen = Ascii.asciiArrHexToInt(arr, off, headerLen);
            if (nextPartLen == 0) {
                ci.setChunkBytesWaiting(-1);
                if (allLen > off + headerLen + 4) {
                    ci.setNextRequestOffset(off + headerLen + 4);
                }
                return true;
            }
            ci.setChunkBytesWaiting(nextPartLen + 2);
            return Utils.searchEndOfChunk(arr, off + headerLen + 2, allLen, ci);
        }
        byte[] newArr = new byte[ci.getBuffer().length + allLen - off];
        System.arraycopy(ci.getBuffer(), 0, newArr, 0, ci.getBuffer().length);
        System.arraycopy(arr, off, newArr, ci.getBuffer().length, allLen - off);
        ci.clearBuffer();
        return Utils.searchEndOfChunk(newArr, 0, newArr.length, ci);
    }

    public static int getHeadLength(byte[] arr, int length) {
        if (arr == null) {
            return -1;
        }
        int k = 0;
        while (k < length - 3) {
            if (arr[k] == 13 && arr[k + 1] == 10 && arr[k + 2] == 13 && arr[k + 3] == 10) {
                return k + 4;
            }
            ++k;
        }
        return -1;
    }

    public static int getHeadLength(byte[] bytes, int offset, int length) {
        int i = offset + length - 4;
        while (i >= offset) {
            if (bytes[i + 3] == 10 && bytes[i + 2] == 13 && bytes[i + 1] == 10 && bytes[i] == 13) {
                return i - offset + 4;
            }
            --i;
        }
        return -1;
    }

    public static boolean getUrlSessionTracking(byte[] request, int len) {
        int sepInd;
        int res;
        int ptr = 0;
        while (ptr < len) {
            if (request[ptr] == 32) {
                ++ptr;
                break;
            }
            ++ptr;
        }
        int beg = ptr;
        while (ptr < len - 1) {
            if (request[ptr] == 32 || request[ptr] == 13 && request[ptr + 1] == 10) break;
            ++ptr;
        }
        len = ptr;
        ptr = beg;
        boolean schemeFound = false;
        if (request[ptr] == 104 && request[ptr + 1] == 116 && request[ptr + 2] == 116 && request[ptr + 3] == 112) {
            if (request[ptr + 4] == 58 && request[ptr + 5] == 47 && request[ptr + 6] == 47) {
                ptr += 7;
                schemeFound = true;
            } else if (request[ptr + 4] == 115 && request[ptr + 5] == 58 && request[ptr + 6] == 47 && request[ptr + 7] == 47) {
                ptr += 8;
                schemeFound = true;
            }
        }
        while (ptr < len) {
            if (request[ptr] != 47 && request[ptr] != 92) break;
            ++ptr;
        }
        if (schemeFound) {
            while (ptr < len) {
                if (request[ptr] == 47 || request[ptr] == 92 || request[ptr] == 32) break;
                ++ptr;
            }
        }
        while (ptr < len) {
            if (request[ptr] != 47 && request[ptr] != 92) break;
            ++ptr;
        }
        if (ptr == len) {
            return false;
        }
        if (request[ptr] == 32) {
            return HttpDispatcherFrame.isUrlSessionTracking("/", -1) == 1;
        }
        beg = ptr;
        String url = new String(ParseUtils.separatorsToFS(new String(request, beg, len - beg)));
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((res = HttpDispatcherFrame.isUrlSessionTracking(url, sepInd = url.indexOf("/"))) != -1) {
            return res == 1;
        }
        return HttpDispatcherFrame.isUrlSessionTracking("/", -1) == 1;
    }

    public static int getCookieId(byte[] arr, int length, boolean parseSessionCookieHeader) {
        if (parseSessionCookieHeader) {
            int cookieBeg = Utils.getCookieHeaderBegin(arr, 0, length);
            while (cookieBeg != -1) {
                int cookieEnd = Utils.getCookieHeaderEnd(arr, cookieBeg);
                int id = Utils.getCookieIDFromHeader(arr, cookieBeg, cookieEnd);
                if (id != -1) {
                    return id;
                }
                cookieBeg = Utils.getCookieHeaderBegin(arr, cookieEnd, length);
            }
        }
        return Utils.getCookieIDFromURL(arr, length);
    }

    public static byte[] getSessionCookie(byte[] arr, int length) {
        int cookieBeg = Utils.getCookieHeaderBegin(arr, 0, length);
        while (cookieBeg != -1) {
            int cookieEnd = Utils.getCookieHeaderEnd(arr, cookieBeg);
            byte[] sessionCookie = Utils.getSessionCookieFromHeader(arr, cookieBeg, cookieEnd);
            if (sessionCookie != null) {
                return sessionCookie;
            }
            cookieBeg = Utils.getCookieHeaderBegin(arr, cookieEnd, length);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] getSessionCookieFromHeader(byte[] arr, int beg, int len) {
        quotes = false;
        beg = Utils.skipSpaces(arr, beg, len);
        while (arr[beg] == 13 && arr[beg + 1] == 10 && arr[beg + 2] == 32) {
            beg += 3;
            beg = Utils.skipSpaces(arr, beg, len);
        }
        while (beg < len - CookieParser.jsessionid_cookie_.length) {
            block17: {
                if (arr[beg] != CookieParser.jsessionid_cookie_[0]) break block17;
                ji = 1;
                while (ji < CookieParser.jsessionid_cookie_.length) {
                    if (arr[beg + ji] != CookieParser.jsessionid_cookie_[ji]) break;
                    ++ji;
                }
                if (ji != CookieParser.jsessionid_cookie_.length) break block17;
                if (arr[beg += ji] == 32) {
                    ++beg;
                }
                if (arr[beg] != 61) {
                    beg = Utils.skipCurrentCookie(arr, beg, len);
                    continue;
                }
                if (arr[++beg] == 32) {
                    ++beg;
                }
                if (arr[beg] == 34) {
                    quotes = true;
                }
                cookieOffset = ++beg;
                if (arr[beg] == 40) {
                    endOfCookie = false;
                    while (beg < len && arr[beg] != 41) {
                        if (arr[beg] == 59) {
                            endOfCookie = true;
                            break;
                        }
                        ++beg;
                    }
                    if (endOfCookie || beg >= len - 9) {
                        beg = Utils.skipCurrentCookie(arr, beg, len);
                        continue;
                    }
                }
                if (arr[++beg] != 73 || arr[beg + 1] != 68) break block17;
                beg += 2;
                wrongValue = false;
                while (arr[beg] != 68 && beg < len - 1) {
                    if (arr[beg] == 59) {
                        wrongValue = true;
                        break;
                    }
                    ++beg;
                }
                if (wrongValue) break block17;
                if (++beg < len - 5 && arr[beg] == 66) ** GOTO lbl52
                return null;
lbl-1000:
                // 1 sources

                {
                    if (arr[beg] == 59) {
                        wrongValue = true;
                        break;
                    }
                    ++beg;
lbl52:
                    // 2 sources

                    ** while (arr[beg] != 69 && beg < len)
                }
lbl53:
                // 2 sources

                if (!wrongValue) {
                    if (arr[++beg] != 110 || arr[beg + 1] != 100 || quotes && arr[beg + 2] != 34) {
                        return null;
                    }
                    res = new byte[(beg += 2) - cookieOffset];
                    System.arraycopy(arr, cookieOffset, res, 0, res.length);
                    return res;
                }
            }
            beg = Utils.skipCurrentCookie(arr, beg, len);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static int getCookieIDFromHeader(byte[] arr, int beg, int len) {
        quotes = false;
        beg = Utils.skipSpaces(arr, beg, len);
        while (arr[beg] == 13 && arr[beg + 1] == 10 && arr[beg + 2] == 32) {
            beg += 3;
            beg = Utils.skipSpaces(arr, beg, len);
        }
        while (beg < len - CookieParser.jsessionid_cookie_.length) {
            block17: {
                if (arr[beg] != CookieParser.jsessionid_cookie_[0]) break block17;
                ji = 1;
                while (ji < CookieParser.jsessionid_cookie_.length) {
                    if (arr[beg + ji] != CookieParser.jsessionid_cookie_[ji]) break;
                    ++ji;
                }
                if (ji != CookieParser.jsessionid_cookie_.length) break block17;
                if (arr[beg += ji] == 32) {
                    ++beg;
                }
                if (arr[beg] != 61) {
                    beg = Utils.skipCurrentCookie(arr, beg, len);
                    continue;
                }
                if (arr[++beg] == 32) {
                    ++beg;
                }
                if (arr[beg] == 34) {
                    ++beg;
                    quotes = true;
                }
                if (arr[beg] == 40) {
                    endOfCookie = false;
                    while (beg < len && arr[beg] != 41) {
                        if (arr[beg] == 59) {
                            endOfCookie = true;
                            break;
                        }
                        ++beg;
                    }
                    if (endOfCookie || beg >= len - 9) {
                        beg = Utils.skipCurrentCookie(arr, beg, len);
                        continue;
                    }
                }
                if (arr[++beg] != 73 || arr[beg + 1] != 68) break block17;
                cookieBeg = beg += 2;
                wrongValue = false;
                while (arr[beg] != 68 && beg < len - 1) {
                    if (arr[beg] == 59) {
                        wrongValue = true;
                        break;
                    }
                    ++beg;
                }
                if (wrongValue) break block17;
                end = beg++;
                if (beg < len - 5 && arr[beg] == 66) ** GOTO lbl53
                return -1;
lbl-1000:
                // 1 sources

                {
                    if (arr[beg] == 59) {
                        wrongValue = true;
                        break;
                    }
                    ++beg;
lbl53:
                    // 2 sources

                    ** while (arr[beg] != 69 && beg < len)
                }
lbl54:
                // 2 sources

                if (!wrongValue) {
                    if (arr[++beg] != 110 || arr[beg + 1] != 100 || quotes && arr[beg + 2] != 34) {
                        return -1;
                    }
                    return Ascii.asciiArrToIntNoException(arr, cookieBeg, end - cookieBeg);
                }
            }
            beg = Utils.skipCurrentCookie(arr, beg, len);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int getCookieIDFromURL(byte[] arr, int length) {
        quotes = false;
        k = 0;
        while (k < length - 1) {
            block15: {
                if (arr[k] == 13 && arr[k + 1] == 10) {
                    return -1;
                }
                if (arr[k] == 63) {
                    return -1;
                }
                if (CookieParser.jsessionid_url_sep_[0] != arr[k]) break block15;
                j = 1;
                while (j < CookieParser.jsessionid_url_sep_.length && j + k < length) {
                    if (CookieParser.jsessionid_url_sep_[j] != arr[k + j]) {
                        return -1;
                    }
                    ++j;
                }
                n = k += CookieParser.jsessionid_url_sep_.length;
                if (n >= length - 9) break block15;
                if (arr[n] == 34) {
                    ++n;
                    quotes = true;
                }
                if (arr[n] == 40) {
                    while (arr[n] != 41) {
                        if (++n >= length - 5) {
                            return -1;
                        }
                        if (arr[n - 1] != 13 || arr[n] != 10) continue;
                        return -1;
                    }
                }
                if (arr[++n] != 73 && arr[n + 1] != 68) {
                    return -1;
                }
                beg = n += 2;
                while (arr[n] != 68) {
                    if (++n >= length - 5) {
                        return -1;
                    }
                    if (arr[n - 1] != 13 || arr[n] != 10) continue;
                    return -1;
                }
                end = n++;
                if (arr[n] == 66) ** GOTO lbl41
                return -1;
lbl-1000:
                // 1 sources

                {
                    if (++n >= length - 3) {
                        return -1;
                    }
                    if (arr[n - 1] != 13 || arr[n] != 10) continue;
                    return -1;
lbl41:
                    // 2 sources

                    ** while (arr[n] != 69)
                }
lbl42:
                // 1 sources

                if (arr[++n] != 110 || arr[n + 1] != 100 || quotes && arr[n + 2] != 34) {
                    return -1;
                }
                return Ascii.asciiArrToIntNoException(arr, beg, end - beg);
            }
            ++k;
        }
        return -1;
    }

    private static int skipSpaces(byte[] arr, int k, int length) {
        while (k < length && (arr[k] == 32 || arr[k] == 9)) {
            ++k;
        }
        return k;
    }

    private static int skipCurrentCookie(byte[] arr, int k, int length) {
        while (k < length - CookieParser.jsessionid_cookie_.length && arr[k] != 59) {
            if (arr[k] == 13 && arr[k + 1] == 10) {
                if (arr[k + 2] == 32) {
                    k += 3;
                } else {
                    return k;
                }
            }
            ++k;
        }
        ++k;
        k = Utils.skipSpaces(arr, k, length);
        while (arr[k] == 13 && arr[k + 1] == 10 && arr[k + 2] == 32) {
            k += 3;
            k = Utils.skipSpaces(arr, k, length);
        }
        return k;
    }

    private static int getCookieHeaderBegin(byte[] arr, int offset, int requestLength) {
        int k = offset;
        while (k < requestLength - Constants.cookie.length - CookieParser.jsessionid_cookie_.length - 9) {
            if (Constants.cookie[0] == arr[k]) {
                int j = 1;
                while (j < Constants.cookie.length && j + k < requestLength) {
                    if (Constants.cookie[j] != Ascii.toLower(arr[k + j])) break;
                    ++j;
                }
                if (j >= Constants.cookie.length) {
                    if ((k += j) > requestLength - CookieParser.jsessionid_cookie_.length - 9) {
                        return -1;
                    }
                    if (arr[k] == 32) {
                        ++k;
                    }
                    if (arr[k] == 58) {
                        return k + 1;
                    }
                }
            }
            ++k;
        }
        return -1;
    }

    private static int getCookieHeaderEnd(byte[] arr, int cookieBeg) {
        while (arr[cookieBeg] != 13 || arr[cookieBeg + 1] != 10 || arr[cookieBeg + 2] == 32) {
            ++cookieBeg;
        }
        return cookieBeg;
    }

    public static boolean startsWith(byte[] arr1, byte[] arr2) {
        if (arr2.length > arr1.length) {
            return false;
        }
        int j = 0;
        int k = 0;
        while (k < arr2.length) {
            if (arr1[j++] != arr2[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static boolean startsWith(byte[] arr1, int off, byte[] arr2, int off2) {
        if (arr2.length - off2 > arr1.length - off) {
            return false;
        }
        int j = 0;
        while (j < arr2.length - off2) {
            if (arr1[off + j] != arr2[off2 + j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(byte f, byte s) {
        return f == s || Ascii.toLower(f) == Ascii.toLower(s);
    }

    public static byte[] intToBytes(int c) {
        byte[] res = new byte[]{(byte)c, (byte)(c >> 8)};
        return res;
    }

    private static boolean isSimpleHttpRequest(byte[] arr, int length) {
        if (length < 7) {
            return false;
        }
        if (arr[0] != 71 || arr[1] != 69 || arr[2] != 84 || arr[3] != 32) {
            return false;
        }
        int k = 4;
        while (k < length) {
            if (arr[k] == 32) {
                return false;
            }
            if (arr[k] == 10 && arr[k - 1] == 13) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

